/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.progress;

import com.intellij.docker.agent.progress.DockerResponseItem;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\bH\u0002J\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\r\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\u00020\u0003*\u00020\u000fH\u0002J\u0014\u0010\u0014\u001a\u00020\u0003*\u00020\u000f2\u0006\u0010\f\u001a\u00020\bH\u0002J\f\u0010\u0015\u001a\u00020\u0003*\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/docker/agent/progress/DockerProgressDetailsFormat;", "", "units", "", "(Ljava/lang/String;)V", "hideCounts", "", "ttyWidth", "", "getUnits", "()Ljava/lang/String;", "getPbBox", "percentage", "toTtyString", "progress", "Lcom/intellij/docker/agent/progress/DockerResponseItem$ProgressDetail;", "cur", "total", "", "getNumberBox", "getTimeLeftBox", "toTerminalString", "Companion", "intellij.clouds.docker.agent"})
public final class DockerProgressDetailsFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String units;
    private int ttyWidth;
    private boolean hideCounts;
    @NotNull
    private static final String[] BYTE_DECIMAL_NAMES;

    public DockerProgressDetailsFormat(@NotNull String units) {
        Intrinsics.checkNotNullParameter((Object)units, (String)"units");
        this.units = units;
        this.ttyWidth = 200;
    }

    public /* synthetic */ DockerProgressDetailsFormat(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    @NotNull
    public final String getUnits() {
        return this.units;
    }

    @NotNull
    public final String toTtyString(@NotNull DockerResponseItem.ProgressDetail progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        return this.toTerminalString(progress);
    }

    @NotNull
    public final String toTtyString(long cur, long total) {
        return this.toTtyString(new DockerResponseItem.ProgressDetail.Impl(0L, total, cur));
    }

    @NotNull
    public final String toTtyString(int cur, int total) {
        return this.toTtyString((long)cur, (long)total);
    }

    private final String toTerminalString(DockerResponseItem.ProgressDetail $this$toTerminalString) {
        if ($this$toTerminalString.getCurrent() <= 0L && $this$toTerminalString.getTotal() <= 0L) {
            return "";
        }
        if ($this$toTerminalString.getTotal() <= 0L) {
            String string;
            if (Intrinsics.areEqual((Object)this.units, (Object)"")) {
                String string2 = "%8s";
                Object[] objectArray = new Object[]{Companion.humanSizeBytes($this$toTerminalString.getCurrent())};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            } else {
                String string4 = "%d %s";
                Object[] objectArray = new Object[]{$this$toTerminalString.getCurrent(), this.units};
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            }
            return string;
        }
        int percentage = Math.min(50, MathKt.roundToInt((double)((double)$this$toTerminalString.getCurrent() / (double)$this$toTerminalString.getTotal() * (double)100)) / 2);
        String pbBox = this.getPbBox(percentage);
        String timeLeftBox = this.getTimeLeftBox($this$toTerminalString, percentage);
        String numbersBox = this.getNumberBox($this$toTerminalString);
        return pbBox + numbersBox + timeLeftBox;
    }

    private final String getTimeLeftBox(DockerResponseItem.ProgressDetail $this$getTimeLeftBox, int percentage) {
        if (this.ttyWidth <= 50 || percentage >= 50) {
            return "";
        }
        if ($this$getTimeLeftBox.getCurrent() <= 0L || $this$getTimeLeftBox.getStart() <= 0L) {
            return "";
        }
        long fromStart = System.currentTimeMillis() - $this$getTimeLeftBox.getStart();
        long perEntry = fromStart / $this$getTimeLeftBox.getCurrent();
        Duration left = Duration.of(($this$getTimeLeftBox.getTotal() - $this$getTimeLeftBox.getCurrent()) * perEntry, ChronoUnit.MILLIS);
        Intrinsics.checkNotNull((Object)left);
        return " " + DockerProgressDetailsFormat.Companion.toDockerString(left);
    }

    private final String getPbBox(int percentage) {
        if (this.ttyWidth <= 110) {
            return "";
        }
        int numSpaces = Math.max(0, 50 - percentage);
        String string = "[%s>%s]";
        Object[] objectArray = new Object[]{StringsKt.repeat((CharSequence)"=", (int)percentage), StringsKt.repeat((CharSequence)" ", (int)numSpaces)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final String getNumberBox(DockerResponseItem.ProgressDetail $this$getNumberBox) {
        String string;
        if (this.hideCounts) {
            string = "";
        } else {
            if (Intrinsics.areEqual((Object)this.units, (Object)"")) {
                String string2;
                String currentString = Companion.humanSizeBytes($this$getNumberBox.getCurrent());
                String totalString = Companion.humanSizeBytes($this$getNumberBox.getTotal());
                if ($this$getNumberBox.getCurrent() > $this$getNumberBox.getTotal()) {
                    String string3 = "%8s/%s";
                    Object[] objectArray = new Object[]{currentString, totalString};
                    String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                } else {
                    String string5 = "%8s";
                    Object[] objectArray = new Object[]{currentString};
                    String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                    string2 = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
                }
                return string2;
            }
            String string7 = "%d/%d %s";
            Object[] objectArray = new Object[]{$this$getNumberBox.getCurrent(), $this$getNumberBox.getTotal(), this.units};
            String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(...)");
        }
        return string;
    }

    public DockerProgressDetailsFormat() {
        this(null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final String humanSizeBytes(double value) {
        return Companion.humanSizeBytes(value);
    }

    static {
        String[] stringArray = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};
        BYTE_DECIMAL_NAMES = stringArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\tH\u0007J\f\u0010\u000f\u001a\u00020\u0005*\u00020\u0010H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/agent/progress/DockerProgressDetailsFormat$Companion;", "", "()V", "BYTE_DECIMAL_NAMES", "", "", "[Ljava/lang/String;", "getSizeAndUnit", "Lkotlin/Pair;", "", "value", "base", "unitNames", "(DD[Ljava/lang/String;)Lkotlin/Pair;", "humanSizeBytes", "toDockerString", "Ljava/time/Duration;", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String humanSizeBytes(double value) {
            Pair<Double, String> pair = this.getSizeAndUnit(value, 1000.0, BYTE_DECIMAL_NAMES);
            double size = ((Number)pair.component1()).doubleValue();
            String unit = (String)pair.component2();
            String string = "%.4g%s";
            Object[] objectArray = new Object[]{size, unit};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        private final Pair<Double, String> getSizeAndUnit(double value, double base, String[] unitNames) {
            double current;
            int idx = 0;
            for (current = value; current > base && idx < unitNames.length - 1; current /= base, ++idx) {
            }
            return new Pair((Object)current, (Object)unitNames[idx]);
        }

        private final String toDockerString(Duration $this$toDockerString) {
            long seconds = $this$toDockerString.getSeconds();
            String string = "%d:%02d:%02d";
            Object[] objectArray = new Object[]{seconds / (long)3600, seconds % (long)3600 / (long)60, seconds % (long)60};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

