/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.SELContext;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.settings.DockerAgentAdvancedSettingsProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u001f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/agent/impl/VolumeMapper;", "", "pathMapper", "Lcom/intellij/docker/agent/DockerAgentPathMapper;", "settingsProvider", "Lcom/intellij/docker/agent/settings/DockerAgentAdvancedSettingsProvider;", "(Lcom/intellij/docker/agent/DockerAgentPathMapper;Lcom/intellij/docker/agent/settings/DockerAgentAdvancedSettingsProvider;)V", "expandPath", "Lcom/github/dockerjava/api/model/Bind;", "bind", "", "binds", "([Lcom/github/dockerjava/api/model/Bind;)[Lcom/github/dockerjava/api/model/Bind;", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nCreateContainerCmdValueTransfers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateContainerCmdValueTransfers.kt\ncom/intellij/docker/agent/impl/VolumeMapper\n+ 2 logging.kt\ncom/intellij/docker/agent/util/LoggingKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,322:1\n7#2:323\n11065#3:324\n11400#3,3:325\n37#4,2:328\n*S KotlinDebug\n*F\n+ 1 CreateContainerCmdValueTransfers.kt\ncom/intellij/docker/agent/impl/VolumeMapper\n*L\n293#1:323\n303#1:324\n303#1:325,3\n303#1:328,2\n*E\n"})
final class VolumeMapper {
    @NotNull
    private final DockerAgentPathMapper pathMapper;
    @Nullable
    private final DockerAgentAdvancedSettingsProvider settingsProvider;

    public VolumeMapper(@NotNull DockerAgentPathMapper pathMapper2, @Nullable DockerAgentAdvancedSettingsProvider settingsProvider) {
        Intrinsics.checkNotNullParameter((Object)pathMapper2, (String)"pathMapper");
        this.pathMapper = pathMapper2;
        this.settingsProvider = settingsProvider;
    }

    private final Bind expandPath(Bind bind) {
        boolean applySELinuxLabel;
        String mappedPath = this.pathMapper.mapPath(bind.getPath());
        Path hostPath = Path.of(mappedPath, new String[0]);
        DockerAgentAdvancedSettingsProvider dockerAgentAdvancedSettingsProvider = this.settingsProvider;
        boolean bl = applySELinuxLabel = dockerAgentAdvancedSettingsProvider != null ? dockerAgentAdvancedSettingsProvider.getBoolean("docker.selinux.label.volumes") : false;
        if (applySELinuxLabel) {
            if (hostPath.isAbsolute() && hostPath.getNameCount() < 2) {
                applySELinuxLabel = false;
            } else {
                Path home = Path.of(System.getProperty("user.home"), new String[0]);
                if (Intrinsics.areEqual((Object)hostPath, (Object)home)) {
                    applySELinuxLabel = false;
                }
            }
            if (!applySELinuxLabel) {
                boolean $i$f$logger = false;
                Logger logger2 = LoggerFactory.getLogger(VolumeMapper.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
                logger2.warn("Applying selinux label to system directory can make your machine inoperable, selinux label won't be applied to " + hostPath);
            }
        }
        return new Bind(mappedPath, bind.getVolume(), bind.getAccessMode(), applySELinuxLabel ? SELContext.shared : SELContext.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bind[] expandPath(@NotNull Bind[] binds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)binds, (String)"binds");
        Bind[] $this$map$iv = binds;
        boolean $i$f$map = false;
        Bind[] bindArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.expandPath((Bind)p0));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Bind[0]);
    }
}

