/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers.ideSettings;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.docker.agent.devcontainers.DevcontainerJsonModel;
import com.intellij.docker.agent.devcontainers.ideSettings.DevcontainerIdeConfig;
import com.intellij.docker.agent.devcontainers.ideSettings.DevcontainerIdeConfig$;
import com.intellij.docker.agent.devcontainers.ideSettings.DevcontainerIdeConfigManipulator$DevcontainerCustomizations$;
import com.intellij.docker.agent.devcontainers.ideSettings.DevcontainerIntellijIdeConfig;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0016\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002J\u0016\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J6\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0014H\u0002J \u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J,\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/docker/agent/devcontainers/ideSettings/DevcontainerIdeConfigManipulator;", "", "devcontainerJson", "", "(Ljava/lang/String;)V", "addCustomizations", "preferredIde", "createParser", "Lcom/fasterxml/jackson/core/JsonParser;", "json", "findCustomizationSection", "Lkotlin/Pair;", "", "findCustomizationsMarker", "findLastObjectOrValue", "generateCustomizations", "backend", "plugins", "", "options", "", "insert", "str", "offset", "content", "replaceRange", "range", "newContent", "DevcontainerCustomizations", "intellij.clouds.docker.agent"})
public final class DevcontainerIdeConfigManipulator {
    @NotNull
    private final String devcontainerJson;

    public DevcontainerIdeConfigManipulator(@NotNull String devcontainerJson) {
        Intrinsics.checkNotNullParameter((Object)devcontainerJson, (String)"devcontainerJson");
        this.devcontainerJson = devcontainerJson;
    }

    private final int findLastObjectOrValue() {
        JsonParser parser = this.createParser(this.devcontainerJson);
        int lastOffset = -1;
        int prevObjectEnd = -1;
        while (!parser.isClosed()) {
            JsonToken jsonToken = parser.nextToken();
            if (jsonToken == null) {
                if (prevObjectEnd < 0) break;
                lastOffset = prevObjectEnd;
                break;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    lastOffset = (int)parser.getTokenLocation().getCharOffset() + parser.getTextLength() + 1;
                    break;
                }
                case 7: {
                    lastOffset = (int)parser.getTokenLocation().getCharOffset() + 1;
                    break;
                }
                case 8: {
                    prevObjectEnd = lastOffset;
                    lastOffset = (int)parser.getTokenLocation().getCharOffset() + 1;
                }
            }
        }
        parser.close();
        String string = this.devcontainerJson.substring(lastOffset, lastOffset + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        if (Intrinsics.areEqual((Object)string, (Object)"\"")) {
            ++lastOffset;
        }
        return lastOffset;
    }

    private final Pair<Integer, Integer> findCustomizationSection() {
        JsonToken jsonToken;
        JsonParser parser = this.createParser(this.devcontainerJson);
        int startOffset = -1;
        int endOffset = -1;
        int nestingLevel = 0;
        while (!parser.isClosed() && (jsonToken = parser.nextToken()) != null) {
            String fieldName = parser.getCurrentName();
            if (Intrinsics.areEqual((Object)fieldName, (Object)"customizations") && startOffset == -1) {
                startOffset = (int)parser.getTokenLocation().getCharOffset();
            }
            if (startOffset < 0) continue;
            if (jsonToken == JsonToken.START_OBJECT) {
                ++nestingLevel;
                continue;
            }
            if (jsonToken != JsonToken.END_OBJECT || --nestingLevel != 0) continue;
            endOffset = (int)parser.getTokenLocation().getCharOffset();
            break;
        }
        parser.close();
        return (0 <= startOffset ? startOffset < endOffset : false) ? new Pair((Object)startOffset, (Object)endOffset) : null;
    }

    private final Pair<Integer, Integer> findCustomizationsMarker() {
        int start2 = StringsKt.indexOf$default((CharSequence)this.devcontainerJson, (String)"// \"customizations\": {},", (int)0, (boolean)false, (int)6, null);
        return start2 >= 0 ? new Pair((Object)start2, (Object)(start2 + 24)) : null;
    }

    private final JsonParser createParser(String json2) {
        JsonParser parser;
        JsonParser jsonParser;
        JsonFactory factory = new JsonFactory();
        JsonParser jsonParser2 = factory.createParser(json2);
        Intrinsics.checkNotNullExpressionValue((Object)jsonParser2, (String)"createParser(...)");
        JsonParser $this$createParser_u24lambda_u240 = jsonParser = (parser = jsonParser2);
        boolean bl = false;
        $this$createParser_u24lambda_u240.enable(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES.mappedFeature());
        $this$createParser_u24lambda_u240.enable(JsonReadFeature.ALLOW_TRAILING_COMMA.mappedFeature());
        $this$createParser_u24lambda_u240.enable(JsonReadFeature.ALLOW_SINGLE_QUOTES.mappedFeature());
        $this$createParser_u24lambda_u240.enable(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature());
        $this$createParser_u24lambda_u240.enable(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS.mappedFeature());
        $this$createParser_u24lambda_u240.enable(JsonReadFeature.ALLOW_JAVA_COMMENTS.mappedFeature());
        $this$createParser_u24lambda_u240.enable(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature());
        return parser;
    }

    private final String generateCustomizations(String backend, List<String> plugins, Map<String, String> options2) {
        DevcontainerCustomizations ideConfig = new DevcontainerCustomizations(new DevcontainerIdeConfig(new DevcontainerIntellijIdeConfig(backend, plugins, options2)));
        ObjectMapper objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        String string = objectMapper.writeValueAsString((Object)ideConfig);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        char[] cArray = new char[]{'{'};
        String string2 = StringsKt.trimStart((String)string, (char[])cArray);
        cArray = new char[]{'}'};
        return StringsKt.trimEnd((String)string2, (char[])cArray);
    }

    static /* synthetic */ String generateCustomizations$default(DevcontainerIdeConfigManipulator devcontainerIdeConfigManipulator, String string, List list2, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return devcontainerIdeConfigManipulator.generateCustomizations(string, list2, map2);
    }

    @NotNull
    public final String addCustomizations(@NotNull String preferredIde) {
        Intrinsics.checkNotNullParameter((Object)preferredIde, (String)"preferredIde");
        try {
            DevcontainerJsonModel model2 = DevcontainerJsonModel.Companion.fromString(this.devcontainerJson);
            DevcontainerIdeConfig devcontainerIdeConfig = model2.getCustomizations();
            if ((devcontainerIdeConfig != null ? devcontainerIdeConfig.getJetbrains() : null) != null) {
                return this.devcontainerJson;
            }
        }
        catch (Exception e) {
            return this.devcontainerJson;
        }
        String customizations = ((Object)StringsKt.trimEnd((CharSequence)DevcontainerIdeConfigManipulator.generateCustomizations$default(this, preferredIde, null, null, 6, null))).toString();
        Pair<Integer, Integer> pair = this.findCustomizationSection();
        if (pair != null) {
            Pair<Integer, Integer> it = pair;
            boolean bl = false;
            return this.replaceRange(this.devcontainerJson, it, customizations);
        }
        int lastObjectOffset = this.findLastObjectOrValue();
        if (lastObjectOffset >= 0) {
            String string = this.devcontainerJson.substring(lastObjectOffset, lastObjectOffset + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            if (!Intrinsics.areEqual((Object)string, (Object)",")) {
                String withInsertedComma = this.insert(this.devcontainerJson, lastObjectOffset, ",");
                Pair<Integer, Integer> it = this.findCustomizationsMarker();
                if (it != null) {
                    Pair<Integer, Integer> it2 = it;
                    boolean bl = false;
                    return this.replaceRange(withInsertedComma, it2, customizations + ",");
                }
                int closingBraceOffset = StringsKt.lastIndexOf$default((CharSequence)withInsertedComma, (String)"}", (int)0, (boolean)false, (int)6, null);
                if (closingBraceOffset > 0) {
                    return this.insert(withInsertedComma, closingBraceOffset - 1, customizations + "\n");
                }
            }
        }
        return this.devcontainerJson;
    }

    private final String replaceRange(String str, Pair<Integer, Integer> range, String newContent) {
        String string = str.substring(0, ((Number)range.getFirst()).intValue() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = str.substring(((Number)range.getSecond()).intValue() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string + newContent + string2;
    }

    private final String insert(String str, int offset, String content2) {
        String string = str.substring(0, offset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = str.substring(offset, this.devcontainerJson.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string + content2 + string2;
    }

    @Serializable
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB#\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u0011\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0015\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u00c1\u0001\u00a2\u0006\u0002\b\u001bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/docker/agent/devcontainers/ideSettings/DevcontainerIdeConfigManipulator$DevcontainerCustomizations;", "", "seen1", "", "customizations", "Lcom/intellij/docker/agent/devcontainers/ideSettings/DevcontainerIdeConfig;", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/intellij/docker/agent/devcontainers/ideSettings/DevcontainerIdeConfig;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lcom/intellij/docker/agent/devcontainers/ideSettings/DevcontainerIdeConfig;)V", "getCustomizations", "()Lcom/intellij/docker/agent/devcontainers/ideSettings/DevcontainerIdeConfig;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_clouds_docker_agent", "$serializer", "Companion", "intellij.clouds.docker.agent"})
    public static final class DevcontainerCustomizations {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final DevcontainerIdeConfig customizations;

        public DevcontainerCustomizations(@Nullable DevcontainerIdeConfig customizations) {
            this.customizations = customizations;
        }

        public /* synthetic */ DevcontainerCustomizations(DevcontainerIdeConfig devcontainerIdeConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                devcontainerIdeConfig = null;
            }
            this(devcontainerIdeConfig);
        }

        @Nullable
        public final DevcontainerIdeConfig getCustomizations() {
            return this.customizations;
        }

        @Nullable
        public final DevcontainerIdeConfig component1() {
            return this.customizations;
        }

        @NotNull
        public final DevcontainerCustomizations copy(@Nullable DevcontainerIdeConfig customizations) {
            return new DevcontainerCustomizations(customizations);
        }

        public static /* synthetic */ DevcontainerCustomizations copy$default(DevcontainerCustomizations devcontainerCustomizations, DevcontainerIdeConfig devcontainerIdeConfig, int n, Object object) {
            if ((n & 1) != 0) {
                devcontainerIdeConfig = devcontainerCustomizations.customizations;
            }
            return devcontainerCustomizations.copy(devcontainerIdeConfig);
        }

        @NotNull
        public String toString() {
            return "DevcontainerCustomizations(customizations=" + this.customizations + ")";
        }

        public int hashCode() {
            return this.customizations == null ? 0 : this.customizations.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DevcontainerCustomizations)) {
                return false;
            }
            DevcontainerCustomizations devcontainerCustomizations = (DevcontainerCustomizations)other;
            return Intrinsics.areEqual((Object)this.customizations, (Object)devcontainerCustomizations.customizations);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_clouds_docker_agent(DevcontainerCustomizations self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.customizations != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)DevcontainerIdeConfig$.serializer.INSTANCE, (Object)self.customizations);
            }
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ DevcontainerCustomizations(int seen1, DevcontainerIdeConfig customizations, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen1) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)DevcontainerCustomizations$$serializer.INSTANCE.getDescriptor());
            }
            this.customizations = (seen1 & 1) == 0 ? null : customizations;
        }

        public DevcontainerCustomizations() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/agent/devcontainers/ideSettings/DevcontainerIdeConfigManipulator$DevcontainerCustomizations$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/docker/agent/devcontainers/ideSettings/DevcontainerIdeConfigManipulator$DevcontainerCustomizations;", "intellij.clouds.docker.agent"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<DevcontainerCustomizations> serializer() {
                return (KSerializer)DevcontainerCustomizations$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonToken.values().length];
            try {
                nArray[JsonToken.VALUE_STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.VALUE_FALSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.VALUE_TRUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.VALUE_NULL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.VALUE_NUMBER_FLOAT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.VALUE_NUMBER_INT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.END_ARRAY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.END_OBJECT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

