/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers.feautures;

import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.DockerDeploymentConfig;
import com.intellij.docker.agent.devcontainers.DevcontainerJsonModel;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerDataExchangeProxy;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeature;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeatureBuilder;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeatureBuilderKt;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeatureSet;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.impl.DockerDefaultImageBuilder;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.util.MD5;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001cH\u0002J\b\u0010#\u001a\u00020\u001cH\u0002J\b\u0010$\u001a\u00020\u001cH\u0002J\u0010\u0010%\u001a\u0004\u0018\u00010\u0011H\u0086@\u00a2\u0006\u0002\u0010&R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureBuilder;", "", "image", "Lcom/intellij/docker/agent/DockerAgentImage;", "devcontainerDir", "Ljava/io/File;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "agent", "Lcom/intellij/docker/agent/DockerAgent;", "model", "Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel;", "(Lcom/intellij/docker/agent/DockerAgentImage;Ljava/io/File;Lkotlin/coroutines/CoroutineContext;Lcom/intellij/docker/agent/DockerAgent;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel;)V", "proxy", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;", "(Lcom/intellij/docker/agent/DockerAgentImage;Ljava/io/File;Lcom/intellij/docker/agent/DockerAgent;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel;Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;)V", "substitutedDockerFile", "Ljava/nio/file/Path;", "tempPath", "cleanup", "", "createBaseDockerfile", "createBaseImageFiles", "createFeatureFiles", "f", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature;", "createImage", "imageName", "", "dockerFile", "(Ljava/lang/String;Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createInstallScriptWrapper", "destPath", "createSubstitutedDockerFile", "baseImageName", "getBaseImageName", "getExtendedDockerContent", "setupDockerFile", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDevcontainerFeatureBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerFeatureBuilder.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,179:1\n1855#2,2:180\n1855#2,2:182\n1855#2,2:186\n13309#3,2:184\n*S KotlinDebug\n*F\n+ 1 DevcontainerFeatureBuilder.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureBuilder\n*L\n57#1:180,2\n73#1:182,2\n131#1:186,2\n107#1:184,2\n*E\n"})
public final class DevcontainerFeatureBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerAgentImage image;
    @NotNull
    private final File devcontainerDir;
    @NotNull
    private final DockerAgent agent;
    @NotNull
    private final DevcontainerJsonModel model;
    @NotNull
    private final DevcontainerDataExchangeProxy proxy;
    @Nullable
    private Path tempPath;
    @Nullable
    private Path substitutedDockerFile;
    @NotNull
    public static final String WRAPPER_SCRIPT = "devcontainer-feature-setup.sh";
    @NotNull
    public static final String FEATURE_SETUP_DIR = "/tmp/jb-devcontainer-features";
    @NotNull
    public static final String BASE_DOCKERFILE = "Dockerfile.features";
    @NotNull
    public static final String BASE_IMAGE_PREFIX = "jb-devcontainer-features";

    public DevcontainerFeatureBuilder(@NotNull DockerAgentImage image, @NotNull File devcontainerDir, @NotNull DockerAgent agent, @NotNull DevcontainerJsonModel model2, @NotNull DevcontainerDataExchangeProxy proxy) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)devcontainerDir, (String)"devcontainerDir");
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        this.image = image;
        this.devcontainerDir = devcontainerDir;
        this.agent = agent;
        this.model = model2;
        this.proxy = proxy;
    }

    public DevcontainerFeatureBuilder(@NotNull DockerAgentImage image, @NotNull File devcontainerDir, @NotNull CoroutineContext coroutineContext, @NotNull DockerAgent agent, @NotNull DevcontainerJsonModel model2) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)devcontainerDir, (String)"devcontainerDir");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this(image, devcontainerDir, agent, model2, new DevcontainerDataExchangeProxy.RemoteProxy(DevcontainerDataExchangeProxy.Companion.getCurrMessagesPrinter(coroutineContext)));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object setupDockerFile(@NotNull Continuation<? super Path> var1_1) {
        if (!(var1_1 instanceof setupDockerFile.1)) ** GOTO lbl-1000
        var6_2 = var1_1;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DevcontainerFeatureBuilder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.setupDockerFile((Continuation<? super Path>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.model.getFeatureSet() == null || this.model.getFeatureSet().getFeatures().isEmpty()) {
                    return null;
                }
                this.createBaseImageFiles();
                var3_5 = new String[]{"Dockerfile.features"};
                baseDockerFile = Path.of(String.valueOf(this.tempPath), var3_5).toFile();
                v0 = this.getBaseImageName();
                Intrinsics.checkNotNull((Object)baseDockerFile);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = this.createImage(v0, baseDockerFile, (Continuation<? super Unit>)$continuation);
                if (v1 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl29
            }
            case 1: {
                this = (DevcontainerFeatureBuilder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                if ((v2 /* !! */  = (clientImage = this.image.getImage()).getRepoTags()) == null || (v2 /* !! */  = (String)ArraysKt.firstOrNull((Object[])v2 /* !! */ )) == null) {
                    v3 = clientImage.getRepoDigests();
                    v2 /* !! */  = v3 != null ? (String)ArraysKt.firstOrNull((Object[])v3) : null;
                    if (v2 /* !! */  == null) {
                        v2 /* !! */  = clientImage.getId();
                    }
                }
                var4_7 /* !! */  = v2 /* !! */ ;
                Intrinsics.checkNotNull((Object)var4_7 /* !! */ );
                return this.createSubstitutedDockerFile((String)var4_7 /* !! */ );
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void cleanup() {
        block0: {
            Path path = this.substitutedDockerFile;
            if (path == null) break block0;
            Files.deleteIfExists(path);
        }
    }

    private final String getBaseImageName() {
        StringBuilder content2 = new StringBuilder();
        content2.append(this.devcontainerDir.getPath());
        Object object = this.model.getFeatureSet();
        if (object != null && (object = ((DevcontainerFeatureSet)object).getFeatures()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DevcontainerFeature it = (DevcontainerFeature)element$iv;
                boolean bl = false;
                content2.append(it.getRef());
            }
        }
        String string = content2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "jb-devcontainer-features-" + MD5.INSTANCE.getHash(string);
    }

    private final Object createImage(String imageName2, File dockerFile, Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{imageName2};
        this.proxy.getPrinter().printInfo(DockerAgentBundle.Companion.message("devcontainers.feature.creating.base.image", objectArray));
        String[] stringArray = new String[]{imageName2};
        DockerAgentDeploymentConfig config = DockerDeploymentConfig.FromFile$default(DockerDeploymentConfig.INSTANCE, dockerFile, false, null, null, null, stringArray, null, 94, null);
        TtySink tty2 = DevcontainerDataExchangeProxy.Companion.getCurrTty($completion.getContext());
        DockerDefaultImageBuilder imageBuilder = new DockerDefaultImageBuilder(tty2, this.agent.getDockerClient(), config, this.agent);
        Object object = imageBuilder.build($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void createBaseImageFiles() {
        this.tempPath = Files.createTempDirectory("devcontainer-features-image-temp-", new FileAttribute[0]);
        Object object = this.model.getFeatureSet();
        if (object != null && (object = ((DevcontainerFeatureSet)object).getFeatures()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DevcontainerFeature it = (DevcontainerFeature)element$iv;
                boolean bl = false;
                this.createFeatureFiles(it);
            }
        }
        this.createBaseDockerfile();
    }

    private final void createFeatureFiles(DevcontainerFeature f) {
        String cachePath = f.getCachePath();
        if (cachePath == null) {
            Object[] objectArray = new Object[]{f.getRef().getId()};
            this.proxy.getPrinter().printError(DockerAgentBundle.Companion.message("devcontainers.feature.installation.data.not.found", objectArray));
            return;
        }
        String[] stringArray = new String[]{f.getFeatureFolderName()};
        Path destPath = Path.of(String.valueOf(this.tempPath), stringArray);
        FileUtils.forceMkdir((File)destPath.toFile());
        Object[] objectArray = new String[]{"install.sh"};
        Path installScript = Path.of(cachePath.toString(), (String[])objectArray);
        if (!Files.exists(installScript, new LinkOption[0])) {
            objectArray = new Object[]{f.getRef().getId()};
            this.proxy.getPrinter().printError(DockerAgentBundle.Companion.message("devcontainers.feature.install.script.is.missing", objectArray));
            return;
        }
        FileUtils.copyDirectory((File)new File(cachePath), (File)destPath.toFile());
        Intrinsics.checkNotNull((Object)destPath);
        this.createInstallScriptWrapper(f, destPath);
    }

    private final void createBaseDockerfile() {
        StringBuilder content2 = new StringBuilder();
        content2.append("FROM scratch\nCOPY . /tmp/jb-devcontainer-features");
        Object object = new String[]{BASE_DOCKERFILE};
        Path path = Path.of(String.valueOf(this.tempPath), (String[])object);
        String string = content2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        object = string;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Files.write(path, byArray, new OpenOption[0]);
    }

    private final void createInstallScriptWrapper(DevcontainerFeature f, Path destPath) {
        String[] stringArray = new String[]{WRAPPER_SCRIPT};
        Path scriptPath = Path.of(((Object)destPath).toString(), stringArray);
        StringBuilder scriptContent = new StringBuilder();
        scriptContent.append("echo Installing " + f.getConfig().getId() + " feature...\n");
        DockerEnvVar[] dockerEnvVarArray = f.getFeatureEnv();
        if (dockerEnvVarArray != null) {
            DockerEnvVar[] $this$forEach$iv = dockerEnvVarArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                DockerEnvVar element$iv;
                DockerEnvVar it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                scriptContent.append("export " + it.getName() + "=" + it.getValue() + "\n");
            }
        }
        scriptContent.append("chmod +x ./install.sh\n").append("./install.sh");
        String string = scriptContent.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Files.write(scriptPath, byArray, new OpenOption[0]);
    }

    private final String getExtendedDockerContent() {
        Object object;
        Object object2;
        Map<String, String> it;
        StringBuilder content2 = new StringBuilder();
        content2.append("COPY --from=" + this.getBaseImageName() + " /tmp/jb-devcontainer-features /tmp/jb-devcontainer-features/\n");
        Map<String, String> map2 = this.model.getContainerEnv();
        if (map2 != null && (map2 = DevcontainerFeatureBuilderKt.access$asDockerfileEnvs(map2)) != null) {
            it = map2;
            boolean bl = false;
            content2.append((String)((Object)it));
            content2.append('\n');
        }
        if ((object2 = DevcontainerFeatureBuilderKt.access$getUserEnv(this.model)) != null && (object2 = DevcontainerFeatureBuilderKt.access$asDockerfileEnvs((Map)object2)) != null) {
            it = object2;
            boolean bl = false;
            content2.append((String)((Object)it));
            content2.append('\n');
        }
        if ((object = this.model.getFeatureSet()) != null && (object = ((DevcontainerFeatureSet)object).getFeatures()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DevcontainerFeature f = (DevcontainerFeature)element$iv;
                boolean bl = false;
                String featurePath = "/tmp/jb-devcontainer-features/" + f.getFeatureFolderName();
                content2.append('\n');
                Map<String, String> map3 = f.getConfig().getContainerEnv();
                if (map3 != null && (map3 = DevcontainerFeatureBuilderKt.access$asDockerfileEnvs(map3)) != null) {
                    Map<String, String> it2 = map3;
                    boolean bl2 = false;
                    content2.append((String)((Object)it2));
                    content2.append('\n');
                }
                content2.append("USER root\n");
                content2.append(StringsKt.trimIndent((String)("\n        RUN chmod -R 0755 " + featurePath + " \\\n        && cd " + featurePath + " \\\n        && chmod +x ./devcontainer-feature-setup.sh \\\n        && ./devcontainer-feature-setup.sh\n      ")));
            }
        }
        String string = content2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final Path createSubstitutedDockerFile(String baseImageName) {
        String[] stringArray = new String[]{".features.temp.dockerfile"};
        Path path = Path.of(this.devcontainerDir.getPath(), stringArray);
        StringBuilder content2 = new StringBuilder();
        content2.append("FROM " + baseImageName + "\n");
        content2.append(this.getExtendedDockerContent());
        String string = content2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Files.write(path, byArray, new OpenOption[0]);
        this.substitutedDockerFile = path;
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    public static final /* synthetic */ Object access$createImage(DevcontainerFeatureBuilder $this, String imageName2, File dockerFile, Continuation $completion) {
        return $this.createImage(imageName2, dockerFile, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureBuilder$Companion;", "", "()V", "BASE_DOCKERFILE", "", "BASE_IMAGE_PREFIX", "FEATURE_SETUP_DIR", "WRAPPER_SCRIPT", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

