/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers.feautures;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intellij.docker.agent.devcontainers.DevcontainerJsonModel;
import com.intellij.docker.agent.devcontainers.LifecycleScriptDeserializer;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerResource;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerMount;
import com.intellij.docker.agent.util.DockerJsonUtilsKt;
import io.ktor.util.TextKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u0000  2\u00020\u0001:\b !\"#$%&'B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0015\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0007\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0007H\u0007J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\b\u0010\u001f\u001a\u00020\u0007H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature;", "", "ref", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$Ref;", "config", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$FeatureConfig;", "cachePath", "", "(Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$Ref;Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$FeatureConfig;Ljava/lang/String;)V", "getCachePath", "()Ljava/lang/String;", "getConfig", "()Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$FeatureConfig;", "getRef", "()Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$Ref;", "component1", "component2", "component3", "copy", "equals", "", "other", "getEnvVarName", "optionName", "getFeatureEnv", "", "Lcom/intellij/docker/agent/settings/DockerEnvVar;", "()[Lcom/intellij/docker/agent/settings/DockerEnvVar;", "getFeatureFolderName", "hashCode", "", "toString", "Companion", "FeatureConfig", "FeatureExtractor", "FeatureOption", "JsonModel", "Manifest", "ManifestConfig", "ManifestLayer", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDevcontainerFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerFeatures.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,353:1\n125#2:354\n152#2,3:355\n37#3,2:358\n*S KotlinDebug\n*F\n+ 1 DevcontainerFeatures.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature\n*L\n51#1:354\n51#1:355,3\n53#1:358,2\n*E\n"})
public final class DevcontainerFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DevcontainerResource.Ref ref;
    @NotNull
    private final FeatureConfig config;
    @Nullable
    private final String cachePath;
    @NotNull
    public static final String FEATURE_INSTALL_SCRIPT = "install.sh";
    @NotNull
    public static final String SUBSTITUTED_DOCKER_FILE = ".features.temp.dockerfile";

    public DevcontainerFeature(@NotNull DevcontainerResource.Ref ref, @NotNull FeatureConfig config, @Nullable String cachePath) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.ref = ref;
        this.config = config;
        this.cachePath = cachePath;
    }

    public /* synthetic */ DevcontainerFeature(DevcontainerResource.Ref ref, FeatureConfig featureConfig, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(ref, featureConfig, string);
    }

    @NotNull
    public final DevcontainerResource.Ref getRef() {
        return this.ref;
    }

    @NotNull
    public final FeatureConfig getConfig() {
        return this.config;
    }

    @Nullable
    public final String getCachePath() {
        return this.cachePath;
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @Nullable
    public final DockerEnvVar[] getFeatureEnv() {
        DockerEnvVar[] dockerEnvVarArray;
        Map<String, FeatureOption> map2 = this.config.getOptions();
        if (map2 != null) {
            void $this$mapTo$iv$iv;
            Map<String, FeatureOption> $this$map$iv = map2;
            boolean $i$f$map = false;
            Map<String, FeatureOption> map3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new DockerEnvVarImpl(this.getEnvVarName((String)it.getKey()), ((FeatureOption)it.getValue()).getValue()));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            dockerEnvVarArray = thisCollection$iv.toArray(new DockerEnvVar[0]);
        } else {
            dockerEnvVarArray = null;
        }
        return dockerEnvVarArray;
    }

    private final String getEnvVarName(String optionName) {
        CharSequence charSequence = optionName;
        Regex regex = new Regex("[^\\w_]");
        String string = "_";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("^[\\d_]+");
        string = "_";
        return TextKt.toUpperCasePreservingASCIIRules((String)regex.replace(charSequence, string));
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.ref);
    }

    @JsonIgnore
    @NotNull
    public final String getFeatureFolderName() {
        return StringsKt.replace$default((String)(this.ref.getRegistry() + "-" + this.ref.getNamespace() + "-" + this.ref.getId() + "-" + this.ref.getTag()), (char)'/', (char)'-', (boolean)false, (int)4, null);
    }

    @NotNull
    public final DevcontainerResource.Ref component1() {
        return this.ref;
    }

    @NotNull
    public final FeatureConfig component2() {
        return this.config;
    }

    @Nullable
    public final String component3() {
        return this.cachePath;
    }

    @NotNull
    public final DevcontainerFeature copy(@NotNull DevcontainerResource.Ref ref, @NotNull FeatureConfig config, @Nullable String cachePath) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new DevcontainerFeature(ref, config, cachePath);
    }

    public static /* synthetic */ DevcontainerFeature copy$default(DevcontainerFeature devcontainerFeature, DevcontainerResource.Ref ref, FeatureConfig featureConfig, String string, int n, Object object) {
        if ((n & 1) != 0) {
            ref = devcontainerFeature.ref;
        }
        if ((n & 2) != 0) {
            featureConfig = devcontainerFeature.config;
        }
        if ((n & 4) != 0) {
            string = devcontainerFeature.cachePath;
        }
        return devcontainerFeature.copy(ref, featureConfig, string);
    }

    public int hashCode() {
        int result2 = this.ref.hashCode();
        result2 = result2 * 31 + this.config.hashCode();
        result2 = result2 * 31 + (this.cachePath == null ? 0 : this.cachePath.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DevcontainerFeature)) {
            return false;
        }
        DevcontainerFeature devcontainerFeature = (DevcontainerFeature)other;
        if (!Intrinsics.areEqual((Object)this.ref, (Object)devcontainerFeature.ref)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.config, (Object)devcontainerFeature.config)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.cachePath, (Object)devcontainerFeature.cachePath);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$Companion;", "", "()V", "FEATURE_INSTALL_SCRIPT", "", "SUBSTITUTED_DOCKER_FILE", "extractFrom", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature;", "jsonParser", "Lcom/fasterxml/jackson/core/JsonParser;", "jsonModel", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$JsonModel;", "readConfig", "", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$FeatureConfig;", "string", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nDevcontainerFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerFeatures.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$Companion\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,353:1\n50#2:354\n43#2:355\n*S KotlinDebug\n*F\n+ 1 DevcontainerFeatures.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$Companion\n*L\n37#1:354\n37#1:355\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<FeatureConfig> readConfig(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            ObjectMapper objectMapper = DockerJsonUtilsKt.createJson5Mapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"enable(...)");
            ObjectMapper $this$readValue$iv = objectMapper;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            return (List)$this$readValue$iv.readValue(string, (TypeReference)new TypeReference<List<? extends FeatureConfig>>(){});
        }

        @NotNull
        public final DevcontainerFeature extractFrom(@NotNull JsonParser jsonParser, @NotNull JsonModel jsonModel) {
            Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
            Intrinsics.checkNotNullParameter((Object)jsonModel, (String)"jsonModel");
            return new FeatureExtractor(jsonParser).extractFrom(jsonModel);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b?\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u00cd\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\n\u0012\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u0012\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u0012\u0010\b\u0002\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0011\u0012\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u0012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001b\u0012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001b\u0012\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001b\u0012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u001b\u0012\b\b\u0002\u0010 \u001a\u00020\u0011\u00a2\u0006\u0002\u0010!J\u000b\u0010?\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010@\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003\u00a2\u0006\u0002\u0010'J\u0010\u0010A\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003\u00a2\u0006\u0002\u0010'J\u0011\u0010B\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eH\u00c6\u0003J\u0011\u0010C\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010D\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010E\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000eH\u00c6\u0003J\u0010\u0010F\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003\u00a2\u0006\u0002\u0010'J\u0011\u0010G\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010H\u001a\u0004\u0018\u00010\u001bH\u00c6\u0003J\u000b\u0010I\u001a\u0004\u0018\u00010\u001bH\u00c6\u0003J\u000b\u0010J\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010K\u001a\u0004\u0018\u00010\u001bH\u00c6\u0003J\u000b\u0010L\u001a\u0004\u0018\u00010\u001bH\u00c6\u0003J\u000b\u0010M\u001a\u0004\u0018\u00010\u001bH\u00c6\u0003J\t\u0010N\u001a\u00020\u0011H\u00c6\u0003J\u000b\u0010O\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010P\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010Q\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010R\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0017\u0010S\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u00c6\u0003J\u0017\u0010T\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\nH\u00c6\u0003J\u0011\u0010U\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u00c6\u0003J\u00d6\u0002\u0010V\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\n2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000e2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010 \u001a\u00020\u0011H\u00c6\u0001\u00a2\u0006\u0002\u0010WJ\u0013\u0010X\u001a\u00020\u00112\b\u0010Y\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010Z\u001a\u00020[H\u00d6\u0001J\t\u0010\\\u001a\u00020\u0003H\u00d6\u0001R\u0019\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001f\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0015\u0010\u0018\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b&\u0010'R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010*R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010*R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010*R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b.\u0010'R\u0019\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010#R\u0011\u0010 \u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b \u00100R\u0019\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010#R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010*R\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010#R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010*R\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u001b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010%R\u0015\u0010\u001f\u001a\u0004\u0018\u00010\u001b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00106R\u0015\u0010\u001d\u001a\u0004\u0018\u00010\u001b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00106R\u0015\u0010\u001e\u001a\u0004\u0018\u00010\u001b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00106R\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b;\u0010'R\u0019\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010#R\u0015\u0010\u001c\u001a\u0004\u0018\u00010\u001b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u00106R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010*\u00a8\u0006]"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$FeatureConfig;", "", "id", "", "version", "name", "description", "documentationURL", "licenseURL", "options", "", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$FeatureOption;", "containerEnv", "mounts", "", "Lcom/intellij/docker/agent/settings/DockerMount;", "init", "", "privileged", "capAdd", "securityOpt", "entrypoint", "installsAfter", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$Ref;", "deprecated", "legacyIds", "onCreateCommand", "Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel$LifecycleScript;", "updateContentCommand", "postCreateCommand", "postStartCommand", "postAttachCommand", "isRequired", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;Ljava/util/List;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel$LifecycleScript;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel$LifecycleScript;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel$LifecycleScript;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel$LifecycleScript;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel$LifecycleScript;Z)V", "getCapAdd", "()Ljava/util/List;", "getContainerEnv", "()Ljava/util/Map;", "getDeprecated", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getDescription", "()Ljava/lang/String;", "getDocumentationURL", "getEntrypoint", "getId", "getInit", "getInstallsAfter", "()Z", "getLegacyIds", "getLicenseURL", "getMounts", "getName", "getOnCreateCommand", "()Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel$LifecycleScript;", "getOptions", "getPostAttachCommand", "getPostCreateCommand", "getPostStartCommand", "getPrivileged", "getSecurityOpt", "getUpdateContentCommand", "getVersion", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component23", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;Ljava/util/List;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel$LifecycleScript;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel$LifecycleScript;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel$LifecycleScript;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel$LifecycleScript;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel$LifecycleScript;Z)Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$FeatureConfig;", "equals", "other", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
    public static final class FeatureConfig {
        @Nullable
        private final String id;
        @Nullable
        private final String version;
        @Nullable
        private final String name;
        @Nullable
        private final String description;
        @Nullable
        private final String documentationURL;
        @Nullable
        private final String licenseURL;
        @Nullable
        private final Map<String, FeatureOption> options;
        @Nullable
        private final Map<String, String> containerEnv;
        @Nullable
        private final List<DockerMount> mounts;
        @Nullable
        private final Boolean init;
        @Nullable
        private final Boolean privileged;
        @Nullable
        private final List<String> capAdd;
        @Nullable
        private final List<String> securityOpt;
        @Nullable
        private final String entrypoint;
        @Nullable
        private final List<DevcontainerResource.Ref> installsAfter;
        @Nullable
        private final Boolean deprecated;
        @Nullable
        private final List<String> legacyIds;
        @Nullable
        private final DevcontainerJsonModel.LifecycleScript onCreateCommand;
        @Nullable
        private final DevcontainerJsonModel.LifecycleScript updateContentCommand;
        @Nullable
        private final DevcontainerJsonModel.LifecycleScript postCreateCommand;
        @Nullable
        private final DevcontainerJsonModel.LifecycleScript postStartCommand;
        @Nullable
        private final DevcontainerJsonModel.LifecycleScript postAttachCommand;
        private final boolean isRequired;

        public FeatureConfig(@Nullable String id, @Nullable String version2, @Nullable String name2, @Nullable String description, @Nullable String documentationURL, @Nullable String licenseURL, @Nullable Map<String, FeatureOption> options2, @Nullable Map<String, String> containerEnv, @Nullable List<DockerMount> mounts, @Nullable Boolean init2, @Nullable Boolean privileged2, @Nullable List<String> capAdd2, @Nullable List<String> securityOpt2, @Nullable String entrypoint2, @Nullable List<DevcontainerResource.Ref> installsAfter, @Nullable Boolean deprecated, @Nullable List<String> legacyIds, @Nullable DevcontainerJsonModel.LifecycleScript onCreateCommand, @Nullable DevcontainerJsonModel.LifecycleScript updateContentCommand, @Nullable DevcontainerJsonModel.LifecycleScript postCreateCommand, @Nullable DevcontainerJsonModel.LifecycleScript postStartCommand, @Nullable DevcontainerJsonModel.LifecycleScript postAttachCommand, boolean isRequired) {
            this.id = id;
            this.version = version2;
            this.name = name2;
            this.description = description;
            this.documentationURL = documentationURL;
            this.licenseURL = licenseURL;
            this.options = options2;
            this.containerEnv = containerEnv;
            this.mounts = mounts;
            this.init = init2;
            this.privileged = privileged2;
            this.capAdd = capAdd2;
            this.securityOpt = securityOpt2;
            this.entrypoint = entrypoint2;
            this.installsAfter = installsAfter;
            this.deprecated = deprecated;
            this.legacyIds = legacyIds;
            this.onCreateCommand = onCreateCommand;
            this.updateContentCommand = updateContentCommand;
            this.postCreateCommand = postCreateCommand;
            this.postStartCommand = postStartCommand;
            this.postAttachCommand = postAttachCommand;
            this.isRequired = isRequired;
        }

        public /* synthetic */ FeatureConfig(String string, String string2, String string3, String string4, String string5, String string6, Map map2, Map map3, List list2, Boolean bl, Boolean bl2, List list3, List list4, String string7, List list5, Boolean bl3, List list6, DevcontainerJsonModel.LifecycleScript lifecycleScript, DevcontainerJsonModel.LifecycleScript lifecycleScript2, DevcontainerJsonModel.LifecycleScript lifecycleScript3, DevcontainerJsonModel.LifecycleScript lifecycleScript4, DevcontainerJsonModel.LifecycleScript lifecycleScript5, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                string5 = null;
            }
            if ((n & 0x20) != 0) {
                string6 = null;
            }
            if ((n & 0x40) != 0) {
                map2 = null;
            }
            if ((n & 0x80) != 0) {
                map3 = null;
            }
            if ((n & 0x100) != 0) {
                list2 = null;
            }
            if ((n & 0x200) != 0) {
                bl = null;
            }
            if ((n & 0x400) != 0) {
                bl2 = null;
            }
            if ((n & 0x800) != 0) {
                list3 = null;
            }
            if ((n & 0x1000) != 0) {
                list4 = null;
            }
            if ((n & 0x2000) != 0) {
                string7 = null;
            }
            if ((n & 0x4000) != 0) {
                list5 = null;
            }
            if ((n & 0x8000) != 0) {
                bl3 = null;
            }
            if ((n & 0x10000) != 0) {
                list6 = null;
            }
            if ((n & 0x20000) != 0) {
                lifecycleScript = null;
            }
            if ((n & 0x40000) != 0) {
                lifecycleScript2 = null;
            }
            if ((n & 0x80000) != 0) {
                lifecycleScript3 = null;
            }
            if ((n & 0x100000) != 0) {
                lifecycleScript4 = null;
            }
            if ((n & 0x200000) != 0) {
                lifecycleScript5 = null;
            }
            if ((n & 0x400000) != 0) {
                bl4 = true;
            }
            this(string, string2, string3, string4, string5, string6, map2, map3, list2, bl, bl2, list3, list4, string7, list5, bl3, list6, lifecycleScript, lifecycleScript2, lifecycleScript3, lifecycleScript4, lifecycleScript5, bl4);
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @Nullable
        public final String getDocumentationURL() {
            return this.documentationURL;
        }

        @Nullable
        public final String getLicenseURL() {
            return this.licenseURL;
        }

        @Nullable
        public final Map<String, FeatureOption> getOptions() {
            return this.options;
        }

        @Nullable
        public final Map<String, String> getContainerEnv() {
            return this.containerEnv;
        }

        @Nullable
        public final List<DockerMount> getMounts() {
            return this.mounts;
        }

        @Nullable
        public final Boolean getInit() {
            return this.init;
        }

        @Nullable
        public final Boolean getPrivileged() {
            return this.privileged;
        }

        @Nullable
        public final List<String> getCapAdd() {
            return this.capAdd;
        }

        @Nullable
        public final List<String> getSecurityOpt() {
            return this.securityOpt;
        }

        @Nullable
        public final String getEntrypoint() {
            return this.entrypoint;
        }

        @Nullable
        public final List<DevcontainerResource.Ref> getInstallsAfter() {
            return this.installsAfter;
        }

        @Nullable
        public final Boolean getDeprecated() {
            return this.deprecated;
        }

        @Nullable
        public final List<String> getLegacyIds() {
            return this.legacyIds;
        }

        @JsonDeserialize(using=LifecycleScriptDeserializer.class)
        @Nullable
        public final DevcontainerJsonModel.LifecycleScript getOnCreateCommand() {
            return this.onCreateCommand;
        }

        @JsonDeserialize(using=LifecycleScriptDeserializer.class)
        @Nullable
        public final DevcontainerJsonModel.LifecycleScript getUpdateContentCommand() {
            return this.updateContentCommand;
        }

        @JsonDeserialize(using=LifecycleScriptDeserializer.class)
        @Nullable
        public final DevcontainerJsonModel.LifecycleScript getPostCreateCommand() {
            return this.postCreateCommand;
        }

        @JsonDeserialize(using=LifecycleScriptDeserializer.class)
        @Nullable
        public final DevcontainerJsonModel.LifecycleScript getPostStartCommand() {
            return this.postStartCommand;
        }

        @JsonDeserialize(using=LifecycleScriptDeserializer.class)
        @Nullable
        public final DevcontainerJsonModel.LifecycleScript getPostAttachCommand() {
            return this.postAttachCommand;
        }

        public final boolean isRequired() {
            return this.isRequired;
        }

        @Nullable
        public final String component1() {
            return this.id;
        }

        @Nullable
        public final String component2() {
            return this.version;
        }

        @Nullable
        public final String component3() {
            return this.name;
        }

        @Nullable
        public final String component4() {
            return this.description;
        }

        @Nullable
        public final String component5() {
            return this.documentationURL;
        }

        @Nullable
        public final String component6() {
            return this.licenseURL;
        }

        @Nullable
        public final Map<String, FeatureOption> component7() {
            return this.options;
        }

        @Nullable
        public final Map<String, String> component8() {
            return this.containerEnv;
        }

        @Nullable
        public final List<DockerMount> component9() {
            return this.mounts;
        }

        @Nullable
        public final Boolean component10() {
            return this.init;
        }

        @Nullable
        public final Boolean component11() {
            return this.privileged;
        }

        @Nullable
        public final List<String> component12() {
            return this.capAdd;
        }

        @Nullable
        public final List<String> component13() {
            return this.securityOpt;
        }

        @Nullable
        public final String component14() {
            return this.entrypoint;
        }

        @Nullable
        public final List<DevcontainerResource.Ref> component15() {
            return this.installsAfter;
        }

        @Nullable
        public final Boolean component16() {
            return this.deprecated;
        }

        @Nullable
        public final List<String> component17() {
            return this.legacyIds;
        }

        @Nullable
        public final DevcontainerJsonModel.LifecycleScript component18() {
            return this.onCreateCommand;
        }

        @Nullable
        public final DevcontainerJsonModel.LifecycleScript component19() {
            return this.updateContentCommand;
        }

        @Nullable
        public final DevcontainerJsonModel.LifecycleScript component20() {
            return this.postCreateCommand;
        }

        @Nullable
        public final DevcontainerJsonModel.LifecycleScript component21() {
            return this.postStartCommand;
        }

        @Nullable
        public final DevcontainerJsonModel.LifecycleScript component22() {
            return this.postAttachCommand;
        }

        public final boolean component23() {
            return this.isRequired;
        }

        @NotNull
        public final FeatureConfig copy(@Nullable String id, @Nullable String version2, @Nullable String name2, @Nullable String description, @Nullable String documentationURL, @Nullable String licenseURL, @Nullable Map<String, FeatureOption> options2, @Nullable Map<String, String> containerEnv, @Nullable List<DockerMount> mounts, @Nullable Boolean init2, @Nullable Boolean privileged2, @Nullable List<String> capAdd2, @Nullable List<String> securityOpt2, @Nullable String entrypoint2, @Nullable List<DevcontainerResource.Ref> installsAfter, @Nullable Boolean deprecated, @Nullable List<String> legacyIds, @Nullable DevcontainerJsonModel.LifecycleScript onCreateCommand, @Nullable DevcontainerJsonModel.LifecycleScript updateContentCommand, @Nullable DevcontainerJsonModel.LifecycleScript postCreateCommand, @Nullable DevcontainerJsonModel.LifecycleScript postStartCommand, @Nullable DevcontainerJsonModel.LifecycleScript postAttachCommand, boolean isRequired) {
            return new FeatureConfig(id, version2, name2, description, documentationURL, licenseURL, options2, containerEnv, mounts, init2, privileged2, capAdd2, securityOpt2, entrypoint2, installsAfter, deprecated, legacyIds, onCreateCommand, updateContentCommand, postCreateCommand, postStartCommand, postAttachCommand, isRequired);
        }

        public static /* synthetic */ FeatureConfig copy$default(FeatureConfig featureConfig, String string, String string2, String string3, String string4, String string5, String string6, Map map2, Map map3, List list2, Boolean bl, Boolean bl2, List list3, List list4, String string7, List list5, Boolean bl3, List list6, DevcontainerJsonModel.LifecycleScript lifecycleScript, DevcontainerJsonModel.LifecycleScript lifecycleScript2, DevcontainerJsonModel.LifecycleScript lifecycleScript3, DevcontainerJsonModel.LifecycleScript lifecycleScript4, DevcontainerJsonModel.LifecycleScript lifecycleScript5, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                string = featureConfig.id;
            }
            if ((n & 2) != 0) {
                string2 = featureConfig.version;
            }
            if ((n & 4) != 0) {
                string3 = featureConfig.name;
            }
            if ((n & 8) != 0) {
                string4 = featureConfig.description;
            }
            if ((n & 0x10) != 0) {
                string5 = featureConfig.documentationURL;
            }
            if ((n & 0x20) != 0) {
                string6 = featureConfig.licenseURL;
            }
            if ((n & 0x40) != 0) {
                map2 = featureConfig.options;
            }
            if ((n & 0x80) != 0) {
                map3 = featureConfig.containerEnv;
            }
            if ((n & 0x100) != 0) {
                list2 = featureConfig.mounts;
            }
            if ((n & 0x200) != 0) {
                bl = featureConfig.init;
            }
            if ((n & 0x400) != 0) {
                bl2 = featureConfig.privileged;
            }
            if ((n & 0x800) != 0) {
                list3 = featureConfig.capAdd;
            }
            if ((n & 0x1000) != 0) {
                list4 = featureConfig.securityOpt;
            }
            if ((n & 0x2000) != 0) {
                string7 = featureConfig.entrypoint;
            }
            if ((n & 0x4000) != 0) {
                list5 = featureConfig.installsAfter;
            }
            if ((n & 0x8000) != 0) {
                bl3 = featureConfig.deprecated;
            }
            if ((n & 0x10000) != 0) {
                list6 = featureConfig.legacyIds;
            }
            if ((n & 0x20000) != 0) {
                lifecycleScript = featureConfig.onCreateCommand;
            }
            if ((n & 0x40000) != 0) {
                lifecycleScript2 = featureConfig.updateContentCommand;
            }
            if ((n & 0x80000) != 0) {
                lifecycleScript3 = featureConfig.postCreateCommand;
            }
            if ((n & 0x100000) != 0) {
                lifecycleScript4 = featureConfig.postStartCommand;
            }
            if ((n & 0x200000) != 0) {
                lifecycleScript5 = featureConfig.postAttachCommand;
            }
            if ((n & 0x400000) != 0) {
                bl4 = featureConfig.isRequired;
            }
            return featureConfig.copy(string, string2, string3, string4, string5, string6, map2, map3, list2, bl, bl2, list3, list4, string7, list5, bl3, list6, lifecycleScript, lifecycleScript2, lifecycleScript3, lifecycleScript4, lifecycleScript5, bl4);
        }

        @NotNull
        public String toString() {
            return "FeatureConfig(id=" + this.id + ", version=" + this.version + ", name=" + this.name + ", description=" + this.description + ", documentationURL=" + this.documentationURL + ", licenseURL=" + this.licenseURL + ", options=" + this.options + ", containerEnv=" + this.containerEnv + ", mounts=" + this.mounts + ", init=" + this.init + ", privileged=" + this.privileged + ", capAdd=" + this.capAdd + ", securityOpt=" + this.securityOpt + ", entrypoint=" + this.entrypoint + ", installsAfter=" + this.installsAfter + ", deprecated=" + this.deprecated + ", legacyIds=" + this.legacyIds + ", onCreateCommand=" + this.onCreateCommand + ", updateContentCommand=" + this.updateContentCommand + ", postCreateCommand=" + this.postCreateCommand + ", postStartCommand=" + this.postStartCommand + ", postAttachCommand=" + this.postAttachCommand + ", isRequired=" + this.isRequired + ")";
        }

        public int hashCode() {
            int result2 = this.id == null ? 0 : this.id.hashCode();
            result2 = result2 * 31 + (this.version == null ? 0 : this.version.hashCode());
            result2 = result2 * 31 + (this.name == null ? 0 : this.name.hashCode());
            result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
            result2 = result2 * 31 + (this.documentationURL == null ? 0 : this.documentationURL.hashCode());
            result2 = result2 * 31 + (this.licenseURL == null ? 0 : this.licenseURL.hashCode());
            result2 = result2 * 31 + (this.options == null ? 0 : ((Object)this.options).hashCode());
            result2 = result2 * 31 + (this.containerEnv == null ? 0 : ((Object)this.containerEnv).hashCode());
            result2 = result2 * 31 + (this.mounts == null ? 0 : ((Object)this.mounts).hashCode());
            result2 = result2 * 31 + (this.init == null ? 0 : ((Object)this.init).hashCode());
            result2 = result2 * 31 + (this.privileged == null ? 0 : ((Object)this.privileged).hashCode());
            result2 = result2 * 31 + (this.capAdd == null ? 0 : ((Object)this.capAdd).hashCode());
            result2 = result2 * 31 + (this.securityOpt == null ? 0 : ((Object)this.securityOpt).hashCode());
            result2 = result2 * 31 + (this.entrypoint == null ? 0 : this.entrypoint.hashCode());
            result2 = result2 * 31 + (this.installsAfter == null ? 0 : ((Object)this.installsAfter).hashCode());
            result2 = result2 * 31 + (this.deprecated == null ? 0 : ((Object)this.deprecated).hashCode());
            result2 = result2 * 31 + (this.legacyIds == null ? 0 : ((Object)this.legacyIds).hashCode());
            result2 = result2 * 31 + (this.onCreateCommand == null ? 0 : this.onCreateCommand.hashCode());
            result2 = result2 * 31 + (this.updateContentCommand == null ? 0 : this.updateContentCommand.hashCode());
            result2 = result2 * 31 + (this.postCreateCommand == null ? 0 : this.postCreateCommand.hashCode());
            result2 = result2 * 31 + (this.postStartCommand == null ? 0 : this.postStartCommand.hashCode());
            result2 = result2 * 31 + (this.postAttachCommand == null ? 0 : this.postAttachCommand.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.isRequired);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FeatureConfig)) {
                return false;
            }
            FeatureConfig featureConfig = (FeatureConfig)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)featureConfig.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)featureConfig.version)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)featureConfig.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)featureConfig.description)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.documentationURL, (Object)featureConfig.documentationURL)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.licenseURL, (Object)featureConfig.licenseURL)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.options, featureConfig.options)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.containerEnv, featureConfig.containerEnv)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.mounts, featureConfig.mounts)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.init, (Object)featureConfig.init)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.privileged, (Object)featureConfig.privileged)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.capAdd, featureConfig.capAdd)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.securityOpt, featureConfig.securityOpt)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.entrypoint, (Object)featureConfig.entrypoint)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.installsAfter, featureConfig.installsAfter)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.deprecated, (Object)featureConfig.deprecated)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.legacyIds, featureConfig.legacyIds)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.onCreateCommand, (Object)featureConfig.onCreateCommand)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.updateContentCommand, (Object)featureConfig.updateContentCommand)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.postCreateCommand, (Object)featureConfig.postCreateCommand)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.postStartCommand, (Object)featureConfig.postStartCommand)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.postAttachCommand, (Object)featureConfig.postAttachCommand)) {
                return false;
            }
            return this.isRequired == featureConfig.isRequired;
        }

        public FeatureConfig() {
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, 0x7FFFFF, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ*\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$FeatureExtractor;", "", "jsonParser", "Lcom/fasterxml/jackson/core/JsonParser;", "(Lcom/fasterxml/jackson/core/JsonParser;)V", "getJsonParser", "()Lcom/fasterxml/jackson/core/JsonParser;", "extractFrom", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature;", "jsonModel", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$JsonModel;", "extractOptions", "", "", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$FeatureOption;", "rawOptions", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nDevcontainerFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerFeatures.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$FeatureExtractor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,353:1\n453#2:354\n403#2:355\n1238#3,4:356\n*S KotlinDebug\n*F\n+ 1 DevcontainerFeatures.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$FeatureExtractor\n*L\n74#1:354\n74#1:355\n74#1:356,4\n*E\n"})
    private static final class FeatureExtractor {
        @NotNull
        private final JsonParser jsonParser;

        public FeatureExtractor(@NotNull JsonParser jsonParser) {
            Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
            this.jsonParser = jsonParser;
        }

        @NotNull
        public final JsonParser getJsonParser() {
            return this.jsonParser;
        }

        @NotNull
        public final DevcontainerFeature extractFrom(@NotNull JsonModel jsonModel) {
            Intrinsics.checkNotNullParameter((Object)jsonModel, (String)"jsonModel");
            if (jsonModel.getId() == null) {
                throw new JsonMappingException((Closeable)this.jsonParser, DockerAgentBundle.Companion.message("devcontainer.feature.missing.mandatory.identifier", new Object[0]));
            }
            DevcontainerResource.Ref ref = new DevcontainerResource.Ref(jsonModel.getId());
            String string = ref.getId();
            Map map2 = jsonModel.getOptions();
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            FeatureConfig config = new FeatureConfig(string, null, null, null, null, null, this.extractOptions(map2), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, 8388542, null);
            return new DevcontainerFeature(ref, config, null, 4, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, FeatureOption> extractOptions(Map<String, String> rawOptions) {
            void $this$mapValuesTo$iv$iv;
            Map<String, String> $this$mapValues$iv = rawOptions;
            boolean $i$f$mapValues = false;
            Map<String, String> map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void entry;
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                FeatureOption featureOption = new FeatureOption(null, null, (String)entry.getValue(), null, null, 27, null);
                map4.put(k, featureOption);
            }
            return destination$iv$iv;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001BG\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JK\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$FeatureOption;", "", "type", "", "default", "value", "proposals", "", "description", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getDefault", "()Ljava/lang/String;", "getDescription", "getProposals", "()Ljava/util/List;", "getType", "getValue", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "mergeWith", "toString", "intellij.clouds.docker.agent"})
    public static final class FeatureOption {
        @Nullable
        private final String type;
        @Nullable
        private final String default;
        @Nullable
        private final String value;
        @Nullable
        private final List<String> proposals;
        @Nullable
        private final String description;

        public FeatureOption(@Nullable String type, @Nullable String string, @Nullable String value, @Nullable List<String> proposals, @Nullable String description) {
            this.type = type;
            this.default = string;
            this.value = value;
            this.proposals = proposals;
            this.description = description;
        }

        public /* synthetic */ FeatureOption(String string, String string2, String string3, List list2, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = string2;
            }
            if ((n & 8) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 0x10) != 0) {
                string4 = null;
            }
            this(string, string2, string3, list2, string4);
        }

        @Nullable
        public final String getType() {
            return this.type;
        }

        @Nullable
        public final String getDefault() {
            return this.default;
        }

        @Nullable
        public final String getValue() {
            return this.value;
        }

        @Nullable
        public final List<String> getProposals() {
            return this.proposals;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final FeatureOption mergeWith(@NotNull FeatureOption other) {
            String string;
            String newDefault;
            String string2;
            String newType;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            String string3 = this.type;
            if (string3 == null) {
                string3 = newType = other.type;
            }
            if ((string2 = this.default) == null) {
                string2 = newDefault = other.default;
            }
            if ((string = this.value) == null) {
                string = other.default;
            }
            String newValue = string;
            return new FeatureOption(newType, newDefault, newValue, this.proposals, this.description);
        }

        @Nullable
        public final String component1() {
            return this.type;
        }

        @Nullable
        public final String component2() {
            return this.default;
        }

        @Nullable
        public final String component3() {
            return this.value;
        }

        @Nullable
        public final List<String> component4() {
            return this.proposals;
        }

        @Nullable
        public final String component5() {
            return this.description;
        }

        @NotNull
        public final FeatureOption copy(@Nullable String type, @Nullable String string, @Nullable String value, @Nullable List<String> proposals, @Nullable String description) {
            return new FeatureOption(type, string, value, proposals, description);
        }

        public static /* synthetic */ FeatureOption copy$default(FeatureOption featureOption, String string, String string2, String string3, List list2, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = featureOption.type;
            }
            if ((n & 2) != 0) {
                string2 = featureOption.default;
            }
            if ((n & 4) != 0) {
                string3 = featureOption.value;
            }
            if ((n & 8) != 0) {
                list2 = featureOption.proposals;
            }
            if ((n & 0x10) != 0) {
                string4 = featureOption.description;
            }
            return featureOption.copy(string, string2, string3, list2, string4);
        }

        @NotNull
        public String toString() {
            return "FeatureOption(type=" + this.type + ", default=" + this.default + ", value=" + this.value + ", proposals=" + this.proposals + ", description=" + this.description + ")";
        }

        public int hashCode() {
            int result2 = this.type == null ? 0 : this.type.hashCode();
            result2 = result2 * 31 + (this.default == null ? 0 : this.default.hashCode());
            result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
            result2 = result2 * 31 + (this.proposals == null ? 0 : ((Object)this.proposals).hashCode());
            result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FeatureOption)) {
                return false;
            }
            FeatureOption featureOption = (FeatureOption)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)featureOption.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.default, (Object)featureOption.default)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.value, (Object)featureOption.value)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.proposals, featureOption.proposals)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)featureOption.description);
        }

        public FeatureOption() {
            this(null, null, null, null, null, 31, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0017\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005H\u00c6\u0003J-\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$JsonModel;", "", "id", "", "options", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getId", "()Ljava/lang/String;", "getOptions", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clouds.docker.agent"})
    public static final class JsonModel {
        @Nullable
        private final String id;
        @Nullable
        private final Map<String, String> options;

        public JsonModel(@Nullable String id, @Nullable Map<String, String> options2) {
            this.id = id;
            this.options = options2;
        }

        public /* synthetic */ JsonModel(String string, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                map2 = null;
            }
            this(string, map2);
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final Map<String, String> getOptions() {
            return this.options;
        }

        @Nullable
        public final String component1() {
            return this.id;
        }

        @Nullable
        public final Map<String, String> component2() {
            return this.options;
        }

        @NotNull
        public final JsonModel copy(@Nullable String id, @Nullable Map<String, String> options2) {
            return new JsonModel(id, options2);
        }

        public static /* synthetic */ JsonModel copy$default(JsonModel jsonModel, String string, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                string = jsonModel.id;
            }
            if ((n & 2) != 0) {
                map2 = jsonModel.options;
            }
            return jsonModel.copy(string, map2);
        }

        @NotNull
        public String toString() {
            return "JsonModel(id=" + this.id + ", options=" + this.options + ")";
        }

        public int hashCode() {
            int result2 = this.id == null ? 0 : this.id.hashCode();
            result2 = result2 * 31 + (this.options == null ? 0 : ((Object)this.options).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JsonModel)) {
                return false;
            }
            JsonModel jsonModel = (JsonModel)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)jsonModel.id)) {
                return false;
            }
            return Intrinsics.areEqual(this.options, jsonModel.options);
        }

        public JsonModel() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$Manifest;", "", "schemaVersion", "", "mediaType", "", "config", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$ManifestConfig;", "layers", "", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$ManifestLayer;", "(ILjava/lang/String;Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$ManifestConfig;Ljava/util/List;)V", "getConfig", "()Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$ManifestConfig;", "getLayers", "()Ljava/util/List;", "getMediaType", "()Ljava/lang/String;", "getSchemaVersion", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.clouds.docker.agent"})
    public static final class Manifest {
        private final int schemaVersion;
        @NotNull
        private final String mediaType;
        @NotNull
        private final ManifestConfig config;
        @NotNull
        private final List<ManifestLayer> layers;

        public Manifest(int schemaVersion, @NotNull String mediaType, @NotNull ManifestConfig config, @NotNull List<ManifestLayer> layers) {
            Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter(layers, (String)"layers");
            this.schemaVersion = schemaVersion;
            this.mediaType = mediaType;
            this.config = config;
            this.layers = layers;
        }

        public final int getSchemaVersion() {
            return this.schemaVersion;
        }

        @NotNull
        public final String getMediaType() {
            return this.mediaType;
        }

        @NotNull
        public final ManifestConfig getConfig() {
            return this.config;
        }

        @NotNull
        public final List<ManifestLayer> getLayers() {
            return this.layers;
        }

        public final int component1() {
            return this.schemaVersion;
        }

        @NotNull
        public final String component2() {
            return this.mediaType;
        }

        @NotNull
        public final ManifestConfig component3() {
            return this.config;
        }

        @NotNull
        public final List<ManifestLayer> component4() {
            return this.layers;
        }

        @NotNull
        public final Manifest copy(int schemaVersion, @NotNull String mediaType, @NotNull ManifestConfig config, @NotNull List<ManifestLayer> layers) {
            Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter(layers, (String)"layers");
            return new Manifest(schemaVersion, mediaType, config, layers);
        }

        public static /* synthetic */ Manifest copy$default(Manifest manifest, int n, String string, ManifestConfig manifestConfig, List list2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = manifest.schemaVersion;
            }
            if ((n2 & 2) != 0) {
                string = manifest.mediaType;
            }
            if ((n2 & 4) != 0) {
                manifestConfig = manifest.config;
            }
            if ((n2 & 8) != 0) {
                list2 = manifest.layers;
            }
            return manifest.copy(n, string, manifestConfig, list2);
        }

        @NotNull
        public String toString() {
            return "Manifest(schemaVersion=" + this.schemaVersion + ", mediaType=" + this.mediaType + ", config=" + this.config + ", layers=" + this.layers + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.schemaVersion);
            result2 = result2 * 31 + this.mediaType.hashCode();
            result2 = result2 * 31 + this.config.hashCode();
            result2 = result2 * 31 + ((Object)this.layers).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Manifest)) {
                return false;
            }
            Manifest manifest = (Manifest)other;
            if (this.schemaVersion != manifest.schemaVersion) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mediaType, (Object)manifest.mediaType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.config, (Object)manifest.config)) {
                return false;
            }
            return Intrinsics.areEqual(this.layers, manifest.layers);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$ManifestConfig;", "", "digest", "", "mediaType", "size", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "getDigest", "()Ljava/lang/String;", "getMediaType", "getSize", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.clouds.docker.agent"})
    public static final class ManifestConfig {
        @NotNull
        private final String digest;
        @NotNull
        private final String mediaType;
        private final int size;

        public ManifestConfig(@NotNull String digest, @NotNull String mediaType, int size) {
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
            this.digest = digest;
            this.mediaType = mediaType;
            this.size = size;
        }

        @NotNull
        public final String getDigest() {
            return this.digest;
        }

        @NotNull
        public final String getMediaType() {
            return this.mediaType;
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final String component1() {
            return this.digest;
        }

        @NotNull
        public final String component2() {
            return this.mediaType;
        }

        public final int component3() {
            return this.size;
        }

        @NotNull
        public final ManifestConfig copy(@NotNull String digest, @NotNull String mediaType, int size) {
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
            return new ManifestConfig(digest, mediaType, size);
        }

        public static /* synthetic */ ManifestConfig copy$default(ManifestConfig manifestConfig, String string, String string2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = manifestConfig.digest;
            }
            if ((n2 & 2) != 0) {
                string2 = manifestConfig.mediaType;
            }
            if ((n2 & 4) != 0) {
                n = manifestConfig.size;
            }
            return manifestConfig.copy(string, string2, n);
        }

        @NotNull
        public String toString() {
            return "ManifestConfig(digest=" + this.digest + ", mediaType=" + this.mediaType + ", size=" + this.size + ")";
        }

        public int hashCode() {
            int result2 = this.digest.hashCode();
            result2 = result2 * 31 + this.mediaType.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.size);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ManifestConfig)) {
                return false;
            }
            ManifestConfig manifestConfig = (ManifestConfig)other;
            if (!Intrinsics.areEqual((Object)this.digest, (Object)manifestConfig.digest)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mediaType, (Object)manifestConfig.mediaType)) {
                return false;
            }
            return this.size == manifestConfig.size;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$ManifestLayer;", "", "mediaType", "", "digest", "size", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "getDigest", "()Ljava/lang/String;", "getMediaType", "getSize", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.clouds.docker.agent"})
    public static final class ManifestLayer {
        @NotNull
        private final String mediaType;
        @NotNull
        private final String digest;
        private final int size;

        public ManifestLayer(@NotNull String mediaType, @NotNull String digest, int size) {
            Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            this.mediaType = mediaType;
            this.digest = digest;
            this.size = size;
        }

        @NotNull
        public final String getMediaType() {
            return this.mediaType;
        }

        @NotNull
        public final String getDigest() {
            return this.digest;
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final String component1() {
            return this.mediaType;
        }

        @NotNull
        public final String component2() {
            return this.digest;
        }

        public final int component3() {
            return this.size;
        }

        @NotNull
        public final ManifestLayer copy(@NotNull String mediaType, @NotNull String digest, int size) {
            Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            return new ManifestLayer(mediaType, digest, size);
        }

        public static /* synthetic */ ManifestLayer copy$default(ManifestLayer manifestLayer, String string, String string2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = manifestLayer.mediaType;
            }
            if ((n2 & 2) != 0) {
                string2 = manifestLayer.digest;
            }
            if ((n2 & 4) != 0) {
                n = manifestLayer.size;
            }
            return manifestLayer.copy(string, string2, n);
        }

        @NotNull
        public String toString() {
            return "ManifestLayer(mediaType=" + this.mediaType + ", digest=" + this.digest + ", size=" + this.size + ")";
        }

        public int hashCode() {
            int result2 = this.mediaType.hashCode();
            result2 = result2 * 31 + this.digest.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.size);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ManifestLayer)) {
                return false;
            }
            ManifestLayer manifestLayer = (ManifestLayer)other;
            if (!Intrinsics.areEqual((Object)this.mediaType, (Object)manifestLayer.mediaType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.digest, (Object)manifestLayer.digest)) {
                return false;
            }
            return this.size == manifestLayer.size;
        }
    }
}

