/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/agent/devcontainers/DevcontainerDiagnostics;", "", "()V", "evaluateFailurePlace", "Lcom/intellij/docker/agent/devcontainers/DevcontainerDiagnostics$FailurePlace;", "t", "", "FailurePlace", "intellij.clouds.docker.agent"})
public final class DevcontainerDiagnostics {
    @NotNull
    public static final DevcontainerDiagnostics INSTANCE = new DevcontainerDiagnostics();

    private DevcontainerDiagnostics() {
    }

    @Nullable
    public final FailurePlace evaluateFailurePlace(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        ClassLoader currLoader = DevcontainerDiagnostics.class.getClassLoader();
        try {
            StackTraceElement[] stackTraceElementArray = t.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            Object[] objectArray = stackTraceElementArray;
            if (!(objectArray.length == 0)) {
                StackTraceElement topElement = t.getStackTrace()[0];
                Class<?> clazz = Class.forName(topElement.getClassName(), false, currLoader);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
                return new FailurePlace(clazz, topElement.getLineNumber());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/agent/devcontainers/DevcontainerDiagnostics$FailurePlace;", "", "clazz", "Ljava/lang/Class;", "lineNumber", "", "(Ljava/lang/Class;I)V", "getClazz", "()Ljava/lang/Class;", "getLineNumber", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.clouds.docker.agent"})
    public static final class FailurePlace {
        @NotNull
        private final Class<?> clazz;
        private final int lineNumber;

        public FailurePlace(@NotNull Class<?> clazz, int lineNumber) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            this.clazz = clazz;
            this.lineNumber = lineNumber;
        }

        @NotNull
        public final Class<?> getClazz() {
            return this.clazz;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        @NotNull
        public final Class<?> component1() {
            return this.clazz;
        }

        public final int component2() {
            return this.lineNumber;
        }

        @NotNull
        public final FailurePlace copy(@NotNull Class<?> clazz, int lineNumber) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            return new FailurePlace(clazz, lineNumber);
        }

        public static /* synthetic */ FailurePlace copy$default(FailurePlace failurePlace, Class clazz, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                clazz = failurePlace.clazz;
            }
            if ((n2 & 2) != 0) {
                n = failurePlace.lineNumber;
            }
            return failurePlace.copy(clazz, n);
        }

        @NotNull
        public String toString() {
            return "FailurePlace(clazz=" + this.clazz + ", lineNumber=" + this.lineNumber + ")";
        }

        public int hashCode() {
            int result2 = this.clazz.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.lineNumber);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FailurePlace)) {
                return false;
            }
            FailurePlace failurePlace = (FailurePlace)other;
            if (!Intrinsics.areEqual(this.clazz, failurePlace.clazz)) {
                return false;
            }
            return this.lineNumber == failurePlace.lineNumber;
        }
    }
}

