/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.cli.model;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.DeviceRequest;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.InternetProtocol;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.ValueTransfer;
import com.intellij.docker.agent.cli.model.CliParserBase;
import com.intellij.docker.agent.cli.model.DockerRunCliParser;
import com.intellij.docker.agent.cli.model.DockerRunCliParserBase;
import com.intellij.docker.agent.fix.FixedBindParser;
import com.intellij.docker.agent.settings.DockerDeviceRequest;
import com.intellij.docker.agent.settings.DockerPortSpec;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ^2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002^_B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001e0\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010$\u001a\f0%R\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0002002\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u0002022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u0002042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u00105\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u0003062\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u0002022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\u0002022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u0002022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u0002022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00020@2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J!\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u00022\f\u0010H\u001a\b\u0012\u0004\u0012\u00020J0I\u00a2\u0006\u0002\u0010KJ\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00020O2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010U\u001a\b\u0012\u0004\u0012\u00020\u0002022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00020Y2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\\\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006`"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerRunCliParser;", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase;", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "()V", "addHost", "Lcom/intellij/docker/agent/cli/model/CliParserBase$StringListHandler;", "option", "Lorg/apache/commons/cli/Option;", "attach", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$AttachOptionHandler;", "blkioWeight", "Lcom/intellij/docker/agent/cli/model/CliParserBase$IntegerOptionHandler;", "capAdd", "Lcom/intellij/docker/agent/cli/model/CliParserBase$MappedListHandler;", "Lcom/github/dockerjava/api/model/Capability;", "capDrop", "cgroupParent", "Lcom/intellij/docker/agent/cli/model/CliParserBase$SingleValueHandler;", "cidfile", "cpuPeriod", "Lcom/intellij/docker/agent/cli/model/CliParserBase$LongOptionHandler;", "cpuQuota", "cpuShares", "cpus", "Lcom/intellij/docker/agent/cli/model/CliParserBase$DoubleOptionHandler;", "cpusetCpus", "cpusetMems", "detach", "Lcom/intellij/docker/agent/cli/model/CliParserBase$BooleanOptionHandler;", "device", "Lcom/github/dockerjava/api/model/Device;", "dns", "dnsSearch", "entrypoint", "env", "Lcom/intellij/docker/agent/cli/model/CliParserBase$ListHandler;", "envFile", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$EnvFileListHandler;", "expose", "gpus", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$GpuDeviceRequestHandler;", "groupAdd", "hostname", "init", "interactive", "ip", "ip6", "ipc", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$IPCOptionHandler;", "kernelMemory", "Lcom/intellij/docker/agent/cli/model/CliParserBase$MemoryOptionHandler;", "label", "Lcom/intellij/docker/agent/cli/model/CliParserBase$LabelListHandler;", "link", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$LinkOptionHandler;", "logDriver", "logOpt", "lxcConf", "macAddress", "memory", "memoryReservation", "memorySwap", "memorySwappiness", "mount", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$MountOptionHandler;", "name", "network", "networkAlias", "oomKillDisable", "parse", "", "cmd", "optionsLine", "", "", "(Lcom/github/dockerjava/api/command/CreateContainerCmd;[Ljava/lang/String;)V", "platform", "privileged", "publish", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$PortBindingOptionHandler;", "publishAll", "restart", "rm", "runtime", "securityOpt", "shmSize", "sysctl", "tty", "ulimit", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$UlimitOptionHandler;", "user", "volume", "volumesFrom", "workingDir", "Companion", "ExposeHandler", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDockerRunCliParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,541:1\n37#2,2:542\n107#3:544\n79#3,29:545\n*S KotlinDebug\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser\n*L\n266#1:542,2\n268#1:544\n268#1:545,29\n*E\n"})
public final class DockerRunCliParser
extends DockerRunCliParserBase<CreateContainerCmd> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void parse(@NotNull CreateContainerCmd cmd, @NotNull String[] optionsLine) throws ApiTaskException {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)optionsLine, (String)"optionsLine");
        try {
            super.doParse(cmd, optionsLine);
        }
        catch (ParseException e) {
            throw new ApiTaskException((Exception)((Object)e));
        }
        catch (CliParserBase.IllegalOptionException e) {
            throw new ApiTaskException(e);
        }
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> name(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.name$lambda$0(name.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> hostname(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.hostname$lambda$1(hostname.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> user(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.user$lambda$2(user.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memory(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.memory$lambda$3(memory.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memorySwap(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.memorySwap$lambda$4(memorySwap.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memorySwappiness(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.memorySwappiness$lambda$5(memorySwappiness.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> shmSize(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.shmSize$lambda$6(shmSize.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.MountOptionHandler<CreateContainerCmd> mount(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.MountOptionHandler<CreateContainerCmd>(option, DockerRunCliParser::mount$lambda$7);
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> kernelMemory(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.kernelMemory$lambda$8(kernelMemory.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memoryReservation(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.memoryReservation$lambda$9(memoryReservation.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cpusetCpus(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cpusetCpus$lambda$10(cpusetCpus.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> cpuShares(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.IntegerOptionHandler<Object>(option, (BiConsumer<Object, Integer>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.cpuShares$lambda$11(cpuShares.1.INSTANCE, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.LongOptionHandler<CreateContainerCmd> cpuPeriod(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.LongOptionHandler<Object>(option, (BiConsumer<Object, Long>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.cpuPeriod$lambda$12(cpuPeriod.1.INSTANCE, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.LongOptionHandler<CreateContainerCmd> cpuQuota(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.LongOptionHandler<Object>(option, (BiConsumer<Object, Long>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.cpuQuota$lambda$13(cpuQuota.1.INSTANCE, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cpusetMems(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cpusetMems$lambda$14(cpusetMems.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.DoubleOptionHandler<CreateContainerCmd> cpus(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.DoubleOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cpus$lambda$15(cpus.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> blkioWeight(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.IntegerOptionHandler<Object>(option, (BiConsumer<Object, Integer>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.blkioWeight$lambda$16(blkioWeight.1.INSTANCE, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> oomKillDisable(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.oomKillDisable$lambda$17(oomKillDisable.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.AttachOptionHandler<CreateContainerCmd> attach(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.AttachOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.attach$lambda$18(attach.1.INSTANCE, arg_0, arg_1), (arg_0, arg_1) -> DockerRunCliParser.attach$lambda$19(attach.2.INSTANCE, arg_0, arg_1), (arg_0, arg_1) -> DockerRunCliParser.attach$lambda$20(attach.3.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> detach(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                block0: {
                    CreateContainerCmd createContainerCmd;
                    if (!value || (createContainerCmd = ((CreateContainerCmd)this.getCmd()).withAttachStdin(false)) == null || (createContainerCmd = createContainerCmd.withAttachStdout(false)) == null) break block0;
                    createContainerCmd.withAttachStderr(false);
                }
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> tty(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.tty$lambda$21(tty.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> interactive(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                ((CreateContainerCmd)this.getCmd()).withStdinOpen(value);
                ((CreateContainerCmd)this.getCmd()).withAttachStdin(value);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> env(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, String>(option, String.class, arg_0 -> DockerRunCliParser.env$lambda$22((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$appendSystemValueIfFound((Companion)this.receiver, p0);
            }
        }, arg_0), (arg_0, arg_1) -> DockerRunCliParser.env$lambda$23((Function2)new Function2<CreateContainerCmd, String[], Unit>((Object)Companion){

            public final void invoke(@NotNull CreateContainerCmd p0, @NotNull String[] p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$appendToCmdEnvironment((Companion)this.receiver, p0, p1);
            }
        }, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.EnvFileListHandler envFile(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.EnvFileListHandler(this, option){

            protected void handleEnvFile(@NotNull String optionValue, @NotNull File file2) {
                Intrinsics.checkNotNullParameter((Object)optionValue, (String)"optionValue");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                String[] envVars = null;
                try {
                    Stream<String> stream = Files.lines(file2.toPath());
                    Intrinsics.checkNotNullExpressionValue(stream, (String)"lines(...)");
                    Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence(stream), (Function1)envFile.handleEnvFile.1.INSTANCE), (Function1)envFile.handleEnvFile.2.INSTANCE), (Function1)((Function1)new Function1<String, String>((Object)DockerRunCliParser.Companion){

                        @NotNull
                        public final String invoke(@NotNull String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$appendSystemValueIfFound((Companion)this.receiver, p0);
                        }
                    })));
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    envVars = thisCollection$iv.toArray(new String[0]);
                }
                catch (IOException e) {
                    throw new CliParserBase.IllegalOptionException("Error reading env-file " + optionValue);
                }
                CMD CMD = this.getCmd();
                Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$appendToCmdEnvironment(DockerRunCliParser.Companion, (CreateContainerCmd)CMD, envVars);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> entrypoint(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.entrypoint$lambda$24(entrypoint.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> workingDir(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.workingDir$lambda$25(workingDir.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> expose(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new ExposeHandler(option);
    }

    @Override
    @NotNull
    protected CliParserBase.StringListHandler<CreateContainerCmd> addHost(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.addHost$lambda$26(addHost.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.LabelListHandler<CreateContainerCmd> label(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.LabelListHandlerImpl<Object>(option, arg_0 -> DockerRunCliParser.label$lambda$27(label.1.INSTANCE, arg_0), (arg_0, arg_1) -> DockerRunCliParser.label$lambda$28(label.2.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> securityOpt(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.securityOpt$lambda$29(securityOpt.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> volume(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.ListHandler<CreateContainerCmd>(option){

            protected void handleValueList(@NotNull String[] values) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                List volumes = new ArrayList<E>();
                List binds = new ArrayList<E>();
                for (String value : values) {
                    if (!StringsKt.contains$default((CharSequence)value, (CharSequence)":", (boolean)false, (int)2, null)) {
                        volumes.add(new Volume(value));
                        continue;
                    }
                    Bind bind = FixedBindParser.parse(value);
                    Intrinsics.checkNotNullExpressionValue((Object)bind, (String)"parse(...)");
                    binds.add(bind);
                }
                if (!volumes.isEmpty()) {
                    ((CreateContainerCmd)this.getCmd()).withVolumes(volumes);
                }
                if (!binds.isEmpty()) {
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withBinds(binds);
                }
            }
        };
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.LinkOptionHandler<CreateContainerCmd, ?> link(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        BiConsumer<CreateContainerCmd, List<Link>> biConsumer = DockerRunCliParser::link$lambda$30;
        return new DockerRunCliParserBase.LinkOptionHandler<CreateContainerCmd, Link>(option, biConsumer){

            @NotNull
            protected Link createLink(@NotNull String name2, @NotNull String alias) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
                return new Link(name2, alias);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> lxcConf(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, LxcConf>(option, LxcConf.class, arg_0 -> DockerRunCliParser.lxcConf$lambda$33(option, arg_0), (arg_0, arg_1) -> DockerRunCliParser.lxcConf$lambda$34(lxcConf.2.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> logDriver(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.SingleValueHandler<CreateContainerCmd>(option){

            protected void handleEachValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Collection $this$toTypedArray$iv = (Collection)logDriver.EntriesMappings.entries$0;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                for (LogConfig.LoggingType loggingType : thisCollection$iv.toArray(new LogConfig.LoggingType[0])) {
                    if (!Intrinsics.areEqual((Object)loggingType.getType(), (Object)value)) continue;
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$getOrCreateLogConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).setType(loggingType);
                    return;
                }
                throw new CliParserBase.IllegalOptionException(this.getOption(), value);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> logOpt(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.ListHandler<CreateContainerCmd>(option){

            /*
             * WARNING - void declaration
             */
            protected void handleValueList(@NotNull String[] values) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                for (String value : values) {
                    int endIndex$iv$iv;
                    int startIndex$iv$iv;
                    CharSequence $this$trim$iv$iv;
                    void $this$toTypedArray$iv;
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    LogConfig logConfig = com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$getOrCreateLogConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD);
                    Map logOptions = logConfig.getConfig();
                    if (logOptions == null) {
                        logOptions = new HashMap<K, V>();
                        logConfig.setConfig(logOptions);
                    }
                    Object object = value;
                    Object object2 = new Regex("=");
                    int n = 2;
                    object = object2.split((CharSequence)object, n);
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] parts = thisCollection$iv.toArray(new String[0]);
                    if (parts.length == 2) {
                        object = logOptions;
                        String $this$trim$iv = parts[0];
                        boolean $i$f$trim = false;
                        CharSequence $this$trim$iv$iv2 = $this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv2 = 0;
                        int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv2 : endIndex$iv$iv2;
                            char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv2;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv2;
                        }
                        object2 = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                        String $this$trim$iv2 = parts[1];
                        boolean $i$f$trim3 = false;
                        $this$trim$iv$iv = $this$trim$iv2;
                        boolean $i$f$trim4 = false;
                        startIndex$iv$iv = 0;
                        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv2 = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv : endIndex$iv$iv;
                            char it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv2) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv2 = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                    } else {
                        throw new CliParserBase.IllegalOptionException(this.getOption(), value);
                    }
                    String string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    object.put(object2, string);
                }
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> macAddress(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.macAddress$lambda$35(macAddress.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.PortBindingOptionHandler<CreateContainerCmd> publish(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.PortBindingOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.publish$lambda$36(publish.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> publishAll(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.publishAll$lambda$37(publishAll.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> privileged(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.privileged$lambda$38(privileged.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.StringListHandler<CreateContainerCmd> dns(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.dns$lambda$39(dns.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.StringListHandler<CreateContainerCmd> dnsSearch(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.dnsSearch$lambda$40(dnsSearch.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MappedListHandler<CreateContainerCmd, ?> volumesFrom(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, VolumesFrom>(option, VolumesFrom.class, arg_0 -> DockerRunCliParser.volumesFrom$lambda$41(volumesFrom.1.INSTANCE, arg_0), (arg_0, arg_1) -> DockerRunCliParser.volumesFrom$lambda$42(volumesFrom.2.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cidfile(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cidfile$lambda$43(cidfile.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> platform(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.platform$lambda$44(platform.1.INSTANCE, arg_0, arg_1));
    }

    @NotNull
    protected CliParserBase.MappedListHandler<CreateContainerCmd, Capability> capAdd(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, Capability>(option, Capability.class, arg_0 -> DockerRunCliParser.capAdd$lambda$45(capAdd.1.INSTANCE, arg_0), (arg_0, arg_1) -> DockerRunCliParser.capAdd$lambda$46(capAdd.2.INSTANCE, arg_0, arg_1));
    }

    @NotNull
    protected CliParserBase.MappedListHandler<CreateContainerCmd, ?> capDrop(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, Capability>(option, Capability.class, arg_0 -> DockerRunCliParser.capDrop$lambda$47(capDrop.1.INSTANCE, arg_0), (arg_0, arg_1) -> DockerRunCliParser.capDrop$lambda$48(capDrop.2.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> restart(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.restart$lambda$49(restart.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> network(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.SingleValueHandler<CreateContainerCmd>(option){

            protected void handleEachValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (StringsKt.equals((String)"none", (String)value, (boolean)true)) {
                    ((CreateContainerCmd)this.getCmd()).withNetworkDisabled(true);
                } else {
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withNetworkMode(value);
                }
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> networkAlias(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.networkAlias$lambda$50(networkAlias.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> ip(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.ip$lambda$51(ip.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> ip6(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.ip6$lambda$52(ip6.1.INSTANCE, arg_0, arg_1));
    }

    @NotNull
    protected CliParserBase.MappedListHandler<CreateContainerCmd, Device> device(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, Device>(option, Device.class, arg_0 -> DockerRunCliParser.device$lambda$53(device.1.INSTANCE, arg_0), (arg_0, arg_1) -> DockerRunCliParser.device$lambda$54(device.2.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> runtime(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.runtime$lambda$55(runtime.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> rm(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                CMD CMD = this.getCmd();
                Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withAutoRemove(value);
            }
        };
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.IPCOptionHandler<CreateContainerCmd> ipc(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.IPCOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.ipc$lambda$56(ipc.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.UlimitOptionHandler<CreateContainerCmd> ulimit(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.UlimitOptionHandler<CreateContainerCmd>(option){

            private final Ulimit toApiLimit(DockerRunCliParserBase.UlimitOptionHandler.CliUlimit limit) {
                return new Ulimit(limit.getName(), limit.getSoft(), limit.getHard());
            }

            /*
             * WARNING - void declaration
             */
            protected void handleUlimits(@NotNull List<DockerRunCliParserBase.UlimitOptionHandler.CliUlimit> limits) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(limits, (String)"limits");
                Iterable $this$map$iv = limits;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    DockerRunCliParserBase.UlimitOptionHandler.CliUlimit cliUlimit = (DockerRunCliParserBase.UlimitOptionHandler.CliUlimit)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.toApiLimit((DockerRunCliParserBase.UlimitOptionHandler.CliUlimit)p0));
                }
                List apiLimits = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                CMD CMD = this.getCmd();
                Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withUlimits(apiLimits);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.StringListHandler<CreateContainerCmd> groupAdd(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.groupAdd$lambda$57(groupAdd.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cgroupParent(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cgroupParent$lambda$58(cgroupParent.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> sysctl(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.sysctl$lambda$59((Function2)new Function2<CreateContainerCmd, String, Unit>(option){
            final /* synthetic */ Option $option;
            {
                this.$option = $option;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CreateContainerCmd cmd, @Nullable String keyValuePair) {
                void $this$toTypedArray$iv;
                Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
                CharSequence charSequence = keyValuePair;
                if (charSequence == null || charSequence.length() == 0) {
                    throw new CliParserBase.IllegalOptionException(this.$option, keyValuePair);
                }
                Object object = keyValuePair;
                Regex regex = new Regex("=");
                int n = 2;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] parts = thisCollection$iv.toArray(new String[0]);
                if (parts.length != 2) {
                    throw new CliParserBase.IllegalOptionException(this.$option, keyValuePair);
                }
                HostConfig hostConfig = com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, cmd);
                Map allSysctls = hostConfig.getSysctls();
                if (allSysctls == null) {
                    allSysctls = new HashMap<K, V>();
                    hostConfig.withSysctls(allSysctls);
                }
                allSysctls.put(parts[0], parts[1]);
            }
        }, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.GpuDeviceRequestHandler<CreateContainerCmd> gpus(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.GpuDeviceRequestHandler<CreateContainerCmd>(option){

            protected void handleDeviceRequest(@NotNull String value, @NotNull DockerDeviceRequest dto) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    HostConfig hostConfig = com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD);
                    if (hostConfig.getDeviceRequests() == null) {
                        hostConfig.withDeviceRequests((List<DeviceRequest>)new ArrayList<E>());
                    }
                    List<DeviceRequest> list2 = hostConfig.getDeviceRequests();
                    if (list2 == null) break block1;
                    list2.add(new DeviceRequest().withDriver(dto.getDriver()).withCount(dto.getCount()).withCapabilities(dto.getCapabilities()).withOptions(dto.getOptions()).withDeviceIds(dto.getDeviceIds()));
                }
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> init(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                CMD CMD = this.getCmd();
                Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withInit(true);
            }
        };
    }

    private static final void name$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void hostname$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void user$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void memory$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void memorySwap$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void memorySwappiness$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void shmSize$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void mount$lambda$7(CreateContainerCmd cmd, List mounts) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withMounts(mounts);
    }

    private static final void kernelMemory$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void memoryReservation$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void cpusetCpus$lambda$10(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void cpuShares$lambda$11(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void cpuPeriod$lambda$12(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void cpuQuota$lambda$13(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void cpusetMems$lambda$14(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void cpus$lambda$15(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void blkioWeight$lambda$16(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void oomKillDisable$lambda$17(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void attach$lambda$18(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void attach$lambda$19(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void attach$lambda$20(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void tty$lambda$21(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final String env$lambda$22(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void env$lambda$23(Function2 $tmp0, Object p0, String[] p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void entrypoint$lambda$24(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void workingDir$lambda$25(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void addHost$lambda$26(Function2 $tmp0, Object p0, String[] p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Map label$lambda$27(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final void label$lambda$28(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void securityOpt$lambda$29(Function2 $tmp0, Object p0, String[] p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void link$lambda$30(CreateContainerCmd cmd, List value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withLinks(value);
    }

    private static final LxcConf lxcConf$lambda$33(Option $option, String source) {
        Intrinsics.checkNotNullParameter((Object)$option, (String)"$option");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        CharSequence charSequence = source;
        Regex regex = new Regex("=");
        int n = 2;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        if (parts.length == 2) {
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            String $this$trim$iv = parts[0];
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            $this$trim$iv = parts[1];
            String string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            $i$f$trim = false;
            $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim2 = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            String string3 = string;
            return new LxcConf(string3, string2);
        }
        throw new CliParserBase.IllegalOptionException($option, source);
    }

    private static final void lxcConf$lambda$34(Function2 $tmp0, Object p0, LxcConf[] p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void macAddress$lambda$35(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void publish$lambda$36(Function2 $tmp0, Object p0, DockerPortSpec[] p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void publishAll$lambda$37(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void privileged$lambda$38(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void dns$lambda$39(Function2 $tmp0, Object p0, String[] p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void dnsSearch$lambda$40(Function2 $tmp0, Object p0, String[] p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final VolumesFrom volumesFrom$lambda$41(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VolumesFrom)$tmp0.invoke(p0);
    }

    private static final void volumesFrom$lambda$42(Function2 $tmp0, Object p0, VolumesFrom[] p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void cidfile$lambda$43(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void platform$lambda$44(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final Capability capAdd$lambda$45(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Capability)((Object)$tmp0.invoke(p0));
    }

    private static final void capAdd$lambda$46(Function2 $tmp0, Object p0, Capability[] p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Capability capDrop$lambda$47(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Capability)((Object)$tmp0.invoke(p0));
    }

    private static final void capDrop$lambda$48(Function2 $tmp0, Object p0, Capability[] p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void restart$lambda$49(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void networkAlias$lambda$50(Function2 $tmp0, Object p0, String[] p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void ip$lambda$51(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void ip6$lambda$52(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final Device device$lambda$53(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Device)$tmp0.invoke(p0);
    }

    private static final void device$lambda$54(Function2 $tmp0, Object p0, Device[] p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void runtime$lambda$55(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void ipc$lambda$56(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void groupAdd$lambda$57(Function2 $tmp0, Object p0, String[] p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void cgroupParent$lambda$58(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void sysctl$lambda$59(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J#\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerRunCliParser$Companion;", "", "()V", "appendSystemValueIfFound", "", "varDeclaration", "appendToCmdEnvironment", "", "cmd", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "env", "", "(Lcom/github/dockerjava/api/command/CreateContainerCmd;[Ljava/lang/String;)V", "findOrCreateHostConfig", "Lcom/github/dockerjava/api/model/HostConfig;", "getOrCreateLogConfig", "Lcom/github/dockerjava/api/model/LogConfig;", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nDockerRunCliParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser$Companion\n+ 2 ValueTransfer.kt\ncom/intellij/docker/agent/ValueTransfer$CombiningListTransfer$Companion\n*L\n1#1,541:1\n48#2,4:542\n*S KotlinDebug\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser$Companion\n*L\n512#1:542,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String appendSystemValueIfFound(String varDeclaration) {
            String localSystemValue;
            Object varDeclaration2 = varDeclaration;
            if (!StringsKt.contains$default((CharSequence)((CharSequence)varDeclaration2), (CharSequence)"=", (boolean)false, (int)2, null) && (localSystemValue = System.getProperty((String)varDeclaration2)) != null && !(((CharSequence)localSystemValue).length() == 0)) {
                varDeclaration2 = (String)varDeclaration2 + "=" + localSystemValue;
            }
            return varDeclaration2;
        }

        private final void appendToCmdEnvironment(CreateContainerCmd cmd, String[] env2) {
            ValueTransfer.CombiningListTransfer.Companion this_$iv = ValueTransfer.CombiningListTransfer.Companion;
            boolean $i$f$mergeArrays = false;
            new ValueTransfer.CombiningListTransfer((Function1)new Function1<String[], List<? extends String>>(env2){
                final /* synthetic */ String[] $env$inlined;
                {
                    this.$env$inlined = stringArray;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                @Nullable
                public final List invoke(Object it) {
                    String[] it2 = (String[])it;
                    boolean bl = false;
                    Object[] objectArray = this.$env$inlined;
                    return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
                }
            }, (Function1)new Function1<CreateContainerCmd, List<? extends String>>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                @Nullable
                public final List invoke(Object it) {
                    CreateContainerCmd p0 = (CreateContainerCmd)it;
                    boolean bl = false;
                    Object[] objectArray = p0.getEnv();
                    return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
                }
            }, (Function2)new Function2<CreateContainerCmd, List<? extends String>, Object>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                @NotNull
                public final Object invoke(Object trg, @NotNull List list2) {
                    void array;
                    Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
                    Collection $this$toTypedArray$iv = list2;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    CreateContainerCmd target = (CreateContainerCmd)trg;
                    boolean bl = false;
                    CreateContainerCmd createContainerCmd = target.withEnv((String[])Arrays.copyOf(array, ((void)array).length));
                    Intrinsics.checkNotNullExpressionValue((Object)createContainerCmd, (String)"withEnv(...)");
                    return createContainerCmd;
                }
            }).transferFromTo(env2, cmd);
        }

        private final LogConfig getOrCreateLogConfig(CreateContainerCmd cmd) {
            HostConfig hostConfig = this.findOrCreateHostConfig(cmd);
            LogConfig result2 = hostConfig.getLogConfig();
            if (result2 == null) {
                result2 = new LogConfig();
                hostConfig.withLogConfig(result2);
            }
            return result2;
        }

        private final HostConfig findOrCreateHostConfig(CreateContainerCmd cmd) {
            HostConfig result2 = cmd.getHostConfig();
            if (result2 == null) {
                result2 = new HostConfig();
                cmd.withHostConfig(result2);
            }
            return result2;
        }

        public static final /* synthetic */ String access$appendSystemValueIfFound(Companion $this, String varDeclaration) {
            return $this.appendSystemValueIfFound(varDeclaration);
        }

        public static final /* synthetic */ void access$appendToCmdEnvironment(Companion $this, CreateContainerCmd cmd, String[] env2) {
            $this.appendToCmdEnvironment(cmd, env2);
        }

        public static final /* synthetic */ LogConfig access$getOrCreateLogConfig(Companion $this, CreateContainerCmd cmd) {
            return $this.getOrCreateLogConfig(cmd);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \b2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0001\bB\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerRunCliParser$ExposeHandler;", "Lcom/intellij/docker/agent/cli/model/CliParserBase$MappedListHandler;", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "", "Lcom/github/dockerjava/api/model/ExposedPort;", "option", "Lorg/apache/commons/cli/Option;", "(Lorg/apache/commons/cli/Option;)V", "Companion", "intellij.clouds.docker.agent"})
    private static final class ExposeHandler
    extends CliParserBase.MappedListHandler<CreateContainerCmd, ExposedPort[]> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final BiFunction<String, Integer, ExposedPort> newExposedPort = ExposeHandler::newExposedPort$lambda$1;

        public ExposeHandler(@NotNull Option option) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            super(option, ExposedPort[].class, arg_0 -> ExposeHandler._init_$lambda$0(option, arg_0), (arg_0, arg_1) -> Companion.access$applyToCmd(Companion, arg_0, arg_1));
        }

        private static final ExposedPort[] _init_$lambda$0(Option $option, String text2) {
            Intrinsics.checkNotNullParameter((Object)$option, (String)"$option");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return ExposeHandler.Companion.parseFromString($option, text2);
        }

        private static final ExposedPort newExposedPort$lambda$1(String protocol, int port) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            String string = protocol.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return new ExposedPort(port, InternetProtocol.valueOf(string));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000f0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0015R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerRunCliParser$ExposeHandler$Companion;", "", "()V", "newExposedPort", "Ljava/util/function/BiFunction;", "", "", "Lcom/github/dockerjava/api/model/ExposedPort;", "getNewExposedPort", "()Ljava/util/function/BiFunction;", "applyToCmd", "", "cmd", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "parsedArray", "", "(Lcom/github/dockerjava/api/command/CreateContainerCmd;[[Lcom/github/dockerjava/api/model/ExposedPort;)V", "parseFromString", "option", "Lorg/apache/commons/cli/Option;", "text", "(Lorg/apache/commons/cli/Option;Ljava/lang/String;)[Lcom/github/dockerjava/api/model/ExposedPort;", "intellij.clouds.docker.agent"})
        @SourceDebugExtension(value={"SMAP\nDockerRunCliParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser$ExposeHandler$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,541:1\n37#2,2:542\n37#2,2:550\n9972#3:544\n10394#3,5:545\n*S KotlinDebug\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser$ExposeHandler$Companion\n*L\n196#1:542,2\n204#1:550,2\n204#1:544\n204#1:545,5\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final ExposedPort[] parseFromString(Option option, String text2) {
                try {
                    Collection $this$toTypedArray$iv = DockerPortSpec.ContainerPortsSpec.Companion.fromString(text2).toNativeList(this.getNewExposedPort());
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    return thisCollection$iv.toArray(new ExposedPort[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new CliParserBase.IllegalOptionException(option, text2);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void applyToCmd(CreateContainerCmd cmd, ExposedPort[][] parsedArray) {
                void $this$toTypedArray$iv;
                void $this$flatMapTo$iv$iv;
                Object $this$flatMap$iv = (Object[])parsedArray;
                boolean $i$f$flatMap = false;
                Object[] objectArray = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                    Object[] it = (ExposedPort[])element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = ArraysKt.toList((Object[])it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                ExposedPort[] flattenedPorts = thisCollection$iv.toArray(new ExposedPort[0]);
                cmd.withExposedPorts(Arrays.copyOf(flattenedPorts, flattenedPorts.length));
            }

            @NotNull
            public final BiFunction<String, Integer, ExposedPort> getNewExposedPort() {
                return newExposedPort;
            }

            public static final /* synthetic */ void access$applyToCmd(Companion $this, CreateContainerCmd cmd, ExposedPort[][] parsedArray) {
                $this.applyToCmd(cmd, parsedArray);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

