/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.cli.model;

import com.intellij.docker.agent.cli.model.CliParserBase;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.cli.Option;

public abstract class DockerBuildCliParserBase<CMD>
extends CliParserBase<CMD> {
    public static final String BUILD_ARG_FROM_ENV_VAR_PREFIX = "$env:";

    @Override
    public List<CliParserBase.OptionHandler<CMD>> createAllHandlers() {
        LinkedList<CliParserBase.OptionHandler<CMD>> result2 = new LinkedList<CliParserBase.OptionHandler<CMD>>();
        result2.add(this.buildArgs(DockerBuildCliParserBase.buildArgsOption()));
        result2.add(this.cacheFrom(DockerBuildCliParserBase.builder13().longOpt("cache-from").hasArg().build()));
        result2.add(this.cpuShares(DockerBuildCliParserBase.builder13("c").longOpt("cpu-shares").hasArg().build()));
        result2.add(this.cpusetCpus(DockerBuildCliParserBase.builder13().longOpt("cpuset-cpus").hasArg().build()));
        result2.add(this.forceRm(DockerBuildCliParserBase.builder13().longOpt("force-rm").hasArg().optionalArg(true).build()));
        result2.add(this.label(DockerBuildCliParserBase.builder13().longOpt("label").hasArg().build()));
        result2.add(this.memory(DockerBuildCliParserBase.builder13("m").longOpt("memory").hasArg().build()));
        result2.add(this.memorySwap(DockerBuildCliParserBase.builder13().longOpt("memory-swap").hasArg().build()));
        result2.add(this.shmSize(DockerBuildCliParserBase.builder13().longOpt("shm-size").hasArg().build()));
        result2.add(this.network(DockerBuildCliParserBase.builder13().longOpt("network").hasArg().build()));
        result2.add(this.noCache(DockerBuildCliParserBase.builder13().longOpt("no-cache").hasArg().optionalArg(true).build()));
        result2.add(this.pull(DockerBuildCliParserBase.builder13().longOpt("pull").hasArg().optionalArg(true).build()));
        result2.add(this.quiet(DockerBuildCliParserBase.builder13("q").longOpt("quiet").hasArg().optionalArg(true).build()));
        result2.add(this.rm(DockerBuildCliParserBase.builder13().longOpt("rm").hasArg().optionalArg(true).build()));
        result2.add(this.target(DockerBuildCliParserBase.builder13().longOpt("target").hasArg().build()));
        result2.add(this.platform(DockerBuildCliParserBase.builder13().longOpt("platform").hasArg().build()));
        result2.add(this.secrets(DockerBuildCliParserBase.builder13().longOpt("secret").hasArg().build()));
        result2.add(this.ssh(DockerBuildCliParserBase.builder13().longOpt("ssh").hasArg().build()));
        result2.add(this.progress(DockerBuildCliParserBase.builder13().longOpt("progress").hasArg().build()));
        return result2;
    }

    public static Option buildArgsOption() {
        return DockerBuildCliParserBase.builder13().longOpt("build-arg").hasArg().build();
    }

    protected abstract CliParserBase.ListHandler<CMD> ssh(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> progress(Option var1);

    protected abstract CliParserBase.ListHandler<CMD> secrets(Option var1);

    protected abstract CliParserBase.LabelListHandler<CMD> buildArgs(Option var1);

    protected abstract CommaSeparatedListHandler<CMD> cacheFrom(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> cpuShares(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> cpusetCpus(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> forceRm(Option var1);

    protected abstract CliParserBase.LabelListHandler<CMD> label(Option var1);

    protected abstract CliParserBase.MemoryOptionHandler<CMD> memory(Option var1);

    protected abstract CliParserBase.MemoryOptionHandler<CMD> memorySwap(Option var1);

    protected abstract CliParserBase.MemoryOptionHandler<CMD> shmSize(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> network(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> noCache(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> pull(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> quiet(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> rm(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> target(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> platform(Option var1);

    protected static class CommaSeparatedListHandler<CMD>
    extends CliParserBase.StringListHandler<CMD> {
        public CommaSeparatedListHandler(Option option, BiConsumer<CMD, String[]> setter2) {
            super(option, setter2);
        }

        @Override
        protected void handleValueList(String[] values) {
            LinkedList<String> pieces = new LinkedList<String>();
            if (values != null) {
                for (String next2 : values) {
                    for (String nextPiece : next2.split(",")) {
                        if (nextPiece.isEmpty()) continue;
                        pieces.add(nextPiece);
                    }
                }
            }
            super.handleValueList(pieces.toArray(new String[0]));
        }
    }
}

