/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.cli.model;

import com.intellij.docker.agent.util.DockerUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jetbrains.annotations.NonNls;

public abstract class CliParserBase<CMD> {
    protected abstract List<OptionHandler<CMD>> createAllHandlers();

    protected final void doParse(CMD result2, String[] arguments) throws ParseException {
        List<OptionHandler<CMD>> handlers = this.createAllHandlers();
        Options options2 = new Options();
        for (OptionHandler<CMD> handler2 : handlers) {
            options2.addOption(handler2.getOption());
        }
        CommandLine commandLine = new PosixParser().parse(options2, arguments);
        for (OptionHandler<CMD> handler3 : handlers) {
            handler3.handle(commandLine, result2);
        }
        switch (commandLine.getArgList().size()) {
            case 0: {
                break;
            }
            case 1: {
                throw new ParseException("Unrecognized argument: " + (String)commandLine.getArgList().get(0));
            }
            default: {
                throw new ParseException("Unrecognized arguments: " + commandLine.getArgList());
            }
        }
    }

    public static Option.Builder builder13(@NonNls String opt) {
        return Option.builder((String)opt);
    }

    public static Option.Builder builder13() {
        return CliParserBase.builder13(null);
    }

    public static abstract class OptionHandler<CMD> {
        private final Option myOption;
        private CMD myCmd;

        public OptionHandler(Option option) {
            this.myOption = option;
        }

        public Option getOption() {
            return this.myOption;
        }

        public void handle(CommandLine commandLine, CMD cmd) {
            String opt;
            this.myCmd = cmd;
            String string = opt = this.myOption.getOpt() == null ? this.myOption.getLongOpt() : this.myOption.getOpt();
            if (commandLine.hasOption(opt)) {
                String[] values = commandLine.getOptionValues(opt);
                boolean noValues = values == null || values.length == 0;
                this.handleOptionalValue(noValues ? null : values[0]);
                if (!noValues) {
                    this.handleValueList(values);
                }
            }
        }

        protected abstract void handleValueList(String[] var1);

        protected CMD getCmd() {
            return this.myCmd;
        }

        protected abstract void handleOptionalValue(String var1);
    }

    public static class IllegalOptionException
    extends IllegalArgumentException {
        private Option myOption;

        public IllegalOptionException(String message) {
            super(message);
        }

        public IllegalOptionException(Option option, String value) {
            this(MessageFormat.format("Error parsing value: ''{0}'' for option ''{1}''", value, IllegalOptionException.getDisplayName(option)));
            this.myOption = option;
        }

        public IllegalOptionException(Option option, String value, Throwable cause) {
            this(MessageFormat.format("Error parsing value for option ''{1}'': {2}", value, IllegalOptionException.getDisplayName(option), cause.getMessage()));
            this.myOption = option;
        }

        public Option getOption() {
            return this.myOption;
        }

        private static String getDisplayName(Option option) {
            return Optional.ofNullable(option.getOpt()).orElseGet(() -> option.getLongOpt());
        }
    }

    protected static class LabelListHandlerImpl<CMD>
    extends LabelListHandler<CMD> {
        private final Function<? super CMD, ? extends Map<String, String>> myGetter;
        private final BiConsumer<? super CMD, ? super Map<String, String>> mySetter;

        public LabelListHandlerImpl(Option option, Function<? super CMD, ? extends Map<String, String>> getter2, BiConsumer<? super CMD, ? super Map<String, String>> setter2) {
            super(option);
            this.myGetter = getter2;
            this.mySetter = setter2;
        }

        @Override
        protected void handleLabelsMap(Map<String, String> parsedMap) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            Optional.ofNullable(this.myGetter.apply(this.getCmd())).ifPresent(resultMap::putAll);
            resultMap.putAll(parsedMap);
            this.mySetter.accept(this.getCmd(), resultMap);
        }
    }

    public static abstract class LabelListHandler<CMD>
    extends ListHandler<CMD> {
        public LabelListHandler(Option option) {
            super(option);
        }

        @Override
        protected final void handleValueList(String[] values) {
            String SEPARATOR = "=";
            HashMap<String, String> resultLabels = new HashMap<String, String>();
            for (String next2 : values) {
                String value;
                String label2;
                int splitIdx = next2.indexOf("=");
                if (splitIdx == 0) {
                    throw new IllegalOptionException(this.getOption(), next2);
                }
                if (splitIdx < 0) {
                    label2 = next2;
                    value = "";
                } else {
                    label2 = next2.substring(0, splitIdx);
                    value = next2.substring(splitIdx + "=".length());
                }
                resultLabels.put(label2, value);
            }
            this.handleLabelsMap(resultLabels);
        }

        protected abstract void handleLabelsMap(Map<String, String> var1);
    }

    public static class MemoryOptionHandler<CMD>
    extends SingleValueHandler<CMD> {
        private static final Map<String, Long> MEMORY_UNIT_2_RATIO = new HashMap<String, Long>();
        private static final Map<String, String> LONG_UNTI_2_UNIT;
        private final BiConsumer<? super CMD, ? super Long> mySetter;

        public MemoryOptionHandler(Option option, BiConsumer<? super CMD, ? super Long> memorySetter) {
            super(option);
            this.mySetter = memorySetter;
        }

        @Override
        protected void handleEachValue(String value) {
            this.mySetter.accept(this.getCmd(), this.parseMemory(value));
        }

        protected long parseMemory(String value) {
            if (value.isEmpty()) {
                throw new IllegalOptionException(this.getOption(), value);
            }
            value = value.toLowerCase(Locale.ENGLISH);
            Long ratio = null;
            for (Map.Entry<String, String> entry : LONG_UNTI_2_UNIT.entrySet()) {
                String longUnit = entry.getKey();
                if (!value.endsWith(longUnit)) continue;
                String shortUnit = entry.getValue();
                ratio = MEMORY_UNIT_2_RATIO.get(shortUnit);
                value = value.substring(0, value.length() - longUnit.length());
            }
            if (ratio == null) {
                for (Map.Entry<String, Object> entry : MEMORY_UNIT_2_RATIO.entrySet()) {
                    String shortUnit = entry.getKey();
                    if (!value.endsWith(shortUnit)) continue;
                    ratio = (Long)entry.getValue();
                    value = value.substring(0, value.length() - shortUnit.length());
                }
            }
            try {
                return ratio == null ? Long.parseLong(value) : Long.parseLong(value) * ratio;
            }
            catch (NumberFormatException e) {
                throw new IllegalOptionException(this.getOption(), value);
            }
        }

        static {
            MEMORY_UNIT_2_RATIO.put("b", 1L);
            MEMORY_UNIT_2_RATIO.put("k", 1024L);
            MEMORY_UNIT_2_RATIO.put("m", 0x100000L);
            MEMORY_UNIT_2_RATIO.put("g", 0x40000000L);
            LONG_UNTI_2_UNIT = new HashMap<String, String>();
            LONG_UNTI_2_UNIT.put("kb", "k");
            LONG_UNTI_2_UNIT.put("mb", "m");
            LONG_UNTI_2_UNIT.put("gb", "g");
        }
    }

    public static class MappedListHandler<CMD, VAL>
    extends ListHandler<CMD> {
        private final BiConsumer<? super CMD, VAL[]> mySetter;
        private final Function<? super String, ? extends VAL> myMapper;
        private final Class<? extends VAL> myValueClass;

        public MappedListHandler(Option option, Class<? extends VAL> valueClass, Function<? super String, ? extends VAL> mapper, BiConsumer<? super CMD, VAL[]> setter2) {
            super(option);
            this.mySetter = setter2;
            this.myMapper = mapper;
            this.myValueClass = valueClass;
        }

        @Override
        protected void handleValueList(String[] values) {
            VAL[] mappedValues = DockerUtil.mapArray(values, this.myValueClass, this.myMapper);
            this.mySetter.accept(this.getCmd(), mappedValues);
        }
    }

    public static class DoubleOptionHandler<CMD>
    extends SingleValueHandler<CMD> {
        private final BiConsumer<? super CMD, ? super Double> mySetter;

        public DoubleOptionHandler(Option option, BiConsumer<? super CMD, ? super Double> setter2) {
            super(option);
            this.mySetter = setter2;
        }

        @Override
        protected void handleEachValue(String value) {
            double doubleValue;
            try {
                doubleValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalOptionException(this.getOption(), value);
            }
            this.mySetter.accept(this.getCmd(), doubleValue);
        }
    }

    public static class LongOptionHandler<CMD>
    extends NumberOptionHandler<CMD, Long> {
        public LongOptionHandler(Option option, BiConsumer<? super CMD, ? super Long> setter2) {
            super(option, setter2);
        }

        @Override
        protected Long parseNumber(String value) throws NumberFormatException {
            return Long.parseLong(value);
        }
    }

    public static class IntegerOptionHandler<CMD>
    extends NumberOptionHandler<CMD, Integer> {
        public IntegerOptionHandler(Option option, BiConsumer<? super CMD, ? super Integer> setter2) {
            super(option, setter2);
        }

        @Override
        protected Integer parseNumber(String value) throws NumberFormatException {
            return Integer.parseInt(value);
        }
    }

    public static abstract class NumberOptionHandler<CMD, NUM>
    extends SingleValueHandler<CMD> {
        private final BiConsumer<? super CMD, ? super NUM> mySetter;

        public NumberOptionHandler(Option option, BiConsumer<? super CMD, ? super NUM> setter2) {
            super(option);
            this.mySetter = setter2;
        }

        protected abstract NUM parseNumber(String var1) throws NumberFormatException;

        @Override
        protected final void handleEachValue(String value) {
            NUM parsedValue;
            try {
                parsedValue = this.parseNumber(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalOptionException(this.getOption(), value);
            }
            this.mySetter.accept(this.getCmd(), parsedValue);
        }
    }

    public static class StringListHandler<CMD>
    extends ListHandler<CMD> {
        private final BiConsumer<? super CMD, String[]> mySetter;

        public StringListHandler(Option option, BiConsumer<? super CMD, String[]> setter2) {
            super(option);
            this.mySetter = setter2;
        }

        @Override
        protected void handleValueList(String[] values) {
            this.mySetter.accept(this.getCmd(), values);
        }
    }

    public static class EachValueHandler<CMD>
    extends SingleValueHandler<CMD> {
        private final BiConsumer<? super CMD, ? super String> mySetter;

        public EachValueHandler(Option option, BiConsumer<? super CMD, ? super String> setter2) {
            super(option);
            this.mySetter = setter2;
        }

        @Override
        protected void handleEachValue(String value) {
            this.mySetter.accept(this.getCmd(), value);
        }
    }

    public static class BooleanOptionHandlerImpl<CMD>
    extends BooleanOptionHandler<CMD> {
        private final BiConsumer<? super CMD, ? super Boolean> mySetter;

        public BooleanOptionHandlerImpl(Option option, BiConsumer<? super CMD, ? super Boolean> setter2) {
            super(option);
            this.mySetter = setter2;
        }

        @Override
        protected void handleBooleanValue(boolean value) {
            this.mySetter.accept(this.getCmd(), value);
        }
    }

    public static abstract class BooleanOptionHandler<CMD>
    extends OptionHandler<CMD> {
        public BooleanOptionHandler(Option option) {
            super(option);
        }

        @Override
        protected final void handleValueList(String[] values) {
        }

        @Override
        protected void handleOptionalValue(String value) {
            boolean boolValue = value == null || Boolean.parseBoolean(value);
            this.handleBooleanValue(boolValue);
        }

        protected abstract void handleBooleanValue(boolean var1);
    }

    public static abstract class ListHandler<CMD>
    extends OptionHandler<CMD> {
        public ListHandler(Option option) {
            super(option);
        }

        @Override
        protected final void handleOptionalValue(String value) {
        }
    }

    public static abstract class SingleValueHandler<CMD>
    extends OptionHandler<CMD> {
        public SingleValueHandler(Option option) {
            super(option);
        }

        @Override
        protected final void handleOptionalValue(String value) {
        }

        @Override
        protected final void handleValueList(String[] values) {
            for (String next2 : values) {
                this.handleEachValue(next2);
            }
        }

        protected abstract void handleEachValue(String var1);
    }
}

