/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.CommonBundle;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/docker/action/NewDockerfileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createDockerfile", "Lcom/intellij/psi/PsiFile;", "psiDir", "Lcom/intellij/psi/PsiDirectory;", "doCreate", "findChildDockerfile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dir", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getOffsetToPreserve", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getPsiDirectory", "isAvailable", "", "update", "intellij.clouds.docker"})
public final class NewDockerfileAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabledAndVisible(this.isAvailable(e));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiDirectory psiDirectory = this.getPsiDirectory(e);
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory psiDir = psiDirectory;
        if (psiDir.isValid()) {
            PsiFile psiFile = this.createDockerfile(psiDir);
            if (psiFile == null) {
                return;
            }
            PsiFile dockerfile = psiFile;
            Project project = psiDir.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
            Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
            if (view != null && editor != null && Intrinsics.areEqual((Object)editor.getDocument(), (Object)PsiDocumentManager.getInstance((Project)project2).getDocument(dockerfile))) {
                int offset = this.getOffsetToPreserve(editor);
                view.selectElement((PsiElement)dockerfile);
                if (offset != -1 && !editor.isDisposed()) {
                    editor.getCaretModel().moveToOffset(offset);
                }
            }
        }
    }

    private final PsiFile createDockerfile(PsiDirectory psiDir) {
        Project project = psiDir.getProject();
        String string = CommonBundle.getErrorTitle();
        ElementCreator elementCreator2 = new ElementCreator(this, psiDir, project, string){
            final /* synthetic */ NewDockerfileAction this$0;
            final /* synthetic */ PsiDirectory $psiDir;
            {
                this.this$0 = $receiver;
                this.$psiDir = $psiDir;
                super($super_call_param$1, $super_call_param$2);
            }

            @NotNull
            protected PsiElement[] create(@NotNull String newName) {
                Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
                PsiFile psiFile = NewDockerfileAction.access$doCreate(this.this$0, this.$psiDir);
                if (psiFile == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                    return PsiElement.EMPTY_ARRAY;
                }
                PsiFile file2 = psiFile;
                PsiElement[] psiElementArray = new PsiElement[]{file2};
                return psiElementArray;
            }

            @NotNull
            protected String getActionName(@NotNull String newName) {
                Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
                String string = DockerBundle.message("action.NewDockerfile.text", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        };
        Object[] objectArray = elementCreator2.tryCreate("Dockerfile");
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"tryCreate(...)");
        Object[] elements = objectArray;
        return (PsiFile)ArraysKt.firstOrNull((Object[])elements);
    }

    private final boolean isAvailable(AnActionEvent e) {
        PsiDirectory psiDir = this.getPsiDirectory(e);
        if (psiDir != null && psiDir.isValid()) {
            VirtualFile virtualFile2 = psiDir.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            VirtualFile virtualDir = virtualFile2;
            return virtualDir.isValid() && virtualDir.isDirectory() && this.findChildDockerfile(virtualDir) == null;
        }
        return false;
    }

    private final PsiDirectory getPsiDirectory(AnActionEvent e) {
        PsiDirectory[] directories;
        PsiDirectory[] view;
        PsiDirectory[] psiDirectoryArray = view = (PsiDirectory[])e.getData(LangDataKeys.IDE_VIEW);
        if (view == null || (psiDirectoryArray = psiDirectoryArray.getDirectories()) == null) {
            psiDirectoryArray = PsiDirectory.EMPTY_ARRAY;
        }
        return (directories = psiDirectoryArray).length == 1 ? directories[0] : null;
    }

    private final int getOffsetToPreserve(Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        return offset == 0 ? -1 : offset;
    }

    private final PsiFile doCreate(PsiDirectory psiDir) {
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)psiDir.getProject());
        FileTemplate fileTemplate = fileTemplateManager.getInternalTemplate("Dockerfile");
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getInternalTemplate(...)");
        FileTemplate template = fileTemplate;
        return CreateFileFromTemplateAction.createFileFromTemplate((String)"Dockerfile", (FileTemplate)template, (PsiDirectory)psiDir, null, (boolean)true, (Map)MapsKt.emptyMap());
    }

    private final VirtualFile findChildDockerfile(VirtualFile dir) {
        VirtualFile dockerfile;
        if (dir.isValid() && (dockerfile = dir.findChild("Dockerfile")) != null && dockerfile.isValid() && !dockerfile.isDirectory()) {
            return dockerfile;
        }
        return null;
    }

    public static final /* synthetic */ PsiFile access$doCreate(NewDockerfileAction $this, PsiDirectory psiDir) {
        return $this.doCreate(psiDir);
    }
}

