/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerAgentPathMapperImplKt;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.PathMappingSettings;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001d\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/DockerAgentPathMapperImpl;", "Lcom/intellij/docker/agent/DockerAgentPathMapper;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/docker/DockerCloudConfiguration;)V", "myEnvVars", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "myMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "mapPath", "", "path", "Companion", "intellij.clouds.docker"})
public final class DockerAgentPathMapperImpl
implements DockerAgentPathMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @Nullable
    private final DockerCloudConfiguration config;
    @Nullable
    private final PathMacroManager myMacroManager;
    @NotNull
    private final ExpandMacroToPathMap myEnvVars;

    @JvmOverloads
    public DockerAgentPathMapperImpl(@Nullable Project project, @Nullable DockerCloudConfiguration config) {
        this.project = project;
        this.config = config;
        this.myMacroManager = DockerAgentPathMapperImplKt.access$getPathMacroManager(this.project);
        this.myEnvVars = DockerAgentPathMapperImpl.Companion.getSystemEnvMacroToPathMap();
    }

    public /* synthetic */ DockerAgentPathMapperImpl(Project project, DockerCloudConfiguration dockerCloudConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            dockerCloudConfiguration = null;
        }
        this(project, dockerCloudConfiguration);
    }

    @Override
    @NotNull
    public String mapPath(@NotNull String path) {
        PathMappingSettings mapper;
        String string;
        String p;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        PathMacroManager pathMacroManager = this.myMacroManager;
        String string2 = p = pathMacroManager != null ? pathMacroManager.expandPath(path) : null;
        if (Intrinsics.areEqual((Object)p, (Object)path)) {
            string = this.myEnvVars.substitute(DockerAgentPathMapperImpl.Companion.normalizeEnvMacros(path), SystemInfoRt.isFileSystemCaseSensitive);
        } else {
            string = p;
            if (string == null) {
                string = path;
            }
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        String expandedPath = string3;
        Function1<Project, PathMappingSettings> function1 = this.config;
        PathMappingSettings pathMappingSettings = mapper = function1 != null && (function1 = function1.getPathMapper$intellij_clouds_docker()) != null ? (PathMappingSettings)function1.invoke((Object)this.project) : null;
        String string4 = pathMappingSettings != null ? pathMappingSettings.convertToRemote(expandedPath) : null;
        if (string4 == null) {
            string4 = expandedPath;
        }
        return string4;
    }

    @JvmOverloads
    public DockerAgentPathMapperImpl(@Nullable Project project) {
        this(project, null, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/DockerAgentPathMapperImpl$Companion;", "", "()V", "getSystemEnvMacroToPathMap", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "normalizeEnvMacros", "", "macros", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        private final String normalizeEnvMacros(String macros) {
            Object object;
            if (StringsKt.startsWith$default((String)macros, (String)"${", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)macros, (String)"}", (boolean)false, (int)2, null)) {
                String string = macros.substring(2, macros.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = "$" + string + "$";
            } else {
                object = macros;
            }
            return object;
        }

        private final ExpandMacroToPathMap getSystemEnvMacroToPathMap() {
            ExpandMacroToPathMap result2 = new ExpandMacroToPathMap();
            Map<String, String> map2 = System.getenv();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getenv(...)");
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                result2.addMacroExpand(key, value);
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

