/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.DockerObject;
import java.io.Serializable;

public class Link
extends DockerObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String alias;

    public Link(String name2, String alias) {
        this.name = name2;
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public static Link parse(String serialized) throws IllegalArgumentException {
        try {
            String[] parts = serialized.split(":");
            switch (parts.length) {
                case 2: {
                    String[] nameSplit = parts[0].split("/");
                    String[] aliasSplit = parts[1].split("/");
                    return new Link(nameSplit[nameSplit.length - 1], aliasSplit[aliasSplit.length - 1]);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing Link '" + serialized + "'");
        }
    }

    public String toString() {
        return this.name + ":" + this.alias;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Link)) {
            return false;
        }
        Link other = (Link)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Link;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $name = this.getName();
        result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
        String $alias = this.getAlias();
        result2 = result2 * 59 + ($alias == null ? 43 : $alias.hashCode());
        return result2;
    }
}

