/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.thinClientLink;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remoteDev.downloader.JetBrainsClientDownloaderConfigurationProvider;
import com.intellij.remoteDev.util.ClientVersionUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.UriUtilKt;
import com.jetbrains.gateway.thinClientLink.ClientLifetimeTracker;
import com.jetbrains.gateway.thinClientLink.ClientVersionContext;
import com.jetbrains.gateway.thinClientLink.LinkedClientManager;
import com.jetbrains.gateway.thinClientLink.SingleClientLifetimeTracker;
import com.jetbrains.gateway.thinClientLink.ThinClientHandle;
import com.jetbrains.gateway.thinClientLink.ThinClientProjectInfo;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\nJ\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0018J4\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0 H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/gateway/thinClientLink/LinkedClientManager;", "", "()V", "knownClients", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle;", "perVersionContexts", "Lcom/jetbrains/gateway/thinClientLink/ClientVersionContext;", "projectInfoByUUID", "Lcom/jetbrains/gateway/thinClientLink/ThinClientProjectInfo;", "addProjectInfo", "", "uuid", "info", "closeClient", "findByFingerprint", "fingerprint", "findByProjectInfo", "getState", "uid", "getState$intellij_gateway_core", "isKnownClientUid", "", "isKnownClientUid$intellij_gateway_core", "startNewClient", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "initialLink", "Ljava/net/URI;", "remoteIdentity", "onStarted", "Lkotlin/Function0;", "Companion", "intellij.gateway.core"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nLinkedClientManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkedClientManager.kt\ncom/jetbrains/gateway/thinClientLink/LinkedClientManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1#2:169\n46#3,5:170\n11#3:177\n288#4,2:175\n*S KotlinDebug\n*F\n+ 1 LinkedClientManager.kt\ncom/jetbrains/gateway/thinClientLink/LinkedClientManager\n*L\n64#1:170,5\n164#1:177\n135#1:175,2\n*E\n"})
public final class LinkedClientManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, ThinClientHandle> knownClients = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, ThinClientProjectInfo> projectInfoByUUID = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, ClientVersionContext> perVersionContexts = new ConcurrentHashMap();
    @NotNull
    private static final Logger logger;

    public final boolean isKnownClientUid$intellij_gateway_core(@NotNull String uid) {
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        return this.knownClients.containsKey(uid);
    }

    @JvmOverloads
    @NotNull
    public final ThinClientHandle startNewClient(@NotNull Lifetime lifetime, @NotNull URI initialLink, @Nullable String remoteIdentity, @NotNull Function0<Unit> onStarted) {
        String string;
        Object object;
        Map initialFragmentParameters;
        String newClientId;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)initialLink, (String)"initialLink");
                Intrinsics.checkNotNullParameter(onStarted, (String)"onStarted");
                String string2 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                newClientId = string2;
                initialFragmentParameters = UriUtilKt.getFragmentParameters((URI)initialLink);
                object = remoteIdentity;
                if (object == null) break block7;
                String remoteId = object;
                boolean bl = false;
                Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"remoteId", (Object)remoteId));
                object = map;
                if (map != null) break block8;
            }
            object = MapsKt.emptyMap();
        }
        Object remoteIdParameter = object;
        Map gatewayBuildParameter = MapsKt.mapOf((Pair)TuplesKt.to((Object)"gtw_build", (Object)ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode()));
        URI initialUriWithRemoteId = UriUtilKt.newURIWithFragmentParameters((URI)initialLink, (Map)MapsKt.plus((Map)initialFragmentParameters, (Map)remoteIdParameter));
        URI uRI = URI.create("gwws://127.0.0.1:" + BuiltInServerManager.Companion.getInstance().getPort());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        URI gatewayConnectionUri = UriUtilKt.newURIWithFragmentParameters((URI)UriUtilKt.withQuery((URI)UriUtilKt.withPath((URI)uRI, (String)"/gateway/clientLink"), (String)("uid=" + newClientId)), (Map)MapsKt.plus((Map)MapsKt.plus((Map)initialFragmentParameters, (Map)gatewayBuildParameter), (Map)remoteIdParameter));
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Starting new linked client uid=" + newClientId + " initialLinkWithRemoteId=" + initialUriWithRemoteId + " replacedUri=" + gatewayConnectionUri, e$iv);
        }
        if ((string = (String)UriUtilKt.getFragmentParameters((URI)initialUriWithRemoteId).get("cb")) == null) {
            string = "unknown";
        }
        String clientVersion = string;
        ThinClientHandle thinClientHandle = (ThinClientHandle)lifetime.executeIfAlive((Function0)new Function0<ThinClientHandle>(clientVersion, lifetime, this, newClientId, gatewayConnectionUri){
            final /* synthetic */ String $clientVersion;
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ LinkedClientManager this$0;
            final /* synthetic */ String $newClientId;
            final /* synthetic */ URI $gatewayConnectionUri;
            {
                this.$clientVersion = $clientVersion;
                this.$lifetime = $lifetime;
                this.this$0 = $receiver;
                this.$newClientId = $newClientId;
                this.$gatewayConnectionUri = $gatewayConnectionUri;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ThinClientHandle invoke() {
                ClientLifetimeTracker clientLifetimeTracker2;
                boolean isProcessPerConnectionSupported = ClientVersionUtil.INSTANCE.isJBCSeparateConfigSupported(this.$clientVersion);
                if (Registry.is((String)"rdct.enable.per.connection.client.process") && isProcessPerConnectionSupported) {
                    Logger logger = LinkedClientManager.access$getLogger$cp();
                    var5_3 = this.$clientVersion;
                    e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        var12_8 = $this$debug_u24default$iv;
                        boolean bl = false;
                        var12_8.debug("rdct.enable.per.connection.client.process is set and client version " + var5_3 + " supports the functionality. Will use separate client processes even for identical versions.", (Throwable)((Object)e$iv));
                    }
                    clientLifetimeTracker2 = new SingleClientLifetimeTracker(this.$lifetime, this.$clientVersion);
                } else {
                    void key$iv;
                    void $this$getOrPut$iv;
                    if (isProcessPerConnectionSupported) {
                        $this$debug_u24default$iv = LinkedClientManager.access$getLogger$cp();
                        var5_3 = this.$clientVersion;
                        e$iv = null;
                        $i$f$debug = false;
                        if ($this$debug_u24default$iv.isDebugEnabled()) {
                            var12_8 = $this$debug_u24default$iv;
                            boolean bl = false;
                            var12_8.debug("Client version " + var5_3 + " supports the functionality, but rdct.enable.per.connection.client.process is not set. Will use a single client process per version.", (Throwable)((Object)e$iv));
                        }
                    } else {
                        $this$debug_u24default$iv = LinkedClientManager.access$getLogger$cp();
                        var5_3 = this.$clientVersion;
                        e$iv = null;
                        $i$f$debug = false;
                        if ($this$debug_u24default$iv.isDebugEnabled()) {
                            var12_8 = $this$debug_u24default$iv;
                            boolean bl = false;
                            var12_8.debug("rdct.enable.per.connection.client.process is set, but client version " + var5_3 + " does not support the functionality. Will use a single client process per version.", (Throwable)((Object)e$iv));
                        }
                    }
                    $this$debug_u24default$iv = LinkedClientManager.access$getPerVersionContexts$p(this.this$0);
                    e$iv = this.$clientVersion;
                    var5_3 = this.$clientVersion;
                    LinkedClientManager linkedClientManager = this.this$0;
                    boolean $i$f$getOrPut = false;
                    Object object = $this$getOrPut$iv.get(key$iv);
                    if (object == null) {
                        boolean bl = false;
                        ClientVersionContext context = new ClientVersionContext(var5_3);
                        context.getLifetime().onTermination((Function0)new Function0<Unit>(linkedClientManager, var5_3){
                            final /* synthetic */ LinkedClientManager this$0;
                            final /* synthetic */ String $clientVersion;
                            {
                                this.this$0 = $receiver;
                                this.$clientVersion = $clientVersion;
                                super(0);
                            }

                            public final void invoke() {
                                LinkedClientManager.access$getPerVersionContexts$p(this.this$0).remove(this.$clientVersion);
                            }
                        });
                        ClientVersionContext default$iv = context;
                        boolean bl2 = false;
                        object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                        if (object == null) {
                            object = default$iv;
                        }
                    }
                    clientLifetimeTracker2 = (ClientLifetimeTracker)object;
                }
                ClientLifetimeTracker clientLifetimeTracker3 = clientLifetimeTracker2;
                LifetimeDefinition clientStateLifetimeDef = this.$lifetime.createNested();
                Intrinsics.checkNotNull((Object)clientLifetimeTracker3);
                ThinClientHandle newClientState2 = new ThinClientHandle(this.$newClientId, clientStateLifetimeDef, this.$gatewayConnectionUri, clientLifetimeTracker3, this.$clientVersion);
                ((Map)LinkedClientManager.access$getKnownClients$p(this.this$0)).put(this.$newClientId, newClientState2);
                clientStateLifetimeDef.onTermination((Function0)new Function0<Unit>(this.$newClientId, this.this$0){
                    final /* synthetic */ String $newClientId;
                    final /* synthetic */ LinkedClientManager this$0;
                    {
                        this.$newClientId = $newClientId;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        LinkedClientManager.access$getLogger$cp().debug("Linked client " + this.$newClientId + " lifetime terminated, removing");
                        LinkedClientManager.access$getKnownClients$p(this.this$0).remove(this.$newClientId);
                        LinkedClientManager.access$getProjectInfoByUUID$p(this.this$0).remove(this.$newClientId);
                    }
                });
                return newClientState2;
            }
        });
        if (thinClientHandle == null) {
            throw new CancellationException();
        }
        ThinClientHandle newClientState2 = thinClientHandle;
        newClientState2.updateJoinLink(initialUriWithRemoteId, false);
        if (!ApplicationKt.getApplication().isUnitTestMode() && !JetBrainsClientDownloaderConfigurationProvider.Companion.getCustomPropertiesAreSet() && !Registry.is((String)"rdct.always.use.embedded.client") && StringsKt.contains$default((CharSequence)clientVersion, (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null) && ApplicationKt.getApplication().isInternal()) {
            logger.info("Not launching SNAPSHOT client for link " + gatewayConnectionUri);
            newClientState2.startPingingClient$intellij_gateway_core();
            return newClientState2;
        }
        newClientState2.onClientLaunch$intellij_gateway_core(onStarted);
        return newClientState2;
    }

    public static /* synthetic */ ThinClientHandle startNewClient$default(LinkedClientManager linkedClientManager, Lifetime lifetime, URI uRI, String string, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            function0 = startNewClient.1.INSTANCE;
        }
        return linkedClientManager.startNewClient(lifetime, uRI, string, (Function0<Unit>)function0);
    }

    @Nullable
    public final ThinClientHandle getState$intellij_gateway_core(@Nullable String uid) {
        String string = uid;
        if (string == null) {
            return null;
        }
        return this.knownClients.get(string);
    }

    public final void addProjectInfo(@NotNull String uuid, @NotNull ThinClientProjectInfo info) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        ((Map)this.projectInfoByUUID).put(uuid, info);
    }

    @Nullable
    public final ThinClientHandle findByFingerprint(@NotNull String fingerprint) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            Collection<ThinClientHandle> collection = this.knownClients.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ThinClientHandle it = (ThinClientHandle)element$iv;
                boolean bl = false;
                Object object = it.getLastSeenLink$intellij_gateway_core();
                if (!Intrinsics.areEqual(object != null && (object = UriUtilKt.getFragmentParameters((URI)object)) != null ? (String)object.get("fp") : null, (Object)fingerprint)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    @Nullable
    public final ThinClientHandle findByProjectInfo(@NotNull ThinClientProjectInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        for (Map.Entry entry : ((Map)this.projectInfoByUUID).entrySet()) {
            String uid = (String)entry.getKey();
            ThinClientProjectInfo projectInfo = (ThinClientProjectInfo)entry.getValue();
            if (!Intrinsics.areEqual((Object)projectInfo, (Object)info)) continue;
            ThinClientHandle handle2 = this.getState$intellij_gateway_core(uid);
            if (handle2 == null) {
                logger.warn("Inconsistent state: UID '" + uid + "' was found in project info map, but is missing in knownClients map.");
            }
            return handle2;
        }
        return null;
    }

    public final void closeClient(@NotNull ThinClientProjectInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        ThinClientHandle handle2 = this.findByProjectInfo(info);
        if (handle2 == null) {
            logger.info("No client handle for " + info);
        } else {
            logger.info("Found thin client '" + handle2.getUid() + "', for " + info);
            handle2.close();
        }
    }

    @JvmOverloads
    @NotNull
    public final ThinClientHandle startNewClient(@NotNull Lifetime lifetime, @NotNull URI initialLink, @Nullable String remoteIdentity) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)initialLink, (String)"initialLink");
        return LinkedClientManager.startNewClient$default(this, lifetime, initialLink, remoteIdentity, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final ThinClientHandle startNewClient(@NotNull Lifetime lifetime, @NotNull URI initialLink) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)initialLink, (String)"initialLink");
        return LinkedClientManager.startNewClient$default(this, lifetime, initialLink, null, null, 12, null);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getPerVersionContexts$p(LinkedClientManager $this) {
        return $this.perVersionContexts;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getKnownClients$p(LinkedClientManager $this) {
        return $this.knownClients;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getProjectInfoByUUID$p(LinkedClientManager $this) {
        return $this.projectInfoByUUID;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LinkedClientManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LinkedClientManager.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/gateway/thinClientLink/LinkedClientManager$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/gateway/thinClientLink/LinkedClientManager;", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nLinkedClientManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkedClientManager.kt\ncom/jetbrains/gateway/thinClientLink/LinkedClientManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,168:1\n42#2,3:169\n*S KotlinDebug\n*F\n+ 1 LinkedClientManager.kt\ncom/jetbrains/gateway/thinClientLink/LinkedClientManager$Companion\n*L\n166#1:169,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LinkedClientManager getInstance() {
            boolean $i$f$service = false;
            Class<LinkedClientManager> serviceClass$iv = LinkedClientManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (LinkedClientManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

