/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.gateway.ssh.ConnectedHostStorage;
import com.jetbrains.gateway.ssh.InstalledIde;
import com.jetbrains.gateway.ssh.IntelliJPlatformProduct;
import com.jetbrains.gateway.ssh.panels.RecentConnectionModel;
import com.jetbrains.gateway.ssh.panels.RecentProjectModel;
import com.jetbrains.gateway.ssh.panels.recentConnections.SshRecentProject;
import com.jetbrains.gateway.ssh.util.InstalledIdeInfo;
import com.jetbrains.rd.util.reactive.ViewableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 /*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0006/01234B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00020\u000eH$\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H$J\u001d\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0019\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u0004H\u0016J\b\u0010\"\u001a\u00020\fH\u0016J\u0010\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0004H\u0016J\u001c\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000&0\u001e2\u0006\u0010$\u001a\u00020\u0004H\u0002J\u0013\u0010'\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010(J\u0013\u0010)\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010(J!\u0010*\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00028\u00002\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001e\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020,H\u0002R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u00065"}, d2={"Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager;", "TConnectionConfig", "", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$LocalRecentConnectionsState;", "()V", "recents", "Lcom/jetbrains/rd/util/reactive/ViewableList;", "Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentConnection;", "getRecents", "()Lcom/jetbrains/rd/util/reactive/ViewableList;", "addKnownHosts", "", "generateConfigName", "", "config", "(Ljava/lang/Object;)Ljava/lang/String;", "getConfigById", "id", "(Ljava/lang/String;)Ljava/lang/Object;", "getConfigId", "getConfigsStorage", "Lcom/jetbrains/gateway/ssh/ConnectedHostStorage;", "getExistingConnection", "(Ljava/lang/Object;)Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentConnection;", "getInstalledIde", "Lcom/jetbrains/gateway/ssh/InstalledIde;", "project", "Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentProjectState;", "getProjects", "", "Lcom/jetbrains/gateway/ssh/panels/RecentProjectModel;", "(Ljava/lang/Object;)Ljava/util/List;", "getState", "initializeComponent", "loadState", "state", "recentConnectionModelsCreate", "Lcom/jetbrains/gateway/ssh/panels/RecentConnectionModel;", "registerHost", "(Ljava/lang/Object;)V", "remove", "replaceAll", "recentProjects", "Lcom/jetbrains/gateway/ssh/panels/recentConnections/SshRecentProject;", "(Ljava/lang/Object;Ljava/util/List;)V", "toModel", "Companion", "LocalRecentConnectionState", "LocalRecentConnectionsState", "RecentConnection", "RecentProjectInstalledIde", "RecentProjectState", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nLocalRecentConnectionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalRecentConnectionsManager.kt\ncom/jetbrains/gateway/ssh/LocalRecentConnectionsManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,263:1\n1#2:264\n1549#3:265\n1620#3,3:266\n661#3,11:269\n1549#3:280\n1620#3,2:281\n1549#3:283\n1620#3,3:284\n1622#3:287\n11#4:288\n*S KotlinDebug\n*F\n+ 1 LocalRecentConnectionsManager.kt\ncom/jetbrains/gateway/ssh/LocalRecentConnectionsManager\n*L\n102#1:265\n102#1:266,3\n137#1:269,11\n165#1:280\n165#1:281,2\n167#1:283\n167#1:284,3\n165#1:287\n18#1:288\n*E\n"})
public abstract class LocalRecentConnectionsManager<TConnectionConfig>
implements PersistentStateComponent<LocalRecentConnectionsState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewableList<RecentConnection<TConnectionConfig>> recents = new ViewableList(null, 1, null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public final ViewableList<RecentConnection<TConnectionConfig>> getRecents() {
        return this.recents;
    }

    @NotNull
    protected abstract String getConfigId(@NotNull TConnectionConfig var1);

    @Nullable
    protected abstract TConnectionConfig getConfigById(@NotNull String var1);

    @NotNull
    protected abstract String generateConfigName(@NotNull TConnectionConfig var1);

    @NotNull
    protected abstract ConnectedHostStorage<TConnectionConfig> getConfigsStorage();

    private final List<RecentConnectionModel<TConnectionConfig>> recentConnectionModelsCreate(LocalRecentConnectionsState state) {
        List recentConnections = new ArrayList();
        List<LocalRecentConnectionState> connections = state.getConnections();
        if (connections == null) {
            return CollectionsKt.emptyList();
        }
        for (LocalRecentConnectionState connection : connections) {
            List<RecentProjectState> projects;
            String configId;
            if (connection == null || connection.getConfigId() == null || connection.getProjects() == null) continue;
            TConnectionConfig config = this.getConfigById(configId);
            if (config == null) {
                LOG.warn("Failed to find a config. configId: '" + connection.getConfigId() + "'");
                continue;
            }
            List recentProjects = new ArrayList();
            for (RecentProjectState project : projects) {
                InstalledIde ide;
                String projectPath;
                if (project.getProjectPath() == null || this.getInstalledIde(project) == null) continue;
                Object object = project.getProductCode();
                if (object == null) continue;
                String it = object;
                boolean bl = false;
                IntelliJPlatformProduct intelliJPlatformProduct = IntelliJPlatformProduct.Companion.fromProductCode(it);
                object = intelliJPlatformProduct;
                if (intelliJPlatformProduct == null) {
                    continue;
                }
                Object product = object;
                String string = project.getProjectPathLink();
                Date date = project.getDate();
                if (date == null) {
                    date = new Date();
                }
                recentProjects.add(new RecentProjectModel(projectPath, string, (IntelliJPlatformProduct)((Object)product), ide, date));
            }
            if (!(!((Collection)recentProjects).isEmpty())) continue;
            recentConnections.add(new RecentConnectionModel<TConnectionConfig>(config, recentProjects));
        }
        return recentConnections;
    }

    private final InstalledIde getInstalledIde(RecentProjectState project) {
        RecentProjectInstalledIde recentProjectInstalledIde = project.getLatestUsedIde();
        if (recentProjectInstalledIde == null) {
            return null;
        }
        RecentProjectInstalledIde installedIde = recentProjectInstalledIde;
        String string = installedIde.getProductCode();
        if (string == null) {
            return null;
        }
        String productCode = string;
        IntelliJPlatformProduct intelliJPlatformProduct = IntelliJPlatformProduct.Companion.fromProductCode(productCode);
        if (intelliJPlatformProduct == null) {
            return null;
        }
        IntelliJPlatformProduct product = intelliJPlatformProduct;
        String string2 = installedIde.getBuildNumber();
        if (string2 == null) {
            return null;
        }
        String buildNumber = string2;
        String string3 = installedIde.getPathToIde();
        if (string3 == null) {
            return null;
        }
        String pathToIde = string3;
        return new InstalledIde(product, buildNumber, pathToIde);
    }

    public final void registerHost(@NotNull TConnectionConfig config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        LOG.info("Registering connection for config: '" + this.generateConfigName(config) + "'");
        RecentConnection<TConnectionConfig> existingConnection = this.getExistingConnection(config);
        if (existingConnection == null) {
            this.recents.add(new RecentConnection<TConnectionConfig>(config, new ArrayList()));
            CollectionsKt.last((List)((List)this.recents));
        }
        this.getConfigsStorage().add(this.getConfigId(config));
    }

    /*
     * WARNING - void declaration
     */
    public final void replaceAll(@NotNull TConnectionConfig config, @NotNull List<SshRecentProject> recentProjects) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        RecentConnection recentConnection;
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Intrinsics.checkNotNullParameter(recentProjects, (String)"recentProjects");
        ThreadingAssertions.assertEventDispatchThread();
        LOG.info("Replace connection for config: '" + this.generateConfigName(config) + "', projects count: " + recentProjects.size());
        RecentConnection existingConnection = this.getExistingConnection(config);
        if (existingConnection == null) {
            this.recents.add(new RecentConnection<TConnectionConfig>(config, new ArrayList()));
            recentConnection = (RecentConnection)CollectionsKt.last((List)((List)this.recents));
        } else {
            recentConnection = existingConnection;
        }
        RecentConnection connection = recentConnection;
        connection.getProjects().clear();
        Iterable iterable = recentProjects;
        List<RecentProjectModel> list = connection.getProjects();
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SshRecentProject sshRecentProject = (SshRecentProject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toModel((SshRecentProject)it));
        }
        list.addAll((List)destination$iv$iv);
        this.getConfigsStorage().add(this.getConfigId(config));
    }

    @NotNull
    public final List<RecentProjectModel> getProjects(@NotNull TConnectionConfig config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        RecentConnection<TConnectionConfig> existingConnection = this.getExistingConnection(config);
        RecentConnection<TConnectionConfig> recentConnection = existingConnection;
        if (recentConnection == null || (recentConnection = recentConnection.getProjects()) == null) {
            recentConnection = CollectionsKt.emptyList();
        }
        return recentConnection;
    }

    private final RecentProjectModel toModel(SshRecentProject project) {
        InstalledIde installedIde;
        InstalledIdeInfo projectIde;
        InstalledIdeInfo installedIdeInfo = projectIde = project.getIdeFromStatus();
        if (installedIdeInfo != null) {
            InstalledIdeInfo it = installedIdeInfo;
            boolean bl = false;
            installedIde = new InstalledIde(project.getProduct(), projectIde.getProductInfo().getBuildNumber(), projectIde.getPathToIde());
        } else {
            installedIde = null;
        }
        InstalledIde ide = installedIde;
        return new RecentProjectModel(project.getProjectPath(), project.getProjectPathLink(), project.getProduct(), ide, project.getDate());
    }

    public final void remove(@NotNull TConnectionConfig config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        ThreadingAssertions.assertEventDispatchThread();
        LOG.info("Removing a connection: '" + this.generateConfigName(config) + "'");
        this.recents.removeIf(arg_0 -> LocalRecentConnectionsManager.remove$lambda$3((Function1)new Function1<RecentConnection<TConnectionConfig>, Boolean>(config){
            final /* synthetic */ TConnectionConfig $config;
            {
                this.$config = $config;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull RecentConnection<TConnectionConfig> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return Intrinsics.areEqual(it.getConfig(), this.$config);
            }
        }, arg_0));
        this.getConfigsStorage().remove(this.getConfigId(config));
    }

    private final RecentConnection<TConnectionConfig> getExistingConnection(TConnectionConfig config) {
        Object v0;
        block2: {
            String configId = this.getConfigId(config);
            Iterable $this$singleOrNull$iv = (Iterable)this.recents;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                RecentConnection it = (RecentConnection)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this.getConfigId(it.getConfig()), (Object)configId)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LocalRecentConnectionsState getState() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)this.recents;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void configToProjects;
            RecentConnection recentConnection = (RecentConnection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object config = configToProjects.component1();
            List<RecentProjectModel> projects = configToProjects.component2();
            Iterable $this$map$iv2 = projects;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                RecentProjectModel recentProjectModel = (RecentProjectModel)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                RecentProjectInstalledIde ide = it.getProjectIde() == null ? new RecentProjectInstalledIde(it.getProduct().getProductCode(), "NONSENSE", "NONSENSE") : new RecentProjectInstalledIde(it.getProjectIde().getProduct().getProductCode(), it.getProjectIde().getBuildNumber(), it.getProjectIde().getPathToIde());
                collection2.add(new RecentProjectState(it.getProjectPath(), it.getProjectPathLink(), it.getProduct().getProductCode(), ide, it.getDate()));
            }
            List projectsState = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
            collection.add(new LocalRecentConnectionState(this.getConfigId(config), projectsState));
        }
        List list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        return new LocalRecentConnectionsState(list);
    }

    public void loadState(@NotNull LocalRecentConnectionsState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        List<RecentConnectionModel<TConnectionConfig>> models = this.recentConnectionModelsCreate(state);
        for (RecentConnectionModel<TConnectionConfig> model : models) {
            this.recents.add(new RecentConnection<TConnectionConfig>(model.getConfig(), CollectionsKt.toMutableList((Collection)model.getProjects())));
        }
    }

    public void initializeComponent() {
        this.addKnownHosts();
    }

    private final void addKnownHosts() {
        ConnectedHostStorage<TConnectionConfig> configStorage = this.getConfigsStorage();
        List<String> configIds = configStorage.getConfigIds();
        for (String configId : configIds) {
            TConnectionConfig config;
            Object v0;
            block2: {
                Iterable iterable = (Iterable)this.recents;
                for (Object t : iterable) {
                    RecentConnection it = (RecentConnection)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)this.getConfigId(it.getConfig()), (Object)configId)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            RecentConnection found = v0;
            if (this.getConfigById(configId) == null || found != null) continue;
            this.recents.add(new RecentConnection<TConnectionConfig>(config, new ArrayList()));
        }
    }

    private static final boolean remove$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LocalRecentConnectionsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$LocalRecentConnectionState;", "", "configId", "", "projects", "", "Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentProjectState;", "(Ljava/lang/String;Ljava/util/List;)V", "getConfigId", "()Ljava/lang/String;", "setConfigId", "(Ljava/lang/String;)V", "getProjects", "()Ljava/util/List;", "setProjects", "(Ljava/util/List;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.gateway.core"})
    public static final class LocalRecentConnectionState {
        @Nullable
        private String configId;
        @Nullable
        private List<RecentProjectState> projects;

        public LocalRecentConnectionState(@Nullable String configId, @Nullable List<RecentProjectState> projects) {
            this.configId = configId;
            this.projects = projects;
        }

        public /* synthetic */ LocalRecentConnectionState(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            this(string, list);
        }

        @Nullable
        public final String getConfigId() {
            return this.configId;
        }

        public final void setConfigId(@Nullable String string) {
            this.configId = string;
        }

        @Nullable
        public final List<RecentProjectState> getProjects() {
            return this.projects;
        }

        public final void setProjects(@Nullable List<RecentProjectState> list) {
            this.projects = list;
        }

        @Nullable
        public final String component1() {
            return this.configId;
        }

        @Nullable
        public final List<RecentProjectState> component2() {
            return this.projects;
        }

        @NotNull
        public final LocalRecentConnectionState copy(@Nullable String configId, @Nullable List<RecentProjectState> projects) {
            return new LocalRecentConnectionState(configId, projects);
        }

        public static /* synthetic */ LocalRecentConnectionState copy$default(LocalRecentConnectionState localRecentConnectionState, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = localRecentConnectionState.configId;
            }
            if ((n & 2) != 0) {
                list = localRecentConnectionState.projects;
            }
            return localRecentConnectionState.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "LocalRecentConnectionState(configId=" + this.configId + ", projects=" + this.projects + ")";
        }

        public int hashCode() {
            int result2 = this.configId == null ? 0 : this.configId.hashCode();
            result2 = result2 * 31 + (this.projects == null ? 0 : ((Object)this.projects).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LocalRecentConnectionState)) {
                return false;
            }
            LocalRecentConnectionState localRecentConnectionState = (LocalRecentConnectionState)other;
            if (!Intrinsics.areEqual((Object)this.configId, (Object)localRecentConnectionState.configId)) {
                return false;
            }
            return Intrinsics.areEqual(this.projects, localRecentConnectionState.projects);
        }

        public LocalRecentConnectionState() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001d\u0010\n\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R$\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$LocalRecentConnectionsState;", "", "connections", "", "Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$LocalRecentConnectionState;", "(Ljava/util/List;)V", "getConnections", "()Ljava/util/List;", "setConnections", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.gateway.core"})
    public static final class LocalRecentConnectionsState {
        @Nullable
        private List<LocalRecentConnectionState> connections;

        public LocalRecentConnectionsState(@Nullable List<LocalRecentConnectionState> connections) {
            this.connections = connections;
        }

        public /* synthetic */ LocalRecentConnectionsState(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = null;
            }
            this(list);
        }

        @Nullable
        public final List<LocalRecentConnectionState> getConnections() {
            return this.connections;
        }

        public final void setConnections(@Nullable List<LocalRecentConnectionState> list) {
            this.connections = list;
        }

        @Nullable
        public final List<LocalRecentConnectionState> component1() {
            return this.connections;
        }

        @NotNull
        public final LocalRecentConnectionsState copy(@Nullable List<LocalRecentConnectionState> connections) {
            return new LocalRecentConnectionsState(connections);
        }

        public static /* synthetic */ LocalRecentConnectionsState copy$default(LocalRecentConnectionsState localRecentConnectionsState, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = localRecentConnectionsState.connections;
            }
            return localRecentConnectionsState.copy(list);
        }

        @NotNull
        public String toString() {
            return "LocalRecentConnectionsState(connections=" + this.connections + ")";
        }

        public int hashCode() {
            return this.connections == null ? 0 : ((Object)this.connections).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LocalRecentConnectionsState)) {
                return false;
            }
            LocalRecentConnectionsState localRecentConnectionsState = (LocalRecentConnectionsState)other;
            return Intrinsics.areEqual(this.connections, localRecentConnectionsState.connections);
        }

        public LocalRecentConnectionsState() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentConnection;", "TConnectionConfig", "", "config", "projects", "", "Lcom/jetbrains/gateway/ssh/panels/RecentProjectModel;", "(Ljava/lang/Object;Ljava/util/List;)V", "getConfig", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getProjects", "()Ljava/util/List;", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/util/List;)Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentConnection;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.gateway.core"})
    public static final class RecentConnection<TConnectionConfig> {
        private final TConnectionConfig config;
        @NotNull
        private final List<RecentProjectModel> projects;

        public RecentConnection(TConnectionConfig config, @NotNull List<RecentProjectModel> projects) {
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            this.config = config;
            this.projects = projects;
        }

        public final TConnectionConfig getConfig() {
            return this.config;
        }

        @NotNull
        public final List<RecentProjectModel> getProjects() {
            return this.projects;
        }

        public final TConnectionConfig component1() {
            return this.config;
        }

        @NotNull
        public final List<RecentProjectModel> component2() {
            return this.projects;
        }

        @NotNull
        public final RecentConnection<TConnectionConfig> copy(TConnectionConfig config, @NotNull List<RecentProjectModel> projects) {
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            return new RecentConnection<TConnectionConfig>(config, projects);
        }

        public static /* synthetic */ RecentConnection copy$default(RecentConnection recentConnection, Object object, List list, int n, Object object2) {
            if ((n & 1) != 0) {
                object = recentConnection.config;
            }
            if ((n & 2) != 0) {
                list = recentConnection.projects;
            }
            return recentConnection.copy(object, list);
        }

        @NotNull
        public String toString() {
            return "RecentConnection(config=" + this.config + ", projects=" + this.projects + ")";
        }

        public int hashCode() {
            int result2 = this.config == null ? 0 : this.config.hashCode();
            result2 = result2 * 31 + ((Object)this.projects).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RecentConnection)) {
                return false;
            }
            RecentConnection recentConnection = (RecentConnection)other;
            if (!Intrinsics.areEqual(this.config, recentConnection.config)) {
                return false;
            }
            return Intrinsics.areEqual(this.projects, recentConnection.projects);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentProjectInstalledIde;", "", "productCode", "", "buildNumber", "pathToIde", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBuildNumber", "()Ljava/lang/String;", "setBuildNumber", "(Ljava/lang/String;)V", "getPathToIde", "setPathToIde", "getProductCode", "setProductCode", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.gateway.core"})
    public static final class RecentProjectInstalledIde {
        @Nullable
        private String productCode;
        @Nullable
        private String buildNumber;
        @Nullable
        private String pathToIde;

        public RecentProjectInstalledIde(@Nullable String productCode, @Nullable String buildNumber, @Nullable String pathToIde) {
            this.productCode = productCode;
            this.buildNumber = buildNumber;
            this.pathToIde = pathToIde;
        }

        public /* synthetic */ RecentProjectInstalledIde(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @Nullable
        public final String getProductCode() {
            return this.productCode;
        }

        public final void setProductCode(@Nullable String string) {
            this.productCode = string;
        }

        @Nullable
        public final String getBuildNumber() {
            return this.buildNumber;
        }

        public final void setBuildNumber(@Nullable String string) {
            this.buildNumber = string;
        }

        @Nullable
        public final String getPathToIde() {
            return this.pathToIde;
        }

        public final void setPathToIde(@Nullable String string) {
            this.pathToIde = string;
        }

        @Nullable
        public final String component1() {
            return this.productCode;
        }

        @Nullable
        public final String component2() {
            return this.buildNumber;
        }

        @Nullable
        public final String component3() {
            return this.pathToIde;
        }

        @NotNull
        public final RecentProjectInstalledIde copy(@Nullable String productCode, @Nullable String buildNumber, @Nullable String pathToIde) {
            return new RecentProjectInstalledIde(productCode, buildNumber, pathToIde);
        }

        public static /* synthetic */ RecentProjectInstalledIde copy$default(RecentProjectInstalledIde recentProjectInstalledIde, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = recentProjectInstalledIde.productCode;
            }
            if ((n & 2) != 0) {
                string2 = recentProjectInstalledIde.buildNumber;
            }
            if ((n & 4) != 0) {
                string3 = recentProjectInstalledIde.pathToIde;
            }
            return recentProjectInstalledIde.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "RecentProjectInstalledIde(productCode=" + this.productCode + ", buildNumber=" + this.buildNumber + ", pathToIde=" + this.pathToIde + ")";
        }

        public int hashCode() {
            int result2 = this.productCode == null ? 0 : this.productCode.hashCode();
            result2 = result2 * 31 + (this.buildNumber == null ? 0 : this.buildNumber.hashCode());
            result2 = result2 * 31 + (this.pathToIde == null ? 0 : this.pathToIde.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RecentProjectInstalledIde)) {
                return false;
            }
            RecentProjectInstalledIde recentProjectInstalledIde = (RecentProjectInstalledIde)other;
            if (!Intrinsics.areEqual((Object)this.productCode, (Object)recentProjectInstalledIde.productCode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.buildNumber, (Object)recentProjectInstalledIde.buildNumber)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pathToIde, (Object)recentProjectInstalledIde.pathToIde);
        }

        public RecentProjectInstalledIde() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\tH\u00c6\u0003JE\u0010 \u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u0016\u00a8\u0006'"}, d2={"Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentProjectState;", "", "projectPath", "", "projectPathLink", "productCode", "latestUsedIde", "Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentProjectInstalledIde;", "date", "Ljava/util/Date;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentProjectInstalledIde;Ljava/util/Date;)V", "getDate", "()Ljava/util/Date;", "setDate", "(Ljava/util/Date;)V", "getLatestUsedIde", "()Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentProjectInstalledIde;", "setLatestUsedIde", "(Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentProjectInstalledIde;)V", "getProductCode", "()Ljava/lang/String;", "setProductCode", "(Ljava/lang/String;)V", "getProjectPath", "setProjectPath", "getProjectPathLink", "setProjectPathLink", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.gateway.core"})
    public static final class RecentProjectState {
        @Nullable
        private String projectPath;
        @Nullable
        private String projectPathLink;
        @Nullable
        private String productCode;
        @Nullable
        private RecentProjectInstalledIde latestUsedIde;
        @Nullable
        private Date date;

        public RecentProjectState(@NlsSafe @Nullable String projectPath, @NlsSafe @Nullable String projectPathLink, @Nullable String productCode, @Nullable RecentProjectInstalledIde latestUsedIde, @Nullable Date date) {
            this.projectPath = projectPath;
            this.projectPathLink = projectPathLink;
            this.productCode = productCode;
            this.latestUsedIde = latestUsedIde;
            this.date = date;
        }

        public /* synthetic */ RecentProjectState(String string, String string2, String string3, RecentProjectInstalledIde recentProjectInstalledIde, Date date, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                recentProjectInstalledIde = null;
            }
            if ((n & 0x10) != 0) {
                date = null;
            }
            this(string, string2, string3, recentProjectInstalledIde, date);
        }

        @Nullable
        public final String getProjectPath() {
            return this.projectPath;
        }

        public final void setProjectPath(@Nullable String string) {
            this.projectPath = string;
        }

        @Nullable
        public final String getProjectPathLink() {
            return this.projectPathLink;
        }

        public final void setProjectPathLink(@Nullable String string) {
            this.projectPathLink = string;
        }

        @Nullable
        public final String getProductCode() {
            return this.productCode;
        }

        public final void setProductCode(@Nullable String string) {
            this.productCode = string;
        }

        @Nullable
        public final RecentProjectInstalledIde getLatestUsedIde() {
            return this.latestUsedIde;
        }

        public final void setLatestUsedIde(@Nullable RecentProjectInstalledIde recentProjectInstalledIde) {
            this.latestUsedIde = recentProjectInstalledIde;
        }

        @Nullable
        public final Date getDate() {
            return this.date;
        }

        public final void setDate(@Nullable Date date) {
            this.date = date;
        }

        @Nullable
        public final String component1() {
            return this.projectPath;
        }

        @Nullable
        public final String component2() {
            return this.projectPathLink;
        }

        @Nullable
        public final String component3() {
            return this.productCode;
        }

        @Nullable
        public final RecentProjectInstalledIde component4() {
            return this.latestUsedIde;
        }

        @Nullable
        public final Date component5() {
            return this.date;
        }

        @NotNull
        public final RecentProjectState copy(@NlsSafe @Nullable String projectPath, @NlsSafe @Nullable String projectPathLink, @Nullable String productCode, @Nullable RecentProjectInstalledIde latestUsedIde, @Nullable Date date) {
            return new RecentProjectState(projectPath, projectPathLink, productCode, latestUsedIde, date);
        }

        public static /* synthetic */ RecentProjectState copy$default(RecentProjectState recentProjectState, String string, String string2, String string3, RecentProjectInstalledIde recentProjectInstalledIde, Date date, int n, Object object) {
            if ((n & 1) != 0) {
                string = recentProjectState.projectPath;
            }
            if ((n & 2) != 0) {
                string2 = recentProjectState.projectPathLink;
            }
            if ((n & 4) != 0) {
                string3 = recentProjectState.productCode;
            }
            if ((n & 8) != 0) {
                recentProjectInstalledIde = recentProjectState.latestUsedIde;
            }
            if ((n & 0x10) != 0) {
                date = recentProjectState.date;
            }
            return recentProjectState.copy(string, string2, string3, recentProjectInstalledIde, date);
        }

        @NotNull
        public String toString() {
            return "RecentProjectState(projectPath=" + this.projectPath + ", projectPathLink=" + this.projectPathLink + ", productCode=" + this.productCode + ", latestUsedIde=" + this.latestUsedIde + ", date=" + this.date + ")";
        }

        public int hashCode() {
            int result2 = this.projectPath == null ? 0 : this.projectPath.hashCode();
            result2 = result2 * 31 + (this.projectPathLink == null ? 0 : this.projectPathLink.hashCode());
            result2 = result2 * 31 + (this.productCode == null ? 0 : this.productCode.hashCode());
            result2 = result2 * 31 + (this.latestUsedIde == null ? 0 : this.latestUsedIde.hashCode());
            result2 = result2 * 31 + (this.date == null ? 0 : this.date.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RecentProjectState)) {
                return false;
            }
            RecentProjectState recentProjectState = (RecentProjectState)other;
            if (!Intrinsics.areEqual((Object)this.projectPath, (Object)recentProjectState.projectPath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.projectPathLink, (Object)recentProjectState.projectPathLink)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.productCode, (Object)recentProjectState.productCode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.latestUsedIde, (Object)recentProjectState.latestUsedIde)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.date, (Object)recentProjectState.date);
        }

        public RecentProjectState() {
            this(null, null, null, null, null, 31, null);
        }
    }
}

