/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.migration;

import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigBackup;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSyncBridge;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncIdeMediatorImpl;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.migration.SettingsRepositoryToSettingsSyncMigration;
import com.intellij.settingsSync.migration.SettingsRepositoryToSettingsSyncMigrationKt;
import com.intellij.settingsSync.plugins.PluginManagerProxy;
import com.intellij.settingsSync.statistics.SettingsSyncEventsStatistics;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "OS_PREFIXES", "", "Lkotlin/Pair;", "", "SETTINGS_REPOSITORY_ID", "SPECIAL_FILES", "backupCurrentConfig", "", "migrateIfNeeded", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "showNotificationAboutUnbundling", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsRepositoryToSettingsSyncMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsRepositoryToSettingsSyncMigration.kt\ncom/intellij/settingsSync/migration/SettingsRepositoryToSettingsSyncMigrationKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,160:1\n11#2:161\n*S KotlinDebug\n*F\n+ 1 SettingsRepositoryToSettingsSyncMigration.kt\ncom/intellij/settingsSync/migration/SettingsRepositoryToSettingsSyncMigrationKt\n*L\n33#1:161\n*E\n"})
public final class SettingsRepositoryToSettingsSyncMigrationKt {
    @NotNull
    private static final String SETTINGS_REPOSITORY_ID = "org.jetbrains.settingsRepository";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<String> SPECIAL_FILES;
    @NotNull
    private static final List<Pair<String, String>> OS_PREFIXES;

    private static final void showNotificationAboutUnbundling(ScheduledExecutorService executorService) {
        NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)SettingsSyncBundle.INSTANCE.message("settings.repository.unbundled.notification.action.install.settings.repository", new Object[0]), SettingsRepositoryToSettingsSyncMigrationKt::showNotificationAboutUnbundling$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
        NotificationAction installOldPluginAction = notificationAction;
        NotificationAction notificationAction2 = NotificationAction.createSimpleExpiring((String)SettingsSyncBundle.INSTANCE.message("settings.repository.unbundled.notification.action.use.new.settings.sync", new Object[0]), () -> SettingsRepositoryToSettingsSyncMigrationKt.showNotificationAboutUnbundling$lambda$2(executorService));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction2, (String)"createSimpleExpiring(...)");
        NotificationAction useNewSettingsSyncAction = notificationAction2;
        NotificationGroupManager.getInstance().getNotificationGroup("settingsSync.errors").createNotification(SettingsSyncBundle.INSTANCE.message("settings.repository.unbundled.notification.title", new Object[0]), SettingsSyncBundle.INSTANCE.message("settings.repository.unbundled.notification.description", new Object[0]), NotificationType.INFORMATION).addAction((AnAction)installOldPluginAction).addAction((AnAction)useNewSettingsSyncAction).notify(null);
    }

    public static final void migrateIfNeeded(@NotNull ScheduledExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        if (PluginManager.isPluginInstalled((PluginId)PluginId.getId((String)SETTINGS_REPOSITORY_ID))) {
            return;
        }
        SettingsRepositoryToSettingsSyncMigration settingsRepositoryMigration = new SettingsRepositoryToSettingsSyncMigration();
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir(...)");
        if (settingsRepositoryMigration.isLocalDataAvailable(path)) {
            LOG.info("Migrating from the Settings Repository");
            Path path2 = PathManager.getConfigDir();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getConfigDir(...)");
            SettingsSnapshot snapshot = settingsRepositoryMigration.getLocalDataIfAvailable(path2);
            if (snapshot != null) {
                SettingsRepositoryToSettingsSyncMigrationKt.backupCurrentConfig();
                TemplateSettings.getInstance();
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
                IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application));
                Intrinsics.checkNotNull((Object)iComponentStore, (String)"null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
                ComponentStoreImpl componentStoreImpl = (ComponentStoreImpl)iComponentStore;
                Path path3 = PathManager.getConfigDir();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getConfigDir(...)");
                new SettingsSyncIdeMediatorImpl(componentStoreImpl, path3, (Function0<Boolean>)((Function0)migrateIfNeeded.1.INSTANCE)).applyToIde(snapshot, null);
                SettingsRepositoryToSettingsSyncMigrationKt.showNotificationAboutUnbundling(executorService);
                SettingsSyncEventsStatistics.INSTANCE.getMIGRATED_FROM_SETTINGS_REPOSITORY().log();
            }
        }
    }

    private static final void backupCurrentConfig() {
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir(...)");
        Path configDir = path;
        Path tempBackupDir = Files.createTempDirectory(configDir.getFileName() + "-backup-" + UUID.randomUUID(), new FileAttribute[0]);
        LOG.info("Backup config from " + configDir + " to " + tempBackupDir);
        FileUtil.copyDir((File)configDir.toFile(), (File)tempBackupDir.toFile());
        Path path2 = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getConfigDir(...)");
        ConfigBackup configBackup = new ConfigBackup(path2);
        Intrinsics.checkNotNull((Object)tempBackupDir);
        configBackup.moveToBackup(tempBackupDir);
    }

    private static final void showNotificationAboutUnbundling$lambda$0() {
        PluginManagerProxy.Companion.getInstance().createInstaller(true).installPlugins(CollectionsKt.listOf((Object)PluginId.getId((String)SETTINGS_REPOSITORY_ID)));
        SettingsSyncEventsStatistics.INSTANCE.getSETTINGS_REPOSITORY_NOTIFICATION_ACTION().log((Object)SettingsSyncEventsStatistics.SettingsRepositoryMigrationNotificationAction.INSTALL_SETTINGS_REPOSITORY);
    }

    private static final void showNotificationAboutUnbundling$lambda$2$lambda$1() {
        SettingsSyncMain.Companion.getInstance().getControls().getBridge().initialize$intellij_settingsSync(SettingsSyncBridge.InitMode.PushToServer.INSTANCE);
    }

    private static final void showNotificationAboutUnbundling$lambda$2(ScheduledExecutorService $executorService) {
        Intrinsics.checkNotNullParameter((Object)$executorService, (String)"$executorService");
        SettingsSyncSettings.Companion.getInstance().setSyncEnabled(true);
        $executorService.submit(SettingsRepositoryToSettingsSyncMigrationKt::showNotificationAboutUnbundling$lambda$2$lambda$1);
        SettingsSyncEventsStatistics.INSTANCE.getSETTINGS_REPOSITORY_NOTIFICATION_ACTION().log((Object)SettingsSyncEventsStatistics.SettingsRepositoryMigrationNotificationAction.USE_NEW_SETTINGS_SYNC);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ List access$getOS_PREFIXES$p() {
        return OS_PREFIXES;
    }

    public static final /* synthetic */ List access$getSPECIAL_FILES$p() {
        return SPECIAL_FILES;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsRepositoryToSettingsSyncMigration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{".git", "config.json"};
        SPECIAL_FILES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"_mac", (Object)"mac"), TuplesKt.to((Object)"_windows", (Object)"windows"), TuplesKt.to((Object)"_linux", (Object)"linux"), TuplesKt.to((Object)"_freebsd", (Object)"freebsd"), TuplesKt.to((Object)"_unix", (Object)"unix")};
        OS_PREFIXES = CollectionsKt.listOf((Object[])objectArray);
    }
}

