/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.migration;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.settingsSync.FileState;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSnapshotKt;
import com.intellij.settingsSync.SettingsSyncMigration;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.migration.CloudConfigToSettingsSyncMigration;
import com.intellij.settingsSync.migration.ConfigState;
import com.intellij.settingsSync.migration.StatusInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J*\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000f2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001cJ*\u0010\u0019\u001a\u00020\u00042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0018\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J3\u0010 \u001a\u0004\u0018\u0001H!\"\u0004\b\u0000\u0010!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u0001H!0#H\u0002\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u000fH\u0002\u00a8\u0006("}, d2={"Lcom/intellij/settingsSync/migration/CloudConfigToSettingsSyncMigration;", "Lcom/intellij/settingsSync/SettingsSyncMigration;", "()V", "disableCategoryForClass", "", "className", "", "syncSettings", "Lcom/intellij/settingsSync/SettingsSyncSettings;", "filterOsName", "", "fileName", "getLocalDataIfAvailable", "Lcom/intellij/settingsSync/SettingsSnapshot;", "appConfigDir", "Ljava/nio/file/Path;", "getPluginId", "Lcom/intellij/openapi/extensions/PluginId;", "text", "getRuleValue", "isLocalDataAvailable", "loadLines", "", "file", "jbaConfigDir", "loadStates", "configDir", "states", "", "Lcom/intellij/settingsSync/migration/ConfigState$Type;", "lines", "migrateCategoriesSyncStatus", "processLocalData", "T", "processor", "Lkotlin/Function1;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readLocalData", "jbaConfigPath", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nCloudConfigToSettingsSyncMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudConfigToSettingsSyncMigration.kt\ncom/intellij/settingsSync/migration/CloudConfigToSettingsSyncMigration\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,235:1\n494#2,7:236\n1#3:243\n11#4:244\n*S KotlinDebug\n*F\n+ 1 CloudConfigToSettingsSyncMigration.kt\ncom/intellij/settingsSync/migration/CloudConfigToSettingsSyncMigration\n*L\n103#1:236,7\n129#1:244\n*E\n"})
public final class CloudConfigToSettingsSyncMigration
implements SettingsSyncMigration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String CACHES_DIR;
    @NotNull
    private static final String OS_FILE;
    @NotNull
    private static final String VERSION_FILE;
    @NotNull
    private static final String STATUS_INFO_FILE;
    @NotNull
    private static final String AUTO_UPDATE_PLUGINS_FILE;
    @NotNull
    private static final String LOCAL_CHANGES_FILE;
    @NotNull
    private static final String AUTO_CONNECT_FILE;
    @NotNull
    private static final String LOCAL_DISABLED_PLUGINS_FILENAME;
    @NotNull
    private static final String LAYOUT_CONFIG_FILENAME;
    @NotNull
    private static final String LOCAL_LAYOUT_CONFIG_FILENAME;
    @NotNull
    private static final String INSTALLED_PLUGINS_FILENAME;
    @NotNull
    private static final List<String> TOP_LEVEL_SPECIAL_FILES;
    @NotNull
    private static final String[] OS_NAMES;

    @Override
    @Nullable
    public SettingsSnapshot getLocalDataIfAvailable(@NotNull Path appConfigDir) {
        Intrinsics.checkNotNullParameter((Object)appConfigDir, (String)"appConfigDir");
        return (SettingsSnapshot)this.processLocalData(appConfigDir, (Function1)new Function1<Path, SettingsSnapshot>(this){
            final /* synthetic */ CloudConfigToSettingsSyncMigration this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final SettingsSnapshot invoke(@NotNull Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return CloudConfigToSettingsSyncMigration.access$readLocalData(this.this$0, path);
            }
        });
    }

    @Override
    public boolean isLocalDataAvailable(@NotNull Path appConfigDir) {
        Intrinsics.checkNotNullParameter((Object)appConfigDir, (String)"appConfigDir");
        return this.processLocalData(appConfigDir, isLocalDataAvailable.1.INSTANCE) != null;
    }

    private final <T> T processLocalData(Path appConfigDir, Function1<? super Path, ? extends T> processor) {
        try {
            Path path = appConfigDir.resolve("jba_config");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path jbaConfigPath = path;
            Path path2 = jbaConfigPath.resolve(STATUS_INFO_FILE);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Path statusInfoFile = path2;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(statusInfoFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                StatusInfo statusInfo = StatusInfo.valueOf(PathsKt.readText$default((Path)statusInfoFile, null, (int)1, null));
                if (statusInfo == StatusInfo.JBA_CONNECTED) {
                    return (T)processor.invoke((Object)jbaConfigPath);
                }
                LOG.info("Cloud config sync was not active (status is '" + statusInfo + "') => no migration needed");
            } else {
                LOG.info("No data from cloudConfig in jba_config folder => no migration needed");
            }
        }
        catch (Exception e) {
            LOG.error("Could not read data from cloudConfig => no migration ", (Throwable)e);
        }
        return null;
    }

    private final SettingsSnapshot readLocalData(Path jbaConfigPath) {
        Set fileStates2 = new LinkedHashSet();
        Files.list(jbaConfigPath).forEach(arg_0 -> CloudConfigToSettingsSyncMigration.readLocalData$lambda$0((Function1)new Function1<Path, Unit>(this, (Set<FileState>)fileStates2, jbaConfigPath){
            final /* synthetic */ CloudConfigToSettingsSyncMigration this$0;
            final /* synthetic */ Set<FileState> $fileStates;
            final /* synthetic */ Path $jbaConfigPath;
            {
                this.this$0 = $receiver;
                this.$fileStates = $fileStates;
                this.$jbaConfigPath = $jbaConfigPath;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(Path path) {
                String osPrefix = CloudConfigToSettingsSyncMigration.Companion.calcOS() + ".";
                Intrinsics.checkNotNull((Object)path);
                boolean isPerOsSetting = StringsKt.startsWith$default((String)PathsKt.getName((Path)path), (String)osPrefix, (boolean)false, (int)2, null);
                if (!CloudConfigToSettingsSyncMigration.access$getTOP_LEVEL_SPECIAL_FILES$cp().contains(PathsKt.getName((Path)path)) && this.this$0.filterOsName(PathsKt.getName((Path)path))) {
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        void $this$forEach$iv;
                        Iterable iterable = PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null);
                        Path path2 = this.$jbaConfigPath;
                        Set<FileState> set = this.$fileStates;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            byte[] content;
                            Path it = (Path)element$iv;
                            boolean bl = false;
                            Path path3 = path2.relativize(it);
                            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"relativize(...)");
                            String relative = PathsKt.getInvariantSeparatorsPathString((Path)path3);
                            String fileSpec = isPerOsSetting ? StringsKt.removePrefix((String)relative, (CharSequence)osPrefix) : relative;
                            Intrinsics.checkNotNullExpressionValue((Object)Files.readAllBytes(it), (String)"readAllBytes(...)");
                            set.add(new FileState.Modified(fileSpec, content));
                        }
                    } else {
                        String plainPath;
                        Object fileSpec = null;
                        fileSpec = isPerOsSetting ? (Intrinsics.areEqual((Object)(plainPath = StringsKt.removePrefix((String)PathsKt.getName((Path)path), (CharSequence)osPrefix)), (Object)"ui.lnf.xml") ? plainPath : StoreUtilKt.getPerOsSettingsStorageFolderName() + "/" + plainPath) : PathsKt.getName((Path)path);
                        byte[] byArray = Files.readAllBytes(path);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                        byte[] content = byArray;
                        this.$fileStates.add(new FileState.Modified("options/" + (String)fileSpec, content));
                    }
                }
            }
        }, arg_0));
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return new SettingsSnapshot(new SettingsSnapshot.MetaInfo(instant, SettingsSnapshotKt.getLocalApplicationInfo(), false, 4, null), fileStates2, null, MapsKt.emptyMap(), SetsKt.emptySet());
    }

    @Override
    public void migrateCategoriesSyncStatus(@NotNull Path appConfigDir, @NotNull SettingsSyncSettings syncSettings) {
        Intrinsics.checkNotNullParameter((Object)appConfigDir, (String)"appConfigDir");
        Intrinsics.checkNotNullParameter((Object)syncSettings, (String)"syncSettings");
        Path path = appConfigDir.resolve("jba_config");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path jbaConfigDir = path;
        Map states = new HashMap();
        this.loadStates(LAYOUT_CONFIG_FILENAME, jbaConfigDir, states);
        this.loadStates(LOCAL_LAYOUT_CONFIG_FILENAME, jbaConfigDir, states);
        Map $this$filterValues$iv = states;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            ConfigState.Type type = (ConfigState.Type)((Object)entry$iv.getValue());
            boolean bl = false;
            if (!(type == ConfigState.Type.Disable || type == ConfigState.Type.DisableLocally)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set classesToDisable = ((Map)result$iv).keySet();
        if (!((Collection)classesToDisable).isEmpty()) {
            LOG.info("Disabling sync for following classes: " + classesToDisable);
            for (String className : classesToDisable) {
                this.disableCategoryForClass(className, syncSettings);
            }
        }
        syncSettings.setSubcategoryEnabled(SettingsCategory.UI, "editorFont", false);
    }

    private final void disableCategoryForClass(String className, SettingsSyncSettings syncSettings) {
        try {
            SettingsCategory category;
            State state;
            Object object;
            block4: {
                Class<?> clazz = Class.forName(className);
                Annotation[] annotationArray = clazz.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"getAnnotations(...)");
                for (Object object2 : (Object[])annotationArray) {
                    Annotation it = (Annotation)object2;
                    boolean bl = false;
                    if (!(it instanceof State)) continue;
                    object = object2;
                    break block4;
                }
                object = null;
            }
            Object object3 = object;
            State state2 = state = object3 instanceof State ? (State)object3 : null;
            Object object4 = category = state2 != null ? state2.category() : null;
            if (category != null && category != SettingsCategory.OTHER) {
                syncSettings.setCategoryEnabled(category, false);
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't find class " + className, (Throwable)e);
        }
    }

    public final boolean filterOsName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!StringsKt.startsWith$default((String)fileName, (String)(Companion.calcOS() + "."), (boolean)false, (int)2, null)) {
            for (String name : OS_NAMES) {
                if (!StringsKt.startsWith$default((String)fileName, (String)(name + "."), (boolean)false, (int)2, null)) continue;
                return false;
            }
        }
        return true;
    }

    public final void loadStates(@NotNull String fileName, @NotNull Path configDir, @NotNull Map<String, ConfigState.Type> states) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        Intrinsics.checkNotNullParameter(states, (String)"states");
        this.loadStates(this.loadLines(fileName, configDir), states);
    }

    private final void loadStates(List<String> lines, Map<String, ConfigState.Type> states) {
        for (String line : lines) {
            String id;
            Intrinsics.checkNotNullExpressionValue((Object)this.getPluginId(line).getIdString(), (String)"getIdString(...)");
            String type = this.getRuleValue(line);
            states.put(id, ConfigState.Type.valueOf(type));
        }
    }

    private final String getRuleValue(String text) {
        String string = StringUtil.substringAfter((String)text, (String)":");
        Intrinsics.checkNotNull((Object)string);
        String rule = string;
        return rule;
    }

    private final PluginId getPluginId(String text) {
        String pluginId = StringUtil.substringBefore((String)text, (String)":");
        LOG.assertTrue(pluginId != null, (Object)("Couldn't find id in text '" + text + "'"));
        String string = pluginId;
        Intrinsics.checkNotNull((Object)string);
        PluginId pluginId2 = PluginId.getId((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"getId(...)");
        return pluginId2;
    }

    private final List<String> loadLines(String fileName, Path jbaConfigDir) throws IOException {
        Path path = jbaConfigDir.resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return this.loadLines(path);
    }

    private final List<String> loadLines(Path file) throws IOException {
        List list;
        try {
            list = Files.readAllLines(file);
            Intrinsics.checkNotNull(list);
        }
        catch (FileNotFoundException e) {
            list = new ArrayList();
        }
        catch (NoSuchFileException e) {
            list = new ArrayList();
        }
        return list;
    }

    private static final void readLocalData$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ SettingsSnapshot access$readLocalData(CloudConfigToSettingsSyncMigration $this, Path jbaConfigPath) {
        return $this.readLocalData(jbaConfigPath);
    }

    public static final /* synthetic */ List access$getTOP_LEVEL_SPECIAL_FILES$cp() {
        return TOP_LEVEL_SPECIAL_FILES;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CloudConfigToSettingsSyncMigration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        CACHES_DIR = "caches";
        OS_FILE = "os";
        VERSION_FILE = "version";
        STATUS_INFO_FILE = "status.info";
        AUTO_UPDATE_PLUGINS_FILE = "auto_update_plugins";
        LOCAL_CHANGES_FILE = "local.changes";
        AUTO_CONNECT_FILE = ".auto_connect";
        LOCAL_DISABLED_PLUGINS_FILENAME = "local_disabled_plugins.txt";
        LAYOUT_CONFIG_FILENAME = "layout_config.txt";
        LOCAL_LAYOUT_CONFIG_FILENAME = "local_" + LAYOUT_CONFIG_FILENAME;
        INSTALLED_PLUGINS_FILENAME = "installed_plugins.txt";
        Object[] objectArray = new String[]{CACHES_DIR, AUTO_UPDATE_PLUGINS_FILE, OS_FILE, VERSION_FILE, STATUS_INFO_FILE, "disabled_plugins.txt", INSTALLED_PLUGINS_FILENAME, LOCAL_DISABLED_PLUGINS_FILENAME, LAYOUT_CONFIG_FILENAME, LOCAL_LAYOUT_CONFIG_FILENAME, LOCAL_CHANGES_FILE, AUTO_CONNECT_FILE};
        TOP_LEVEL_SPECIAL_FILES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"mac", "win", "linux", "freebsd", "unix", "unknown"};
        OS_NAMES = objectArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001d\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/settingsSync/migration/CloudConfigToSettingsSyncMigration$Companion;", "", "()V", "AUTO_CONNECT_FILE", "", "AUTO_UPDATE_PLUGINS_FILE", "CACHES_DIR", "INSTALLED_PLUGINS_FILENAME", "LAYOUT_CONFIG_FILENAME", "getLAYOUT_CONFIG_FILENAME", "()Ljava/lang/String;", "LOCAL_CHANGES_FILE", "LOCAL_DISABLED_PLUGINS_FILENAME", "LOCAL_LAYOUT_CONFIG_FILENAME", "getLOCAL_LAYOUT_CONFIG_FILENAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "OS_FILE", "OS_NAMES", "", "getOS_NAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "STATUS_INFO_FILE", "TOP_LEVEL_SPECIAL_FILES", "", "VERSION_FILE", "calcOS", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final String getLAYOUT_CONFIG_FILENAME() {
            return LAYOUT_CONFIG_FILENAME;
        }

        @NotNull
        public final String getLOCAL_LAYOUT_CONFIG_FILENAME() {
            return LOCAL_LAYOUT_CONFIG_FILENAME;
        }

        @NotNull
        public final String[] getOS_NAMES() {
            return OS_NAMES;
        }

        @NotNull
        public final String calcOS() {
            if (SystemInfo.isMac) {
                return "mac";
            }
            if (SystemInfo.isWindows) {
                return "win";
            }
            if (SystemInfo.isLinux) {
                return "linux";
            }
            if (SystemInfo.isFreeBSD) {
                return "freebsd";
            }
            if (SystemInfo.isUnix) {
                return "unix";
            }
            if (SystemInfo.isSolaris) {
                return "solaris";
            }
            if (SystemInfo.isChromeOS) {
                return "chrome";
            }
            return "unknown";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

