/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java.validation;

import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.JavaPsiStringTemplateUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.siyeh.ig.psiutils.CollectionUtils;
import java.util.Objects;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;

public class LanguageMismatch
extends LocalInspectionTool {
    public boolean CHECK_NON_ANNOTATED_REFERENCES = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"CHECK_NON_ANNOTATED_REFERENCES", (String)IntelliLangBundle.message((String)"flag.usages.of.non.annotated.elements", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(HtmlChunk.text((String)IntelliLangBundle.message((String)"flag.usages.of.non.annotated.elements.description", (Object[])new Object[0])))});
        if (optPane == null) {
            LanguageMismatch.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LanguageMismatch.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){
            final Pair<String, ? extends Set<String>> annotationName;
            {
                this.annotationName = Configuration.getProjectInstance((Project)holder.getProject()).getAdvancedConfiguration().getLanguageAnnotationPair();
            }

            public void visitExpression(@NotNull PsiExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                LanguageMismatch.this.checkExpression(expression, holder, this.annotationName);
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (expression.getParent() instanceof PsiMethodCallExpression) {
                    return;
                }
                PsiElement element = expression.resolve();
                if (!(element instanceof PsiModifierListOwner)) {
                    return;
                }
                LanguageMismatch.this.checkExpression((PsiExpression)expression, holder, this.annotationName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "expression";
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/java/validation/LanguageMismatch$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    void checkExpression(PsiExpression expression, ProblemsHolder holder, Pair<String, ? extends Set<String>> annotationName) {
        PsiModifierListOwner declOwner;
        String expected;
        PsiAnnotation[] annotations;
        PsiType type = expression.getType();
        if (type == null || !PsiUtilEx.isInjectionTargetType(type)) {
            return;
        }
        PsiModifierListOwner contextOwner = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.CONTEXT_ONLY);
        if (contextOwner != null && PsiUtilEx.isLanguageAnnotationTarget(contextOwner) && (annotations = AnnotationUtilEx.getAnnotationFrom(contextOwner, annotationName, true)).length > 0 && (expected = AnnotationUtilEx.calcAnnotationValue(annotations, "value")) != null && (declOwner = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.PREFER_DECLARATION)) != null && PsiUtilEx.isLanguageAnnotationTarget(declOwner)) {
            PsiAnnotation[] as = AnnotationUtilEx.getAnnotationFrom(declOwner, annotationName, true);
            if (as.length > 0) {
                String actual = AnnotationUtilEx.calcAnnotationValue(as, "value");
                if (!expected.equals(actual)) {
                    holder.registerProblem((PsiElement)expression, IntelliLangBundle.message((String)"inspection.language.mismatch.description", (Object[])new Object[]{expected, actual}), new LocalQuickFix[0]);
                }
            } else if (this.CHECK_NON_ANNOTATED_REFERENCES) {
                PsiAssignmentExpression a;
                PsiExpressionList list;
                PsiElement decl = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiVariable.class, PsiExpressionList.class, PsiAssignmentExpression.class});
                if (decl instanceof PsiVariable) {
                    PsiVariable variable = (PsiVariable)decl;
                    if (variable.getInitializer() != expression) {
                        return;
                    }
                    if (JavaPsiStringTemplateUtil.isStrTemplate((PsiExpression)expression)) {
                        return;
                    }
                } else if (decl instanceof PsiExpressionList ? !ArrayUtil.contains((Object)expression, (Object[])(list = (PsiExpressionList)decl).getExpressions()) : decl instanceof PsiAssignmentExpression && (a = (PsiAssignmentExpression)decl).getRExpression() != expression) {
                    return;
                }
                if (declOwner instanceof PsiField && CollectionUtils.isConstantEmptyArray((PsiField)((PsiField)declOwner))) {
                    return;
                }
                PsiAnnotation annotation = annotations[annotations.length - 1];
                String fqn = Objects.requireNonNull(annotation.getQualifiedName());
                SmartList fixes = new SmartList();
                PsiModifierListOwner owner = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.PREFER_DECLARATION);
                if (owner != null && AddAnnotationPsiFix.isAvailable((PsiModifierListOwner)owner, (String)fqn)) {
                    fixes.add(new AddAnnotationFix(fqn, owner, annotation.getParameterList().getAttributes(), new String[0]));
                }
                holder.registerProblem((PsiElement)expression, IntelliLangBundle.message((String)"inspection.language.problem.description", (Object[])new Object[]{expected}), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/java/validation/LanguageMismatch";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/java/validation/LanguageMismatch";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

