/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.utils.graph;

import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.rml.dfa.utils.graph.GraphImpl;
import com.intellij.rml.dfa.utils.graph.IntGraphBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017J\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0019\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/rml/dfa/utils/graph/GraphBuilder;", "T", "", "()V", "builder", "Lcom/intellij/rml/dfa/utils/graph/IntGraphBuilder;", "idToNode", "", "", "nodeToId", "addEdge", "", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)V", "addNode", "node", "(Ljava/lang/Object;)I", "addSubGraph", "g", "Lcom/intellij/rml/dfa/utils/graph/Graph;", "getGraph", "getNodes", "", "incomingNodes", "(Ljava/lang/Object;)Ljava/util/Set;", "outgoingNodes", "removeNode", "(Ljava/lang/Object;)V", "intellij.rml.dfa"})
@SourceDebugExtension(value={"SMAP\nGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Graph.kt\ncom/intellij/rml/dfa/utils/graph/GraphBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n1549#2:231\n1620#2,3:232\n1549#2:235\n1620#2,3:236\n1#3:239\n*S KotlinDebug\n*F\n+ 1 Graph.kt\ncom/intellij/rml/dfa/utils/graph/GraphBuilder\n*L\n164#1:231\n164#1:232,3\n168#1:235\n168#1:236,3\n*E\n"})
public class GraphBuilder<T> {
    @NotNull
    private final Map<T, Integer> nodeToId = new LinkedHashMap();
    @NotNull
    private final Map<Integer, T> idToNode = new LinkedHashMap();
    @NotNull
    private final IntGraphBuilder builder = new IntGraphBuilder();

    @NotNull
    public final Set<T> getNodes() {
        return this.nodeToId.keySet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<T> incomingNodes(T node) {
        void $this$mapTo$iv$iv;
        Integer n = this.nodeToId.get(node);
        Intrinsics.checkNotNull((Object)n);
        Iterable $this$map$iv = this.builder.incomingNodes(((Number)n).intValue());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n2 = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            T t = this.idToNode.get((int)it);
            Intrinsics.checkNotNull(t);
            collection.add(t);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<T> outgoingNodes(T node) {
        void $this$mapTo$iv$iv;
        Integer n = this.nodeToId.get(node);
        Intrinsics.checkNotNull((Object)n);
        Iterable $this$map$iv = this.builder.outgoingNodes(((Number)n).intValue());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n2 = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            T t = this.idToNode.get((int)it);
            Intrinsics.checkNotNull(t);
            collection.add(t);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final int addNode(T node) {
        Integer n = this.nodeToId.get(node);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            return it;
        }
        int nodeId = this.nodeToId.size();
        Integer n2 = nodeId;
        this.nodeToId.put(node, n2);
        n2 = nodeId;
        this.idToNode.put(n2, node);
        this.builder.addNode(nodeId);
        return nodeId;
    }

    public final void addEdge(T from, T to) {
        this.builder.addEdge(this.addNode(from), this.addNode(to));
    }

    public final void addSubGraph(@NotNull Graph<T> g) {
        Intrinsics.checkNotNullParameter(g, (String)"g");
        for (T pair : g.nodes()) {
            this.addNode(pair);
        }
        for (Pair pair : g.edges()) {
            Object v = pair.component1();
            Object to = pair.component2();
            this.addEdge(v, to);
        }
    }

    public final void removeNode(T node) {
        Integer n = this.nodeToId.get(node);
        Intrinsics.checkNotNull((Object)n);
        this.builder.removeNode(((Number)n).intValue());
        this.nodeToId.remove(node);
    }

    @NotNull
    public final Graph<T> getGraph() {
        return new GraphImpl<T>(this.builder.getGraph(), this.nodeToId, this.idToNode);
    }
}

