/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.test;

import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.ir.DfaInvalidIrException;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.ast.IrBoolConstant;
import com.intellij.rml.dfa.ir.ast.IrComparisonCondition;
import com.intellij.rml.dfa.ir.ast.IrCondition;
import com.intellij.rml.dfa.ir.ast.IrConstant;
import com.intellij.rml.dfa.ir.ast.IrConstantCondition;
import com.intellij.rml.dfa.ir.ast.IrConstantExpr;
import com.intellij.rml.dfa.ir.ast.IrEqualityKind;
import com.intellij.rml.dfa.ir.ast.IrExpr;
import com.intellij.rml.dfa.ir.ast.IrFieldDecl;
import com.intellij.rml.dfa.ir.ast.IrFieldID;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrFunctionID;
import com.intellij.rml.dfa.ir.ast.IrGlobalVarDecl;
import com.intellij.rml.dfa.ir.ast.IrIntConstant;
import com.intellij.rml.dfa.ir.ast.IrParameterDecl;
import com.intellij.rml.dfa.ir.ast.IrRecordDecl;
import com.intellij.rml.dfa.ir.ast.IrRecordID;
import com.intellij.rml.dfa.ir.ast.IrStringConstant;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.ast.IrUnknownExpr;
import com.intellij.rml.dfa.ir.ast.IrUnsupportedCondition;
import com.intellij.rml.dfa.ir.ast.IrValueConstant;
import com.intellij.rml.dfa.ir.ast.IrVarID;
import com.intellij.rml.dfa.ir.ast.IrVarRefExpr;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.ir.cfg.IrCfgBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0003OPQB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\f\u0010*\u001a\u00060+R\u00020\u0000H\u0014J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0003H\u0004J\b\u0010/\u001a\u000200H\u0004J\u0010\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020\u0003H\u0004J\b\u00103\u001a\u00020\u0003H\u0004J\b\u00104\u001a\u00020\u0003H\u0004J\u0010\u00105\u001a\u0002002\u0006\u00106\u001a\u000200H\u0004J\u0018\u00107\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00030\n08J\b\u00109\u001a\u00020:H\u0004J\f\u0010;\u001a\b\u0012\u0004\u0012\u00020)08J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0003H\u0004J\u0010\u0010?\u001a\u00020=2\u0006\u0010@\u001a\u00020\u0003H\u0004J\b\u0010A\u001a\u00020:H\u0002J\b\u0010B\u001a\u00020:H\u0002J\b\u0010C\u001a\u00020:H\u0002J\b\u0010D\u001a\u00020\u0003H\u0004J\b\u0010E\u001a\u00020FH\u0004J\b\u0010G\u001a\u00020HH\u0004J\b\u0010I\u001a\u00020\u0003H\u0004J\b\u0010J\u001a\u00020KH\u0004J\u0010\u0010J\u001a\u00020:2\u0006\u00102\u001a\u00020\u0003H\u0004J\b\u0010L\u001a\u00020\u0003H\u0004J\u0010\u0010L\u001a\u00020:2\u0006\u00102\u001a\u00020\u0003H\u0004J\b\u0010M\u001a\u00020NH\u0004R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00030\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0015R \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0019R\u001a\u0010#\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/intellij/rml/dfa/test/IrProtoLanguageParser;", "", "filePath", "", "fileText", "(Ljava/lang/String;Ljava/lang/String;)V", "calls", "", "Lcom/intellij/rml/dfa/test/IrProtoLanguageParser$Call;", "comments", "Lkotlin/Pair;", "", "curToken", "Lcom/intellij/rml/dfa/test/IrProtoLanguageParser$TokenType;", "getCurToken", "()Lcom/intellij/rml/dfa/test/IrProtoLanguageParser$TokenType;", "setCurToken", "(Lcom/intellij/rml/dfa/test/IrProtoLanguageParser$TokenType;)V", "fields", "", "getFields", "()Ljava/util/Set;", "functions", "", "getFunctions", "()Ljava/util/Map;", "line", "lineStartOffset", "pos", "prevPos", "prevPosBeforeSpace", "records", "getRecords", "signatures", "getSignatures", "tokenText", "getTokenText", "()Ljava/lang/String;", "setTokenText", "(Ljava/lang/String;)V", "topLevelDecls", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "createStatementParser", "Lcom/intellij/rml/dfa/test/IrProtoLanguageParser$StatementParser;", "curIdentifier", "", "identifier", "curLocation", "Lcom/intellij/rml/dfa/ir/IrLocation;", "curOperator", "name", "expectIdentifier", "expectOperator", "extend", "startLoc", "getComments", "", "nextToken", "", "parse", "parseError", "", "message", "parseErrorExpected", "expected", "parseFunction", "parseGlobalVar", "parseRecord", "skipConstant", "skipField", "Lcom/intellij/rml/dfa/ir/ast/IrFieldID;", "skipFunction", "Lcom/intellij/rml/dfa/ir/ast/IrFunctionID;", "skipFunctionSignature", "skipIdentifier", "Lcom/intellij/rml/dfa/attributes/Attribute;", "skipOperator", "skipRecord", "Lcom/intellij/rml/dfa/ir/ast/IrRecordID;", "Call", "StatementParser", "TokenType", "intellij.rml.dfa"})
@SourceDebugExtension(value={"SMAP\nIrProtoLanguageParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrProtoLanguageParser.kt\ncom/intellij/rml/dfa/test/IrProtoLanguageParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,618:1\n1549#2:619\n1620#2,3:620\n800#2,11:623\n1549#2:634\n1620#2,3:635\n1549#2:638\n1620#2,3:639\n*S KotlinDebug\n*F\n+ 1 IrProtoLanguageParser.kt\ncom/intellij/rml/dfa/test/IrProtoLanguageParser\n*L\n151#1:619\n151#1:620,3\n152#1:623,11\n152#1:634\n152#1:635,3\n154#1:638\n154#1:639,3\n*E\n"})
public class IrProtoLanguageParser {
    @NotNull
    private final String filePath;
    @NotNull
    private final String fileText;
    protected TokenType curToken;
    @NotNull
    private String tokenText;
    private int prevPosBeforeSpace;
    private int prevPos;
    private int pos;
    private int line;
    private int lineStartOffset;
    @NotNull
    private final List<IrTopLevelDecl> topLevelDecls;
    @NotNull
    private final Set<String> records;
    @NotNull
    private final Set<String> fields;
    @NotNull
    private final Map<String, Integer> functions;
    @NotNull
    private final Map<String, String> signatures;
    @NotNull
    private final List<Call> calls;
    @NotNull
    private final List<Pair<Integer, String>> comments;

    public IrProtoLanguageParser(@NotNull String filePath, @NotNull String fileText) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
        this.filePath = filePath;
        this.fileText = fileText;
        this.tokenText = "";
        this.topLevelDecls = new ArrayList();
        this.records = new LinkedHashSet();
        this.fields = new LinkedHashSet();
        this.functions = new LinkedHashMap();
        this.signatures = new LinkedHashMap();
        this.calls = new ArrayList();
        this.comments = new ArrayList();
    }

    @NotNull
    protected final TokenType getCurToken() {
        TokenType tokenType = this.curToken;
        if (tokenType != null) {
            return tokenType;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"curToken");
        return null;
    }

    protected final void setCurToken(@NotNull TokenType tokenType) {
        Intrinsics.checkNotNullParameter((Object)((Object)tokenType), (String)"<set-?>");
        this.curToken = tokenType;
    }

    @NotNull
    protected final String getTokenText() {
        return this.tokenText;
    }

    protected final void setTokenText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.tokenText = string;
    }

    @NotNull
    protected final Set<String> getRecords() {
        return this.records;
    }

    @NotNull
    protected final Set<String> getFields() {
        return this.fields;
    }

    @NotNull
    protected final Map<String, Integer> getFunctions() {
        return this.functions;
    }

    @NotNull
    protected final Map<String, String> getSignatures() {
        return this.signatures;
    }

    @NotNull
    public final List<Pair<Integer, String>> getComments() {
        return this.comments;
    }

    @NotNull
    public final List<IrTopLevelDecl> parse() {
        String signature;
        this.nextToken();
        block10: while (this.getCurToken() != TokenType.EndOfFile) {
            switch (this.expectIdentifier()) {
                case "var": {
                    this.parseGlobalVar();
                    continue block10;
                }
                case "record": {
                    this.parseRecord();
                    continue block10;
                }
                case "fun": {
                    this.parseFunction();
                    continue block10;
                }
            }
            this.parseErrorExpected("top level declaration");
            throw new KotlinNothingValueException();
        }
        for (Map.Entry object : this.signatures.entrySet()) {
            signature = (String)object.getKey();
            String function2 = (String)object.getValue();
            if (this.functions.containsKey(function2)) continue;
            this.parseError("Unresolved function " + function2 + " referenced by signature " + signature);
            throw new KotlinNothingValueException();
        }
        for (Call call : this.calls) {
            String function3;
            signature = call.component1();
            int argumentsCnt = call.component2();
            boolean isVirtual = call.component3();
            IrLocation location = call.component4();
            if (isVirtual) {
                if (!this.signatures.containsKey(signature)) {
                    throw new DfaInvalidIrException("Unresolved signature " + signature, location);
                }
                v0 = this.signatures.get(signature);
            } else {
                v0 = function3 = signature;
            }
            if (!this.functions.containsKey(function3)) {
                throw new DfaInvalidIrException("Unresolved function " + function3, location);
            }
            Integer n = this.functions.get(function3);
            if (n != null && argumentsCnt == n) continue;
            this.parseError("Function " + function3 + " has " + this.functions.get(String.valueOf(function3)) + " arguments, but " + argumentsCnt + " provided");
            throw new KotlinNothingValueException();
        }
        return this.topLevelDecls;
    }

    private final void parseGlobalVar() {
        this.skipIdentifier("var");
        IrLocation loc = this.curLocation();
        Attribute name = this.skipIdentifier();
        ((Collection)this.topLevelDecls).add(new IrGlobalVarDecl(new IrVarID(name), loc));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void parseRecord() {
        this.skipIdentifier("record");
        IrLocation loc = this.curLocation();
        IrRecordID name = new IrRecordID(this.skipIdentifier());
        ((Collection)this.records).add(name.toString());
        List superRecords = new ArrayList();
        if (Intrinsics.areEqual((Object)this.expectOperator(), (Object)":")) {
            this.nextToken();
            ((Collection)superRecords).add(this.skipRecord());
            while (Intrinsics.areEqual((Object)this.expectOperator(), (Object)",")) {
                this.nextToken();
                ((Collection)superRecords).add(this.skipRecord());
            }
        }
        this.skipOperator("{");
        List fields = new ArrayList();
        Map methods = new LinkedHashMap();
        block5: while (true) {
            String signature;
            if (this.getCurToken() != TokenType.Identifier) {
                this.skipOperator("}");
                ((Collection)this.topLevelDecls).add(new IrRecordDecl(name, superRecords, fields, methods, loc));
                return;
            }
            String string = this.skipIdentifier().toString();
            switch (string.hashCode()) {
                case -991338933: {
                    if (string.equals("virtual_fun")) break;
                    break block5;
                }
                case 116519: {
                    if (!string.equals("var")) break block5;
                    IrLocation fieldLoc = this.curLocation();
                    Attribute identifier = this.skipIdentifier();
                    ((Collection)fields).add(new IrFieldDecl(new IrFieldID(identifier), fieldLoc));
                    ((Collection)this.fields).add(identifier.toString());
                    continue block5;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)this.skipIdentifier().toString(), (String)"toString(...)");
            this.skipOperator("=");
            IrFunctionID function2 = new IrFunctionID(this.skipIdentifier());
            methods.put(signature, function2);
            this.signatures.put(signature, function2.toString());
        }
        this.parseErrorExpected("top level declaration");
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    private final void parseFunction() {
        Collection<Set> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        IrGlobalVarDecl it;
        Collection collection2;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        this.skipIdentifier("fun");
        IrLocation loc = this.curLocation();
        IrFunctionID name = new IrFunctionID(this.skipIdentifier());
        List params = new ArrayList();
        if (Intrinsics.areEqual((Object)this.expectOperator(), (Object)"(")) {
            this.nextToken();
            IrLocation paramLoc = this.curLocation();
            ((Collection)params).add(new IrParameterDecl(new IrVarID(this.skipIdentifier()), paramLoc));
            while (Intrinsics.areEqual((Object)this.expectOperator(), (Object)",")) {
                this.nextToken();
                paramLoc = this.curLocation();
                ((Collection)params).add(new IrParameterDecl(new IrVarID(this.skipIdentifier()), paramLoc));
            }
            this.skipOperator(")");
        } else {
            this.skipOperator("()");
        }
        StatementParser statementParser = this.createStatementParser();
        Iterable iterable = params;
        StatementParser statementParser2 = statementParser;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            IrParameterDecl irParameterDecl = (IrParameterDecl)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((IrParameterDecl)((Object)it)).getName().toString());
        }
        statementParser2.addLocalVars(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        $this$map$iv2 = this.topLevelDecls;
        statementParser2 = statementParser;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv2 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrGlobalVarDecl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (IrGlobalVarDecl)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getName().toString());
        }
        statementParser2.addLocalVars(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        statementParser.parseBlock();
        Iterable $i$f$map2 = params;
        List list = params;
        IrFunctionID irFunctionID = name;
        boolean $i$f$map3 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IrParameterDecl bl = (IrParameterDecl)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(SetsKt.setOf((Object)it2.getName()));
        }
        collection = (List)destination$iv$iv2;
        IrLocation irLocation = loc;
        IrCfg irCfg = statementParser.buildCfg();
        boolean bl = false;
        List list2 = collection;
        List list3 = list;
        IrFunctionID irFunctionID2 = irFunctionID;
        IrFunctionDecl functionDecl = new IrFunctionDecl(irFunctionID2, list3, list2, bl, irCfg, irLocation);
        ((Collection)this.topLevelDecls).add(functionDecl);
        this.functions.put(name.toString(), params.size());
    }

    @NotNull
    protected StatementParser createStatementParser() {
        return new StatementParser();
    }

    @NotNull
    protected final IrRecordID skipRecord() {
        Attribute identifier = this.skipIdentifier();
        if (!this.records.contains(identifier.toString())) {
            this.parseError("Unknown record \"" + identifier + "\"");
            throw new KotlinNothingValueException();
        }
        return new IrRecordID(identifier);
    }

    @NotNull
    protected final IrFieldID skipField() {
        Attribute identifier = this.skipIdentifier();
        if (!this.fields.contains(identifier.toString())) {
            this.parseError("Unknown field \"" + identifier + "\"");
            throw new KotlinNothingValueException();
        }
        return new IrFieldID(identifier);
    }

    @NotNull
    protected final IrFunctionID skipFunction() {
        Attribute identifier = this.skipIdentifier();
        return new IrFunctionID(identifier);
    }

    @NotNull
    protected final String skipFunctionSignature() {
        Attribute identifier = this.skipIdentifier();
        Map<String, String> map2 = this.signatures;
        String string = identifier.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        if (!map2.containsKey(string)) {
            this.parseError("Unknown function \"" + identifier + "\"");
            throw new KotlinNothingValueException();
        }
        String string2 = identifier.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    protected final void skipIdentifier(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!Intrinsics.areEqual((Object)this.skipIdentifier().toString(), (Object)name)) {
            this.parseErrorExpected("\"" + name + "\"");
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    protected final Attribute skipIdentifier() {
        String text = this.expectIdentifier();
        this.nextToken();
        return new Attribute(text);
    }

    @NotNull
    protected final String expectIdentifier() {
        if (this.getCurToken() != TokenType.Identifier) {
            this.parseErrorExpected("identifier");
            throw new KotlinNothingValueException();
        }
        return this.tokenText;
    }

    protected final boolean curIdentifier(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.getCurToken() == TokenType.Identifier && Intrinsics.areEqual((Object)this.tokenText, (Object)identifier);
    }

    protected final void skipOperator(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!Intrinsics.areEqual((Object)this.skipOperator(), (Object)name)) {
            this.parseErrorExpected("\"" + name + "\"");
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    protected final String skipOperator() {
        String text = this.expectOperator();
        this.nextToken();
        return text;
    }

    @NotNull
    protected final String expectOperator() {
        if (this.getCurToken() != TokenType.Operator) {
            this.parseErrorExpected("operator");
            throw new KotlinNothingValueException();
        }
        return this.tokenText;
    }

    protected final boolean curOperator(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getCurToken() == TokenType.Operator && Intrinsics.areEqual((Object)this.tokenText, (Object)name);
    }

    @NotNull
    protected final String skipConstant() {
        if (this.getCurToken() != TokenType.IntConstant && this.getCurToken() != TokenType.BoolConstant && this.getCurToken() != TokenType.StringConstant) {
            this.parseErrorExpected("constant");
            throw new KotlinNothingValueException();
        }
        String text = this.tokenText;
        this.nextToken();
        return text;
    }

    @NotNull
    protected final Void parseError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        IrLocation location = this.curLocation();
        throw new DfaInvalidIrException(message + " at " + location.getLine() + ":" + location.getCol(), location);
    }

    @NotNull
    protected final Void parseErrorExpected(@NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        this.parseError(expected + " expected");
        throw new KotlinNothingValueException();
    }

    @NotNull
    protected final IrLocation curLocation() {
        return new IrLocation(this.filePath, this.prevPos, this.pos, this.line + 1, this.prevPos - this.lineStartOffset + 1);
    }

    @NotNull
    protected final IrLocation extend(@NotNull IrLocation startLoc) {
        Intrinsics.checkNotNullParameter((Object)startLoc, (String)"startLoc");
        return new IrLocation(startLoc.getFilePath(), startLoc.getOffset1(), this.prevPosBeforeSpace, startLoc.getLine(), startLoc.getCol());
    }

    protected final void nextToken() {
        int n;
        this.prevPosBeforeSpace = this.pos;
        while (this.pos < this.fileText.length() && CharsKt.isWhitespace((char)this.fileText.charAt(this.pos))) {
            if (this.fileText.charAt(this.pos) == '\n') {
                n = this.line;
                this.line = n + 1;
                this.lineStartOffset = this.pos + 1;
            }
            n = this.pos;
            this.pos = n + 1;
        }
        this.prevPos = this.pos;
        if (this.pos >= this.fileText.length()) {
            this.setCurToken(TokenType.EndOfFile);
        } else if (Character.isJavaIdentifierStart(this.fileText.charAt(this.pos))) {
            while (this.pos < this.fileText.length() && Character.isJavaIdentifierPart(this.fileText.charAt(this.pos))) {
                n = this.pos;
                this.pos = n + 1;
            }
            String string = this.fileText.substring(this.prevPos, this.pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = this.tokenText = string;
            this.setCurToken(Intrinsics.areEqual((Object)string2, (Object)"true") ? TokenType.BoolConstant : (Intrinsics.areEqual((Object)string2, (Object)"false") ? TokenType.BoolConstant : TokenType.Identifier));
        } else if (Character.isDigit(this.fileText.charAt(this.pos)) || this.fileText.charAt(this.pos) == '-') {
            if (this.fileText.charAt(this.pos) == '-') {
                n = this.pos;
                this.pos = n + 1;
            }
            while (this.pos < this.fileText.length() && Character.isDigit(this.fileText.charAt(this.pos))) {
                n = this.pos;
                this.pos = n + 1;
            }
            String string = this.fileText.substring(this.prevPos, this.pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.tokenText = string;
            this.setCurToken(TokenType.IntConstant);
        } else if (this.fileText.charAt(this.pos) == '\"') {
            n = this.pos;
            this.pos = n + 1;
            while (this.pos < this.fileText.length() && this.fileText.charAt(this.pos) != '\"') {
                n = this.pos;
                this.pos = n + 1;
            }
            if (this.pos < this.fileText.length()) {
                n = this.pos;
                this.pos = n + 1;
            }
            String string = this.fileText.substring(this.prevPos, this.pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            char[] cArray = new char[]{'\"'};
            this.tokenText = StringsKt.trim((String)string, (char[])cArray);
            this.setCurToken(TokenType.StringConstant);
        } else {
            while (!(this.pos >= this.fileText.length() || Character.isDigit(this.fileText.charAt(this.pos)) || Character.isJavaIdentifierPart(this.fileText.charAt(this.pos)) || CharsKt.isWhitespace((char)this.fileText.charAt(this.pos)) || this.fileText.charAt(this.pos) == '\"')) {
                n = this.pos;
                this.pos = n + 1;
            }
            String string = this.fileText.substring(this.prevPos, this.pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.tokenText = string;
            if (Intrinsics.areEqual((Object)this.tokenText, (Object)"//")) {
                int n2;
                int commentStartPos = this.prevPosBeforeSpace;
                this.prevPos = this.pos;
                while (this.pos < this.fileText.length() && this.fileText.charAt(this.pos) != '\n') {
                    n2 = this.pos;
                    this.pos = n2 + 1;
                }
                String string3 = this.fileText.substring(this.prevPos, this.pos);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                this.tokenText = string3;
                ((Collection)this.comments).add(TuplesKt.to((Object)(this.line + 1), (Object)this.tokenText));
                if (this.pos < this.fileText.length()) {
                    n2 = this.pos;
                    this.pos = n2 + 1;
                    n2 = this.line;
                    this.line = n2 + 1;
                }
                this.nextToken();
                this.prevPosBeforeSpace = commentStartPos;
                return;
            }
            this.setCurToken(TokenType.Operator);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/intellij/rml/dfa/test/IrProtoLanguageParser$Call;", "", "function", "", "argumentsCnt", "", "isVirtual", "", "location", "Lcom/intellij/rml/dfa/ir/IrLocation;", "(Ljava/lang/String;IZLcom/intellij/rml/dfa/ir/IrLocation;)V", "getArgumentsCnt", "()I", "getFunction", "()Ljava/lang/String;", "()Z", "getLocation", "()Lcom/intellij/rml/dfa/ir/IrLocation;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "intellij.rml.dfa"})
    private static final class Call {
        @NotNull
        private final String function;
        private final int argumentsCnt;
        private final boolean isVirtual;
        @NotNull
        private final IrLocation location;

        public Call(@NotNull String function2, int argumentsCnt, boolean isVirtual, @NotNull IrLocation location) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            this.function = function2;
            this.argumentsCnt = argumentsCnt;
            this.isVirtual = isVirtual;
            this.location = location;
        }

        @NotNull
        public final String getFunction() {
            return this.function;
        }

        public final int getArgumentsCnt() {
            return this.argumentsCnt;
        }

        public final boolean isVirtual() {
            return this.isVirtual;
        }

        @NotNull
        public final IrLocation getLocation() {
            return this.location;
        }

        @NotNull
        public final String component1() {
            return this.function;
        }

        public final int component2() {
            return this.argumentsCnt;
        }

        public final boolean component3() {
            return this.isVirtual;
        }

        @NotNull
        public final IrLocation component4() {
            return this.location;
        }

        @NotNull
        public final Call copy(@NotNull String function2, int argumentsCnt, boolean isVirtual, @NotNull IrLocation location) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            return new Call(function2, argumentsCnt, isVirtual, location);
        }

        public static /* synthetic */ Call copy$default(Call call, String string, int n, boolean bl, IrLocation irLocation, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = call.function;
            }
            if ((n2 & 2) != 0) {
                n = call.argumentsCnt;
            }
            if ((n2 & 4) != 0) {
                bl = call.isVirtual;
            }
            if ((n2 & 8) != 0) {
                irLocation = call.location;
            }
            return call.copy(string, n, bl, irLocation);
        }

        @NotNull
        public String toString() {
            return "Call(function=" + this.function + ", argumentsCnt=" + this.argumentsCnt + ", isVirtual=" + this.isVirtual + ", location=" + this.location + ")";
        }

        public int hashCode() {
            int result = this.function.hashCode();
            result = result * 31 + Integer.hashCode(this.argumentsCnt);
            result = result * 31 + Boolean.hashCode(this.isVirtual);
            result = result * 31 + this.location.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Call)) {
                return false;
            }
            Call call = (Call)other;
            if (!Intrinsics.areEqual((Object)this.function, (Object)call.function)) {
                return false;
            }
            if (this.argumentsCnt != call.argumentsCnt) {
                return false;
            }
            if (this.isVirtual != call.isVirtual) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.location, (Object)call.location);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0094\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0006\u0010\u001e\u001a\u00020\u0011J\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0 J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\u0018H\u0014J\b\u0010$\u001a\u00020\u0011H\u0002J\b\u0010%\u001a\u00020\u0011H\u0014J.\u0010&\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010*\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,H\u0002J*\u0010-\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u00101\u001a\u00020\u0011H\u0002J\b\u00102\u001a\u00020\u001bH\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00063"}, d2={"Lcom/intellij/rml/dfa/test/IrProtoLanguageParser$StatementParser;", "", "(Lcom/intellij/rml/dfa/test/IrProtoLanguageParser;)V", "builder", "Lcom/intellij/rml/dfa/ir/cfg/IrCfgBuilder;", "getBuilder", "()Lcom/intellij/rml/dfa/ir/cfg/IrCfgBuilder;", "gotos", "", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "labels", "", "", "localVars", "getLocalVars", "()Ljava/util/Set;", "addLocalVars", "", "vars", "", "buildCfg", "Lcom/intellij/rml/dfa/ir/cfg/IrCfg;", "parseArguments", "", "Lcom/intellij/rml/dfa/ir/ast/IrExpr;", "parseAssignment", "result", "Lcom/intellij/rml/dfa/ir/ast/IrVarID;", "location", "Lcom/intellij/rml/dfa/ir/IrLocation;", "parseBlock", "parseBranch", "Lkotlin/Pair;", "parseCondition", "Lcom/intellij/rml/dfa/ir/ast/IrCondition;", "parseExpression", "parseIf", "parseStatement", "parseStaticCall", "function", "Lcom/intellij/rml/dfa/ir/ast/IrFunctionID;", "extraArg", "parseVarDecl", "isTemp", "", "parseVirtualCall", "receiver", "Lcom/intellij/rml/dfa/ir/ast/IrVarRefExpr;", "signature", "parseWhile", "skipVar", "intellij.rml.dfa"})
    @SourceDebugExtension(value={"SMAP\nIrProtoLanguageParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrProtoLanguageParser.kt\ncom/intellij/rml/dfa/test/IrProtoLanguageParser$StatementParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,618:1\n1#2:619\n*E\n"})
    protected class StatementParser {
        @NotNull
        private final IrCfgBuilder builder = IrCfgBuilder.Companion.invoke();
        @NotNull
        private final Set<String> localVars = new LinkedHashSet();
        @NotNull
        private final Map<String, IrCFGBlock> labels = new LinkedHashMap();
        @NotNull
        private final Set<IrCFGBlock> gotos = new LinkedHashSet();

        @NotNull
        protected final IrCfgBuilder getBuilder() {
            return this.builder;
        }

        @NotNull
        protected final Set<String> getLocalVars() {
            return this.localVars;
        }

        public final void addLocalVars(@NotNull Set<String> vars) {
            Intrinsics.checkNotNullParameter(vars, (String)"vars");
            CollectionsKt.addAll((Collection)this.localVars, (Iterable)vars);
        }

        @NotNull
        public final IrCfg buildCfg() {
            return this.builder.build();
        }

        public final void parseBlock() {
            IrProtoLanguageParser.this.skipOperator("{");
            while (!IrProtoLanguageParser.this.curOperator("}")) {
                this.parseStatement();
                this.builder.addBlock();
            }
            IrProtoLanguageParser.this.skipOperator("}");
        }

        protected void parseStatement() {
            IrLocation location = IrProtoLanguageParser.this.curLocation();
            if (IrProtoLanguageParser.this.getCurToken() == TokenType.IntConstant) {
                this.labels.put(IrProtoLanguageParser.this.skipConstant(), this.builder.getLastAddedBlock());
                IrProtoLanguageParser.this.skipOperator(":");
            }
            switch (IrProtoLanguageParser.this.expectIdentifier()) {
                case "var": {
                    this.parseVarDecl(location, false);
                    break;
                }
                case "temp": {
                    this.parseVarDecl(location, true);
                    break;
                }
                case "return": {
                    IrProtoLanguageParser.this.nextToken();
                    this.builder.addReturnStmt(this.parseExpression(), IrProtoLanguageParser.this.extend(location));
                    break;
                }
                case "goto": {
                    IrProtoLanguageParser.this.nextToken();
                    IrCFGBlock irCFGBlock = this.labels.get(IrProtoLanguageParser.this.skipConstant());
                    if (irCFGBlock == null) {
                        IrProtoLanguageParser.this.parseErrorExpected("label");
                        throw new KotlinNothingValueException();
                    }
                    IrCFGBlock target = irCFGBlock;
                    this.builder.setUnconditionalJump(this.builder.getLastAddedBlock(), target);
                    ((Collection)this.gotos).add(this.builder.getLastAddedBlock());
                    break;
                }
                case "if": {
                    this.parseIf();
                    break;
                }
                case "while": {
                    this.parseWhile();
                    break;
                }
                default: {
                    if (IrProtoLanguageParser.this.getRecords().contains(IrProtoLanguageParser.this.expectIdentifier())) {
                        IrRecordID record = IrProtoLanguageParser.this.skipRecord();
                        IrProtoLanguageParser.this.skipOperator(".");
                        IrProtoLanguageParser.this.skipIdentifier("copy");
                        IrProtoLanguageParser.this.skipOperator("(");
                        IrVarID source = this.skipVar();
                        IrProtoLanguageParser.this.skipOperator(",");
                        IrVarID dest = this.skipVar();
                        IrProtoLanguageParser.this.skipOperator(")");
                        this.builder.addRecordCopyStmt(source, dest, record, IrProtoLanguageParser.this.extend(location));
                        break;
                    }
                    if (this.localVars.contains(IrProtoLanguageParser.this.expectIdentifier())) {
                        IrVarID result = this.skipVar();
                        IrLocation varLocation = IrProtoLanguageParser.this.extend(location);
                        String string = IrProtoLanguageParser.this.skipOperator();
                        if (Intrinsics.areEqual((Object)string, (Object)"=")) {
                            this.parseAssignment(result, location);
                            break;
                        }
                        if (Intrinsics.areEqual((Object)string, (Object)".")) {
                            if (IrProtoLanguageParser.this.getSignatures().containsKey(IrProtoLanguageParser.this.expectIdentifier())) {
                                this.parseVirtualCall(null, new IrVarRefExpr(result, varLocation), IrProtoLanguageParser.this.skipFunctionSignature(), location);
                                break;
                            }
                            IrFieldID field = IrProtoLanguageParser.this.skipField();
                            IrProtoLanguageParser.this.skipOperator("=");
                            this.builder.addStoreStmt(result, field, this.parseExpression(), IrProtoLanguageParser.this.extend(location));
                            break;
                        }
                        IrProtoLanguageParser.this.parseErrorExpected("= or .");
                        throw new KotlinNothingValueException();
                    }
                    StatementParser.parseStaticCall$default(this, null, IrProtoLanguageParser.this.skipFunction(), location, null, 8, null);
                }
            }
        }

        private final void parseVarDecl(IrLocation location, boolean isTemp) {
            IrProtoLanguageParser.this.nextToken();
            IrLocation assignmentLocation = IrProtoLanguageParser.this.curLocation();
            Attribute id = IrProtoLanguageParser.this.skipIdentifier();
            IrVarID varID = new IrVarID(id);
            this.builder.addLocalVarDeclarationStmt(varID, isTemp, IrProtoLanguageParser.this.extend(location));
            ((Collection)this.localVars).add(id.toString());
            if (IrProtoLanguageParser.this.curOperator("=")) {
                IrProtoLanguageParser.this.nextToken();
                this.parseAssignment(varID, assignmentLocation);
            }
        }

        protected void parseAssignment(@NotNull IrVarID result, @NotNull IrLocation location) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            if (IrProtoLanguageParser.this.getCurToken() == TokenType.Identifier) {
                if (Intrinsics.areEqual((Object)IrProtoLanguageParser.this.getTokenText(), (Object)"new")) {
                    IrProtoLanguageParser.this.nextToken();
                    IrLocation callLocation = IrProtoLanguageParser.this.curLocation();
                    String recordName = IrProtoLanguageParser.this.getTokenText();
                    this.builder.addNewRecordInstanceStmt(result, IrProtoLanguageParser.this.skipRecord(), IrProtoLanguageParser.this.extend(location));
                    if (IrProtoLanguageParser.this.curOperator("(") || IrProtoLanguageParser.this.curOperator("()")) {
                        IrFunctionID constructor = new IrFunctionID(new Attribute(recordName));
                        this.parseStaticCall(null, constructor, callLocation, new IrVarRefExpr(result, IrProtoLanguageParser.this.extend(location)));
                    }
                } else if (IrProtoLanguageParser.this.getCurToken() == TokenType.Identifier && !this.localVars.contains(IrProtoLanguageParser.this.getTokenText()) && !Intrinsics.areEqual((Object)IrProtoLanguageParser.this.getTokenText(), (Object)"unknown")) {
                    StatementParser.parseStaticCall$default(this, result, IrProtoLanguageParser.this.skipFunction(), location, null, 8, null);
                } else {
                    IrExpr expr = this.parseExpression();
                    if (expr instanceof IrVarRefExpr && IrProtoLanguageParser.this.curOperator(".")) {
                        IrProtoLanguageParser.this.nextToken();
                        if (IrProtoLanguageParser.this.getSignatures().containsKey(IrProtoLanguageParser.this.expectIdentifier())) {
                            this.parseVirtualCall(result, (IrVarRefExpr)expr, IrProtoLanguageParser.this.skipFunctionSignature(), location);
                        } else {
                            this.builder.addLoadStmt(result, ((IrVarRefExpr)expr).getVariable(), IrProtoLanguageParser.this.skipField(), IrProtoLanguageParser.this.extend(location));
                        }
                    } else {
                        this.builder.addAssignmentStmt(result, expr, IrProtoLanguageParser.this.extend(location));
                    }
                }
            } else {
                this.builder.addAssignmentStmt(result, this.parseExpression(), IrProtoLanguageParser.this.extend(location));
            }
        }

        private final void parseStaticCall(IrVarID result, IrFunctionID function2, IrLocation location, IrExpr extraArg) {
            IrExpr irExpr = extraArg;
            List arguments = CollectionsKt.plus((Collection)(irExpr != null ? CollectionsKt.listOf((Object)irExpr) : CollectionsKt.emptyList()), (Iterable)this.parseArguments());
            ((Collection)IrProtoLanguageParser.this.calls).add(new Call(function2.toString(), arguments.size(), false, IrProtoLanguageParser.this.curLocation()));
            this.builder.addStaticCallStmt(result, function2, arguments, IrProtoLanguageParser.this.extend(location));
        }

        static /* synthetic */ void parseStaticCall$default(StatementParser statementParser, IrVarID irVarID, IrFunctionID irFunctionID, IrLocation irLocation, IrExpr irExpr, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parseStaticCall");
            }
            if ((n & 8) != 0) {
                irExpr = null;
            }
            statementParser.parseStaticCall(irVarID, irFunctionID, irLocation, irExpr);
        }

        private final void parseVirtualCall(IrVarID result, IrVarRefExpr receiver, String signature, IrLocation location) {
            List<IrExpr> arguments = this.parseArguments();
            ((Collection)IrProtoLanguageParser.this.calls).add(new Call(signature, arguments.size() + 1, true, IrProtoLanguageParser.this.curLocation()));
            this.builder.addVirtualCallStmt(result, receiver, null, signature, arguments, IrProtoLanguageParser.this.extend(location));
        }

        private final List<IrExpr> parseArguments() {
            List arguments = new ArrayList();
            String string = IrProtoLanguageParser.this.skipOperator();
            if (Intrinsics.areEqual((Object)string, (Object)"(")) {
                ((Collection)arguments).add(this.parseExpression());
                while (Intrinsics.areEqual((Object)IrProtoLanguageParser.this.expectOperator(), (Object)",")) {
                    IrProtoLanguageParser.this.nextToken();
                    ((Collection)arguments).add(this.parseExpression());
                }
                IrProtoLanguageParser.this.skipOperator(")");
            } else if (!Intrinsics.areEqual((Object)string, (Object)"()")) {
                IrProtoLanguageParser.this.parseErrorExpected("(");
                throw new KotlinNothingValueException();
            }
            return arguments;
        }

        private final void parseIf() {
            Pair pair;
            IrProtoLanguageParser.this.skipIdentifier("if");
            IrProtoLanguageParser.this.skipOperator("(");
            this.builder.addBlock();
            IrCondition condition = this.parseCondition();
            IrProtoLanguageParser.this.skipOperator(")");
            IrCFGBlock conditionExit = this.builder.getLastAddedBlock();
            Pair<IrCFGBlock, IrCFGBlock> thenBlock = this.parseBranch();
            if (IrProtoLanguageParser.this.curIdentifier("else")) {
                IrProtoLanguageParser.this.nextToken();
                pair = this.parseBranch();
            } else {
                IrCFGBlock it = this.builder.createBlock();
                boolean bl = false;
                pair = TuplesKt.to((Object)it, (Object)it);
            }
            Pair elseBlock = pair;
            IrCFGBlock exitBlock = this.builder.createBlock();
            this.builder.setConditionalJump(conditionExit, (IrCFGBlock)thenBlock.getFirst(), (IrCFGBlock)elseBlock.getFirst(), condition);
            if (!this.gotos.contains(thenBlock.getSecond())) {
                this.builder.setUnconditionalJump((IrCFGBlock)thenBlock.getSecond(), exitBlock);
            }
            if (!this.gotos.contains(elseBlock.getSecond())) {
                this.builder.setUnconditionalJump((IrCFGBlock)elseBlock.getSecond(), exitBlock);
            }
        }

        private final void parseWhile() {
            IrProtoLanguageParser.this.skipIdentifier("while");
            IrProtoLanguageParser.this.skipOperator("(");
            IrCFGBlock conditionStart = this.builder.addBlock();
            IrCondition condition = this.parseCondition();
            IrProtoLanguageParser.this.skipOperator(")");
            IrCFGBlock conditionExit = this.builder.getLastAddedBlock();
            Pair<IrCFGBlock, IrCFGBlock> body = this.parseBranch();
            IrCFGBlock exitBlock = this.builder.createBlock();
            this.builder.setConditionalJump(conditionExit, (IrCFGBlock)body.getFirst(), exitBlock, condition);
            this.builder.setUnconditionalJump((IrCFGBlock)body.getSecond(), conditionStart);
        }

        @NotNull
        public final Pair<IrCFGBlock, IrCFGBlock> parseBranch() {
            IrCFGBlock start = this.builder.createBlock();
            if (IrProtoLanguageParser.this.curOperator("{")) {
                this.parseBlock();
            } else {
                this.parseStatement();
            }
            return TuplesKt.to((Object)start, (Object)this.builder.getLastAddedBlock());
        }

        @NotNull
        protected IrCondition parseCondition() {
            IrEqualityKind irEqualityKind;
            IrLocation location = IrProtoLanguageParser.this.curLocation();
            IrExpr left2 = this.parseExpression();
            if (IrProtoLanguageParser.this.curOperator(")")) {
                if (Intrinsics.areEqual((Object)left2, (Object)IrUnknownExpr.INSTANCE)) {
                    return new IrUnsupportedCondition(IrProtoLanguageParser.this.extend(location));
                }
                if (left2 instanceof IrConstantExpr && ((IrConstantExpr)left2).getConst() instanceof IrBoolConstant) {
                    return new IrConstantCondition(((IrBoolConstant)((IrConstantExpr)left2).getConst()).getValue(), IrProtoLanguageParser.this.extend(location));
                }
                IrProtoLanguageParser.this.parseErrorExpected("operator");
                throw new KotlinNothingValueException();
            }
            try {
                irEqualityKind = IrEqualityKind.Companion.parse(IrProtoLanguageParser.this.skipOperator());
            }
            catch (NoSuchElementException e) {
                IrProtoLanguageParser.this.parseErrorExpected("comparison operator");
                throw new KotlinNothingValueException();
            }
            IrEqualityKind comparison = irEqualityKind;
            IrExpr right2 = this.parseExpression();
            return new IrComparisonCondition(left2, right2, comparison, IrProtoLanguageParser.this.extend(location));
        }

        @NotNull
        protected IrExpr parseExpression() {
            IrLocation location = IrProtoLanguageParser.this.curLocation();
            switch (WhenMappings.$EnumSwitchMapping$0[IrProtoLanguageParser.this.getCurToken().ordinal()]) {
                case 1: {
                    if (Intrinsics.areEqual((Object)IrProtoLanguageParser.this.getTokenText(), (Object)"unknown")) {
                        IrProtoLanguageParser.this.nextToken();
                        return IrUnknownExpr.INSTANCE;
                    }
                    return new IrVarRefExpr(this.skipVar(), IrProtoLanguageParser.this.extend(location));
                }
                case 2: {
                    IrConstant irConstant;
                    try {
                        irConstant = new IrIntConstant(Integer.parseInt(IrProtoLanguageParser.this.getTokenText()));
                    }
                    catch (NumberFormatException e) {
                        irConstant = new IrValueConstant(IrProtoLanguageParser.this.getTokenText(), null, 2, null);
                    }
                    IrConstant constant = irConstant;
                    IrProtoLanguageParser.this.nextToken();
                    return new IrConstantExpr(constant);
                }
                case 3: {
                    IrBoolConstant constant = new IrBoolConstant(Intrinsics.areEqual((Object)IrProtoLanguageParser.this.getTokenText(), (Object)"true"));
                    IrProtoLanguageParser.this.nextToken();
                    return new IrConstantExpr(constant);
                }
                case 4: {
                    IrStringConstant constant = new IrStringConstant(IrProtoLanguageParser.this.getTokenText());
                    IrProtoLanguageParser.this.nextToken();
                    return new IrConstantExpr(constant);
                }
            }
            IrProtoLanguageParser.this.parseErrorExpected("var or integer");
            throw new KotlinNothingValueException();
        }

        @NotNull
        protected final IrVarID skipVar() {
            Attribute identifier = IrProtoLanguageParser.this.skipIdentifier();
            if (!this.localVars.contains(identifier.toString())) {
                IrProtoLanguageParser.this.parseError("Unknown variable \"" + identifier + "\"");
                throw new KotlinNothingValueException();
            }
            return new IrVarID(identifier);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TokenType.values().length];
                try {
                    nArray[TokenType.Identifier.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TokenType.IntConstant.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TokenType.BoolConstant.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TokenType.StringConstant.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/rml/dfa/test/IrProtoLanguageParser$TokenType;", "", "(Ljava/lang/String;I)V", "Identifier", "IntConstant", "BoolConstant", "StringConstant", "Operator", "EndOfFile", "intellij.rml.dfa"})
    protected static final class TokenType
    extends Enum<TokenType> {
        public static final /* enum */ TokenType Identifier = new TokenType();
        public static final /* enum */ TokenType IntConstant = new TokenType();
        public static final /* enum */ TokenType BoolConstant = new TokenType();
        public static final /* enum */ TokenType StringConstant = new TokenType();
        public static final /* enum */ TokenType Operator = new TokenType();
        public static final /* enum */ TokenType EndOfFile = new TokenType();
        private static final /* synthetic */ TokenType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TokenType[] values() {
            return (TokenType[])$VALUES.clone();
        }

        public static TokenType valueOf(String value) {
            return Enum.valueOf(TokenType.class, value);
        }

        @NotNull
        public static EnumEntries<TokenType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tokenTypeArray = new TokenType[]{TokenType.Identifier, TokenType.IntConstant, TokenType.BoolConstant, TokenType.StringConstant, TokenType.Operator, TokenType.EndOfFile};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

