/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.ir.cfg;

import com.intellij.rml.dfa.ir.ast.IrCondition;
import com.intellij.rml.dfa.ir.ast.IrVisitor;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/rml/dfa/ir/cfg/IrConditionalJump;", "Lcom/intellij/rml/dfa/ir/cfg/IrJump;", "condition", "Lcom/intellij/rml/dfa/ir/ast/IrCondition;", "trueBranch", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "falseBranch", "(Lcom/intellij/rml/dfa/ir/ast/IrCondition;Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;)V", "getCondition", "()Lcom/intellij/rml/dfa/ir/ast/IrCondition;", "getFalseBranch", "()Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "targets", "", "getTargets", "()Ljava/util/List;", "getTrueBranch", "accept", "", "visitor", "Lcom/intellij/rml/dfa/ir/ast/IrVisitor;", "sourceBlock", "acceptChildren", "intellij.rml.dfa"})
public final class IrConditionalJump
implements IrJump {
    @NotNull
    private final IrCondition condition;
    @NotNull
    private final IrCFGBlock trueBranch;
    @NotNull
    private final IrCFGBlock falseBranch;
    @NotNull
    private final List<IrCFGBlock> targets;

    public IrConditionalJump(@NotNull IrCondition condition, @NotNull IrCFGBlock trueBranch, @NotNull IrCFGBlock falseBranch) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)trueBranch, (String)"trueBranch");
        Intrinsics.checkNotNullParameter((Object)falseBranch, (String)"falseBranch");
        this.condition = condition;
        this.trueBranch = trueBranch;
        this.falseBranch = falseBranch;
        Object[] objectArray = new IrCFGBlock[]{this.trueBranch, this.falseBranch};
        this.targets = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final IrCondition getCondition() {
        return this.condition;
    }

    @NotNull
    public final IrCFGBlock getTrueBranch() {
        return this.trueBranch;
    }

    @NotNull
    public final IrCFGBlock getFalseBranch() {
        return this.falseBranch;
    }

    @Override
    @NotNull
    public List<IrCFGBlock> getTargets() {
        return this.targets;
    }

    public final void accept(@NotNull IrVisitor visitor, @NotNull IrCFGBlock sourceBlock) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)sourceBlock, (String)"sourceBlock");
        visitor.visitConditionalJump(sourceBlock, this);
    }

    public final void acceptChildren(@NotNull IrVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        this.condition.accept(visitor);
    }
}

