/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.ir;

import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.ast.IrDeclaration;
import com.intellij.rml.dfa.ir.ast.IrIdentifier;
import com.intellij.rml.dfa.ir.ast.IrLocationID;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002BA\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0004\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\u0002\u0010\fJ&\u0010\r\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0012\b\u0002\u0010\u000f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0005J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\tR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/rml/dfa/ir/IrScope;", "", "()V", "statementLocations", "", "Lcom/intellij/rml/dfa/attributes/DfaTuple;", "Lcom/intellij/rml/dfa/ir/IrLocation;", "attributeToIdentifier", "Lcom/intellij/rml/dfa/attributes/Attribute;", "Lcom/intellij/rml/dfa/ir/ast/IrIdentifier;", "identifierToDecl", "Lcom/intellij/rml/dfa/ir/ast/IrDeclaration;", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "findIdentifier", "attribute", "irClass", "Lkotlin/reflect/KClass;", "findLocation", "getStatementLocation", "tuple", "plus", "scope", "resolve", "identifier", "intellij.rml.dfa"})
public final class IrScope {
    @NotNull
    private final Map<DfaTuple, IrLocation> statementLocations;
    @NotNull
    private final Map<Attribute, IrIdentifier> attributeToIdentifier;
    @NotNull
    private final Map<IrIdentifier, IrDeclaration> identifierToDecl;

    public IrScope(@NotNull Map<DfaTuple, IrLocation> statementLocations, @NotNull Map<Attribute, ? extends IrIdentifier> attributeToIdentifier, @NotNull Map<IrIdentifier, ? extends IrDeclaration> identifierToDecl) {
        Intrinsics.checkNotNullParameter(statementLocations, (String)"statementLocations");
        Intrinsics.checkNotNullParameter(attributeToIdentifier, (String)"attributeToIdentifier");
        Intrinsics.checkNotNullParameter(identifierToDecl, (String)"identifierToDecl");
        this.statementLocations = statementLocations;
        this.attributeToIdentifier = attributeToIdentifier;
        this.identifierToDecl = identifierToDecl;
    }

    public IrScope() {
        this(MapsKt.emptyMap(), MapsKt.emptyMap(), MapsKt.emptyMap());
    }

    @NotNull
    public final IrScope plus(@NotNull IrScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return new IrScope(MapsKt.plus(this.statementLocations, scope.statementLocations), MapsKt.plus(this.attributeToIdentifier, scope.attributeToIdentifier), MapsKt.plus(this.identifierToDecl, scope.identifierToDecl));
    }

    @Nullable
    public final IrDeclaration resolve(@NotNull IrIdentifier identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.identifierToDecl.get(identifier);
    }

    @Nullable
    public final IrIdentifier findIdentifier(@Nullable Attribute attribute, @Nullable KClass<? extends IrIdentifier> irClass) {
        IrIdentifier identifier = this.attributeToIdentifier.get(attribute);
        return irClass == null || irClass.isInstance((Object)identifier) ? identifier : null;
    }

    public static /* synthetic */ IrIdentifier findIdentifier$default(IrScope irScope, Attribute attribute, KClass kClass, int n, Object object) {
        if ((n & 2) != 0) {
            kClass = null;
        }
        return irScope.findIdentifier(attribute, (KClass<? extends IrIdentifier>)kClass);
    }

    @Nullable
    public final IrLocation findLocation(@NotNull Attribute attribute) {
        IrLocation irLocation;
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        IrIdentifier identifier = this.attributeToIdentifier.get(attribute);
        if (identifier instanceof IrLocationID) {
            irLocation = ((IrLocationID)identifier).getLocation();
        } else {
            IrDeclaration irDeclaration = this.identifierToDecl.get(identifier);
            irLocation = irDeclaration != null ? irDeclaration.getLocation() : null;
        }
        return irLocation;
    }

    @Nullable
    public final IrLocation getStatementLocation(@NotNull DfaTuple tuple) {
        Intrinsics.checkNotNullParameter((Object)tuple, (String)"tuple");
        return this.statementLocations.get(tuple);
    }
}

