/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.ir;

import com.intellij.openapi.util.UserDataHolderBase;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B-\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0000J\u0013\u0010\u0018\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/intellij/rml/dfa/ir/IrLocation;", "", "Lcom/intellij/openapi/util/UserDataHolderBase;", "name", "", "(Ljava/lang/String;)V", "filePath", "offset1", "", "offset2", "line", "col", "(Ljava/lang/String;IIII)V", "getCol", "()I", "getFilePath", "()Ljava/lang/String;", "getLine", "getOffset1", "getOffset2", "compareTo", "other", "contains", "", "equals", "", "hashCode", "toString", "intellij.rml.dfa"})
public final class IrLocation
extends UserDataHolderBase
implements Comparable<IrLocation> {
    @NotNull
    private final String filePath;
    private final int offset1;
    private final int offset2;
    private final int line;
    private final int col;

    public IrLocation(@NotNull String filePath, int offset1, int offset2, int line, int col) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.filePath = filePath;
        this.offset1 = offset1;
        this.offset2 = offset2;
        this.line = line;
        this.col = col;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    public final int getOffset1() {
        return this.offset1;
    }

    public final int getOffset2() {
        return this.offset2;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getCol() {
        return this.col;
    }

    public IrLocation(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, -1, -1, -1, -1);
    }

    @NotNull
    public String toString() {
        return new File(this.filePath).getName() + ":" + this.line + ":" + this.col + "-" + (this.col + this.offset2 - this.offset1);
    }

    @Override
    public int compareTo(@NotNull IrLocation other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int fileComparison = this.filePath.compareTo(other.filePath);
        return fileComparison != 0 ? fileComparison : this.offset1 - other.offset1;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof IrLocation && Intrinsics.areEqual((Object)this.filePath, (Object)((IrLocation)other).filePath) && this.offset1 == ((IrLocation)other).offset1 && this.offset2 == ((IrLocation)other).offset2;
    }

    public final boolean contains(@NotNull IrLocation other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.filePath, (Object)other.filePath) && this.offset1 <= other.offset1 && other.offset2 <= this.offset2;
    }

    public int hashCode() {
        int result = this.filePath.hashCode();
        result = 31 * result + this.offset1;
        result = 31 * result + this.offset2;
        return result;
    }
}

