/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.utils.graph;

import com.intellij.rml.dfa.utils.graph.ControlFlowGraph;
import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.rml.dfa.utils.graph.GraphBuilder;
import com.intellij.rml.dfa.utils.graph.GraphImpl;
import com.intellij.rml.dfa.utils.graph.GraphKt;
import com.intellij.rml.dfa.utils.graph.IntGraph;
import com.intellij.rml.dfa.utils.graph.IntGraphBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0003\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003\u001a\n\u0010\u0000\u001a\u00020\u0004*\u00020\u0004\u001a6\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00060\b\u001a6\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0003\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00060\b\u001a*\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0003\"\u0004\b\u0000\u0010\u0002*\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00020\n\u001a*\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0003\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\u00a8\u0006\u000f"}, d2={"inverted", "Lcom/intellij/rml/dfa/utils/graph/ControlFlowGraph;", "T", "Lcom/intellij/rml/dfa/utils/graph/Graph;", "Lcom/intellij/rml/dfa/utils/graph/IntGraph;", "map", "R", "nodeMapping", "", "nodeTransform", "Lkotlin/Function1;", "", "removeBackEdges", "sortedNodes", "", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nGraphAlgorithmsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphAlgorithmsImpl.kt\ncom/intellij/rml/dfa/impl/utils/graph/GraphAlgorithmsImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1179#2,2:222\n1253#2,4:224\n*S KotlinDebug\n*F\n+ 1 GraphAlgorithmsImpl.kt\ncom/intellij/rml/dfa/impl/utils/graph/GraphAlgorithmsImplKt\n*L\n24#1:222,2\n24#1:224,4\n*E\n"})
public final class GraphAlgorithmsImplKt {
    @NotNull
    public static final <T> Graph<T> inverted(@NotNull Graph<T> $this$inverted) {
        Intrinsics.checkNotNullParameter($this$inverted, (String)"<this>");
        return GraphKt.buildGraph((Function1)new Function1<GraphBuilder<T>, Unit>($this$inverted){
            final /* synthetic */ Graph<T> $this_inverted;
            {
                this.$this_inverted = $receiver;
                super(1);
            }

            public final void invoke(@NotNull GraphBuilder<T> $this$buildGraph) {
                Intrinsics.checkNotNullParameter($this$buildGraph, (String)"$this$buildGraph");
                Iterable $this$forEach$iv = this.$this_inverted.nodes();
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator.next();
                    boolean bl = false;
                    $this$buildGraph.addNode(it);
                }
                $this$forEach$iv = this.$this_inverted.edges();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    Object from = pair.component1();
                    Object to = pair.component2();
                    $this$buildGraph.addEdge(to, from);
                }
            }
        });
    }

    @NotNull
    public static final IntGraph inverted(@NotNull IntGraph $this$inverted) {
        Intrinsics.checkNotNullParameter((Object)$this$inverted, (String)"<this>");
        return GraphKt.buildIntGraph((Function1<? super IntGraphBuilder, Unit>)((Function1)new Function1<IntGraphBuilder, Unit>($this$inverted){
            final /* synthetic */ IntGraph $this_inverted;
            {
                this.$this_inverted = $receiver;
                super(1);
            }

            public final void invoke(@NotNull IntGraphBuilder $this$buildIntGraph) {
                Intrinsics.checkNotNullParameter((Object)$this$buildIntGraph, (String)"$this$buildIntGraph");
                Iterable $this$forEach$iv = this.$this_inverted.nodes();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    $this$buildIntGraph.addNode(it);
                }
                $this$forEach$iv = this.$this_inverted.edges();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    int from = ((Number)pair.component1()).intValue();
                    int to = ((Number)pair.component2()).intValue();
                    $this$buildIntGraph.addEdge(to, from);
                }
            }
        }));
    }

    @NotNull
    public static final <T> ControlFlowGraph<T> inverted(@NotNull ControlFlowGraph<T> $this$inverted) {
        Intrinsics.checkNotNullParameter($this$inverted, (String)"<this>");
        return new ControlFlowGraph<T>(GraphAlgorithmsImplKt.inverted($this$inverted.getGraph()), $this$inverted.getExitNode(), $this$inverted.getStartNode());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Graph<T> removeBackEdges(@NotNull Graph<T> $this$removeBackEdges, @NotNull List<? extends T> sortedNodes) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$removeBackEdges, (String)"<this>");
        Intrinsics.checkNotNullParameter(sortedNodes, (String)"sortedNodes");
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)sortedNodes);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            boolean bl = false;
            int idx = indexedValue.component1();
            Object func = indexedValue.component2();
            indexedValue = new Pair(func, (Object)idx);
            map2.put(indexedValue.getFirst(), indexedValue.getSecond());
        }
        Map order = destination$iv$iv;
        return GraphKt.buildGraph((Function1)new Function1<GraphBuilder<T>, Unit>($this$removeBackEdges, order){
            final /* synthetic */ Graph<T> $this_removeBackEdges;
            final /* synthetic */ Map<T, Integer> $order;
            {
                this.$this_removeBackEdges = $receiver;
                this.$order = $order;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull GraphBuilder<T> $this$buildGraph) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                T element$iv2;
                Intrinsics.checkNotNullParameter($this$buildGraph, (String)"$this$buildGraph");
                Iterable $this$forEach$iv = this.$this_removeBackEdges.nodes();
                boolean $i$f$forEach22 = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T it = element$iv2 = iterator.next();
                    boolean bl = false;
                    $this$buildGraph.addNode(it);
                }
                $this$forEach$iv = this.$this_removeBackEdges.edges();
                Map<T, Integer> $i$f$forEach22 = this.$order;
                boolean $i$f$filter = false;
                element$iv2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Pair pair = (Pair)element$iv$iv;
                    boolean bl = false;
                    Object from = pair.component1();
                    Object to = pair.component2();
                    Integer n = $i$f$forEach22.get(from);
                    Intrinsics.checkNotNull((Object)n);
                    int n2 = ((Number)n).intValue();
                    Integer n3 = $i$f$forEach22.get(to);
                    Intrinsics.checkNotNull((Object)n3);
                    if (!(n2 > ((Number)n3).intValue())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (T element$iv2 : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv2;
                    boolean bl = false;
                    Object from = pair.component1();
                    Object to = pair.component2();
                    $this$buildGraph.addEdge(from, to);
                }
            }
        });
    }

    @NotNull
    public static final <T> Graph<T> map(@NotNull IntGraph $this$map, @NotNull Function1<? super Integer, ? extends T> nodeTransform) {
        Intrinsics.checkNotNullParameter((Object)$this$map, (String)"<this>");
        Intrinsics.checkNotNullParameter(nodeTransform, (String)"nodeTransform");
        Map nodeToId = new LinkedHashMap();
        Map idToNode = new LinkedHashMap();
        Iterator<Integer> iterator = $this$map.nodes().iterator();
        while (iterator.hasNext()) {
            int node = ((Number)iterator.next()).intValue();
            Object transformed = nodeTransform.invoke((Object)node);
            Integer n = node;
            nodeToId.put(transformed, n);
            n = node;
            idToNode.put(n, transformed);
        }
        return new GraphImpl($this$map, nodeToId, idToNode);
    }

    @NotNull
    public static final <T, R> Graph<R> map(@NotNull Graph<T> $this$map, @NotNull Map<T, ? extends R> nodeMapping) {
        Intrinsics.checkNotNullParameter($this$map, (String)"<this>");
        Intrinsics.checkNotNullParameter(nodeMapping, (String)"nodeMapping");
        return GraphKt.buildGraph((Function1)new Function1<GraphBuilder<R>, Unit>($this$map, nodeMapping){
            final /* synthetic */ Graph<T> $this_map;
            final /* synthetic */ Map<T, R> $nodeMapping;
            {
                this.$this_map = $receiver;
                this.$nodeMapping = $nodeMapping;
                super(1);
            }

            public final void invoke(@NotNull GraphBuilder<R> $this$buildGraph) {
                Iterable $this$forEach$iv;
                Intrinsics.checkNotNullParameter($this$buildGraph, (String)"$this$buildGraph");
                Iterable iterable = this.$this_map.nodes();
                Map<T, R> map2 = this.$nodeMapping;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator.next();
                    boolean bl = false;
                    R r = map2.get(it);
                    Intrinsics.checkNotNull(r);
                    $this$buildGraph.addNode(r);
                }
                $this$forEach$iv = this.$this_map.edges();
                map2 = this.$nodeMapping;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    Object from = pair.component1();
                    Object to = pair.component2();
                    R r = map2.get(from);
                    Intrinsics.checkNotNull(r);
                    R r2 = map2.get(to);
                    Intrinsics.checkNotNull(r2);
                    $this$buildGraph.addEdge(r, r2);
                }
            }
        });
    }

    @NotNull
    public static final <T, R> ControlFlowGraph<R> map(@NotNull ControlFlowGraph<T> $this$map, @NotNull Map<T, ? extends R> nodeMapping) {
        Intrinsics.checkNotNullParameter($this$map, (String)"<this>");
        Intrinsics.checkNotNullParameter(nodeMapping, (String)"nodeMapping");
        Graph<? extends R> graph2 = GraphAlgorithmsImplKt.map($this$map.getGraph(), nodeMapping);
        R r = nodeMapping.get($this$map.getStartNode());
        Intrinsics.checkNotNull(r);
        R r2 = nodeMapping.get($this$map.getExitNode());
        Intrinsics.checkNotNull(r2);
        return new ControlFlowGraph<R>(graph2, r, r2);
    }
}

