/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.translator;

import com.intellij.rml.dfa.AnalysisOptions;
import com.intellij.rml.dfa.DfaAnalysisKind;
import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.DfaNotImplementedException;
import com.intellij.rml.dfa.analyzes.input.InputRelations;
import com.intellij.rml.dfa.analyzes.input.InputRelationsGlobal;
import com.intellij.rml.dfa.analyzes.input.InputRelationsPredefined;
import com.intellij.rml.dfa.analyzes.input.P;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.impl.translator.BaseInstructionTranslator;
import com.intellij.rml.dfa.impl.translator.InlineTranslatorExtension;
import com.intellij.rml.dfa.impl.translator.IrConstantsCollector;
import com.intellij.rml.dfa.impl.translator.IrSessionTranslationContext;
import com.intellij.rml.dfa.impl.translator.IrToRmlTranslatorKt;
import com.intellij.rml.dfa.impl.translator.IrTranslationContextImpl;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.ast.IrAttributeWrapper;
import com.intellij.rml.dfa.ir.ast.IrComparisonCondition;
import com.intellij.rml.dfa.ir.ast.IrCondition;
import com.intellij.rml.dfa.ir.ast.IrConstantCondition;
import com.intellij.rml.dfa.ir.ast.IrConstantExpr;
import com.intellij.rml.dfa.ir.ast.IrCustomEvaluationCondition;
import com.intellij.rml.dfa.ir.ast.IrEqualityKind;
import com.intellij.rml.dfa.ir.ast.IrExpr;
import com.intellij.rml.dfa.ir.ast.IrFieldDecl;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrFunctionID;
import com.intellij.rml.dfa.ir.ast.IrGlobalVarDecl;
import com.intellij.rml.dfa.ir.ast.IrInstanceofCondition;
import com.intellij.rml.dfa.ir.ast.IrIntConstant;
import com.intellij.rml.dfa.ir.ast.IrLocationID;
import com.intellij.rml.dfa.ir.ast.IrNewRecordInstanceStmt;
import com.intellij.rml.dfa.ir.ast.IrObjectID;
import com.intellij.rml.dfa.ir.ast.IrParameterDecl;
import com.intellij.rml.dfa.ir.ast.IrRecordDecl;
import com.intellij.rml.dfa.ir.ast.IrRecordID;
import com.intellij.rml.dfa.ir.ast.IrRecursiveVisitor;
import com.intellij.rml.dfa.ir.ast.IrStatement;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.ast.IrUnsupportedCondition;
import com.intellij.rml.dfa.ir.ast.IrValueConstant;
import com.intellij.rml.dfa.ir.ast.IrVarID;
import com.intellij.rml.dfa.ir.ast.IrVarRefExpr;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.ir.cfg.IrUnconditionalJump;
import com.intellij.rml.dfa.rml.DfaConstants;
import com.intellij.rml.dfa.rml.dsl.lang.RmlRelation1;
import com.intellij.rml.dfa.rml.dsl.lang.RmlRelation2;
import com.intellij.rml.dfa.translator.ComparisonTranslationHelperKt;
import com.intellij.rml.dfa.translator.IrTranslationContext;
import com.intellij.rml.dfa.translator.IrTranslatorExtension;
import com.intellij.rml.dfa.utils.RMLOptions;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/rml/dfa/impl/translator/IrToRmlTranslator;", "", "sessionContext", "Lcom/intellij/rml/dfa/impl/translator/IrSessionTranslationContext;", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "(Lcom/intellij/rml/dfa/impl/translator/IrSessionTranslationContext;Lcom/intellij/rml/dfa/utils/RMLOptions;)V", "translators", "", "Lcom/intellij/rml/dfa/translator/IrTranslatorExtension;", "addConstants", "", "function", "Lcom/intellij/rml/dfa/ir/ast/IrFunctionDecl;", "ctx", "Lcom/intellij/rml/dfa/translator/IrTranslationContext;", "getPredefinedTuples", "", "Lcom/intellij/rml/dfa/attributes/DfaTuple;", "analysisKind", "Lcom/intellij/rml/dfa/DfaAnalysisKind;", "translate", "Lcom/intellij/rml/dfa/impl/translator/IrToRmlTranslator$GlobalAndLocalTuples;", "decl", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "translateBlock", "cfgBlock", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "Lcom/intellij/rml/dfa/impl/translator/IrTranslationContextImpl;", "translateFunction", "translateGlobalVarDecl", "varDecl", "Lcom/intellij/rml/dfa/ir/ast/IrGlobalVarDecl;", "translateRecordDecl", "recordDecl", "Lcom/intellij/rml/dfa/ir/ast/IrRecordDecl;", "GlobalAndLocalTuples", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nIrToRmlTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrToRmlTranslator.kt\ncom/intellij/rml/dfa/impl/translator/IrToRmlTranslator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,465:1\n1855#2,2:466\n*S KotlinDebug\n*F\n+ 1 IrToRmlTranslator.kt\ncom/intellij/rml/dfa/impl/translator/IrToRmlTranslator\n*L\n114#1:466,2\n*E\n"})
public final class IrToRmlTranslator {
    @NotNull
    private final List<IrTranslatorExtension> translators;

    /*
     * WARNING - void declaration
     */
    public IrToRmlTranslator(@NotNull IrSessionTranslationContext sessionContext, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)sessionContext, (String)"sessionContext");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Object object = new IrTranslatorExtension[]{new BaseInstructionTranslator(sessionContext), new InlineTranslatorExtension()};
        Object object2 = object = CollectionsKt.mutableListOf((Object[])object);
        IrToRmlTranslator irToRmlTranslator = this;
        boolean bl = false;
        IrTranslatorExtension irTranslatorExtension = options.get(AnalysisOptions.INSTANCE.getTranslatorExtension());
        if (irTranslatorExtension != null) {
            void list;
            IrTranslatorExtension it = irTranslatorExtension;
            boolean bl2 = false;
            ((Collection)list).add(it);
        }
        irToRmlTranslator.translators = object;
    }

    @NotNull
    public final GlobalAndLocalTuples translate(@NotNull IrTopLevelDecl decl) {
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        IrTopLevelDecl irTopLevelDecl = decl;
        if (irTopLevelDecl instanceof IrFunctionDecl) {
            return this.translateFunction((IrFunctionDecl)decl);
        }
        if (irTopLevelDecl instanceof IrGlobalVarDecl) {
            return this.translateGlobalVarDecl((IrGlobalVarDecl)decl);
        }
        if (irTopLevelDecl instanceof IrRecordDecl) {
            return this.translateRecordDecl((IrRecordDecl)decl);
        }
        throw new NoWhenBranchMatchedException();
    }

    private final GlobalAndLocalTuples translateRecordDecl(IrRecordDecl recordDecl) {
        IrTranslationContextImpl context = new IrTranslationContextImpl(null, 1, null);
        for (IrRecordID superRecord : recordDecl.getSuperRecords()) {
            IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getSubtype(), recordDecl.getName(), superRecord, null, 8, null);
        }
        for (IrFieldDecl field : recordDecl.getFields()) {
            IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getField(), field.getName(), recordDecl.getName(), null, 8, null);
        }
        return new GlobalAndLocalTuples(context.getTuples(), CollectionsKt.emptyList(), context.getLocations(), context.getLocationObjects());
    }

    private final GlobalAndLocalTuples translateGlobalVarDecl(IrGlobalVarDecl varDecl) {
        IrTranslationContextImpl context = new IrTranslationContextImpl(null, 1, null);
        IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getGlobalVar(), varDecl.getName(), null, 4, null);
        return new GlobalAndLocalTuples(context.getTuples(), CollectionsKt.emptyList(), context.getLocations(), context.getLocationObjects());
    }

    private final GlobalAndLocalTuples translateFunction(IrFunctionDecl function2) {
        IrJump jump;
        IrTranslationContextImpl context = new IrTranslationContextImpl(function2);
        IrCfg cfg2 = function2.getBody();
        Iterator<Map.Entry<IrCFGBlock, IrJump>> $this$forEach$iv = cfg2.getBlocks();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            IrCFGBlock it = (IrCFGBlock)element$iv;
            boolean bl = false;
            this.translateBlock(it, context);
        }
        for (IrCFGBlock block : cfg2.getBlocks()) {
            int fromStmt = context.exitStmt(block);
            jump = cfg2.getJumps().get(block);
            if (jump instanceof IrConditionalJump) {
                Object[] bl = new IrCFGBlock[]{((IrConditionalJump)jump).getTrueBranch(), ((IrConditionalJump)jump).getFalseBranch()};
                for (IrCFGBlock branch : SetsKt.setOf((Object[])bl)) {
                    int toStmt = context.startStmt(branch);
                    IrAttributeWrapper isTrueBranch = IrToRmlTranslatorKt.boolAttr(Intrinsics.areEqual((Object)branch, (Object)((IrConditionalJump)jump).getTrueBranch()));
                    IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getConditionalJump(), new IrAttributeWrapper(fromStmt), new IrAttributeWrapper(toStmt), IrTranslationContextImpl.objectID$default(context, ((IrConditionalJump)jump).getCondition(), block, 0, 4, null), isTrueBranch, null, 32, null);
                }
                continue;
            }
            if (jump instanceof IrUnconditionalJump) {
                int toStmt = context.startStmt(((IrUnconditionalJump)jump).getNextBlock());
                IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getUnconditionalJump(), new IrAttributeWrapper(fromStmt), new IrAttributeWrapper(toStmt), null, 8, null);
                continue;
            }
            if (jump != null) continue;
        }
        for (Map.Entry<IrCFGBlock, IrJump> entry : cfg2.getJumps().entrySet()) {
            IrCFGBlock from = entry.getKey();
            jump = entry.getValue();
            if (!(jump instanceof IrConditionalJump)) continue;
            IrCondition condition = ((IrConditionalJump)jump).getCondition();
            IrObjectID objectAttr = IrTranslationContextImpl.objectID$default(context, condition, from, 0, 4, null);
            IrCondition toStmt = condition;
            if (toStmt instanceof IrComparisonCondition) {
                IrExpr left2 = ((IrComparisonCondition)condition).getLeft();
                IrExpr right2 = ((IrComparisonCondition)condition).getRight();
                if (left2 instanceof IrVarRefExpr) {
                    IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getUse(), new IrAttributeWrapper(context.exitStmt(from)), ((IrVarRefExpr)left2).getVariable(), objectAttr, null, 16, null);
                }
                if (right2 instanceof IrVarRefExpr) {
                    IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getUse(), new IrAttributeWrapper(context.exitStmt(from)), ((IrVarRefExpr)right2).getVariable(), objectAttr, null, 16, null);
                }
                if (left2 instanceof IrVarRefExpr && right2 instanceof IrConstantExpr) {
                    IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getComparisonWithConstCondition(), objectAttr, new IrAttributeWrapper(DfaConstants.INSTANCE.getTrueValue()), ((IrVarRefExpr)left2).getVariable(), ((IrConstantExpr)right2).getConst(), ((IrComparisonCondition)condition).getKind(), null, 64, null);
                    IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getComparisonWithConstCondition(), objectAttr, new IrAttributeWrapper(DfaConstants.INSTANCE.getFalseValue()), ((IrVarRefExpr)left2).getVariable(), ((IrConstantExpr)right2).getConst(), ((IrComparisonCondition)condition).getKind().invert(), null, 64, null);
                    continue;
                }
                if (left2 instanceof IrConstantExpr && right2 instanceof IrVarRefExpr) {
                    IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getComparisonWithConstCondition(), objectAttr, new IrAttributeWrapper(DfaConstants.INSTANCE.getTrueValue()), ((IrVarRefExpr)right2).getVariable(), ((IrConstantExpr)left2).getConst(), ((IrComparisonCondition)condition).getKind().flip(), null, 64, null);
                    IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getComparisonWithConstCondition(), objectAttr, new IrAttributeWrapper(DfaConstants.INSTANCE.getFalseValue()), ((IrVarRefExpr)right2).getVariable(), ((IrConstantExpr)left2).getConst(), ((IrComparisonCondition)condition).getKind().flip().invert(), null, 64, null);
                    continue;
                }
                if (left2 instanceof IrVarRefExpr && right2 instanceof IrVarRefExpr) {
                    IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getComparisonWithVarCondition(), objectAttr, new IrAttributeWrapper(DfaConstants.INSTANCE.getTrueValue()), ((IrVarRefExpr)left2).getVariable(), ((IrVarRefExpr)right2).getVariable(), ((IrComparisonCondition)condition).getKind(), null, 64, null);
                    IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getComparisonWithVarCondition(), objectAttr, new IrAttributeWrapper(DfaConstants.INSTANCE.getFalseValue()), ((IrVarRefExpr)left2).getVariable(), ((IrVarRefExpr)right2).getVariable(), ((IrComparisonCondition)condition).getKind().invert(), null, 64, null);
                    continue;
                }
                if (left2 instanceof IrConstantExpr && right2 instanceof IrConstantExpr) {
                    throw new DfaInternalException("Use IrConstantCondition when both operands of IrComparisonCondition are constant");
                }
                IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getUnsupportedCondition(), objectAttr, null, 4, null);
                continue;
            }
            if (toStmt instanceof IrConstantCondition) {
                IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getConstantCondition(), objectAttr, IrToRmlTranslatorKt.boolAttr(((IrConstantCondition)condition).getBranch()), null, 8, null);
                continue;
            }
            if (toStmt instanceof IrUnsupportedCondition) {
                IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getUnsupportedCondition(), objectAttr, null, 4, null);
                continue;
            }
            if (toStmt instanceof IrCustomEvaluationCondition) {
                throw new DfaNotImplementedException(null, 1, null);
            }
            if (!(toStmt instanceof IrInstanceofCondition)) continue;
            throw new DfaNotImplementedException(null, 1, null);
        }
        IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getStartStmt(), function2.getName(), new IrAttributeWrapper(context.startStmt(cfg2.getStartBlock())), null, 8, null);
        IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getExitStmt(), function2.getName(), new IrAttributeWrapper(context.exitStmt(cfg2.getExitBlock())), null, 8, null);
        IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getCurFunction(), function2.getName(), null, 4, null);
        this.addConstants(function2, context);
        IrTranslationContextImpl globalContext = new IrTranslationContextImpl(null, 1, null);
        if (function2.isPrivate()) {
            IrTranslationContext.addTuple$default(globalContext, InputRelationsGlobal.INSTANCE.getPrivateFunction(), function2.getName(), null, 4, null);
        }
        for (IrTranslatorExtension translator : this.translators) {
            translator.translateGlobal(function2, globalContext);
        }
        Iterator<Object> iterator2 = function2.getParameters().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            IrParameterDecl parameter = (IrParameterDecl)iterator2.next();
            IrTranslationContext.addTuple$default(globalContext, InputRelationsGlobal.INSTANCE.getParameter(), function2.getName(), new IrAttributeWrapper(index), parameter.getName(), null, 16, null);
            for (IrVarID alias : function2.getParametersMayBeAliased().get(index)) {
                IrTranslationContext.addTuple$default(globalContext, InputRelationsGlobal.INSTANCE.getAliasedParameters(), function2.getName(), parameter.getName(), alias, null, 16, null);
            }
        }
        function2.accept(new IrRecursiveVisitor(globalContext){
            final /* synthetic */ IrTranslationContextImpl $globalContext;
            {
                this.$globalContext = $globalContext;
            }

            public void visitNewRecordInstanceStmt(@NotNull IrNewRecordInstanceStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                IrValueConstant constant = new IrValueConstant(stmt.getLocation().toString(), null, 2, null);
                IrTranslationContext.addTuple$default(this.$globalContext, InputRelationsGlobal.INSTANCE.getRecordInstance(), constant, stmt.getRecord(), null, 8, null);
            }
        });
        return new GlobalAndLocalTuples(globalContext.getTuples(), context.getTuples(), context.getLocations(), context.getLocationObjects());
    }

    private final void addConstants(IrFunctionDecl function2, IrTranslationContext ctx) {
        IrConstantsCollector collector = new IrConstantsCollector();
        Set intConstants = CollectionsKt.toSet((Iterable)collector.collectConstants(function2));
        Iterator iterator = intConstants.iterator();
        while (iterator.hasNext()) {
            int intConstant = ((Number)iterator.next()).intValue();
            IrTranslationContext.addTuple$default(ctx, InputRelations.INSTANCE.getIntegerConstant(), new IrIntConstant(intConstant), null, 4, null);
        }
    }

    private final void translateBlock(IrCFGBlock cfgBlock, IrTranslationContextImpl ctx) {
        ctx.nextStatement(false);
        ctx.startBlock(cfgBlock);
        Iterator<IrStatement> iterator = cfgBlock.getInstructions().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            IrStatement inst = iterator.next();
            if (i > 0) {
                IrTranslationContext.nextStatement$default(ctx, false, 1, null);
            }
            for (IrTranslatorExtension translator : this.translators) {
                translator.translate(inst, ctx);
            }
        }
        ctx.endBlock(cfgBlock);
    }

    @NotNull
    public final List<DfaTuple> getPredefinedTuples(@NotNull DfaAnalysisKind analysisKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)analysisKind), (String)"analysisKind");
        IrTranslationContextImpl context = new IrTranslationContextImpl(null, 1, null);
        for (Attribute attribute : DfaConstants.INSTANCE.getAllConstants()) {
            IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getPredefinedConstant(), new IrValueConstant(attribute), null, 4, null);
        }
        if (analysisKind == DfaAnalysisKind.Interprocedural) {
            for (int i = 0; i < 100; ++i) {
                IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getPlaceholderValue(), new IrAttributeWrapper(i), new IrValueConstant(DfaConstants.INSTANCE.placeholder(i)), null, 8, null);
            }
            IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getAliasingContext(), new IrAttributeWrapper(DfaConstants.INSTANCE.getAliasingContext()), null, 4, null);
            IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getEmptyMethod(), new IrFunctionID(DfaConstants.INSTANCE.getCurFunction()), null, 4, null);
        }
        ComparisonTranslationHelperKt.processComparisonBasicRelations((Function2<? super RmlRelation1<P>, ? super IrEqualityKind, Unit>)((Function2)new Function2<RmlRelation1<P>, IrEqualityKind, Unit>(context){
            final /* synthetic */ IrTranslationContextImpl $context;
            {
                this.$context = $context;
                super(2);
            }

            public final void invoke(@NotNull RmlRelation1<P> relation, @NotNull IrEqualityKind attr) {
                Intrinsics.checkNotNullParameter(relation, (String)"relation");
                Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
                IrTranslationContext.addTuple$default(this.$context, relation, attr, null, 4, null);
            }
        }), (Function3<? super RmlRelation2<P, P>, ? super IrEqualityKind, ? super IrEqualityKind, Unit>)((Function3)new Function3<RmlRelation2<P, P>, IrEqualityKind, IrEqualityKind, Unit>(context){
            final /* synthetic */ IrTranslationContextImpl $context;
            {
                this.$context = $context;
                super(3);
            }

            public final void invoke(@NotNull RmlRelation2<P, P> relation, @NotNull IrEqualityKind attr1, @NotNull IrEqualityKind attr2) {
                Intrinsics.checkNotNullParameter(relation, (String)"relation");
                Intrinsics.checkNotNullParameter((Object)attr1, (String)"attr1");
                Intrinsics.checkNotNullParameter((Object)attr2, (String)"attr2");
                IrTranslationContext.addTuple$default(this.$context, relation, attr1, attr2, null, 8, null);
            }
        }));
        for (IrTranslatorExtension translator : this.translators) {
            translator.translatePredefined(context);
        }
        return context.getTuples();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u00c6\u0003JO\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/intellij/rml/dfa/impl/translator/IrToRmlTranslator$GlobalAndLocalTuples;", "", "globalTuples", "", "Lcom/intellij/rml/dfa/attributes/DfaTuple;", "localTuples", "statementLocations", "", "Lcom/intellij/rml/dfa/ir/IrLocation;", "locationObjects", "Lcom/intellij/rml/dfa/ir/ast/IrLocationID;", "(Ljava/util/List;Ljava/util/List;Ljava/util/Map;Ljava/util/List;)V", "getGlobalTuples", "()Ljava/util/List;", "getLocalTuples", "getLocationObjects", "getStatementLocations", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rml.dfa.impl"})
    public static final class GlobalAndLocalTuples {
        @NotNull
        private final List<DfaTuple> globalTuples;
        @NotNull
        private final List<DfaTuple> localTuples;
        @NotNull
        private final Map<DfaTuple, IrLocation> statementLocations;
        @NotNull
        private final List<IrLocationID> locationObjects;

        public GlobalAndLocalTuples(@NotNull List<DfaTuple> globalTuples, @NotNull List<DfaTuple> localTuples, @NotNull Map<DfaTuple, IrLocation> statementLocations, @NotNull List<IrLocationID> locationObjects) {
            Intrinsics.checkNotNullParameter(globalTuples, (String)"globalTuples");
            Intrinsics.checkNotNullParameter(localTuples, (String)"localTuples");
            Intrinsics.checkNotNullParameter(statementLocations, (String)"statementLocations");
            Intrinsics.checkNotNullParameter(locationObjects, (String)"locationObjects");
            this.globalTuples = globalTuples;
            this.localTuples = localTuples;
            this.statementLocations = statementLocations;
            this.locationObjects = locationObjects;
        }

        @NotNull
        public final List<DfaTuple> getGlobalTuples() {
            return this.globalTuples;
        }

        @NotNull
        public final List<DfaTuple> getLocalTuples() {
            return this.localTuples;
        }

        @NotNull
        public final Map<DfaTuple, IrLocation> getStatementLocations() {
            return this.statementLocations;
        }

        @NotNull
        public final List<IrLocationID> getLocationObjects() {
            return this.locationObjects;
        }

        @NotNull
        public final List<DfaTuple> component1() {
            return this.globalTuples;
        }

        @NotNull
        public final List<DfaTuple> component2() {
            return this.localTuples;
        }

        @NotNull
        public final Map<DfaTuple, IrLocation> component3() {
            return this.statementLocations;
        }

        @NotNull
        public final List<IrLocationID> component4() {
            return this.locationObjects;
        }

        @NotNull
        public final GlobalAndLocalTuples copy(@NotNull List<DfaTuple> globalTuples, @NotNull List<DfaTuple> localTuples, @NotNull Map<DfaTuple, IrLocation> statementLocations, @NotNull List<IrLocationID> locationObjects) {
            Intrinsics.checkNotNullParameter(globalTuples, (String)"globalTuples");
            Intrinsics.checkNotNullParameter(localTuples, (String)"localTuples");
            Intrinsics.checkNotNullParameter(statementLocations, (String)"statementLocations");
            Intrinsics.checkNotNullParameter(locationObjects, (String)"locationObjects");
            return new GlobalAndLocalTuples(globalTuples, localTuples, statementLocations, locationObjects);
        }

        public static /* synthetic */ GlobalAndLocalTuples copy$default(GlobalAndLocalTuples globalAndLocalTuples, List list, List list2, Map map2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list = globalAndLocalTuples.globalTuples;
            }
            if ((n & 2) != 0) {
                list2 = globalAndLocalTuples.localTuples;
            }
            if ((n & 4) != 0) {
                map2 = globalAndLocalTuples.statementLocations;
            }
            if ((n & 8) != 0) {
                list3 = globalAndLocalTuples.locationObjects;
            }
            return globalAndLocalTuples.copy(list, list2, map2, list3);
        }

        @NotNull
        public String toString() {
            return "GlobalAndLocalTuples(globalTuples=" + this.globalTuples + ", localTuples=" + this.localTuples + ", statementLocations=" + this.statementLocations + ", locationObjects=" + this.locationObjects + ")";
        }

        public int hashCode() {
            int result = ((Object)this.globalTuples).hashCode();
            result = result * 31 + ((Object)this.localTuples).hashCode();
            result = result * 31 + ((Object)this.statementLocations).hashCode();
            result = result * 31 + ((Object)this.locationObjects).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GlobalAndLocalTuples)) {
                return false;
            }
            GlobalAndLocalTuples globalAndLocalTuples = (GlobalAndLocalTuples)other;
            if (!Intrinsics.areEqual(this.globalTuples, globalAndLocalTuples.globalTuples)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.localTuples, globalAndLocalTuples.localTuples)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.statementLocations, globalAndLocalTuples.statementLocations)) {
                return false;
            }
            return Intrinsics.areEqual(this.locationObjects, globalAndLocalTuples.locationObjects);
        }
    }
}

