/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.translator;

import com.intellij.rml.dfa.AnalysisOptions;
import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.Quadruple;
import com.intellij.rml.dfa.analyzes.MayPointsToAnalysisKt;
import com.intellij.rml.dfa.analyzes.ParametersSubstitutorAnalysisKt;
import com.intellij.rml.dfa.impl.DfaAnalysisIrResultImpl;
import com.intellij.rml.dfa.ir.DfaInvalidIrException;
import com.intellij.rml.dfa.ir.IrEnvironment;
import com.intellij.rml.dfa.ir.ast.IrDeclaration;
import com.intellij.rml.dfa.ir.ast.IrFieldDecl;
import com.intellij.rml.dfa.ir.ast.IrFieldID;
import com.intellij.rml.dfa.ir.ast.IrIdentifier;
import com.intellij.rml.dfa.ir.ast.IrLocationID;
import com.intellij.rml.dfa.ir.ast.IrObjectID;
import com.intellij.rml.dfa.ir.ast.IrRecursiveVisitor;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.ast.IrVarID;
import com.intellij.rml.dfa.utils.RMLOptions;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"checkEnvironment", "", "decls", "", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "environment", "Lcom/intellij/rml/dfa/ir/IrEnvironment;", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "checkNotInitialized", "result", "Lcom/intellij/rml/dfa/impl/DfaAnalysisIrResultImpl;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nIrConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConsistencyChecker.kt\ncom/intellij/rml/dfa/impl/translator/IrConsistencyCheckerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class IrConsistencyCheckerKt {
    public static final void checkEnvironment(@NotNull List<? extends IrTopLevelDecl> decls, @NotNull IrEnvironment environment, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter(decls, (String)"decls");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (options.get(AnalysisOptions.INSTANCE.getCheckEnvironment()).booleanValue()) {
            Set fields = new LinkedHashSet();
            for (IrTopLevelDecl irTopLevelDecl : decls) {
                irTopLevelDecl.accept(new IrRecursiveVisitor(fields){
                    final /* synthetic */ Set<IrFieldID> $fields;
                    {
                        this.$fields = $fields;
                    }

                    public void visitFieldDecl(@NotNull IrFieldDecl field) {
                        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                        ((Collection)this.$fields).add(field.getName());
                    }
                });
            }
            for (IrTopLevelDecl irTopLevelDecl : decls) {
                irTopLevelDecl.accept(new IrRecursiveVisitor(fields, environment, irTopLevelDecl){
                    final /* synthetic */ Set<IrFieldID> $fields;
                    final /* synthetic */ IrEnvironment $environment;
                    final /* synthetic */ IrTopLevelDecl $decl;
                    {
                        this.$fields = $fields;
                        this.$environment = $environment;
                        this.$decl = $decl;
                    }

                    public void visitIdentifier(@NotNull IrIdentifier identifier) {
                        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                        if (!CollectionsKt.contains((Iterable)this.$fields, (Object)identifier) && this.$environment.resolve(identifier, this.$decl.getName()) == null) {
                            throw new DfaInternalException("Undefined identifier " + identifier);
                        }
                    }

                    public void visitDeclaration(@NotNull IrDeclaration declarator) {
                        Intrinsics.checkNotNullParameter((Object)declarator, (String)"declarator");
                        if (!Intrinsics.areEqual((Object)this.$environment.resolve(declarator.getName(), this.$decl.getName()), (Object)declarator)) {
                            throw new DfaInvalidIrException("Duplicate declaration " + declarator.getName(), declarator.getLocation());
                        }
                    }
                });
            }
        }
    }

    public static final void checkNotInitialized(@NotNull DfaAnalysisIrResultImpl result, @NotNull RMLOptions options) {
        Quadruple quadruple;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (options.get(AnalysisOptions.INSTANCE.getCheckNotInitializedFields()).booleanValue() && (quadruple = (Quadruple)CollectionsKt.firstOrNull(result.getRelation(ParametersSubstitutorAnalysisKt.getNotInitializedFieldUsage()))) != null) {
            Quadruple quadruple2 = quadruple;
            boolean bl = false;
            IrObjectID loc = (IrObjectID)quadruple2.component2();
            IrFieldID field = (IrFieldID)quadruple2.component3();
            String string = "Field \"" + field + "\" is not initialized";
            Intrinsics.checkNotNull((Object)loc, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.ir.ast.IrLocationID");
            throw new DfaInvalidIrException(string, ((IrLocationID)loc).getLocation());
        }
        if (options.get(AnalysisOptions.INSTANCE.getCheckNotInitializedVars()).booleanValue() && (quadruple = (Triple)CollectionsKt.firstOrNull(result.getRelation(MayPointsToAnalysisKt.getNotInitializedVarUsage()))) != null) {
            Quadruple quadruple3 = quadruple;
            boolean bl = false;
            IrObjectID loc = (IrObjectID)quadruple3.component2();
            IrVarID variable = (IrVarID)quadruple3.component3();
            String string = "Variable \"" + variable + "\" is not initialized";
            Intrinsics.checkNotNull((Object)loc, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.ir.ast.IrLocationID");
            throw new DfaInvalidIrException(string, ((IrLocationID)loc).getLocation());
        }
    }
}

