/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.translator;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.transform.IrTransformStage;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.utils.RMLOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/rml/dfa/impl/translator/CfgConsistencyCheckStage;", "Lcom/intellij/rml/dfa/impl/transform/IrTransformStage;", "()V", "name", "", "getName", "()Ljava/lang/String;", "transform", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "decl", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "intellij.rml.dfa.impl"})
public final class CfgConsistencyCheckStage
implements IrTransformStage {
    @NotNull
    private final String name;

    public CfgConsistencyCheckStage() {
        this.name = "CFG consistency check";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public IrTopLevelDecl transform(@NotNull IrTopLevelDecl decl, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(decl instanceof IrFunctionDecl)) {
            return decl;
        }
        IrCfg cfg2 = ((IrFunctionDecl)decl).getBody();
        for (IrCFGBlock block : cfg2.getBlocks()) {
            if (Intrinsics.areEqual((Object)block, (Object)cfg2.getExitBlock()) || cfg2.getJumps().get(block) != null) continue;
            throw new DfaInternalException("All control flow graph nodes except exit node must have jumps");
        }
        return decl;
    }
}

