/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.translator;

import com.intellij.rml.dfa.DfaNotImplementedException;
import com.intellij.rml.dfa.analyzes.input.InputRelations;
import com.intellij.rml.dfa.analyzes.input.O;
import com.intellij.rml.dfa.analyzes.input.S;
import com.intellij.rml.dfa.analyzes.input.V;
import com.intellij.rml.dfa.impl.translator.IrSessionTranslationContext;
import com.intellij.rml.dfa.ir.IrLocationOwner;
import com.intellij.rml.dfa.ir.ast.IrAssignmentStmt;
import com.intellij.rml.dfa.ir.ast.IrAttributeHolder;
import com.intellij.rml.dfa.ir.ast.IrAttributeWrapper;
import com.intellij.rml.dfa.ir.ast.IrConstantExpr;
import com.intellij.rml.dfa.ir.ast.IrCustomEvaluationStmt;
import com.intellij.rml.dfa.ir.ast.IrExpr;
import com.intellij.rml.dfa.ir.ast.IrFunctionID;
import com.intellij.rml.dfa.ir.ast.IrGetReferenceStmt;
import com.intellij.rml.dfa.ir.ast.IrLoadRefStmt;
import com.intellij.rml.dfa.ir.ast.IrLoadStmt;
import com.intellij.rml.dfa.ir.ast.IrLocalVarDeclarationStmt;
import com.intellij.rml.dfa.ir.ast.IrMapGetStmt;
import com.intellij.rml.dfa.ir.ast.IrMapSetStmt;
import com.intellij.rml.dfa.ir.ast.IrNewArrayStmt;
import com.intellij.rml.dfa.ir.ast.IrNewRecordInstanceStmt;
import com.intellij.rml.dfa.ir.ast.IrObjectID;
import com.intellij.rml.dfa.ir.ast.IrRecordCopyStmt;
import com.intellij.rml.dfa.ir.ast.IrRequirementStmt;
import com.intellij.rml.dfa.ir.ast.IrReturnStmt;
import com.intellij.rml.dfa.ir.ast.IrStatement;
import com.intellij.rml.dfa.ir.ast.IrStatementsVisitor;
import com.intellij.rml.dfa.ir.ast.IrStaticCallStmt;
import com.intellij.rml.dfa.ir.ast.IrStoreRefStmt;
import com.intellij.rml.dfa.ir.ast.IrStoreStmt;
import com.intellij.rml.dfa.ir.ast.IrUncontrolledVarStmt;
import com.intellij.rml.dfa.ir.ast.IrUnknownCallStmt;
import com.intellij.rml.dfa.ir.ast.IrUnknownExpr;
import com.intellij.rml.dfa.ir.ast.IrValueConstant;
import com.intellij.rml.dfa.ir.ast.IrVarDereferenceStmt;
import com.intellij.rml.dfa.ir.ast.IrVarID;
import com.intellij.rml.dfa.ir.ast.IrVarInvalidationStmt;
import com.intellij.rml.dfa.ir.ast.IrVarMayBeNilAssumptionStmt;
import com.intellij.rml.dfa.ir.ast.IrVarRefExpr;
import com.intellij.rml.dfa.ir.ast.IrVirtualCallStmt;
import com.intellij.rml.dfa.rml.DfaConstants;
import com.intellij.rml.dfa.rml.dsl.lang.RmlRelation3;
import com.intellij.rml.dfa.translator.IrTranslationContext;
import com.intellij.rml.dfa.translator.IrTranslatorExtension;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/rml/dfa/impl/translator/BaseInstructionTranslator;", "Lcom/intellij/rml/dfa/translator/IrTranslatorExtension;", "sessionContext", "Lcom/intellij/rml/dfa/impl/translator/IrSessionTranslationContext;", "(Lcom/intellij/rml/dfa/impl/translator/IrSessionTranslationContext;)V", "getSessionContext", "()Lcom/intellij/rml/dfa/impl/translator/IrSessionTranslationContext;", "translate", "", "instruction", "Lcom/intellij/rml/dfa/ir/ast/IrStatement;", "context", "Lcom/intellij/rml/dfa/translator/IrTranslationContext;", "intellij.rml.dfa.impl"})
final class BaseInstructionTranslator
implements IrTranslatorExtension {
    @NotNull
    private final IrSessionTranslationContext sessionContext;

    public BaseInstructionTranslator(@NotNull IrSessionTranslationContext sessionContext) {
        Intrinsics.checkNotNullParameter((Object)sessionContext, (String)"sessionContext");
        this.sessionContext = sessionContext;
    }

    @NotNull
    public final IrSessionTranslationContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public void translate(@NotNull IrStatement instruction, @NotNull IrTranslationContext context) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        instruction.accept(new IrStatementsVisitor(context, this){
            final /* synthetic */ IrTranslationContext $context;
            final /* synthetic */ BaseInstructionTranslator this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
            }

            public void visitStatement(@NotNull IrStatement stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
            }

            public void visitLocalVarDeclarationStmt(@NotNull IrLocalVarDeclarationStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                if (stmt.isTempVar()) {
                    IrTranslationContext.addTuple$default(this.$context, InputRelations.INSTANCE.getTempVariable(), stmt.getName(), null, 4, null);
                } else {
                    this.$context.addStatement(InputRelations.INSTANCE.getDeclarator(), (IrAttributeHolder)stmt.getName(), stmt.getLocation());
                }
                this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromConstant(), (IrAttributeHolder)stmt.getName(), (IrAttributeHolder)new IrValueConstant(DfaConstants.INSTANCE.getNotInitializedConst()), stmt.getLocation());
            }

            public void visitAssignmentStmt(@NotNull IrAssignmentStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                IrVarID resultAttr = stmt.getResult();
                IrExpr expr = stmt.getValue();
                if (expr instanceof IrVarRefExpr) {
                    this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromVar(), (IrAttributeHolder)resultAttr, (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), stmt.getLocation());
                    this.$context.addStatement(InputRelations.INSTANCE.getUse(), (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), (IrAttributeHolder)this.$context.objectID((IrLocationOwner)((Object)expr)), stmt.getLocation());
                } else if (expr instanceof IrConstantExpr) {
                    this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromConstant(), (IrAttributeHolder)resultAttr, (IrAttributeHolder)((IrConstantExpr)expr).getConst(), stmt.getLocation());
                } else if (Intrinsics.areEqual((Object)expr, (Object)IrUnknownExpr.INSTANCE)) {
                    this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromExpression(), (IrAttributeHolder)resultAttr, stmt.getLocation());
                }
            }

            public void visitLoadStmt(@NotNull IrLoadStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                this.$context.addStatement(InputRelations.INSTANCE.getLoad(), (IrAttributeHolder)stmt.getResult(), (IrAttributeHolder)stmt.getReceiver(), (IrAttributeHolder)stmt.getField(), stmt.getLocation());
                this.$context.addStatement(InputRelations.INSTANCE.getFieldRead(), (IrAttributeHolder)stmt.getReceiver(), (IrAttributeHolder)stmt.getField(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                this.$context.addStatement(InputRelations.INSTANCE.getUse(), (IrAttributeHolder)stmt.getReceiver(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
            }

            public void visitStoreStmt(@NotNull IrStoreStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                IrVarID receiverAttr = stmt.getReceiver();
                IrExpr expr = stmt.getValue();
                if (expr instanceof IrVarRefExpr) {
                    this.$context.addStatement(InputRelations.INSTANCE.getStoreVar(), (IrAttributeHolder)receiverAttr, (IrAttributeHolder)stmt.getField(), (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), stmt.getLocation());
                    this.$context.addStatement(InputRelations.INSTANCE.getUse(), (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), (IrAttributeHolder)this.$context.objectID((IrLocationOwner)((Object)expr)), stmt.getLocation());
                } else if (expr instanceof IrConstantExpr) {
                    this.$context.addStatement(InputRelations.INSTANCE.getStoreConst(), (IrAttributeHolder)receiverAttr, (IrAttributeHolder)stmt.getField(), (IrAttributeHolder)((IrConstantExpr)expr).getConst(), stmt.getLocation());
                } else if (Intrinsics.areEqual((Object)expr, (Object)IrUnknownExpr.INSTANCE)) {
                    this.$context.addStatement(InputRelations.INSTANCE.getStoreExpr(), (IrAttributeHolder)receiverAttr, (IrAttributeHolder)stmt.getField(), stmt.getLocation());
                }
                this.$context.addStatement(InputRelations.INSTANCE.getUse(), (IrAttributeHolder)stmt.getReceiver(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
            }

            public void visitRecordCopyStmt(@NotNull IrRecordCopyStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                this.$context.addStatement(InputRelations.INSTANCE.getCopy(), (IrAttributeHolder)stmt.getDest(), (IrAttributeHolder)stmt.getSource(), (IrAttributeHolder)stmt.getRecord(), stmt.getLocation());
                this.$context.addStatement(InputRelations.INSTANCE.getUse(), (IrAttributeHolder)stmt.getSource(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                this.$context.addStatement(InputRelations.INSTANCE.getUse(), (IrAttributeHolder)stmt.getDest(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
            }

            public void visitMapGetStmt(@NotNull IrMapGetStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                throw new DfaNotImplementedException(null, 1, null);
            }

            public void visitMapSetStmt(@NotNull IrMapSetStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                throw new DfaNotImplementedException(null, 1, null);
            }

            public void visitRequirementStmt(@NotNull IrRequirementStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                this.$context.addStatement(InputRelations.INSTANCE.getAssert(), (IrAttributeHolder)this.$context.objectID(stmt.getCondition()), stmt.getLocation());
            }

            public void visitNewRecordInstanceStmt(@NotNull IrNewRecordInstanceStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                IrVarID result = stmt.getResult();
                IrValueConstant constant = new IrValueConstant(stmt.getLocation().toString(), null, 2, null);
                this.$context.addStatement(InputRelations.INSTANCE.getNewRecordInstanceCreation(), (IrAttributeHolder)constant, (IrAttributeHolder)stmt.getRecord(), stmt.getLocation());
                if (result != null) {
                    this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromConstant(), (IrAttributeHolder)result, (IrAttributeHolder)constant, stmt.getLocation());
                }
            }

            public void visitNewArrayStmt(@NotNull IrNewArrayStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                IrVarID result = stmt.getResult();
                IrValueConstant constant = new IrValueConstant(stmt.getLocation().toString(), null, 2, null);
                IrExpr expr = stmt.getLength();
                if (expr instanceof IrVarRefExpr) {
                    this.$context.addStatement(InputRelations.INSTANCE.getNewArrayVarLengthExpr(), (IrAttributeHolder)constant, (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), stmt.getLocation());
                    this.$context.addStatement(InputRelations.INSTANCE.getUse(), (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), (IrAttributeHolder)this.$context.objectID((IrLocationOwner)((Object)expr)), stmt.getLocation());
                } else if (expr instanceof IrConstantExpr) {
                    this.$context.addStatement(InputRelations.INSTANCE.getNewArrayConstLengthExpr(), (IrAttributeHolder)constant, (IrAttributeHolder)((IrConstantExpr)expr).getConst(), stmt.getLocation());
                } else if (Intrinsics.areEqual((Object)expr, (Object)IrUnknownExpr.INSTANCE)) {
                    // empty if block
                }
                if (result != null) {
                    this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromConstant(), (IrAttributeHolder)result, (IrAttributeHolder)constant, stmt.getLocation());
                }
            }

            public void visitLoadRefStmt(@NotNull IrLoadRefStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                throw new DfaNotImplementedException(null, 1, null);
            }

            public void visitStoreRefStmt(@NotNull IrStoreRefStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                throw new DfaNotImplementedException(null, 1, null);
            }

            public void visitGetReferenceStmt(@NotNull IrGetReferenceStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                throw new DfaNotImplementedException(null, 1, null);
            }

            public void visitStaticCallStmt(@NotNull IrStaticCallStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                IrVarID result = stmt.getResult();
                this.$context.addStatement(InputRelations.INSTANCE.getCallExpression(), (IrAttributeHolder)stmt.getCallee(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                this.processCallArguments(stmt.getArguments(), stmt);
                if (result != null) {
                    this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromCall(), (IrAttributeHolder)result, (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                }
            }

            public void visitVirtualCallStmt(@NotNull IrVirtualCallStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                IrVarID result = stmt.getResult();
                for (IrFunctionID callee : this.this$0.getSessionContext().findTargetsOfVirtualCall(stmt)) {
                    this.$context.addStatement(InputRelations.INSTANCE.getCallExpression(), (IrAttributeHolder)callee, (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                }
                this.processCallArguments(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)stmt.getReceiver()), (Iterable)stmt.getArguments()), stmt);
                if (result != null) {
                    this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromCall(), (IrAttributeHolder)result, (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                }
            }

            public void visitUnknownCallStmt(@NotNull IrUnknownCallStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                IrVarID result = stmt.getResult();
                if (stmt.isLibraryCall()) {
                    this.$context.addStatement(InputRelations.INSTANCE.getExternalCall(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                } else {
                    this.$context.addStatement(InputRelations.INSTANCE.getUnknownCall(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                }
                this.processCallArguments(stmt.getArguments(), stmt);
                if (result != null) {
                    this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromCall(), (IrAttributeHolder)result, (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                }
            }

            private final void processCallArguments(List<? extends IrExpr> arguments, IrStatement stmt) {
                Iterator<? extends IrExpr> iterator = arguments.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int index = n++;
                    IrExpr argument = iterator.next();
                    IrAttributeWrapper indexAttr = new IrAttributeWrapper(index);
                    IrObjectID callAttr = this.$context.objectID(stmt);
                    IrExpr irExpr = argument;
                    if (irExpr instanceof IrVarRefExpr) {
                        this.$context.addTuple(InputRelations.INSTANCE.getCallVarArgument(), (IrAttributeHolder)callAttr, (IrAttributeHolder)indexAttr, (IrAttributeHolder)((IrVarRefExpr)argument).getVariable(), ((IrVarRefExpr)argument).getLocation());
                        this.$context.addStatement(InputRelations.INSTANCE.getUse(), (IrAttributeHolder)((IrVarRefExpr)argument).getVariable(), (IrAttributeHolder)this.$context.objectID((IrLocationOwner)((Object)argument)), stmt.getLocation());
                        continue;
                    }
                    if (irExpr instanceof IrConstantExpr) {
                        IrTranslationContext.addTuple$default(this.$context, InputRelations.INSTANCE.getCallConstArgument(), callAttr, indexAttr, ((IrConstantExpr)argument).getConst(), null, 16, null);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)irExpr, (Object)IrUnknownExpr.INSTANCE)) continue;
                    IrTranslationContext.addTuple$default(this.$context, InputRelations.INSTANCE.getCallExprArgument(), callAttr, indexAttr, null, 8, null);
                }
            }

            public void visitReturnStmt(@NotNull IrReturnStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                IrExpr expr = stmt.getValue();
                if (expr instanceof IrVarRefExpr) {
                    this.$context.addStatement(InputRelations.INSTANCE.getReturnVarStmt(), (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                    this.$context.addStatement(InputRelations.INSTANCE.getUse(), (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), (IrAttributeHolder)this.$context.objectID((IrLocationOwner)((Object)expr)), stmt.getLocation());
                } else if (expr instanceof IrConstantExpr) {
                    this.$context.addStatement(InputRelations.INSTANCE.getReturnConstStmt(), (IrAttributeHolder)((IrConstantExpr)expr).getConst(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                } else if (Intrinsics.areEqual((Object)expr, (Object)IrUnknownExpr.INSTANCE)) {
                    this.$context.addStatement(InputRelations.INSTANCE.getReturnExpressionStmt(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                }
            }

            public void visitUncontrolledVarStmt(@NotNull IrUncontrolledVarStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                this.$context.addStatement(InputRelations.INSTANCE.getUncontrolledVarStmt(), (IrAttributeHolder)stmt.getVariable(), stmt.getLocation());
            }

            public void visitVarInvalidationStmt(@NotNull IrVarInvalidationStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                this.$context.addStatement(InputRelations.INSTANCE.getVarInvalidationStmt(), (IrAttributeHolder)stmt.getVariable(), stmt.getLocation());
            }

            public void visitVarDereferenceStmt(@NotNull IrVarDereferenceStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                RmlRelation3<S, V, O> rel = stmt.getRequireNotNullAfterDereference() ? InputRelations.INSTANCE.getVarDereference() : InputRelations.INSTANCE.getSoftVarDereference();
                this.$context.addStatement(rel, (IrAttributeHolder)stmt.getVariable(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                this.$context.addStatement(InputRelations.INSTANCE.getUse(), (IrAttributeHolder)stmt.getVariable(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
            }

            public void visitCustomEvaluationStmt(@NotNull IrCustomEvaluationStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                throw new DfaNotImplementedException(null, 1, null);
            }

            public void visitVarMayBeNilAssumptionInstruction(@NotNull IrVarMayBeNilAssumptionStmt stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                this.$context.addStatement(InputRelations.INSTANCE.getNullableVar(), (IrAttributeHolder)stmt.getVariable(), stmt.getLocation());
            }
        });
    }
}

