/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.transform;

import com.intellij.rml.dfa.impl.transform.IrTransformStage;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.ir.cfg.IrUnconditionalJump;
import com.intellij.rml.dfa.utils.RMLOptions;
import com.intellij.rml.dfa.utils.graph.CFGAlgorithms;
import com.intellij.rml.dfa.utils.graph.GraphAlgorithmsFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/rml/dfa/impl/transform/EmptyBlockAfterConditionStage;", "Lcom/intellij/rml/dfa/impl/transform/IrTransformStage;", "()V", "name", "", "getName", "()Ljava/lang/String;", "transform", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "decl", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "intellij.rml.dfa.impl"})
public final class EmptyBlockAfterConditionStage
implements IrTransformStage {
    @NotNull
    private final String name;

    public EmptyBlockAfterConditionStage() {
        this.name = "Empty block after condition";
    }

    @Override
    @NotNull
    public IrTopLevelDecl transform(@NotNull IrTopLevelDecl decl, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(decl instanceof IrFunctionDecl)) {
            return decl;
        }
        IrCfg cfg2 = ((IrFunctionDecl)decl).getBody();
        Set newBlocks = CollectionsKt.toMutableSet((Iterable)cfg2.getBlocks());
        Map newJumps = MapsKt.toMutableMap(cfg2.getJumps());
        CFGAlgorithms<IrCFGBlock> algorithms = GraphAlgorithmsFactory.Companion.getInstance().createAlgorithms(cfg2.toControlFlowGraph());
        for (Map.Entry<IrCFGBlock, IrJump> entry : cfg2.getJumps().entrySet()) {
            IrCFGBlock source = entry.getKey();
            IrJump jump = entry.getValue();
            if (!(jump instanceof IrConditionalJump)) continue;
            for (IrCFGBlock target : jump.getTargets()) {
                if (!Intrinsics.areEqual((Object)algorithms.getPostDominators().get(source), (Object)target)) continue;
                IrCFGBlock newBlock = IrCFGBlock.Companion.create();
                newJumps.remove(source);
                Map map2 = newJumps;
                Pair pair = TuplesKt.to((Object)source, (Object)new IrConditionalJump(((IrConditionalJump)jump).getCondition(), Intrinsics.areEqual((Object)((IrConditionalJump)jump).getTrueBranch(), (Object)target) ? newBlock : ((IrConditionalJump)jump).getTrueBranch(), Intrinsics.areEqual((Object)((IrConditionalJump)jump).getFalseBranch(), (Object)target) ? newBlock : ((IrConditionalJump)jump).getFalseBranch()));
                map2.put(pair.getFirst(), pair.getSecond());
                map2 = newJumps;
                pair = TuplesKt.to((Object)newBlock, (Object)new IrUnconditionalJump(target));
                map2.put(pair.getFirst(), pair.getSecond());
                ((Collection)newBlocks).add(newBlock);
            }
        }
        return ((IrFunctionDecl)decl).modifyCfg(new IrCfg(newBlocks, newJumps, cfg2.getStartBlock(), cfg2.getExitBlock()));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }
}

