/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.symtable;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.IntAttribute;
import com.intellij.rml.dfa.impl.WrongAttributeException;
import com.intellij.rml.dfa.impl.domains.AttributesInfo;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.symtable.AttributesComparator;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutableSymbolTable
implements SymbolTable {
    private final String name;
    protected final DomainTypeManager typeManager;
    protected final int availableTypesCnt;
    private final Set<Attribute>[] attributesSet;
    private final List<Attribute>[] attributes;
    private final Map<String, Integer>[] backwardMap;
    private final Map<DomainType, AttributesInfo> domainTypeInfos;
    @Nullable
    private SymbolTable delegateTable;

    public MutableSymbolTable(DomainTypeManager typeManager, String name) {
        this.typeManager = typeManager;
        this.name = name;
        this.availableTypesCnt = typeManager.getDomainTypesCount();
        this.attributesSet = new Set[this.availableTypesCnt];
        this.attributes = new List[this.availableTypesCnt];
        this.backwardMap = new Map[this.availableTypesCnt];
        this.domainTypeInfos = new HashMap<DomainType, AttributesInfo>();
        for (int i = 0; i < this.availableTypesCnt; ++i) {
            this.attributesSet[i] = new HashSet<Attribute>();
            DomainType domainType = typeManager.getDomainType(i);
            if (!domainType.isIntegerType()) continue;
            this.domainTypeInfos.put(domainType, AttributesInfo.Companion.create(domainType));
        }
    }

    public List<Attribute> getAttributes(int domainTypeIndex) {
        return this.attributes[domainTypeIndex];
    }

    public void addAttributesFrom(List<SymbolTable> tables, boolean isDelegate) {
        if (isDelegate) {
            this.delegateTable = tables.get(0);
        }
        for (int i = 0; i < this.availableTypesCnt; ++i) {
            DomainType domainType = this.typeManager.getDomainType(i);
            for (SymbolTable table : tables) {
                if (this.delegateTable != null && domainType.isGlobal()) {
                    for (Attribute attribute : this.attributesSet[i]) {
                        if (this.delegateTable.containsAttribute(i, attribute)) continue;
                        throw new DfaInternalException("Delegate table does not contain attribute \"" + attribute + "\"");
                    }
                    MutableSymbolTable delegate = (MutableSymbolTable)this.delegateTable;
                    this.attributesSet[i] = delegate.attributesSet[i];
                    this.attributes[i] = delegate.attributes[i];
                    this.backwardMap[i] = delegate.backwardMap[i];
                    this.domainTypeInfos.put(domainType, AttributesInfo.Companion.create(delegate.domainTypeInfos.get(domainType)));
                    continue;
                }
                if (domainType.isIntegerType()) {
                    AttributesInfo sourceAttributesInfo = table.getAttributesInfo(domainType);
                    AttributesInfo destAttributesInfo = this.getAttributesInfo(domainType);
                    int newAttrsCnt = sourceAttributesInfo.getNumOfAttributes() - destAttributesInfo.getNumOfAttributes();
                    if (newAttrsCnt <= 0) continue;
                    destAttributesInfo.addAttributes(newAttrsCnt);
                    continue;
                }
                this.attributesSet[i].addAll(table.getAttributes(domainType));
            }
        }
    }

    public void sortAttributes() {
        AttributesComparator comparator2 = new AttributesComparator();
        for (int i = 0; i < this.availableTypesCnt; ++i) {
            DomainType domainType = this.typeManager.getDomainType(i);
            if (domainType.isIntegerType() || this.delegateTable != null && domainType.isGlobal()) continue;
            this.attributes[i] = new ArrayList<Attribute>();
            this.backwardMap[i] = new HashMap<String, Integer>();
            this.domainTypeInfos.put(domainType, AttributesInfo.Companion.create(domainType));
            for (Attribute attribute : this.attributesSet[i].stream().sorted(comparator2).toList()) {
                this.attributes[i].add(attribute);
                AttributesInfo attributesInfo = this.getAttributesInfo(domainType);
                int index = attributesInfo.addAttribute();
                this.backwardMap[i].put(attribute.getKey(), index);
            }
        }
    }

    @Override
    public DomainType @NotNull [] getAvailableDomainTypes() {
        DomainType[] domainTypeArray = this.domainTypeInfos.keySet().toArray(new DomainType[0]);
        if (domainTypeArray == null) {
            MutableSymbolTable.$$$reportNull$$$0(0);
        }
        return domainTypeArray;
    }

    @Override
    @NotNull
    public DomainType getDomainType(@NotNull String name) {
        if (name == null) {
            MutableSymbolTable.$$$reportNull$$$0(1);
        }
        DomainType domainType = this.typeManager.getDomainType(name);
        if (domainType == null) {
            MutableSymbolTable.$$$reportNull$$$0(2);
        }
        return domainType;
    }

    @Override
    @NotNull
    public DomainTypeManager getTypeManager() {
        DomainTypeManager domainTypeManager = this.typeManager;
        if (domainTypeManager == null) {
            MutableSymbolTable.$$$reportNull$$$0(3);
        }
        return domainTypeManager;
    }

    @Override
    @NotNull
    public AttributesInfo getAttributesInfo(@NotNull DomainType type) {
        if (type == null) {
            MutableSymbolTable.$$$reportNull$$$0(4);
        }
        AttributesInfo attributesInfo = this.domainTypeInfos.get(type);
        if (attributesInfo == null) {
            MutableSymbolTable.$$$reportNull$$$0(5);
        }
        return attributesInfo;
    }

    @Override
    public boolean containsAttribute(int domainTypeIndex, @NotNull Attribute attribute) {
        if (attribute == null) {
            MutableSymbolTable.$$$reportNull$$$0(6);
        }
        return this.backwardMap[domainTypeIndex].containsKey(attribute.getKey());
    }

    @Override
    public int getAttributeInt(DomainType type, @NotNull String attribute) {
        if (attribute == null) {
            MutableSymbolTable.$$$reportNull$$$0(7);
        }
        if (type.isIntegerType()) {
            return Integer.parseInt(attribute);
        }
        Integer value = this.backwardMap[type.getIndex()].get(attribute);
        if (value == null) {
            throw new WrongAttributeException(Messages.getString(SymbolTable.class.getName() + "-1") + attribute + "\"");
        }
        return value;
    }

    @Override
    @NotNull
    public Attribute getAttribute(DomainType domainType, int value) {
        if (domainType.isIntegerType()) {
            return new IntAttribute(value);
        }
        Attribute attribute = this.attributes[domainType.getIndex()].get(value);
        if (attribute == null) {
            MutableSymbolTable.$$$reportNull$$$0(8);
        }
        return attribute;
    }

    @Override
    @NotNull
    public List<Attribute> getAttributes(@NotNull DomainType domainType) {
        if (domainType == null) {
            MutableSymbolTable.$$$reportNull$$$0(9);
        }
        List<Attribute> list = this.attributes[domainType.getIndex()];
        if (list == null) {
            MutableSymbolTable.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void addAttribute(Attribute attribute, DomainType domainType) {
        if (this.delegateTable != null && domainType.isGlobal()) {
            throw new DfaInternalException("Adding attributes over delegate table");
        }
        if (domainType.isIntegerType()) {
            AttributesInfo attributesInfo = this.getAttributesInfo(domainType);
            int value = Integer.parseInt(attribute.getKey());
            if (value >= attributesInfo.getNumOfAttributes()) {
                attributesInfo.addAttributes(value - attributesInfo.getNumOfAttributes() + 1);
            }
        } else {
            this.attributesSet[domainType.getIndex()].add(attribute);
        }
    }

    @Override
    @NotNull
    public List<Integer> getIntAttributeSubset(@NotNull DomainType type) {
        if (type == null) {
            MutableSymbolTable.$$$reportNull$$$0(11);
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this.getAttributesInfo(type).getNumOfAttributes(); ++i) {
            Attribute attribute = this.getAttribute(type, i);
            if (!(attribute instanceof IntAttribute)) continue;
            result.add(i);
        }
        ArrayList<Integer> arrayList = result;
        if (arrayList == null) {
            MutableSymbolTable.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public String toString() {
        return this.name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 6, 7, 9, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/rml/dfa/impl/symtable/MutableSymbolTable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDomainTypes";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/rml/dfa/impl/symtable/MutableSymbolTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomainType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttribute";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntAttributeSubset";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDomainType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsAttribute";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeInt";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIntAttributeSubset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 6, 7, 9, 11 -> new IllegalArgumentException(string);
        };
    }
}

