/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.summaries;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.impl.domains.AttributesInfo;
import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.symtable.MutableSymbolTable;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\nH\u0002J \u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u0014H\u0016R4\u0010\f\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\t\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\b0\u00070\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\"\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/rml/dfa/impl/summaries/SymbolTableWithDependencies;", "Lcom/intellij/rml/dfa/impl/symtable/MutableSymbolTable;", "typeManager", "Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;", "name", "", "dependentTables", "", "Lkotlin/Pair;", "Lcom/intellij/rml/dfa/impl/symtable/SymbolTable;", "", "(Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;Ljava/lang/String;Ljava/util/List;)V", "dependentTableAttributesMap", "", "", "", "[Ljava/util/Map;", "dependentTableRelations", "Lcom/intellij/rml/dfa/impl/relations/IRelation;", "buildAttributesMap", "", "sourceTable", "isSubset", "buildMapRelation", "sourceManager", "Lcom/intellij/rml/dfa/impl/relations/IRelationsManager;", "destManager", "getAttributesMap", "dependentTable", "domainType", "Lcom/intellij/rml/dfa/impl/domains/DomainType;", "sortAttributes", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nSymbolTableWithDependencies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolTableWithDependencies.kt\ncom/intellij/rml/dfa/impl/summaries/SymbolTableWithDependencies\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1549#2:79\n1620#2,3:80\n1549#2:83\n1620#2,3:84\n*S KotlinDebug\n*F\n+ 1 SymbolTableWithDependencies.kt\ncom/intellij/rml/dfa/impl/summaries/SymbolTableWithDependencies\n*L\n34#1:79\n34#1:80,3\n44#1:83\n44#1:84,3\n*E\n"})
public final class SymbolTableWithDependencies
extends MutableSymbolTable {
    @NotNull
    private final List<Pair<SymbolTable, Boolean>> dependentTables;
    @NotNull
    private final Map<SymbolTable, List<Pair<Integer, Integer>>>[] dependentTableAttributesMap;
    @NotNull
    private final Map<SymbolTable, IRelation>[] dependentTableRelations;

    public SymbolTableWithDependencies(@NotNull DomainTypeManager typeManager, @NotNull String name, @NotNull List<? extends Pair<? extends SymbolTable, Boolean>> dependentTables) {
        int n;
        Intrinsics.checkNotNullParameter((Object)typeManager, (String)"typeManager");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(dependentTables, (String)"dependentTables");
        super(typeManager, name);
        this.dependentTables = dependentTables;
        int n2 = 0;
        int n3 = this.availableTypesCnt;
        Map[] mapArray = new Map[n3];
        SymbolTableWithDependencies symbolTableWithDependencies = this;
        while (n2 < n3) {
            n = n2++;
            mapArray[n] = new LinkedHashMap();
        }
        symbolTableWithDependencies.dependentTableAttributesMap = mapArray;
        n2 = 0;
        n3 = this.availableTypesCnt;
        mapArray = new Map[n3];
        symbolTableWithDependencies = this;
        while (n2 < n3) {
            n = n2++;
            mapArray[n] = new LinkedHashMap();
        }
        symbolTableWithDependencies.dependentTableRelations = mapArray;
    }

    @Override
    public void sortAttributes() {
        super.sortAttributes();
        for (Pair<SymbolTable, Boolean> pair : this.dependentTables) {
            SymbolTable table = (SymbolTable)pair.component1();
            boolean isSubset = (Boolean)pair.component2();
            this.buildAttributesMap(table, isSubset);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildAttributesMap(SymbolTable sourceTable, boolean isSubset) {
        int n = this.typeManager.getDomainTypesCount();
        for (int i = 0; i < n; ++i) {
            List list;
            DomainType domainType = this.typeManager.getDomainType(i);
            if (domainType.isIntegerType()) continue;
            if (isSubset) {
                attrsMap = new int[sourceTable.getAttributes(domainType).size()];
                for (Attribute attribute : sourceTable.getAttributes(domainType)) {
                    String string = attribute.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                    attrsMap[sourceTable.getAttributeInt((DomainType)domainType, (String)string)] = this.getAttributeInt(domainType, attribute.getKey());
                }
                $this$map$iv = (Iterable)ArraysKt.getIndices((int[])attrsMap);
                $i$f$map = false;
                Object object = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var13_17 = $this$mapTo$iv$iv.iterator();
                while (var13_17.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)var13_17).nextInt();
                    var19_25 = destination$iv$iv;
                    boolean bl = false;
                    var19_25.add(new Pair((Object)((int)it), (Object)((int)attrsMap[it])));
                }
                list = (List)destination$iv$iv;
            } else {
                attrsMap = new HashMap();
                for (Attribute attribute : this.getAttributes(i)) {
                    Intrinsics.checkNotNull((Object)attribute);
                    if (!sourceTable.containsAttribute(i, attribute)) continue;
                    $this$mapTo$iv$iv = attrsMap;
                    String string = attribute.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                    destination$iv$iv = sourceTable.getAttributeInt(domainType, string);
                    Integer $i$f$mapTo = this.getAttributeInt(domainType, attribute.getKey());
                    $this$mapTo$iv$iv.put(destination$iv$iv, $i$f$mapTo);
                }
                $this$map$iv = attrsMap.entrySet();
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var13_17 = $this$mapTo$iv$iv.iterator();
                while (var13_17.hasNext()) {
                    Object item$iv$iv = var13_17.next();
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    var19_25 = destination$iv$iv;
                    boolean bl = false;
                    int key = ((Number)entry.getKey()).intValue();
                    int value = ((Number)entry.getValue()).intValue();
                    var19_25.add(new Pair((Object)key, (Object)value));
                }
                list = (List)destination$iv$iv;
            }
            List pairs = list;
            this.dependentTableAttributesMap[i].put(sourceTable, pairs);
        }
    }

    public final void buildMapRelation(@NotNull SymbolTable sourceTable, @Nullable IRelationsManager sourceManager, @NotNull IRelationsManager destManager) {
        Intrinsics.checkNotNullParameter((Object)sourceTable, (String)"sourceTable");
        Intrinsics.checkNotNullParameter((Object)destManager, (String)"destManager");
        int n = this.typeManager.getDomainTypesCount();
        for (int i = 0; i < n; ++i) {
            IRelationsManager iRelationsManager;
            AttributesInfo destInfo;
            DomainType domainType = this.typeManager.getDomainType(i);
            if (domainType.isIntegerType()) continue;
            AttributesInfo sourceInfo = sourceTable.getAttributesInfo(domainType);
            Intrinsics.checkNotNullExpressionValue((Object)this.getAttributesInfo(domainType), (String)"getAttributesInfo(...)");
            if (sourceInfo.getNumOfAttributes() == destInfo.getNumOfAttributes()) {
                iRelationsManager = sourceManager;
                if (iRelationsManager == null) {
                    iRelationsManager = destManager;
                }
            } else if (sourceInfo.getNumOfAttributes() < destInfo.getNumOfAttributes()) {
                iRelationsManager = destManager;
            } else {
                iRelationsManager = sourceManager;
                if (iRelationsManager == null) {
                    throw new DfaInternalException("Migrating from immutable relation manager");
                }
            }
            IRelationsManager relationsManager = iRelationsManager;
            Object object2 = new Domain[]{domainType.getDomain(0), domainType.getDomain(1)};
            IRelation mapper = relationsManager.makeEmptyRelation((Domain[])object2);
            List<Pair<Integer, Integer>> list = this.dependentTableAttributesMap[domainType.getIndex()].get(sourceTable);
            Intrinsics.checkNotNull(list);
            for (Pair pair : list) {
                int srcAttr = ((Number)pair.component1()).intValue();
                int dstAttr = ((Number)pair.component2()).intValue();
                int[] nArray = new int[]{srcAttr, dstAttr};
                mapper = mapper.addTuple(nArray);
            }
            object2 = this.dependentTableRelations[i];
            IRelation iRelation = mapper;
            Intrinsics.checkNotNull((Object)iRelation);
            IRelation object3 = iRelation;
            object2.put(sourceTable, object3);
        }
    }

    @Nullable
    public final IRelation getAttributesMap(@NotNull SymbolTable dependentTable, @NotNull DomainType domainType) {
        Intrinsics.checkNotNullParameter((Object)dependentTable, (String)"dependentTable");
        Intrinsics.checkNotNullParameter((Object)domainType, (String)"domainType");
        return this.dependentTableRelations[domainType.getIndex()].get(dependentTable);
    }
}

