/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.summaries;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rml.dfa.DfaEvaluationStatus;
import com.intellij.rml.dfa.PathSensitiveMode;
import com.intellij.rml.dfa.impl.DfaEvaluationEvent;
import com.intellij.rml.dfa.impl.DfaFailedException;
import com.intellij.rml.dfa.impl.DfaFunctionEvaluationEvent;
import com.intellij.rml.dfa.impl.RMLInstancesProvider;
import com.intellij.rml.dfa.impl.relations.IImmutableRelation;
import com.intellij.rml.dfa.impl.rml.profiler.tree.IProfileNode;
import com.intellij.rml.dfa.impl.summaries.DfaSummaryEvaluationObserver;
import com.intellij.rml.dfa.impl.summaries.DfaSummaryFunctionEvaluationEvent;
import com.intellij.rml.dfa.utils.FormatHelperKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J,\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u001a\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0004H\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u001fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/SummaryLogObserver;", "Lcom/intellij/rml/dfa/impl/summaries/DfaSummaryEvaluationObserver;", "()V", "operationsCnt", "", "addOperationsCnt", "", "localProvider", "Lcom/intellij/rml/dfa/impl/RMLInstancesProvider;", "summaryProvider", "afterAllPasses", "firstPassCollectionProviders", "", "secondPassCollProvider", "globalProvider", "finish", "status", "Lcom/intellij/rml/dfa/DfaEvaluationStatus;", "profilerTree", "Lcom/intellij/rml/dfa/impl/rml/profiler/tree/IProfileNode;", "functionAnalysisFailed", "event", "Lcom/intellij/rml/dfa/impl/DfaFunctionEvaluationEvent;", "exception", "Lcom/intellij/rml/dfa/impl/DfaFailedException;", "functionAnalysisFinished", "startTime", "functionAnalysisStarted", "getReachableSizeBytes", "provider", "start", "Lcom/intellij/rml/dfa/impl/DfaEvaluationEvent;", "Companion", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nSummaryLogObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SummaryLogObserver.kt\ncom/intellij/rml/dfa/impl/summaries/SummaryLogObserver\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n11065#2:78\n11400#2,3:79\n1#3:82\n*S KotlinDebug\n*F\n+ 1 SummaryLogObserver.kt\ncom/intellij/rml/dfa/impl/summaries/SummaryLogObserver\n*L\n69#1:78\n69#1:79,3\n*E\n"})
public final class SummaryLogObserver
implements DfaSummaryEvaluationObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long operationsCnt;
    @NotNull
    private static final Logger LOG;

    @Override
    public void start(@NotNull DfaEvaluationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.operationsCnt = 0L;
    }

    @Override
    public void functionAnalysisStarted(@NotNull DfaFunctionEvaluationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LOG.warn(event.getFunction() + ": started");
    }

    @Override
    public void functionAnalysisFinished(@NotNull DfaFunctionEvaluationEvent event, long startTime) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DfaSummaryFunctionEvaluationEvent cfr_ignored_0 = (DfaSummaryFunctionEvaluationEvent)event;
        DfaSummaryFunctionEvaluationEvent dfaSummaryFunctionEvaluationEvent = event instanceof DfaSummaryFunctionEvaluationEvent ? (DfaSummaryFunctionEvaluationEvent)event : null;
        this.addOperationsCnt(event.getProvider(), dfaSummaryFunctionEvaluationEvent != null ? dfaSummaryFunctionEvaluationEvent.getSummaryProvider() : null);
        String globalBDDSize = FormatHelperKt.formatMemorySize$default(((DfaSummaryFunctionEvaluationEvent)event).getSummaryProvider().getBddMemoryStat().getAmortizedTotalBytes(), 0, 2, null);
        String localBDDSize = FormatHelperKt.formatMemorySize$default(event.getProvider().getBddMemoryStat().getAmortizedTotalBytes(), 0, 2, null);
        String globalSize = FormatHelperKt.formatMemorySize$default(this.getReachableSizeBytes(((DfaSummaryFunctionEvaluationEvent)event).getSummaryProvider()), 0, 2, null);
        String localSize = FormatHelperKt.formatMemorySize$default(this.getReachableSizeBytes(event.getProvider()), 0, 2, null);
        String duration = FormatHelperKt.formatDuration$default(System.currentTimeMillis() - startTime, 0, 2, null);
        LOG.warn(event.getFunction() + ": Finished (" + duration + "): BDD size: " + globalBDDSize + "/" + localBDDSize + " (" + globalSize + "/" + localSize + ")");
    }

    @Override
    public void functionAnalysisFailed(@NotNull DfaFunctionEvaluationEvent event, @NotNull DfaFailedException exception) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        DfaSummaryFunctionEvaluationEvent cfr_ignored_0 = (DfaSummaryFunctionEvaluationEvent)event;
        this.addOperationsCnt(event.getProvider(), ((DfaSummaryFunctionEvaluationEvent)event).getSummaryProvider());
        if (((DfaSummaryFunctionEvaluationEvent)event).getMode() == PathSensitiveMode.PathSensitive) {
            LOG.warn(event.getFunction() + ": failed to perform path-sensitive DFA, reason: " + exception);
        } else {
            LOG.warn(event.getFunction() + ": failed to perform path-insensitive DFA, reason: " + exception);
        }
    }

    private final void addOperationsCnt(RMLInstancesProvider localProvider, RMLInstancesProvider summaryProvider) {
        this.operationsCnt += localProvider.getBddOperationsCnt();
        if (summaryProvider != null) {
            this.operationsCnt += summaryProvider.getBddOperationsCnt();
        }
    }

    @Override
    public void afterAllPasses(@NotNull List<? extends RMLInstancesProvider> firstPassCollectionProviders, @NotNull List<? extends RMLInstancesProvider> secondPassCollProvider, @NotNull RMLInstancesProvider globalProvider) {
        Intrinsics.checkNotNullParameter(firstPassCollectionProviders, (String)"firstPassCollectionProviders");
        Intrinsics.checkNotNullParameter(secondPassCollProvider, (String)"secondPassCollProvider");
        Intrinsics.checkNotNullParameter((Object)globalProvider, (String)"globalProvider");
        this.operationsCnt += globalProvider.getBddOperationsCnt();
        LOG.warn("BDD operations: " + FormatHelperKt.formatNumber$default(this.operationsCnt, 0, 2, null));
        String bddSize = FormatHelperKt.formatMemorySize$default(globalProvider.getBddMemoryStat().getAmortizedTotalBytes(), 0, 2, null);
        String relationsSize = FormatHelperKt.formatMemorySize$default(this.getReachableSizeBytes(globalProvider), 0, 2, null);
        LOG.warn("BDD size: " + bddSize + " (" + relationsSize + ")");
    }

    @Override
    public void finish(@NotNull DfaEvaluationStatus status, @Nullable IProfileNode profilerTree) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
    }

    /*
     * WARNING - void declaration
     */
    private final long getReachableSizeBytes(RMLInstancesProvider provider) {
        void $this$mapTo$iv$iv;
        String[] stringArray = provider.getRelationsRepository().getAvailableRelations();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getAvailableRelations(...)");
        Object[] $this$map$iv = stringArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(provider.getRelationsRepository().getRelation((String)it));
        }
        Iterable iterable = (List)destination$iv$iv;
        long l = 0L;
        for (Object t : iterable) {
            void it;
            IImmutableRelation iImmutableRelation = (IImmutableRelation)t;
            long l2 = l;
            boolean bl = false;
            long l3 = it.getNumOfBDDNodes();
            l = l2 + l3;
        }
        return l * (long)8;
    }

    static {
        Logger logger = Logger.getInstance((String)SummaryLogObserver.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/SummaryLogObserver$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rml.dfa.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

