/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.summaries;

import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.impl.RMLInstancesProvider;
import com.intellij.rml.dfa.impl.RMLMutableInstancesProvider;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.repositories.MutableRelationsRepository;
import com.intellij.rml.dfa.impl.summaries.SymbolTableWithDependencies;
import com.intellij.rml.dfa.impl.symtable.MutableSymbolTable;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.visitors.Visitor;
import com.intellij.rml.dfa.utils.Cancellation;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\nJ&\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J&\u0010#\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00072\u0006\u0010$\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019\u00a8\u0006%"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/MigrateToSummariesVisitor;", "Lcom/intellij/rml/dfa/impl/visitors/Visitor;", "globalProvider", "Lcom/intellij/rml/dfa/impl/RMLInstancesProvider;", "localProvider", "Lcom/intellij/rml/dfa/impl/RMLMutableInstancesProvider;", "predefinedRelations", "", "", "summaryRelations", "(Lcom/intellij/rml/dfa/impl/RMLInstancesProvider;Lcom/intellij/rml/dfa/impl/RMLMutableInstancesProvider;Ljava/util/List;Ljava/util/List;)V", "getGlobalProvider", "()Lcom/intellij/rml/dfa/impl/RMLInstancesProvider;", "getLocalProvider", "()Lcom/intellij/rml/dfa/impl/RMLMutableInstancesProvider;", "name", "getName", "()Ljava/lang/String;", "outputRelations", "", "Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "getOutputRelations", "()[Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "[Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "getPredefinedRelations", "()Ljava/util/List;", "getSummaryRelations", "collectAttributes", "", "input", "Lcom/intellij/rml/dfa/attributes/DfaTuple;", "symbolTable", "Lcom/intellij/rml/dfa/impl/symtable/MutableSymbolTable;", "cancellation", "Lcom/intellij/rml/dfa/utils/Cancellation;", "collectRelations", "provider", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nMigrateToSummariesVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateToSummariesVisitor.kt\ncom/intellij/rml/dfa/impl/summaries/MigrateToSummariesVisitor\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,51:1\n26#2:52\n*S KotlinDebug\n*F\n+ 1 MigrateToSummariesVisitor.kt\ncom/intellij/rml/dfa/impl/summaries/MigrateToSummariesVisitor\n*L\n16#1:52\n*E\n"})
public final class MigrateToSummariesVisitor
implements Visitor {
    @NotNull
    private final RMLInstancesProvider globalProvider;
    @NotNull
    private final RMLMutableInstancesProvider localProvider;
    @NotNull
    private final List<String> predefinedRelations;
    @NotNull
    private final List<String> summaryRelations;
    @NotNull
    private final String name;
    @NotNull
    private final RelationSignature[] outputRelations;

    public MigrateToSummariesVisitor(@NotNull RMLInstancesProvider globalProvider, @NotNull RMLMutableInstancesProvider localProvider, @NotNull List<String> predefinedRelations, @NotNull List<String> summaryRelations) {
        Intrinsics.checkNotNullParameter((Object)globalProvider, (String)"globalProvider");
        Intrinsics.checkNotNullParameter((Object)localProvider, (String)"localProvider");
        Intrinsics.checkNotNullParameter(predefinedRelations, (String)"predefinedRelations");
        Intrinsics.checkNotNullParameter(summaryRelations, (String)"summaryRelations");
        this.globalProvider = globalProvider;
        this.localProvider = localProvider;
        this.predefinedRelations = predefinedRelations;
        this.summaryRelations = summaryRelations;
        this.name = "Summary collector";
        boolean $i$f$emptyArray = false;
        this.outputRelations = new RelationSignature[0];
    }

    @NotNull
    public final RMLInstancesProvider getGlobalProvider() {
        return this.globalProvider;
    }

    @NotNull
    public final RMLMutableInstancesProvider getLocalProvider() {
        return this.localProvider;
    }

    @NotNull
    public final List<String> getPredefinedRelations() {
        return this.predefinedRelations;
    }

    @NotNull
    public final List<String> getSummaryRelations() {
        return this.summaryRelations;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public RelationSignature[] getOutputRelations() {
        return this.outputRelations;
    }

    @Override
    public void collectAttributes(@NotNull List<DfaTuple> input2, @NotNull MutableSymbolTable symbolTable, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter(input2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        if (symbolTable instanceof SymbolTableWithDependencies) {
            MutableRelationsRepository mutableRelationsRepository = this.localProvider.getRelationsRepository();
            Intrinsics.checkNotNullExpressionValue((Object)mutableRelationsRepository, (String)"<get-relationsRepository>(...)");
            MutableRelationsRepository repository = mutableRelationsRepository;
            for (String relationName : CollectionsKt.plus((Collection)this.summaryRelations, (Iterable)this.predefinedRelations)) {
                IRelation relation;
                if (!repository.containsRelation(relationName)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)repository.getRelation(relationName), (String)"getRelation(...)");
                relation.copyAttributes(repository.getSymbolTable(), symbolTable);
            }
        } else {
            symbolTable.addAttributesFrom(CollectionsKt.listOf((Object)this.globalProvider.getSymbolTable()), true);
        }
    }

    @Override
    public void collectRelations(@NotNull List<DfaTuple> input2, @NotNull RMLMutableInstancesProvider provider, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter(input2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        MutableRelationsRepository mutableRelationsRepository = this.localProvider.getRelationsRepository();
        Intrinsics.checkNotNullExpressionValue((Object)mutableRelationsRepository, (String)"<get-relationsRepository>(...)");
        MutableRelationsRepository repository = mutableRelationsRepository;
        SymbolTable symbolTable = provider.getSymbolTable();
        SymbolTableWithDependencies symbolTableWithDependencies = symbolTable instanceof SymbolTableWithDependencies ? (SymbolTableWithDependencies)symbolTable : null;
        if (symbolTableWithDependencies != null) {
            SymbolTable symbolTable2 = this.localProvider.getSymbolTable();
            Intrinsics.checkNotNullExpressionValue((Object)symbolTable2, (String)"<get-symbolTable>(...)");
            IRelationsManager iRelationsManager = repository.getRelationsManager();
            IRelationsManager iRelationsManager2 = provider.getRelationsManager();
            Intrinsics.checkNotNullExpressionValue((Object)iRelationsManager2, (String)"getRelationsManager(...)");
            symbolTableWithDependencies.buildMapRelation(symbolTable2, iRelationsManager, iRelationsManager2);
        }
        for (String relationName : this.summaryRelations) {
            String nameWithSuffix = relationName + "$Summary";
            if (!repository.containsRelation(nameWithSuffix)) continue;
            IRelation iRelation = repository.getRelation(nameWithSuffix);
            Intrinsics.checkNotNullExpressionValue((Object)iRelation, (String)"getRelation(...)");
            IRelation relation = iRelation;
            IRelation iRelation2 = relation.migrate(repository.getRelationsManager(), provider.getRelationsManager(), this.localProvider.getSymbolTable(), provider.getSymbolTable(), cancellation);
            Intrinsics.checkNotNullExpressionValue((Object)iRelation2, (String)"migrate(...)");
            relation = iRelation2;
            provider.getRelationsRepository().addRelation(relationName, relation);
        }
    }
}

