/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.summaries;

import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.impl.RMLInstancesProvider;
import com.intellij.rml.dfa.impl.RMLMutableInstancesProvider;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.repositories.MutableRelationsRepository;
import com.intellij.rml.dfa.impl.repositories.RelationsRepository;
import com.intellij.rml.dfa.impl.summaries.SymbolTableWithDependencies;
import com.intellij.rml.dfa.impl.symtable.MutableSymbolTable;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.visitors.Visitor;
import com.intellij.rml.dfa.utils.Cancellation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ&\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J&\u0010\u001f\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\f\u00a8\u0006\""}, d2={"Lcom/intellij/rml/dfa/impl/summaries/MigrateFromSummariesVisitor;", "Lcom/intellij/rml/dfa/impl/visitors/Visitor;", "globalProvider", "Lcom/intellij/rml/dfa/impl/RMLInstancesProvider;", "inputProviders", "", "summaryRelations", "", "(Lcom/intellij/rml/dfa/impl/RMLInstancesProvider;Ljava/util/List;Ljava/util/List;)V", "getGlobalProvider", "()Lcom/intellij/rml/dfa/impl/RMLInstancesProvider;", "getInputProviders", "()Ljava/util/List;", "name", "getName", "()Ljava/lang/String;", "outputRelations", "", "Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "getOutputRelations", "()[Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "[Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "getSummaryRelations", "collectAttributes", "", "input", "Lcom/intellij/rml/dfa/attributes/DfaTuple;", "symbolTable", "Lcom/intellij/rml/dfa/impl/symtable/MutableSymbolTable;", "cancellation", "Lcom/intellij/rml/dfa/utils/Cancellation;", "collectRelations", "provider", "Lcom/intellij/rml/dfa/impl/RMLMutableInstancesProvider;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nMigrateFromSummariesVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateFromSummariesVisitor.kt\ncom/intellij/rml/dfa/impl/summaries/MigrateFromSummariesVisitor\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n26#2:65\n1549#3:66\n1620#3,3:67\n*S KotlinDebug\n*F\n+ 1 MigrateFromSummariesVisitor.kt\ncom/intellij/rml/dfa/impl/summaries/MigrateFromSummariesVisitor\n*L\n16#1:65\n20#1:66\n20#1:67,3\n*E\n"})
public final class MigrateFromSummariesVisitor
implements Visitor {
    @NotNull
    private final RMLInstancesProvider globalProvider;
    @NotNull
    private final List<RMLInstancesProvider> inputProviders;
    @NotNull
    private final List<String> summaryRelations;
    @NotNull
    private final String name;
    @NotNull
    private final RelationSignature[] outputRelations;

    public MigrateFromSummariesVisitor(@NotNull RMLInstancesProvider globalProvider, @NotNull List<? extends RMLInstancesProvider> inputProviders, @NotNull List<String> summaryRelations) {
        Intrinsics.checkNotNullParameter((Object)globalProvider, (String)"globalProvider");
        Intrinsics.checkNotNullParameter(inputProviders, (String)"inputProviders");
        Intrinsics.checkNotNullParameter(summaryRelations, (String)"summaryRelations");
        this.globalProvider = globalProvider;
        this.inputProviders = inputProviders;
        this.summaryRelations = summaryRelations;
        this.name = "Summary merger";
        boolean $i$f$emptyArray = false;
        this.outputRelations = new RelationSignature[0];
    }

    @NotNull
    public final RMLInstancesProvider getGlobalProvider() {
        return this.globalProvider;
    }

    @NotNull
    public final List<RMLInstancesProvider> getInputProviders() {
        return this.inputProviders;
    }

    @NotNull
    public final List<String> getSummaryRelations() {
        return this.summaryRelations;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public RelationSignature[] getOutputRelations() {
        return this.outputRelations;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void collectAttributes(@NotNull List<DfaTuple> input2, @NotNull MutableSymbolTable symbolTable, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter(input2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        if (symbolTable instanceof SymbolTableWithDependencies) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.inputProviders;
            MutableSymbolTable mutableSymbolTable = symbolTable;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RMLInstancesProvider rMLInstancesProvider = (RMLInstancesProvider)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSymbolTable());
            }
            mutableSymbolTable.addAttributesFrom((List)destination$iv$iv, false);
        } else {
            symbolTable.addAttributesFrom(CollectionsKt.listOf((Object)this.globalProvider.getSymbolTable()), true);
        }
    }

    @Override
    public void collectRelations(@NotNull List<DfaTuple> input2, @NotNull RMLMutableInstancesProvider provider, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter(input2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        MutableRelationsRepository mutableRelationsRepository = provider.getRelationsRepository();
        Intrinsics.checkNotNullExpressionValue((Object)mutableRelationsRepository, (String)"<get-relationsRepository>(...)");
        MutableRelationsRepository relationsRepository = mutableRelationsRepository;
        String[] globalRelations = this.globalProvider.getRelationsRepository().getAvailableRelations();
        IRelationsManager globalManager = this.globalProvider.cloneRelationsManager();
        SymbolTable symbolTable = provider.getSymbolTable();
        Intrinsics.checkNotNullExpressionValue((Object)symbolTable, (String)"<get-symbolTable>(...)");
        SymbolTable destTable = symbolTable;
        if (destTable instanceof SymbolTableWithDependencies) {
            SymbolTableWithDependencies symbolTableWithDependencies = (SymbolTableWithDependencies)destTable;
            SymbolTable symbolTable2 = this.globalProvider.getSymbolTable();
            IRelationsManager iRelationsManager = provider.getRelationsManager();
            Intrinsics.checkNotNullExpressionValue((Object)iRelationsManager, (String)"getRelationsManager(...)");
            symbolTableWithDependencies.buildMapRelation(symbolTable2, globalManager, iRelationsManager);
            for (RMLInstancesProvider inputProvider : this.inputProviders) {
                SymbolTableWithDependencies symbolTableWithDependencies2 = (SymbolTableWithDependencies)destTable;
                SymbolTable symbolTable3 = inputProvider.getSymbolTable();
                IRelationsManager iRelationsManager2 = provider.getRelationsManager();
                Intrinsics.checkNotNullExpressionValue((Object)iRelationsManager2, (String)"getRelationsManager(...)");
                symbolTableWithDependencies2.buildMapRelation(symbolTable3, null, iRelationsManager2);
            }
        }
        Intrinsics.checkNotNull((Object)globalRelations);
        for (String relationName : globalRelations) {
            List list = CollectionsKt.listOf((Object)this.globalProvider);
            Intrinsics.checkNotNull((Object)relationName);
            MigrateFromSummariesVisitor.collectRelations$processRelation(relationsRepository, cancellation, list, globalManager, relationName);
        }
        for (String relationName : this.summaryRelations) {
            MigrateFromSummariesVisitor.collectRelations$processRelation(relationsRepository, cancellation, this.inputProviders, null, relationName);
        }
    }

    private static final void collectRelations$processRelation(MutableRelationsRepository relationsRepository, Cancellation $cancellation, List<? extends RMLInstancesProvider> dependentProviders, IRelationsManager sourceManager, String relationName) {
        IRelation relation = null;
        for (RMLInstancesProvider rMLInstancesProvider : dependentProviders) {
            RelationsRepository parentRepository = rMLInstancesProvider.getRelationsRepository();
            if (!parentRepository.containsRelation(relationName)) continue;
            IRelation parentRelation = parentRepository.getRelation(relationName).migrate(sourceManager, relationsRepository.getRelationsManager(), parentRepository.getSymbolTable(), relationsRepository.getSymbolTable(), $cancellation);
            IRelation iRelation = relation;
            relation = iRelation != null ? iRelation.unite(parentRelation, $cancellation) : parentRelation;
        }
        if (relation != null) {
            relationsRepository.addRelation(relationName, relation);
        }
    }
}

