/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.summaries;

import com.intellij.rml.dfa.DfaEvaluationStatus;
import com.intellij.rml.dfa.impl.DfaEvaluationEvent;
import com.intellij.rml.dfa.impl.DfaFunctionEvaluationEvent;
import com.intellij.rml.dfa.impl.RMLInstancesProvider;
import com.intellij.rml.dfa.impl.rml.profiler.tree.IProfileNode;
import com.intellij.rml.dfa.impl.summaries.DfaBddOperationCountMeasurement;
import com.intellij.rml.dfa.impl.summaries.DfaDomainSizesMeasurement;
import com.intellij.rml.dfa.impl.summaries.DfaEvaluationStatusMeasurement;
import com.intellij.rml.dfa.impl.summaries.DfaInputRelationSizesMeasurement;
import com.intellij.rml.dfa.impl.summaries.DfaMeasurement;
import com.intellij.rml.dfa.impl.summaries.DfaMemoryMeasurement;
import com.intellij.rml.dfa.impl.summaries.DfaSummaryEvaluationObserver;
import com.intellij.rml.dfa.impl.summaries.DfaTimeMeasurement;
import com.intellij.rml.dfa.utils.measurements.DfaMeasurementKind;
import com.intellij.rml.dfa.utils.measurements.DfaMeasurementRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/DfaMeasurementCombiner;", "Lcom/intellij/rml/dfa/impl/summaries/DfaSummaryEvaluationObserver;", "runner", "Lcom/intellij/rml/dfa/utils/measurements/DfaMeasurementRunner;", "(Lcom/intellij/rml/dfa/utils/measurements/DfaMeasurementRunner;)V", "measurements", "", "Lcom/intellij/rml/dfa/impl/summaries/DfaMeasurement;", "afterAllPasses", "", "firstPassCollectionProviders", "Lcom/intellij/rml/dfa/impl/RMLInstancesProvider;", "secondPassCollProvider", "globalProvider", "finish", "status", "Lcom/intellij/rml/dfa/DfaEvaluationStatus;", "profilerTree", "Lcom/intellij/rml/dfa/impl/rml/profiler/tree/IProfileNode;", "functionAnalysisFinished", "event", "Lcom/intellij/rml/dfa/impl/DfaFunctionEvaluationEvent;", "startTime", "", "functionAnalysisStarted", "start", "Lcom/intellij/rml/dfa/impl/DfaEvaluationEvent;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nDfaMeasurement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DfaMeasurement.kt\ncom/intellij/rml/dfa/impl/summaries/DfaMeasurementCombiner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,258:1\n1549#2:259\n1620#2,3:260\n1855#2,2:263\n1855#2,2:265\n1855#2,2:267\n1855#2,2:269\n1855#2,2:271\n*S KotlinDebug\n*F\n+ 1 DfaMeasurement.kt\ncom/intellij/rml/dfa/impl/summaries/DfaMeasurementCombiner\n*L\n220#1:259\n220#1:260,3\n232#1:263,2\n236#1:265,2\n241#1:267,2\n247#1:269,2\n251#1:271,2\n*E\n"})
public final class DfaMeasurementCombiner
implements DfaSummaryEvaluationObserver {
    @NotNull
    private final DfaMeasurementRunner runner;
    @NotNull
    private final List<DfaMeasurement> measurements;

    /*
     * WARNING - void declaration
     */
    public DfaMeasurementCombiner(@NotNull DfaMeasurementRunner runner) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        this.runner = runner;
        Iterable iterable = this.runner.getMeasurements();
        DfaMeasurementCombiner dfaMeasurementCombiner = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DfaMeasurement dfaMeasurement;
            void it;
            DfaMeasurementKind dfaMeasurementKind = (DfaMeasurementKind)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_12 = it;
            if (var11_12 instanceof DfaMeasurementKind.Time) {
                dfaMeasurement = new DfaTimeMeasurement();
            } else if (var11_12 instanceof DfaMeasurementKind.Memory) {
                dfaMeasurement = new DfaMemoryMeasurement(((DfaMeasurementKind.Memory)it).getParallelism());
            } else if (var11_12 instanceof DfaMeasurementKind.EvaluationStatus) {
                dfaMeasurement = new DfaEvaluationStatusMeasurement();
            } else if (var11_12 instanceof DfaMeasurementKind.BddOperationCount) {
                dfaMeasurement = new DfaBddOperationCountMeasurement();
            } else if (var11_12 instanceof DfaMeasurementKind.DomainSizes) {
                dfaMeasurement = new DfaDomainSizesMeasurement();
            } else if (var11_12 instanceof DfaMeasurementKind.InputRelationSizesMeasurement) {
                dfaMeasurement = new DfaInputRelationSizesMeasurement(((DfaMeasurementKind.InputRelationSizesMeasurement)it).getRelation());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(dfaMeasurement);
        }
        dfaMeasurementCombiner.measurements = (List)destination$iv$iv;
    }

    @Override
    public void start(@NotNull DfaEvaluationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = this.measurements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DfaMeasurement it = (DfaMeasurement)element$iv;
            boolean bl = false;
            it.start(event);
        }
    }

    @Override
    public void functionAnalysisStarted(@NotNull DfaFunctionEvaluationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = this.measurements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DfaMeasurement it = (DfaMeasurement)element$iv;
            boolean bl = false;
            it.functionAnalysisStarted(event);
        }
    }

    @Override
    public void functionAnalysisFinished(@NotNull DfaFunctionEvaluationEvent event, long startTime) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = this.measurements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DfaMeasurement it = (DfaMeasurement)element$iv;
            boolean bl = false;
            it.functionAnalysisFinished(event, startTime);
        }
    }

    @Override
    public void afterAllPasses(@NotNull List<? extends RMLInstancesProvider> firstPassCollectionProviders, @NotNull List<? extends RMLInstancesProvider> secondPassCollProvider, @NotNull RMLInstancesProvider globalProvider) {
        Intrinsics.checkNotNullParameter(firstPassCollectionProviders, (String)"firstPassCollectionProviders");
        Intrinsics.checkNotNullParameter(secondPassCollProvider, (String)"secondPassCollProvider");
        Intrinsics.checkNotNullParameter((Object)globalProvider, (String)"globalProvider");
        Iterable $this$forEach$iv = this.measurements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DfaMeasurement it = (DfaMeasurement)element$iv;
            boolean bl = false;
            it.afterAllPasses(firstPassCollectionProviders, secondPassCollProvider, globalProvider);
        }
    }

    @Override
    public void finish(@NotNull DfaEvaluationStatus status, @Nullable IProfileNode profilerTree) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Iterable $this$forEach$iv = this.measurements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DfaMeasurement it = (DfaMeasurement)element$iv;
            boolean bl = false;
            it.finish(status, profilerTree);
        }
        for (DfaMeasurement m : this.measurements) {
            this.runner.addMetricProvider(m);
        }
        this.runner.finish();
    }
}

