/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.scripts;

import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.rml.dsl.lang.RelationModification;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VariablesManager {
    private final DomainTypeManager typeManager;
    private final Map<String, Integer> variables = new HashMap<String, Integer>();
    private final Map<String, DomainType[]> relations = new HashMap<String, DomainType[]>();
    private final Set<String> usedRelations = new HashSet<String>();
    private final Set<String> options = new HashSet<String>();
    private final Map<String, Integer> defaultOptionValues = new HashMap<String, Integer>();
    private Set<RelationSignature> inputRelations = new LinkedHashSet<RelationSignature>();
    private Map<String, List<RelationModification>> inputRelationModifications = new HashMap<String, List<RelationModification>>();
    private final Set<RelationSignature> outputRelations = new LinkedHashSet<RelationSignature>();
    private final Set<RelationSignature> summaryRelations = new LinkedHashSet<RelationSignature>();
    private final Set<RelationSignature> tempRelations = new LinkedHashSet<RelationSignature>();
    private final Map<String, String> subgroups = new HashMap<String, String>();
    private final Map<String, DomainType> domains = new HashMap<String, DomainType>();
    private final Set<String> domUsages = new HashSet<String>();

    public VariablesManager(DomainTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public DomainTypeManager getTypeManager() {
        return this.typeManager;
    }

    public void addVariable(String name, int type) {
        this.variables.put(name, type);
    }

    public void addOption(String name, Integer defaultValue, int type) {
        this.variables.put(name, type);
        this.defaultOptionValues.put(name, defaultValue);
        this.options.add(name);
    }

    public int getVariableType(String name) {
        return this.variables.get(name);
    }

    public boolean containsVariable(String name) {
        return this.variables.containsKey(name);
    }

    public Collection<String> getVariables() {
        return this.variables.keySet();
    }

    public boolean isOption(String name) {
        return this.options.contains(name);
    }

    public Integer getDefaultOptionValue(String name) {
        return this.defaultOptionValues.get(name);
    }

    public void addInputRelation(RelationSignature signature, List<RelationModification> modifications) {
        this.inputRelations.add(signature);
        this.inputRelationModifications.put(signature.getName(), modifications);
        this.relations.put(signature.getName(), signature.getTypes());
    }

    public void addOutputRelation(RelationSignature signature) {
        this.outputRelations.add(signature);
        this.relations.put(signature.getName(), signature.getTypes());
    }

    public void addSummaryRelation(RelationSignature signature) {
        this.summaryRelations.add(signature);
        this.relations.put(signature.getName(), signature.getTypes());
    }

    public void addTempRelation(RelationSignature signature) {
        this.tempRelations.add(signature);
        this.relations.put(signature.getName(), signature.getTypes());
    }

    public void setRelationSubgroup(String relName, String subgroup) {
        this.subgroups.put(relName, subgroup);
    }

    public RelationSignature[] getInputRelations() {
        return this.inputRelations.toArray(RelationSignature.EMPTY_ARRAY);
    }

    public RelationSignature[] getOutputRelations() {
        return this.outputRelations.toArray(RelationSignature.EMPTY_ARRAY);
    }

    public RelationSignature[] getSummaryRelations() {
        return this.summaryRelations.toArray(RelationSignature.EMPTY_ARRAY);
    }

    public RelationSignature[] getTempRelations() {
        return this.tempRelations.toArray(RelationSignature.EMPTY_ARRAY);
    }

    public String getRelationSubgroup(String relationName) {
        return this.subgroups.get(relationName);
    }

    public boolean isInputRelation(String name) {
        return this.inputRelations.contains(new RelationSignature(name, this.getRelation(name)));
    }

    public List<RelationModification> getInputRelationModifications(String relationName) {
        List<RelationModification> modifications = this.inputRelationModifications.get(relationName);
        return modifications != null ? modifications : List.of();
    }

    public DomainType[] getRelation(String name) {
        return this.relations.get(name);
    }

    public boolean containsRelation(String name) {
        this.usedRelations.add(name);
        return this.relations.containsKey(name);
    }

    public void removeUnusedRelations() {
        LinkedHashSet<RelationSignature> newInputRelations = new LinkedHashSet<RelationSignature>();
        for (RelationSignature inputRelation : this.inputRelations) {
            if (!this.usedRelations.contains(inputRelation.getName())) continue;
            newInputRelations.add(inputRelation);
        }
        this.inputRelations = newInputRelations;
    }

    public boolean containsDomainType(String name) {
        return this.typeManager.containDomainType(name);
    }

    public DomainType getDomainType(String name) {
        return this.typeManager.getDomainType(name);
    }

    public void addDomain(String name, DomainType type) {
        this.domains.put(name, type);
    }

    public DomainType getDomain(String name) {
        return this.domains.get(name);
    }

    public boolean containsDomain(String name) {
        return this.domains.containsKey(name);
    }

    public void useDomain(String name) {
        this.domUsages.add(name);
    }

    public boolean wasDomainUsed(String name) {
        return this.domUsages.contains(name);
    }

    public void removeDomain(String name) {
        this.domains.remove(name);
        this.domUsages.remove(name);
    }
}

