/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.scripts;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.repositories.HypoteticRelationsRepository;
import com.intellij.rml.dfa.impl.repositories.MutableRelationsRepository;
import com.intellij.rml.dfa.impl.repositories.RelationsRepository;
import com.intellij.rml.dfa.impl.rml.profiler.GlobalProfileManager;
import com.intellij.rml.dfa.impl.scripts.RMLScriptDSL;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.scripts.Script;
import com.intellij.rml.dfa.impl.scripts.VariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.impl.utils.StringHelper;
import com.intellij.rml.dfa.rml.dsl.lang.SignatureKt;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.rml.dfa.utils.FormatHelperKt;
import com.intellij.rml.dfa.utils.KeyWithDefault;
import com.intellij.rml.dfa.utils.RMLOptions;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ScriptManager {
    public static final KeyWithDefault<String> KEY_SCRIPT_TIME = new KeyWithDefault<String>("ScriptTime", "");
    private final Map<String, Script> nameToScript = new HashMap<String, Script>();
    private final Map<String, VariablesManager> nameToVariablesManager = new HashMap<String, VariablesManager>();

    public Script[] getAvailableScripts() {
        return this.nameToScript.values().toArray(Script.EMPTY_ARRAY);
    }

    public void addScript(Script script) {
        if (script != null) {
            this.nameToScript.put(script.getName(), script);
        }
    }

    public Script getScript(String name) {
        return this.nameToScript.get(name);
    }

    public VariablesManager getVariablesManager(String name) {
        return this.nameToVariablesManager.get(name);
    }

    public String[] getMissingRelations(Script script, HypoteticRelationsRepository hypotheticRepository, RelationsRepository repository) {
        RelationSignature[] inputRelations;
        HashSet<String> relations = new HashSet<String>();
        for (RelationSignature inputRelation : inputRelations = this.nameToVariablesManager.get(script.getName()).getInputRelations()) {
            if (SignatureKt.isFakeRelation(inputRelation.getName())) continue;
            relations.add(inputRelation.getName());
        }
        Arrays.asList(repository.getAvailableRelations()).forEach(relations::remove);
        hypotheticRepository.getAllSummaryRelations().forEach(relations::remove);
        return ArrayUtil.toStringArray(relations);
    }

    @NotNull
    public List<String> getOutputRelations() {
        List<String> list = Arrays.stream(this.getAvailableScripts()).flatMap(script -> Stream.concat(Arrays.stream(this.getVariablesManager(script.getName()).getOutputRelations()), Arrays.stream(this.getVariablesManager(script.getName()).getSummaryRelations())).map(signature -> signature.getName())).collect(Collectors.toList());
        if (list == null) {
            ScriptManager.$$$reportNull$$$0(0);
        }
        return list;
    }

    public RuntimeVariablesManager run(Script script, SymbolTable symbolTable, HypoteticRelationsRepository hypotheticRepository, RMLOptions options, Cancellation cancellation, UIInstancesProvider uiInstancesProvider, MutableRelationsRepository repository, GlobalProfileManager profileManager2) {
        String[] missingRelations = this.getMissingRelations(script, hypotheticRepository, repository);
        if (missingRelations.length > 0) {
            throw new DfaInternalException(Messages.getString(ScriptManager.class.getName() + "-0") + StringHelper.makeCommaList(missingRelations) + Messages.getString(ScriptManager.class.getName() + "-1"));
        }
        uiInstancesProvider.getConsole().println(Messages.getString(ScriptManager.class.getName() + "-2") + script.getName() + "\"...");
        long time = System.currentTimeMillis();
        RuntimeVariablesManager manager = script.run(repository, repository.getRelationsManager(), symbolTable, options, cancellation, uiInstancesProvider, profileManager2);
        time = System.currentTimeMillis() - time;
        String scriptTime = FormatHelperKt.formatDuration((int)time);
        options.set(KEY_SCRIPT_TIME, scriptTime);
        uiInstancesProvider.getConsole().println(Messages.getString(ScriptManager.class.getName() + "-4") + script.getName() + Messages.getString(ScriptManager.class.getName() + "-5") + scriptTime);
        return manager;
    }

    public void refresh() {
        String[] names;
        for (String name : names = ArrayUtil.toStringArray(this.nameToScript.keySet())) {
            Script currentScript = this.nameToScript.get(name);
            if (!(currentScript instanceof RMLScriptDSL)) continue;
            RMLScriptDSL script = (RMLScriptDSL)currentScript;
            this.nameToVariablesManager.put(name, script.getStaticManager());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/rml/dfa/impl/scripts/ScriptManager", "getOutputRelations"));
    }
}

