/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.scripts;

import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.relations.RelationModificationKt;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.repositories.MutableRelationsRepository;
import com.intellij.rml.dfa.impl.scripts.VariablesManager;
import com.intellij.rml.dfa.impl.utils.ArrayHelper;
import com.intellij.rml.dfa.rml.dsl.lang.RelationModification;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.rml.dfa.utils.KeyWithDefault;
import com.intellij.rml.dfa.utils.RMLOptions;
import com.intellij.rml.dfa.utils.UtilsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class RuntimeVariablesManager {
    public static final KeyWithDefault<Boolean> STORE_TEMP_RELATIONS = new KeyWithDefault<Boolean>("STORE_TEMP_RELATIONS", false);
    public static final String SUMMARY_REL_SUFFIX = "$Summary";
    private final MutableRelationsRepository relationsRepository;
    private final RelationSignature[] outputRelations;
    private final RelationSignature[] summaryRelations;
    private final RelationSignature[] tempRelations;
    private final HashMap<String, IRelation> relations = new HashMap();
    private final HashMap<String, IRelation> summaryOutputRelations = new HashMap();
    private final HashMap<String, Domain> domains = new HashMap();
    private final HashMap<String, Object> variables = new HashMap();

    public RuntimeVariablesManager(MutableRelationsRepository relationsRepository, RMLOptions options, VariablesManager staticManager, IRelationsManager relationsManager) {
        String name;
        this.relationsRepository = relationsRepository;
        this.outputRelations = staticManager.getOutputRelations();
        this.summaryRelations = staticManager.getSummaryRelations();
        this.tempRelations = staticManager.getTempRelations();
        RelationSignature[] inputRelations = ArrayHelper.mergeArrays(staticManager.getInputRelations(), this.summaryRelations, RelationSignature.class);
        for (String name2 : staticManager.getVariables()) {
            if (staticManager.isOption(name2)) {
                if (options.contains(name2)) {
                    this.variables.put(name2, options.get(name2));
                    continue;
                }
                this.variables.put(name2, staticManager.getDefaultOptionValue(name2));
                continue;
            }
            this.variables.put(name2, 0);
        }
        for (RelationSignature inputRelation : inputRelations) {
            name = inputRelation.getName();
            IRelation relation = relationsRepository.containsRelation(name) ? relationsRepository.getRelation(name) : (name.equals("$emptyRelation") ? relationsManager.makeEmptyRelation(new DomainType[0]) : relationsManager.makeEmptyRelation(staticManager.getRelation(name)));
            for (RelationModification modification : staticManager.getInputRelationModifications(name)) {
                relation = RelationModificationKt.modify(relation, modification, staticManager.getTypeManager());
            }
            this.relations.put(name, relation);
        }
        for (RelationSignature outputRelation : this.outputRelations) {
            name = outputRelation.getName();
            if (this.relations.containsKey(name)) continue;
            this.relations.put(name, relationsManager.makeEmptyRelation(staticManager.getRelation(name)));
        }
        for (RelationSignature summaryRelation : this.summaryRelations) {
            name = summaryRelation.getName();
            this.summaryOutputRelations.put(name, relationsManager.makeEmptyRelation(staticManager.getRelation(name)));
        }
        for (int i = 0; i < this.tempRelations.length; ++i) {
            String name3 = staticManager.getTempRelations()[i].getName();
            if (this.relations.containsKey(name3)) continue;
            IRelation relation = relationsManager.makeEmptyRelation(staticManager.getRelation(name3));
            this.relations.put(name3, relation);
        }
    }

    public void storeOutputRelations(RMLOptions options, Cancellation cancellation) {
        ArrayList<RelationSignature> signatures = new ArrayList<RelationSignature>(Arrays.asList(this.outputRelations));
        if (options.get(STORE_TEMP_RELATIONS) == Boolean.TRUE) {
            signatures.addAll(Arrays.asList(this.tempRelations));
        }
        for (RelationSignature signature : signatures) {
            String name = signature.getName();
            IRelation relation = this.relations.get(name);
            relation = relation.fastRename(DomainType.getCorrespondingDomains(relation.getDomainTypes()), cancellation);
            this.relationsRepository.addRelation(name, relation);
        }
        for (RelationSignature signature : this.summaryRelations) {
            String name = signature.getName();
            IRelation relation = this.summaryOutputRelations.get(name);
            relation = relation.fastRename(DomainType.getCorrespondingDomains(relation.getDomainTypes()), cancellation);
            this.relationsRepository.addRelation(name + SUMMARY_REL_SUFFIX, relation);
            if (this.relationsRepository.containsRelation(name)) {
                this.relationsRepository.addRelation(name, this.relationsRepository.getRelation(name).unite(relation, cancellation));
                continue;
            }
            this.relationsRepository.addRelation(name, relation);
        }
    }

    public Domain[] getRelationDomains(String name) {
        return this.relations.get(name).getDomains();
    }

    public DomainType[] getRelationDomainTypes(String name) {
        return this.relations.get(name).getDomainTypes();
    }

    public IRelation getRelation(String name, Cancellation cancellation) {
        if (this.summaryOutputRelations.containsKey(name)) {
            return this.relations.get(name).unite(this.summaryOutputRelations.get(name), cancellation);
        }
        return this.relations.get(name);
    }

    public void storeRelation(String name, IRelation relation) {
        if (this.summaryOutputRelations.containsKey(name)) {
            this.summaryOutputRelations.put(name, relation);
        } else {
            this.relations.put(name, relation);
        }
    }

    public int getVariable(String name) {
        Object v = this.variables.get(name);
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            return UtilsKt.toInt(b);
        }
        return (Integer)v;
    }

    public void storeVariable(String name, int value) {
        this.variables.put(name, value);
    }

    public Domain getDomain(String name) {
        return this.domains.get(name);
    }

    public void storeDomain(String name, Domain domain) {
        this.domains.put(name, domain);
    }

    public void removeDomain(String name) {
        this.domains.remove(name);
    }
}

