/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.dsl.translator;

import com.intellij.rml.dfa.RmlParseException;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.scripts.VariablesManager;
import com.intellij.rml.dfa.rml.dsl.ast.RmlDeclarationType;
import com.intellij.rml.dfa.rml.dsl.ast.RmlOption;
import com.intellij.rml.dfa.rml.dsl.ast.RmlProgram;
import com.intellij.rml.dfa.rml.dsl.ast.RmlRelationDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0005\u001a\u00020\u0006*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/rml/dfa/impl/rml/dsl/translator/VariableManagerInitializer;", "", "manager", "Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;", "(Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;)V", "addDeclaration", "", "decl", "Lcom/intellij/rml/dfa/rml/dsl/ast/RmlRelationDeclaration;", "type", "Lcom/intellij/rml/dfa/rml/dsl/ast/RmlDeclarationType;", "subgroup", "", "initialize", "program", "Lcom/intellij/rml/dfa/rml/dsl/ast/RmlProgram;", "processDeclarations", "processOptions", "domainTypes", "", "Lcom/intellij/rml/dfa/impl/domains/DomainType;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nVariableManagerInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableManagerInitializer.kt\ncom/intellij/rml/dfa/impl/rml/dsl/translator/VariableManagerInitializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,78:1\n1855#2:79\n1855#2,2:80\n1856#2:82\n1855#2,2:83\n1855#2,2:85\n1855#2,2:87\n1855#2,2:89\n37#3,2:91\n37#3,2:93\n37#3,2:95\n37#3,2:97\n*S KotlinDebug\n*F\n+ 1 VariableManagerInitializer.kt\ncom/intellij/rml/dfa/impl/rml/dsl/translator/VariableManagerInitializer\n*L\n23#1:79\n25#1:80,2\n23#1:82\n36#1:83,2\n40#1:85,2\n44#1:87,2\n51#1:89,2\n68#1:91,2\n70#1:93,2\n72#1:95,2\n74#1:97,2\n*E\n"})
public final class VariableManagerInitializer {
    @NotNull
    private final VariablesManager manager;

    public VariableManagerInitializer(@NotNull VariablesManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
    }

    public final void initialize(@NotNull RmlProgram program2) {
        Intrinsics.checkNotNullParameter((Object)program2, (String)"program");
        this.processDeclarations(program2);
        this.processOptions(program2);
    }

    private final void processOptions(RmlProgram program2) {
        for (RmlOption option : program2.getOptions()) {
            this.manager.addOption(option.getName(), option.getDefaultValue(), option.getType().ordinal());
        }
    }

    private final void processDeclarations(RmlProgram program2) {
        Iterable $this$forEach$iv = program2.getInputDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RmlRelationDeclaration inputDecl = (RmlRelationDeclaration)element$iv;
            boolean bl = false;
            List domainTypes = new ArrayList();
            Iterable $this$forEach$iv2 = inputDecl.getDomainNames();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String domainName = (String)element$iv2;
                boolean bl2 = false;
                if (!this.manager.containsDomainType(domainName)) {
                    throw new RmlParseException("Domain type " + domainName + " is not available (should be registered in KnownDomainTypes)", null, 2, null);
                }
                DomainType domainType = this.manager.getDomainType(domainName);
                Intrinsics.checkNotNullExpressionValue((Object)domainType, (String)"getDomainType(...)");
                domainTypes.add(domainType);
            }
            this.addDeclaration(this.manager, inputDecl, RmlDeclarationType.INPUT, domainTypes);
        }
        $this$forEach$iv = program2.getOutputDeclarations();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RmlRelationDeclaration outputDecl = (RmlRelationDeclaration)element$iv;
            boolean bl = false;
            this.addDeclaration(outputDecl, RmlDeclarationType.OUTPUT, program2.getRelationSubgroups().get(outputDecl.getRelationName()));
        }
        $this$forEach$iv = program2.getSummaryDeclarations();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RmlRelationDeclaration summaryDecl = (RmlRelationDeclaration)element$iv;
            boolean bl = false;
            this.addDeclaration(summaryDecl, RmlDeclarationType.SUMMARY, program2.getRelationSubgroups().get(summaryDecl.getRelationName()));
        }
        $this$forEach$iv = program2.getTempDeclarations();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RmlRelationDeclaration tempDecl = (RmlRelationDeclaration)element$iv;
            boolean bl = false;
            this.addDeclaration(tempDecl, RmlDeclarationType.TEMP, program2.getRelationSubgroups().get(tempDecl.getRelationName()));
        }
    }

    private final void addDeclaration(RmlRelationDeclaration decl, RmlDeclarationType type, String subgroup) {
        List domainTypes = new ArrayList();
        Iterable $this$forEach$iv = decl.getDomainNames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String domainName = (String)element$iv;
            boolean bl = false;
            DomainType domainType = this.manager.getDomainType(domainName);
            if (domainType == null) {
                throw new RmlParseException("Domain type " + domainName + " must be present in the input relations", null, 2, null);
            }
            DomainType domainType2 = domainType;
            domainTypes.add(domainType2);
        }
        this.addDeclaration(this.manager, decl, type, domainTypes);
        if (subgroup != null) {
            this.manager.setRelationSubgroup(decl.getRelationName(), subgroup);
        }
    }

    private final void addDeclaration(VariablesManager $this$addDeclaration, RmlRelationDeclaration decl, RmlDeclarationType type, List<? extends DomainType> domainTypes) {
        if ($this$addDeclaration.containsRelation(decl.getRelationName())) {
            throw new RmlParseException("Redeclared " + type + " relation " + decl.getRelationName(), null, 2, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Collection $this$toTypedArray$iv = domainTypes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$addDeclaration.addInputRelation(new RelationSignature(decl.getRelationName(), thisCollection$iv.toArray(new DomainType[0])), decl.getModifications());
                break;
            }
            case 2: {
                Collection $this$toTypedArray$iv = domainTypes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$addDeclaration.addOutputRelation(new RelationSignature(decl.getRelationName(), thisCollection$iv.toArray(new DomainType[0])));
                break;
            }
            case 3: {
                Collection $this$toTypedArray$iv = domainTypes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$addDeclaration.addSummaryRelation(new RelationSignature(decl.getRelationName(), thisCollection$iv.toArray(new DomainType[0])));
                break;
            }
            case 4: {
                Collection $this$toTypedArray$iv = domainTypes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$addDeclaration.addTempRelation(new RelationSignature(decl.getRelationName(), thisCollection$iv.toArray(new DomainType[0])));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RmlDeclarationType.values().length];
            try {
                nArray[RmlDeclarationType.INPUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlDeclarationType.OUTPUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlDeclarationType.SUMMARY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlDeclarationType.TEMP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

