/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.dsl.translator;

import com.intellij.rml.dfa.RmlParseException;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.Expr;
import com.intellij.rml.dfa.impl.rml.ast.ExprBinary;
import com.intellij.rml.dfa.impl.rml.ast.ExprRelCompare;
import com.intellij.rml.dfa.impl.rml.ast.ExprUnary;
import com.intellij.rml.dfa.impl.rml.ast.ExprVar;
import com.intellij.rml.dfa.impl.scripts.VariablesManager;
import com.intellij.rml.dfa.rml.dsl.ast.ComparisonBinOp;
import com.intellij.rml.dfa.rml.dsl.ast.RmlBooleanBinary;
import com.intellij.rml.dfa.rml.dsl.ast.RmlBooleanExpression;
import com.intellij.rml.dfa.rml.dsl.ast.RmlBooleanNegation;
import com.intellij.rml.dfa.rml.dsl.ast.RmlBooleanVar;
import com.intellij.rml.dfa.rml.dsl.ast.RmlRelationComparisonExpr;
import com.intellij.rml.dfa.rml.dsl.ast.RmlRelationComparisonWithConstExpr;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/rml/dfa/impl/rml/dsl/translator/RmlBooleanExpressionTranslator;", "", "context", "Lcom/intellij/rml/dfa/impl/rml/ast/Context;", "manager", "Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;", "(Lcom/intellij/rml/dfa/impl/rml/ast/Context;Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;)V", "translate", "Lcom/intellij/rml/dfa/impl/rml/ast/Expr;", "expr", "Lcom/intellij/rml/dfa/rml/dsl/ast/RmlBooleanExpression;", "toExprRelCompareType", "", "Lcom/intellij/rml/dfa/rml/dsl/ast/ComparisonBinOp;", "intellij.rml.dfa.impl"})
public final class RmlBooleanExpressionTranslator {
    @NotNull
    private final Context context;
    @NotNull
    private final VariablesManager manager;

    public RmlBooleanExpressionTranslator(@NotNull Context context, @NotNull VariablesManager manager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.context = context;
        this.manager = manager;
    }

    @NotNull
    public final Expr translate(@NotNull RmlBooleanExpression expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        RmlBooleanExpression rmlBooleanExpression = expr;
        if (rmlBooleanExpression instanceof RmlBooleanVar) {
            return new ExprVar(((RmlBooleanVar)expr).getName(), this.context);
        }
        if (rmlBooleanExpression instanceof RmlRelationComparisonExpr) {
            Object[] rightDomains;
            Object[] leftDomains = this.manager.getRelation(((RmlRelationComparisonExpr)expr).getLeftRelName());
            if (!Arrays.equals(leftDomains, rightDomains = this.manager.getRelation(((RmlRelationComparisonExpr)expr).getRightRelName()))) {
                throw new RmlParseException("Relations " + ((RmlRelationComparisonExpr)expr).getLeftRelName() + " and " + ((RmlRelationComparisonExpr)expr).getRightRelName() + " are not comparable", null, 2, null);
            }
            int opCode = this.toExprRelCompareType(((RmlRelationComparisonExpr)expr).getType());
            return new ExprRelCompare(opCode, ((RmlRelationComparisonExpr)expr).getLeftRelName(), ((RmlRelationComparisonExpr)expr).getRightRelName(), this.context);
        }
        if (rmlBooleanExpression instanceof RmlRelationComparisonWithConstExpr) {
            int opCode = this.toExprRelCompareType(((RmlRelationComparisonWithConstExpr)expr).getType());
            return new ExprRelCompare(opCode, ((RmlRelationComparisonWithConstExpr)expr).getRelName(), ((RmlRelationComparisonWithConstExpr)expr).getConstant(), this.context);
        }
        if (rmlBooleanExpression instanceof RmlBooleanNegation) {
            return new ExprUnary(1, this.translate(((RmlBooleanNegation)expr).getExpr()), this.context);
        }
        if (rmlBooleanExpression instanceof RmlBooleanBinary) {
            return new ExprBinary(switch (WhenMappings.$EnumSwitchMapping$0[((RmlBooleanBinary)expr).getBinOp().ordinal()]) {
                case 1 -> 0;
                case 2 -> 5;
                default -> throw new NoWhenBranchMatchedException();
            }, this.translate(((RmlBooleanBinary)expr).getLeft()), this.translate(((RmlBooleanBinary)expr).getRight()), this.context);
        }
        throw new NoWhenBranchMatchedException();
    }

    private final int toExprRelCompareType(ComparisonBinOp $this$toExprRelCompareType) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toExprRelCompareType.ordinal()]) {
            case 1 -> 4;
            case 2 -> 5;
            case 3 -> 0;
            case 4 -> 1;
            case 5 -> 2;
            case 6 -> 3;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RmlBooleanBinary.BinOp.values().length];
            try {
                nArray[RmlBooleanBinary.BinOp.OR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlBooleanBinary.BinOp.AND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ComparisonBinOp.values().length];
            try {
                nArray[ComparisonBinOp.EQ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparisonBinOp.NEQ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparisonBinOp.LESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparisonBinOp.LESS_OR_EQ.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparisonBinOp.GREATER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparisonBinOp.GREATER_OR_EQ.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

