/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.Expr;
import com.intellij.rml.dfa.impl.rml.ast.Stmt;
import com.intellij.rml.dfa.impl.rml.ast.StmtTransformer;
import com.intellij.rml.dfa.impl.rml.ast.StmtVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;

public class StmtWhile
extends Stmt {
    private final Expr cond;
    private Stmt stmt;

    public StmtWhile(Expr cond, Stmt stmt, Context context) {
        super(context, stmt);
        this.cond = cond;
        this.stmt = stmt;
    }

    @Override
    public void accept(StmtVisitor visitor) {
        if (visitor.visitWhileStart(this)) {
            this.stmt.accept(visitor);
        }
        visitor.visitWhileEnd(this);
    }

    @Override
    public Stmt transform(StmtTransformer transformer) {
        this.stmt = this.stmt.transform(transformer);
        return transformer.transformWhile(this);
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        while (this.cond.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) != 0) {
            cancellation.checkCancelled();
            this.stmt.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
        }
    }

    @Override
    public String toLongString() {
        return "StmtWhile{cond=" + this.cond.toLongString() + ", stmt=" + this.stmt.toLongString() + "}";
    }
}

