/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprBinary;
import com.intellij.rml.dfa.impl.rml.ast.RelExprTransformer;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.ProfilePoint;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManagerKt;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;

public class RelExprUnary
extends RelExpr {
    public static final int NOT = 0;
    public static final int TC = 1;
    private RelExpr operand;
    private final int opCode;

    public RelExprUnary(RelExpr operand, int opCode, Context context) {
        super(context, operand);
        this.operand = operand;
        this.opCode = opCode;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public RelExpr getOperand() {
        return this.operand;
    }

    @Override
    public void accept(RelExprVisitor visitor) {
        if (visitor.visitUnaryStart(this)) {
            this.operand.accept(visitor);
        }
        visitor.visitUnaryEnd(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        this.operand = this.operand.transform(transformer);
        return transformer.transformUnary(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        return this.operand.getDomains(variablesManager, domainsPool);
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        IRelation cached = variablesManager.getRelation(this.getResultCacheRelName(), cancellation);
        if (this.canBeCached && cached != null) {
            return cached.getClone();
        }
        ProfilePoint start = RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager);
        IRelation opResult = this.operand.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
        IRelation result = this.opCode == 0 ? opResult.complement(cancellation) : opResult.transitiveClosure(cancellation);
        opResult.kill();
        if (profileManager2 != null) {
            profileManager2.addDuration(this, start, RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager));
        }
        variablesManager.storeRelation(this.getResultCacheRelName(), result.getClone());
        return result;
    }

    @Override
    public String toLongString() {
        return "RelExprUnary{operand=" + this.operand.toLongString() + ", opCode=" + this.opCode + "}";
    }

    @Override
    public String toShortString() {
        Object operandStr = this.operand.toShortString();
        if (this.operand instanceof RelExprBinary) {
            operandStr = "(" + (String)operandStr + ")";
        }
        return (this.opCode == 0 ? "!" : "TC ") + (String)operandStr;
    }
}

