/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.QueryNode;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprBinary;
import com.intellij.rml.dfa.impl.rml.ast.RelExprTransformer;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.ProfilePoint;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManagerKt;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class RelExprQuantify
extends RelExpr {
    public static final int EXIST = 0;
    public static final int FOR_ALL = 1;
    private final int opCode;
    private final String quantifier;
    private RelExpr expr;
    private final DomainType domainType;

    public RelExprQuantify(int opCode, String quantifier, DomainType domainType, RelExpr expr, Context context) {
        super(context, expr);
        this.opCode = opCode;
        this.quantifier = quantifier;
        this.expr = expr;
        this.domainType = domainType;
    }

    public String getQuantifier() {
        return this.quantifier;
    }

    public RelExpr getOperand() {
        return this.expr;
    }

    public DomainType getDomainType() {
        return this.domainType;
    }

    public int getOpCode() {
        return this.opCode;
    }

    @Override
    public void accept(RelExprVisitor visitor) {
        if (visitor.visitQuantifyStart(this)) {
            this.expr.accept(visitor);
        }
        visitor.visitQuantifyEnd(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        this.expr = this.expr.transform(transformer);
        return transformer.transformQuantify(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        Domain domain = this.pushDomain(variablesManager, domainsPool);
        ArrayList<Domain> domains2 = new ArrayList<Domain>(Arrays.asList(this.expr.getDomains(variablesManager, domainsPool)));
        domains2.remove(domain);
        this.popDomain(variablesManager);
        return domains2.toArray(new Domain[0]);
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        IRelation result;
        IRelation cached = variablesManager.getRelation(this.getResultCacheRelName(), cancellation);
        if (this.canBeCached && cached != null) {
            return cached.getClone();
        }
        ProfilePoint start = RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager);
        Domain domain = this.pushDomain(variablesManager, domainsPool);
        if (this.opCode == 0) {
            IRelation opResult = this.expr.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
            result = opResult.exists(domain, cancellation);
            opResult.kill();
        } else if (this.opCode == 1) {
            ArrayList<RelExprQuantify> quantifiers = new ArrayList<RelExprQuantify>();
            RelExpr curExpr = this;
            while (curExpr instanceof RelExprQuantify && curExpr.opCode == 1) {
                quantifiers.add(0, (RelExprQuantify)curExpr);
                curExpr = curExpr.expr;
            }
            if (curExpr instanceof RelExprBinary && ((RelExprBinary)curExpr).getOpCode() == 2) {
                ArrayList<Domain> domains2 = new ArrayList<Domain>();
                for (RelExprQuantify quantifier : quantifiers) {
                    if (quantifier != this) {
                        domains2.add(quantifier.pushDomain(variablesManager, domainsPool));
                        continue;
                    }
                    domains2.add(domain);
                }
                IRelation leftResult = ((RelExprBinary)curExpr).getLeftOperand().interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
                IRelation rightResult = ((RelExprBinary)curExpr).getRightOperand().interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
                IRelation rightResultComplement = rightResult.complement(cancellation);
                IRelation faComplement = leftResult.unsafeIntersect(rightResultComplement, cancellation);
                if (profileManager2 != null) {
                    profileManager2.addDuration(curExpr, start, RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager));
                }
                for (int i = 0; i < quantifiers.size(); ++i) {
                    IRelation faOld = faComplement;
                    faComplement = faComplement.exists((Domain)domains2.get(i), cancellation);
                    faOld.kill();
                    if (profileManager2 == null || quantifiers.get(i) == this) continue;
                    profileManager2.addDuration((QueryNode)quantifiers.get(i), start, RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager));
                }
                result = faComplement.complement(cancellation);
                faComplement.kill();
                rightResultComplement.kill();
                rightResult.kill();
                for (RelExprQuantify quantifier : quantifiers) {
                    if (quantifier == this) continue;
                    quantifier.popDomain(variablesManager);
                }
            } else {
                IRelation opResult = this.expr.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
                IRelation opNotResult = opResult.complement(cancellation);
                IRelation oldResult = result = opNotResult.exists(domain, cancellation);
                result = result.complement(cancellation);
                opResult.kill();
                opNotResult.kill();
                oldResult.kill();
            }
        } else {
            throw new DfaInternalException("Unknown op code " + this.opCode);
        }
        this.popDomain(variablesManager);
        if (profileManager2 != null) {
            profileManager2.addDuration(this, start, RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager));
        }
        variablesManager.storeRelation(this.getResultCacheRelName(), result.getClone());
        return result;
    }

    @Nullable
    public Domain pushDomain(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        Domain domain = domainsPool.getDomain(this, this.quantifier);
        variablesManager.storeDomain(this.quantifier, domain);
        return domain;
    }

    public void popDomain(RuntimeVariablesManager variablesManager) {
        variablesManager.removeDomain(this.quantifier);
    }

    @Override
    public String toLongString() {
        return "RelExprQuantify{opCode=" + this.opCode + ", quantifier='" + this.quantifier + "', expr=" + this.expr.toLongString() + ", type=" + this.domainType.getName() + "}";
    }

    @Override
    public String toShortString() {
        return (this.opCode == 0 ? "EX.(" : "FA.(") + this.expr.toShortString() + ")";
    }
}

