/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml;

import com.intellij.rml.dfa.RmlParseException;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.rml.ast.QueryNode;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprBinary;
import com.intellij.rml.dfa.impl.rml.ast.RelExprPredefinedPredicate;
import com.intellij.rml.dfa.impl.rml.ast.RelExprQuantify;
import com.intellij.rml.dfa.impl.rml.ast.RelExprUnary;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVar;
import com.intellij.rml.dfa.impl.rml.ast.Stmt;
import com.intellij.rml.dfa.impl.rml.ast.StmtIncrementalize;
import com.intellij.rml.dfa.impl.rml.ast.StmtRelAssign;
import com.intellij.rml.dfa.impl.rml.ast.StmtVisitor;
import com.intellij.rml.dfa.impl.scripts.VariablesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006\f"}, d2={"checkForSemiNaive", "", "stmt", "Lcom/intellij/rml/dfa/impl/rml/ast/Stmt;", "varManager", "Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;", "getLoopDependentRelations", "", "", "loop", "Lcom/intellij/rml/dfa/impl/rml/ast/StmtIncrementalize;", "exclude", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nSemiNaiveHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemiNaiveHandler.kt\ncom/intellij/rml/dfa/impl/rml/SemiNaiveHandlerKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,141:1\n11065#2:142\n11400#2,3:143\n*S KotlinDebug\n*F\n+ 1 SemiNaiveHandler.kt\ncom/intellij/rml/dfa/impl/rml/SemiNaiveHandlerKt\n*L\n40#1:142\n40#1:143,3\n*E\n"})
public final class SemiNaiveHandlerKt {
    private static final Set<String> getLoopDependentRelations(StmtIncrementalize loop, Set<String> exclude) {
        Set result = new LinkedHashSet();
        Collection collection = result;
        String[] stringArray = loop.getRelations();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getRelations(...)");
        CollectionsKt.addAll((Collection)collection, (Object[])stringArray);
        Ref.BooleanRef changes = new Ref.BooleanRef();
        changes.element = true;
        while (changes.element) {
            changes.element = false;
            loop.accept(new StmtVisitor(result, exclude, changes){
                final /* synthetic */ Set<String> $result;
                final /* synthetic */ Set<String> $exclude;
                final /* synthetic */ Ref.BooleanRef $changes;
                {
                    this.$result = $result;
                    this.$exclude = $exclude;
                    this.$changes = $changes;
                }

                public void visitRelAssignEnd(@NotNull StmtRelAssign stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    if (this.$result.contains(stmt.getRelName()) || this.$exclude.contains(stmt.getRelName())) {
                        return;
                    }
                    Ref.BooleanRef depends = new Ref.BooleanRef();
                    stmt.getExpr().accept(new StmtVisitor(this.$result, depends){
                        final /* synthetic */ Set<String> $result;
                        final /* synthetic */ Ref.BooleanRef $depends;
                        {
                            this.$result = $result;
                            this.$depends = $depends;
                        }

                        public void visitVar(@NotNull RelExprVar expr) {
                            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                            if (this.$result.contains(expr.getRelName())) {
                                this.$depends.element = true;
                            }
                        }
                    });
                    if (depends.element) {
                        ((Collection)this.$result).add(stmt.getRelName());
                        this.$changes.element = true;
                    }
                }
            });
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkForSemiNaive(@NotNull Stmt stmt, @NotNull VariablesManager varManager) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter((Object)varManager, (String)"varManager");
        RelationSignature[] relationSignatureArray = varManager.getTempRelations();
        Intrinsics.checkNotNullExpressionValue((Object)relationSignatureArray, (String)"getTempRelations(...)");
        Object[] $this$map$iv = relationSignatureArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RelationSignature relationSignature = (RelationSignature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Set cumulativeSumRelations = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        Map loopDependentRelations = new LinkedHashMap();
        Map loopIncrementalizableRelations = new LinkedHashMap();
        stmt.accept(new StmtVisitor(cumulativeSumRelations){
            final /* synthetic */ Set<String> $cumulativeSumRelations;
            {
                this.$cumulativeSumRelations = $cumulativeSumRelations;
            }

            public void visitRelAssignEnd(@NotNull StmtRelAssign stmt) {
                block5: {
                    RelExpr expr;
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                        expr = stmt.getExpr();
                        if (!(expr instanceof RelExprBinary) || ((RelExprBinary)expr).getOpCode() != 0 && ((RelExprBinary)expr).getOpCode() != 1 || !(((RelExprBinary)expr).getLeft() instanceof RelExprVar)) break block4;
                        RelExpr relExpr = ((RelExprBinary)expr).getLeft();
                        Intrinsics.checkNotNull((Object)relExpr, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.rml.ast.RelExprVar");
                        if (Intrinsics.areEqual((Object)((RelExprVar)relExpr).getRelName(), (Object)stmt.getRelName())) break block5;
                    }
                    if (!(expr instanceof RelExprPredefinedPredicate)) {
                        ((Collection)this.$cumulativeSumRelations).remove(stmt.getRelName());
                    }
                }
            }
        });
        stmt.accept(new StmtVisitor(loopDependentRelations, loopIncrementalizableRelations, cumulativeSumRelations){
            final /* synthetic */ Map<StmtIncrementalize, Set<String>> $loopDependentRelations;
            final /* synthetic */ Map<StmtIncrementalize, Set<String>> $loopIncrementalizableRelations;
            final /* synthetic */ Set<String> $cumulativeSumRelations;
            {
                this.$loopDependentRelations = $loopDependentRelations;
                this.$loopIncrementalizableRelations = $loopIncrementalizableRelations;
                this.$cumulativeSumRelations = $cumulativeSumRelations;
            }

            public void visitIncrementalizeEnd(@NotNull StmtIncrementalize stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                this.$loopDependentRelations.put(stmt, SemiNaiveHandlerKt.access$getLoopDependentRelations(stmt, SetsKt.emptySet()));
                this.$loopIncrementalizableRelations.put(stmt, SemiNaiveHandlerKt.access$getLoopDependentRelations(stmt, this.$cumulativeSumRelations));
            }
        });
        stmt.accept(new StmtVisitor(loopIncrementalizableRelations, loopDependentRelations){
            @NotNull
            private final Stack<StmtIncrementalize> loopStack;
            @NotNull
            private final Map<RelExpr, StmtIncrementalize> closestDependentLoop;
            @NotNull
            private final Map<RelExpr, StmtIncrementalize> closestIncrementalizableLoop;
            final /* synthetic */ Map<StmtIncrementalize, Set<String>> $loopIncrementalizableRelations;
            final /* synthetic */ Map<StmtIncrementalize, Set<String>> $loopDependentRelations;
            {
                this.$loopIncrementalizableRelations = $loopIncrementalizableRelations;
                this.$loopDependentRelations = $loopDependentRelations;
                this.loopStack = new Stack<E>();
                this.closestDependentLoop = new LinkedHashMap<K, V>();
                this.closestIncrementalizableLoop = new LinkedHashMap<K, V>();
            }

            @NotNull
            public final Stack<StmtIncrementalize> getLoopStack() {
                return this.loopStack;
            }

            @NotNull
            public final Map<RelExpr, StmtIncrementalize> getClosestDependentLoop() {
                return this.closestDependentLoop;
            }

            @NotNull
            public final Map<RelExpr, StmtIncrementalize> getClosestIncrementalizableLoop() {
                return this.closestIncrementalizableLoop;
            }

            public boolean visitIncrementalizeStart(@NotNull StmtIncrementalize stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                this.loopStack.push(stmt);
                return true;
            }

            public void visitIncrementalizeEnd(@NotNull StmtIncrementalize stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                this.loopStack.pop();
            }

            public void visitExpr(@NotNull RelExpr expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                this.findClosestLoop(expr, this.closestDependentLoop);
                this.findClosestLoop(expr, this.closestIncrementalizableLoop);
                expr.setCanBeCached(this.closestDependentLoop.get(expr) == null && !this.loopStack.isEmpty());
            }

            /*
             * WARNING - void declaration
             */
            private final void findClosestLoop(RelExpr expr, Map<RelExpr, StmtIncrementalize> loopMap) {
                void $this$filterIsInstanceTo$iv$iv;
                StmtIncrementalize closestDependentLoop = null;
                QueryNode[] queryNodeArray = expr.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)queryNodeArray, (String)"getChildren(...)");
                Object[] $this$filterIsInstance$iv = queryNodeArray;
                boolean $i$f$filterIsInstance = false;
                Object[] objectArray = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof RelExpr)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (RelExpr child : (List)destination$iv$iv) {
                    StmtIncrementalize curLoop = loopMap.get(child);
                    if (closestDependentLoop != null && (curLoop == null || this.loopStack.indexOf(curLoop) <= this.loopStack.indexOf(closestDependentLoop))) continue;
                    closestDependentLoop = curLoop;
                }
                if (closestDependentLoop != null) {
                    loopMap.put(expr, closestDependentLoop);
                }
            }

            public void visitVar(@NotNull RelExprVar expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                for (StmtIncrementalize loop : CollectionsKt.reversed((Iterable)this.loopStack)) {
                    Set<String> set = this.$loopIncrementalizableRelations.get(loop);
                    Intrinsics.checkNotNull(set);
                    if (!set.contains(expr.getRelName())) continue;
                    Intrinsics.checkNotNull((Object)loop);
                    this.closestIncrementalizableLoop.put(expr, loop);
                    break;
                }
                for (StmtIncrementalize loop : CollectionsKt.reversed((Iterable)this.loopStack)) {
                    Set<String> set = this.$loopDependentRelations.get(loop);
                    Intrinsics.checkNotNull(set);
                    if (!set.contains(expr.getRelName())) continue;
                    Intrinsics.checkNotNull((Object)loop);
                    this.closestDependentLoop.put(expr, loop);
                    break;
                }
                super.visitVar(expr);
            }

            public void visitUnaryEnd(@NotNull RelExprUnary expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                super.visitUnaryEnd(expr);
                if (!expr.isDisableSemiNaive() && this.closestIncrementalizableLoop.containsKey(expr)) {
                    throw new RmlParseException("Negation of incrementalized relation: " + expr.toShortString(), null, 2, null);
                }
            }

            public void visitQuantifyEnd(@NotNull RelExprQuantify expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                super.visitQuantifyEnd(expr);
                if (expr.getOpCode() == 1 && !expr.isDisableSemiNaive() && this.closestIncrementalizableLoop.containsKey(expr)) {
                    throw new RmlParseException("Negation of incrementalized relation: " + expr.toShortString(), null, 2, null);
                }
            }

            public void visitBinaryEnd(@NotNull RelExprBinary expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                super.visitBinaryEnd(expr);
                if (!expr.isDisableSemiNaive() && (expr.getOpCode() == 3 && this.closestIncrementalizableLoop.containsKey(expr.getRight()) || expr.getOpCode() == 2 && this.closestIncrementalizableLoop.containsKey(expr.getLeft()))) {
                    throw new RmlParseException("Negation of incrementalized relation: " + expr.toShortString(), null, 2, null);
                }
                if (!expr.isDisableSemiNaive() && expr.getOpCode() == 1 && this.closestIncrementalizableLoop.containsKey(expr.getLeft()) && this.closestIncrementalizableLoop.containsKey(expr.getRight())) {
                    expr.setSemiNaive(true);
                }
            }
        });
    }

    public static final /* synthetic */ Set access$getLoopDependentRelations(StmtIncrementalize loop, Set exclude) {
        return SemiNaiveHandlerKt.getLoopDependentRelations(loop, exclude);
    }
}

