/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.repositories;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.repositories.RelationsRepository;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutableRelationsRepository
implements RelationsRepository {
    private final SymbolTable symbolTable;
    private final HashMap<String, IRelation> nameToRelationMap = new HashMap();
    protected IRelationsManager relationsManager;

    public MutableRelationsRepository(IRelationsManager relationsManager, SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.relationsManager = relationsManager;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public IRelationsManager getRelationsManager() {
        return this.relationsManager;
    }

    @Override
    public String[] getAvailableRelations() {
        return ArrayUtil.toStringArray(this.nameToRelationMap.keySet());
    }

    @Override
    public boolean containsRelation(String name) {
        return this.nameToRelationMap.containsKey(name);
    }

    @Override
    @NotNull
    public IRelation getRelation(String name) {
        IRelation relation = this.getRelationOrNull(name);
        if (relation == null) {
            throw new DfaInternalException("Relation " + name + " doesn't exist");
        }
        IRelation iRelation = relation;
        if (iRelation == null) {
            MutableRelationsRepository.$$$reportNull$$$0(0);
        }
        return iRelation;
    }

    @Override
    @Nullable
    public IRelation getRelationOrNull(String name) {
        IRelation relation = this.nameToRelationMap.get(name);
        if (relation == null) {
            return null;
        }
        return this.relationsManager.makeRepositoryRelation(relation, name);
    }

    public void addRelation(String name, IRelation relation) {
        this.nameToRelationMap.put(name, relation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/rml/dfa/impl/repositories/MutableRelationsRepository", "getRelation"));
    }
}

