/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.ir.cfg;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.ir.cfg.IrCFGBlockImpl;
import com.intellij.rml.dfa.impl.ir.cfg.IrCfgRegionBuilderImpl;
import com.intellij.rml.dfa.ir.ast.IrCondition;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfgBuilder;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.ir.cfg.IrUnconditionalJump;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/rml/dfa/impl/ir/cfg/IrCfgBuilderImpl;", "Lcom/intellij/rml/dfa/impl/ir/cfg/IrCfgRegionBuilderImpl;", "Lcom/intellij/rml/dfa/ir/cfg/IrCfgBuilder;", "()V", "lastAddedBlock", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "getLastAddedBlock", "()Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "addBlock", "createBlock", "setConditionalJump", "", "from", "trueBranch", "falseBranch", "condition", "Lcom/intellij/rml/dfa/ir/ast/IrCondition;", "setJump", "jump", "Lcom/intellij/rml/dfa/ir/cfg/IrJump;", "setUnconditionalJump", "to", "intellij.rml.dfa.impl"})
public final class IrCfgBuilderImpl
extends IrCfgRegionBuilderImpl
implements IrCfgBuilder {
    @Override
    @NotNull
    public IrCFGBlock getLastAddedBlock() {
        return this.getLastBlock();
    }

    @Override
    @NotNull
    public IrCFGBlock addBlock() {
        if (this.getLastBlock().getInstructions().isEmpty()) {
            return this.getLastBlock();
        }
        IrCFGBlockImpl newExitBlock = new IrCFGBlockImpl(null, 1, null);
        this.getJumps().put((IrCFGBlock)CollectionsKt.last(this.getBlocks()), new IrUnconditionalJump(newExitBlock));
        ((Collection)this.getBlocks()).add(newExitBlock);
        this.setLastBlock(newExitBlock);
        return newExitBlock;
    }

    @Override
    @NotNull
    public IrCFGBlock createBlock() {
        IrCFGBlockImpl irCFGBlockImpl;
        IrCFGBlockImpl it = irCFGBlockImpl = new IrCFGBlockImpl(null, 1, null);
        boolean bl = false;
        ((Collection)this.getBlocks()).add(it);
        this.setLastBlock(it);
        return irCFGBlockImpl;
    }

    @Override
    public void setJump(@NotNull IrCFGBlock from, @NotNull IrJump jump) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        if (this.getJumps().containsKey(from)) {
            throw new DfaInternalException("Jump from block \n" + from + "\n already exists");
        }
        this.getJumps().put(from, jump);
    }

    @Override
    public void setUnconditionalJump(@NotNull IrCFGBlock from, @NotNull IrCFGBlock to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.setJump(from, new IrUnconditionalJump(to));
    }

    @Override
    public void setConditionalJump(@NotNull IrCFGBlock from, @NotNull IrCFGBlock trueBranch, @NotNull IrCFGBlock falseBranch, @NotNull IrCondition condition) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)trueBranch, (String)"trueBranch");
        Intrinsics.checkNotNullParameter((Object)falseBranch, (String)"falseBranch");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        this.setJump(from, new IrConditionalJump(condition, trueBranch, falseBranch));
    }
}

