/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.domains;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.ui.Messages;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/rml/dfa/impl/domains/AttributesInfo;", "", "domainType", "Lcom/intellij/rml/dfa/impl/domains/DomainType;", "numOfAttributes", "", "bitLength", "(Lcom/intellij/rml/dfa/impl/domains/DomainType;II)V", "getBitLength", "()I", "setBitLength", "(I)V", "getDomainType", "()Lcom/intellij/rml/dfa/impl/domains/DomainType;", "getNumOfAttributes", "setNumOfAttributes", "addAttribute", "addAttributes", "", "attributesCnt", "deserialize", "in", "Ljava/io/ObjectInputStream;", "extendDomainType", "serialize", "out", "Ljava/io/ObjectOutputStream;", "Companion", "intellij.rml.dfa.impl"})
public final class AttributesInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DomainType domainType;
    private int numOfAttributes;
    private int bitLength;
    private static final int START_BIT_LENGTH = 2;
    private static final int BIT_LENGTH_INCREASE_STEP = 1;

    public AttributesInfo(@NotNull DomainType domainType, int numOfAttributes, int bitLength) {
        Intrinsics.checkNotNullParameter((Object)domainType, (String)"domainType");
        this.domainType = domainType;
        this.numOfAttributes = numOfAttributes;
        this.bitLength = bitLength;
    }

    @NotNull
    public final DomainType getDomainType() {
        return this.domainType;
    }

    public final int getNumOfAttributes() {
        return this.numOfAttributes;
    }

    public final void setNumOfAttributes(int n) {
        this.numOfAttributes = n;
    }

    public final int getBitLength() {
        return this.bitLength;
    }

    public final void setBitLength(int n) {
        this.bitLength = n;
    }

    public final int addAttribute() {
        int n = this.numOfAttributes;
        this.numOfAttributes = n + 1;
        if (1 << this.bitLength < this.numOfAttributes * 2) {
            this.extendDomainType();
        }
        return this.numOfAttributes - 1;
    }

    public final void addAttributes(int attributesCnt) {
        this.numOfAttributes += attributesCnt;
        while (1 << this.bitLength < this.numOfAttributes * 2) {
            this.extendDomainType();
        }
    }

    private final void extendDomainType() {
        ++this.bitLength;
        if (this.bitLength > 30 || this.domainType.getFixedBitLength() != -1) {
            String string = Messages.getString(DomainType.class.getName() + "-1");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            throw new DfaInternalException(string);
        }
    }

    public final void serialize(@NotNull ObjectOutputStream out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(this.numOfAttributes);
        out.writeInt(this.bitLength);
    }

    public final void deserialize(@NotNull ObjectInputStream in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this.numOfAttributes = in.readInt();
        this.bitLength = in.readInt();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/rml/dfa/impl/domains/AttributesInfo$Companion;", "", "()V", "BIT_LENGTH_INCREASE_STEP", "", "START_BIT_LENGTH", "create", "Lcom/intellij/rml/dfa/impl/domains/AttributesInfo;", "info", "domainType", "Lcom/intellij/rml/dfa/impl/domains/DomainType;", "intellij.rml.dfa.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributesInfo create(@NotNull DomainType domainType) {
            Intrinsics.checkNotNullParameter((Object)domainType, (String)"domainType");
            return domainType.getFixedBitLength() != -1 ? new AttributesInfo(domainType, 1 << domainType.getFixedBitLength(), domainType.getFixedBitLength()) : new AttributesInfo(domainType, 0, 2);
        }

        @NotNull
        public final AttributesInfo create(@NotNull AttributesInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return new AttributesInfo(info.getDomainType(), info.getNumOfAttributes(), info.getBitLength());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

