/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl;

import com.intellij.rml.dfa.AnalysisMode;
import com.intellij.rml.dfa.AnalysisOptions;
import com.intellij.rml.dfa.BaseRelationKind;
import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.RMLAnalysisDescription;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.repositories.HypoteticRelationsRepository;
import com.intellij.rml.dfa.impl.scripts.Script;
import com.intellij.rml.dfa.impl.scripts.ScriptCompileCache;
import com.intellij.rml.dfa.impl.scripts.ScriptManager;
import com.intellij.rml.dfa.impl.ui.FileConfigs;
import com.intellij.rml.dfa.impl.ui.IConfigs;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.impl.ui.ThreadCallback;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.impl.visitors.VisitorImpl;
import com.intellij.rml.dfa.impl.visitors.VisitorsManager;
import com.intellij.rml.dfa.rml.dsl.lang.RmlRelation;
import com.intellij.rml.dfa.utils.RMLOptions;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class RMLInstancesFactory {
    private static final String CONFIGS_FILE_NAME = "configs.properties";
    private static final String MESSAGES_FILE_URL = "strings.properties";
    protected List<AnalysisMode> modes;
    protected final RMLInstancesFactory parent;
    protected final RMLAnalysisDescription description;
    private final RMLOptions options;
    protected final DomainTypeManager domainTypeManager;
    protected final VisitorsManager visitorManager = new VisitorsManager();
    protected final ScriptManager scriptManager = new ScriptManager();
    protected final HypoteticRelationsRepository hypotheticRepository;
    protected final UIInstancesProvider uiInstancesProvider;

    public RMLInstancesFactory(RMLInstancesFactory parent, RMLAnalysisDescription description, UIInstancesProvider provider, RMLOptions options) {
        this.parent = parent;
        this.description = description;
        this.options = options;
        this.domainTypeManager = new DomainTypeManager(description.getTypesDescriptor(), options);
        this.hypotheticRepository = new HypoteticRelationsRepository(this.visitorManager, this.scriptManager, parent != null ? parent.hypotheticRepository : null);
        this.uiInstancesProvider = provider;
    }

    public RMLInstancesFactory(RMLAnalysisDescription description, UIInstancesProvider provider, RMLOptions options) {
        this(null, description, provider, options);
    }

    public void init(List<AnalysisMode> modes, List<BaseRelationKind> relationsKinds, ThreadCallback threadCallback) {
        this.modes = modes;
        Messages.init(RMLInstancesFactory.getURL(MESSAGES_FILE_URL));
        this.initConfigs();
        this.initVisitorManager(relationsKinds);
        this.initScriptManager(modes, this.domainTypeManager, threadCallback);
        this.hypotheticRepository.refresh();
    }

    private void initConfigs() {
        URL url = RMLInstancesFactory.getURL(CONFIGS_FILE_NAME);
        if (url == null) {
            this.uiInstancesProvider.setConfigs(new IConfigs.ConfigsStub());
            return;
        }
        this.uiInstancesProvider.setConfigs(new FileConfigs(url.getPath(), this.uiInstancesProvider.getUICallback()));
    }

    public RMLAnalysisDescription getAnalysisDescription() {
        return this.description;
    }

    public List<AnalysisMode> getModes() {
        return this.modes;
    }

    public DomainTypeManager getTypeManager() {
        return this.domainTypeManager;
    }

    public RMLInstancesFactory getParent() {
        return this.parent;
    }

    protected void initVisitorManager(List<BaseRelationKind> relationsKinds) {
        List<RelationSignature> signatures = this.getBaseRelationSignatures(relationsKinds);
        List<RelationSignature> allPossibleSignatures = this.options.get(AnalysisOptions.INSTANCE.getGlobalDomainTypes()).isEmpty() ? signatures : this.getBaseRelationSignatures((List<BaseRelationKind>)BaseRelationKind.getEntries());
        this.visitorManager.addVisitor(new VisitorImpl(signatures, allPossibleSignatures));
    }

    protected List<RelationSignature> getBaseRelationSignatures(List<BaseRelationKind> relationsKinds) {
        ArrayList<RelationSignature> relationSignatures = new ArrayList<RelationSignature>();
        for (BaseRelationKind kind : relationsKinds) {
            List<RmlRelation> relations = this.description.getBaseRelations().get((Object)kind);
            if (relations == null) continue;
            for (RmlRelation relation : relations) {
                ArrayList<DomainType> types = new ArrayList<DomainType>();
                for (String name : relation.getDomainNames()) {
                    types.add(this.domainTypeManager.getDomainType(name));
                }
                relationSignatures.add(new RelationSignature(relation.getName(), types.toArray(new DomainType[0])));
            }
        }
        return relationSignatures;
    }

    protected void initScriptManager(List<AnalysisMode> modes, DomainTypeManager typeManager, ThreadCallback threadCallback) {
        for (Script script : ScriptCompileCache.Companion.getInstance().loadScripts(this.description, modes, typeManager, threadCallback)) {
            this.scriptManager.addScript(script);
        }
        this.scriptManager.refresh();
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public HypoteticRelationsRepository getHypotheticRepository() {
        return this.hypotheticRepository;
    }

    private static URL getURL(String localPath) {
        try {
            return RMLInstancesFactory.class.getResource(localPath);
        }
        catch (Throwable e) {
            throw new DfaInternalException("Unable to locate \"" + localPath + "\"");
        }
    }
}

