/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.devtools.impl.picasso.graph;

import com.intellij.rml.dfa.devtools.impl.picasso.dot.DotGraph;
import com.intellij.rml.dfa.devtools.impl.picasso.dot.DotGraphKt;
import com.intellij.rml.dfa.devtools.impl.picasso.dot.DotSubGraph;
import com.intellij.rml.dfa.devtools.impl.picasso.dot.Node;
import com.intellij.rml.dfa.devtools.impl.picasso.graph.FileId;
import com.intellij.rml.dfa.devtools.impl.picasso.graph.FileInfo;
import com.intellij.rml.dfa.devtools.impl.picasso.graph.FunctionId;
import com.intellij.rml.dfa.devtools.impl.picasso.graph.FunctionInfo;
import com.intellij.rml.dfa.devtools.impl.picasso.graph.IdConverter;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/rml/dfa/devtools/impl/picasso/graph/CallGraph;", "", "()V", "calls", "", "Lcom/intellij/rml/dfa/devtools/impl/picasso/graph/FunctionId;", "", "fileInfo", "Lcom/intellij/rml/dfa/devtools/impl/picasso/graph/FileId;", "Lcom/intellij/rml/dfa/devtools/impl/picasso/graph/FileInfo;", "files", "functions", "Lcom/intellij/rml/dfa/devtools/impl/picasso/graph/FunctionInfo;", "addCall", "", "from", "toFunctionId", "attachToFile", "fId", "fileId", "getOrPutFile", "id", "getOrPutFunction", "toDot", "", "attachNodesToFiles", "", "intellij.rml.dfa.devtools.impl"})
@SourceDebugExtension(value={"SMAP\nCallGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallGraph.kt\ncom/intellij/rml/dfa/devtools/impl/picasso/graph/CallGraph\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,77:1\n372#2,7:78\n372#2,7:85\n372#2,7:92\n372#2,7:99\n*S KotlinDebug\n*F\n+ 1 CallGraph.kt\ncom/intellij/rml/dfa/devtools/impl/picasso/graph/CallGraph\n*L\n24#1:78,7\n28#1:85,7\n32#1:92,7\n36#1:99,7\n*E\n"})
public final class CallGraph {
    @NotNull
    private final Map<FileId, Set<FunctionId>> files = new LinkedHashMap();
    @NotNull
    private final Map<FunctionId, FunctionInfo> functions = new LinkedHashMap();
    @NotNull
    private final Map<FileId, FileInfo> fileInfo = new LinkedHashMap();
    @NotNull
    private final Map<FunctionId, Set<FunctionId>> calls = new LinkedHashMap();

    public final void addCall(@NotNull FunctionId from, @NotNull FunctionId toFunctionId) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)toFunctionId, (String)"toFunctionId");
        Map<FunctionId, Set<FunctionId>> $this$getOrPut$iv = this.calls;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(from);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(from, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        set.add((FunctionId)toFunctionId);
    }

    @NotNull
    public final FunctionInfo getOrPutFunction(@NotNull FunctionId id) {
        FunctionInfo functionInfo;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Map<FunctionId, FunctionInfo> $this$getOrPut$iv = this.functions;
        boolean $i$f$getOrPut = false;
        FunctionInfo value$iv = $this$getOrPut$iv.get(id);
        if (value$iv == null) {
            boolean bl = false;
            FunctionInfo answer$iv = new FunctionInfo();
            $this$getOrPut$iv.put(id, answer$iv);
            functionInfo = answer$iv;
        } else {
            functionInfo = value$iv;
        }
        return functionInfo;
    }

    @NotNull
    public final FileInfo getOrPutFile(@NotNull FileId id) {
        FileInfo fileInfo;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Map<FileId, FileInfo> $this$getOrPut$iv = this.fileInfo;
        boolean $i$f$getOrPut = false;
        FileInfo value$iv = $this$getOrPut$iv.get(id);
        if (value$iv == null) {
            boolean bl = false;
            FileInfo answer$iv = new FileInfo();
            $this$getOrPut$iv.put(id, answer$iv);
            fileInfo = answer$iv;
        } else {
            fileInfo = value$iv;
        }
        return fileInfo;
    }

    public final void attachToFile(@NotNull FunctionId fId, @NotNull FileId fileId) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)fId, (String)"fId");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Map<FileId, Set<FunctionId>> $this$getOrPut$iv = this.files;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(fileId);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(fileId, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        set.add((FunctionId)fId);
    }

    @NotNull
    public final String toDot(boolean attachNodesToFiles) {
        IdConverter<FunctionId> functionIdConverter = new IdConverter<FunctionId>();
        IdConverter<FileId> fileIdConverter = new IdConverter<FileId>();
        return DotGraphKt.dot("callGraph", (Function1<? super DotGraph, Unit>)((Function1)new Function1<DotGraph, Unit>(this, attachNodesToFiles, fileIdConverter, functionIdConverter){
            final /* synthetic */ CallGraph this$0;
            final /* synthetic */ boolean $attachNodesToFiles;
            final /* synthetic */ IdConverter<FileId> $fileIdConverter;
            final /* synthetic */ IdConverter<FunctionId> $functionIdConverter;
            {
                this.this$0 = $receiver;
                this.$attachNodesToFiles = $attachNodesToFiles;
                this.$fileIdConverter = $fileIdConverter;
                this.$functionIdConverter = $functionIdConverter;
                super(1);
            }

            public final void invoke(@NotNull DotGraph $this$dot) {
                Intrinsics.checkNotNullParameter((Object)$this$dot, (String)"$this$dot");
                for (Map.Entry<K, V> entry : CallGraph.access$getFiles$p(this.this$0).entrySet()) {
                    DotGraph dotGraph;
                    FileId fileId = (FileId)entry.getKey();
                    Set functionIds = (Set)entry.getValue();
                    if (this.$attachNodesToFiles) {
                        int fileNodeId = this.$fileIdConverter.idToInt(fileId);
                        DotSubGraph dotSubGraph = $this$dot.cluster(String.valueOf(fileNodeId));
                        CallGraph callGraph2 = this.this$0;
                        DotSubGraph it = dotSubGraph;
                        boolean bl = false;
                        Object object = (FileInfo)CallGraph.access$getFileInfo$p(callGraph2).get(fileId);
                        if (object == null || (object = ((FileInfo)object).getName()) == null) {
                            object = "unknown file";
                        }
                        it.setAttribute("label", (String)object);
                        dotGraph = dotSubGraph;
                    } else {
                        dotGraph = $this$dot;
                    }
                    DotGraph fileCluster = dotGraph;
                    for (FunctionId functionId : functionIds) {
                        Object object;
                        int functionNodeId = this.$functionIdConverter.idToInt(functionId);
                        Object object2 = (FunctionInfo)CallGraph.access$getFunctions$p(this.this$0).get(functionId);
                        if (object2 == null || (object2 = ((FunctionInfo)object2).getName()) == null) {
                            object2 = "unknown";
                        }
                        Object functionName = object2;
                        Node functionNode = fileCluster.node(functionNodeId);
                        if (this.$attachNodesToFiles) {
                            object = functionName;
                        } else {
                            Object object3 = (FileInfo)CallGraph.access$getFileInfo$p(this.this$0).get(fileId);
                            if (object3 == null || (object3 = ((FileInfo)object3).getName()) == null) {
                                object3 = "unknown file";
                            }
                            Object fileName = object3;
                            object = (String)functionName + "\n" + (String)fileName;
                        }
                        functionNode.set("label", (String)object);
                    }
                }
                for (Map.Entry<K, V> entry : CallGraph.access$getCalls$p(this.this$0).entrySet()) {
                    FunctionId from = (FunctionId)entry.getKey();
                    Set tos = (Set)entry.getValue();
                    int fromNodeId = this.$functionIdConverter.idToInt(from);
                    for (FunctionId to : tos) {
                        int toFunctionId = this.$functionIdConverter.idToInt(to);
                        $this$dot.edgeTo(fromNodeId, toFunctionId);
                    }
                }
            }
        }));
    }

    public static final /* synthetic */ Map access$getFiles$p(CallGraph $this) {
        return $this.files;
    }

    public static final /* synthetic */ Map access$getFunctions$p(CallGraph $this) {
        return $this.functions;
    }

    public static final /* synthetic */ Map access$getFileInfo$p(CallGraph $this) {
        return $this.fileInfo;
    }

    public static final /* synthetic */ Map access$getCalls$p(CallGraph $this) {
        return $this.calls;
    }
}

