/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.devtools.impl.panels;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.devtools.DfaLocationsProvider;
import com.intellij.rml.dfa.devtools.SummaryInfo;
import com.intellij.rml.dfa.devtools.impl.panels.DfaPanelUtilsKt;
import com.intellij.rml.dfa.devtools.impl.panels.Node;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.rml.DfaConstantsKt;
import com.intellij.rml.dfa.utils.MetaInfo;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/rml/dfa/devtools/impl/panels/FunctionNode;", "Lcom/intellij/rml/dfa/devtools/impl/panels/Node;", "function", "Lcom/intellij/rml/dfa/attributes/Attribute;", "isFakeFunction", "", "project", "Lcom/intellij/openapi/project/Project;", "summaryInfo", "Lcom/intellij/rml/dfa/devtools/SummaryInfo;", "(Lcom/intellij/rml/dfa/attributes/Attribute;ZLcom/intellij/openapi/project/Project;Lcom/intellij/rml/dfa/devtools/SummaryInfo;)V", "getFunction", "()Lcom/intellij/rml/dfa/attributes/Attribute;", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSummaryInfo", "()Lcom/intellij/rml/dfa/devtools/SummaryInfo;", "intellij.rml.dfa.devtools.impl"})
public final class FunctionNode
extends Node {
    @NotNull
    private final Attribute function;
    private final boolean isFakeFunction;
    @NotNull
    private final Project project;
    @Nullable
    private final SummaryInfo summaryInfo;

    public FunctionNode(final @NotNull Attribute function2, boolean isFakeFunction, final @NotNull Project project, @Nullable SummaryInfo summaryInfo) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = DfaConstantsKt.isGlobalFunction(function2) ? new File(function2.toString()).getName() : function2.toString();
        Intrinsics.checkNotNull((Object)string);
        Icon icon = DfaConstantsKt.isGlobalFunction(function2) ? AllIcons.Nodes.Type : (isFakeFunction ? AllIcons.Actions.GroupByModule : AllIcons.Nodes.Function);
        if (isFakeFunction) {
            object = CollectionsKt.emptyList();
        } else {
            object = summaryInfo;
            if (object == null || (object = object.getFunctionInfo()) == null) {
                object = CollectionsKt.emptyList();
            }
        }
        super(string, icon, (List<MetaInfo>)object, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                block0: {
                    DfaLocationsProvider dfaLocationsProvider = DfaLocationsProvider.Companion.getInstance(project);
                    Intrinsics.checkNotNullExpressionValue((Object)dfaLocationsProvider, (String)"getInstance(...)");
                    IrLocation irLocation = DfaLocationsProvider.getLocation$default(dfaLocationsProvider, function2, null, 2, null);
                    if (irLocation == null) break block0;
                    IrLocation irLocation2 = irLocation;
                    Project project2 = project;
                    IrLocation it = irLocation2;
                    boolean bl = false;
                    DfaPanelUtilsKt.openLocationInEditor(it, project2);
                }
            }
        }));
        this.function = function2;
        this.isFakeFunction = isFakeFunction;
        this.project = project;
        this.summaryInfo = summaryInfo;
    }

    @NotNull
    public final Attribute getFunction() {
        return this.function;
    }

    public final boolean isFakeFunction() {
        return this.isFakeFunction;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final SummaryInfo getSummaryInfo() {
        return this.summaryInfo;
    }
}

