/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.devtools.impl.panels;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rml.dfa.DfaEvaluationStatus;
import com.intellij.rml.dfa.devtools.impl.actions.ShowDfaToolWindowActionKt;
import com.intellij.rml.dfa.devtools.impl.model.DfaRunningInfoModel;
import com.intellij.rml.dfa.devtools.impl.model.RunningInfo;
import com.intellij.rml.dfa.devtools.impl.panels.DfaPanelBase;
import com.intellij.rml.dfa.devtools.impl.panels.DfaPanelUtilsKt;
import com.intellij.rml.dfa.devtools.impl.panels.DfaProfilePanel;
import com.intellij.rml.dfa.devtools.impl.panels.Node;
import com.intellij.rml.dfa.impl.DfaEvaluationEvent;
import com.intellij.rml.dfa.impl.DfaEvaluationObserver;
import com.intellij.rml.dfa.impl.DfaObserverProvider;
import com.intellij.rml.dfa.impl.rml.profiler.tree.IProfileNode;
import com.intellij.rml.dfa.impl.rml.profiler.tree.ProfileData;
import com.intellij.rml.dfa.impl.rml.profiler.tree.ProfilerNodeMetadata;
import com.intellij.rml.dfa.impl.rml.profiler.tree.ProfilerTreeOpKt;
import com.intellij.rml.dfa.utils.FormatHelperKt;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b*\u0001\u0015\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0002$%B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000bH\u0002J\b\u0010!\u001a\u00020\u0013H\u0016J\b\u0010\"\u001a\u00020\u001cH\u0002J\u0006\u0010#\u001a\u00020\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/intellij/rml/dfa/devtools/impl/panels/DfaProfilePanel;", "Lcom/intellij/rml/dfa/devtools/impl/panels/DfaPanelBase;", "Lcom/intellij/rml/dfa/impl/DfaObserverProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "aggregateCheckBox", "Ljavax/swing/JCheckBox;", "enableCheckBox", "pinCheckBox", "profileRoot", "Lcom/intellij/rml/dfa/impl/rml/profiler/tree/IProfileNode;", "getProject", "()Lcom/intellij/openapi/project/Project;", "rootNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "threadsButton", "Ljavax/swing/JButton;", "tree", "Lcom/intellij/ui/dualView/TreeTableView;", "treeModel", "com/intellij/rml/dfa/devtools/impl/panels/DfaProfilePanel$treeModel$1", "Lcom/intellij/rml/dfa/devtools/impl/panels/DfaProfilePanel$treeModel$1;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getObserver", "Lcom/intellij/rml/dfa/impl/DfaEvaluationObserver;", "initCheckBoxes", "", "isProfilingEnabled", "", "makeTree", "profileNode", "preferredFocusedComponent", "showThreads", "update", "Companion", "ProfileNode", "intellij.rml.dfa.devtools.impl"})
@SourceDebugExtension(value={"SMAP\nDfaProfilePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DfaProfilePanel.kt\ncom/intellij/rml/dfa/devtools/impl/panels/DfaProfilePanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1549#2:223\n1620#2,3:224\n1#3:227\n*S KotlinDebug\n*F\n+ 1 DfaProfilePanel.kt\ncom/intellij/rml/dfa/devtools/impl/panels/DfaProfilePanel\n*L\n191#1:223\n191#1:224,3\n*E\n"})
public final class DfaProfilePanel
extends DfaPanelBase
implements DfaObserverProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private DefaultMutableTreeNode rootNode;
    @NotNull
    private final treeModel.1 treeModel;
    @NotNull
    private final TreeTableView tree;
    private JCheckBox enableCheckBox;
    private JCheckBox aggregateCheckBox;
    private JCheckBox pinCheckBox;
    private JButton threadsButton;
    @Nullable
    private IProfileNode profileRoot;

    public DfaProfilePanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        DefaultMutableTreeNode defaultMutableTreeNode = this.rootNode = new DefaultMutableTreeNode();
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ColumnInfo<ProfileNode, String>(){

            @NotNull
            public String valueOf(@NotNull ProfileNode item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.toString();
            }

            @NotNull
            public Class<TreeTableModel> getColumnClass() {
                return TreeTableModel.class;
            }
        }, new ColumnInfo<ProfileNode, String>(){

            @NotNull
            public String valueOf(@NotNull ProfileNode item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                String string = "%.2f";
                Object[] objectArray = new Object[]{item.getTimePercentRelative()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                return string2 + "%";
            }

            public int getWidth(@Nullable JTable table) {
                return 70;
            }
        }, new ColumnInfo<ProfileNode, String>(){

            @NotNull
            public String valueOf(@NotNull ProfileNode item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                String string = "%.2f";
                Object[] objectArray = new Object[]{item.getTimePercentAbsolute()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                return string2 + "%";
            }

            public int getWidth(@Nullable JTable table) {
                return 70;
            }
        }, new ColumnInfo<ProfileNode, String>(){

            @NotNull
            public String valueOf(@NotNull ProfileNode item) {
                Object object;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                        object = item.getData().getTime();
                        if (object == null) break block2;
                        long it = ((Number)object).longValue();
                        boolean bl = false;
                        String string = FormatHelperKt.formatDuration$default(it, 0, 2, null);
                        object = string;
                        if (string != null) break block3;
                    }
                    object = "";
                }
                return object;
            }

            public int getWidth(@Nullable JTable table) {
                return 70;
            }
        }, new ColumnInfo<ProfileNode, String>(){

            @NotNull
            public String valueOf(@NotNull ProfileNode item) {
                Object object;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                        object = item.getData().getBddOpsCnt();
                        if (object == null) break block2;
                        long it = ((Number)object).longValue();
                        boolean bl = false;
                        String string = FormatHelperKt.formatNumber$default(it, 0, 2, null);
                        object = string;
                        if (string != null) break block3;
                    }
                    object = "";
                }
                return object;
            }

            public int getWidth(@Nullable JTable table) {
                return 70;
            }
        }, new ColumnInfo<ProfileNode, String>(){

            @NotNull
            public String valueOf(@NotNull ProfileNode item) {
                Object object;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                        object = item.getData().getBddMemByte();
                        if (object == null) break block2;
                        long it = ((Number)object).longValue();
                        boolean bl = false;
                        String string = FormatHelperKt.formatMemorySize$default(it, 0, 2, null);
                        object = string;
                        if (string != null) break block3;
                    }
                    object = "";
                }
                return object;
            }

            public int getWidth(@Nullable JTable table) {
                return 70;
            }
        }, new ColumnInfo<ProfileNode, String>(){

            @NotNull
            public String valueOf(@NotNull ProfileNode item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Object object = item.getData().getInvocations();
                if (object == null || (object = ((Integer)object).toString()) == null) {
                    object = "";
                }
                return object;
            }

            public int getWidth(@Nullable JTable table) {
                return 50;
            }
        }};
        ColumnInfo[] columnInfoArray2 = columnInfoArray;
        this.treeModel = new ListTreeTableModelOnColumns(defaultMutableTreeNode, columnInfoArray2){

            @Nullable
            public Object getValueAt(@NotNull Object node, int column) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Object object = ((DefaultMutableTreeNode)node).getUserObject();
                if (object == null) {
                    return null;
                }
                Object userObject = object;
                return this.getColumns()[column].valueOf((Object)((ProfileNode)userObject));
            }
        };
        this.tree = new TreeTableView((ListTreeTableModelOnColumns)this.treeModel);
        TreeTableTree treeTableTree = this.tree.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)treeTableTree, (String)"getTree(...)");
        DfaPanelUtilsKt.installTree((Tree)treeTableTree, this.project, (Component)this.tree);
        this.add((Component)this.createPanel());
        this.initCheckBoxes();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public TreeTableView preferredFocusedComponent() {
        return this.tree;
    }

    public final boolean isProfilingEnabled() {
        JCheckBox jCheckBox = this.enableCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"enableCheckBox");
            jCheckBox = null;
        }
        return jCheckBox.isSelected();
    }

    private final void initCheckBoxes() {
        JCheckBox jCheckBox = this.aggregateCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aggregateCheckBox");
            jCheckBox = null;
        }
        jCheckBox.addActionListener(arg_0 -> DfaProfilePanel.initCheckBoxes$lambda$0(this, arg_0));
    }

    private final DialogPanel createPanel() {
        DialogPanel panel2 = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ DfaProfilePanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ DfaProfilePanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        DfaProfilePanel.access$setEnableCheckBox$p(this.this$0, (JCheckBox)$this$row.checkBox("Enable").getComponent());
                        DfaProfilePanel.access$setAggregateCheckBox$p(this.this$0, (JCheckBox)$this$row.checkBox("Aggregate").getComponent());
                        DfaProfilePanel.access$setPinCheckBox$p(this.this$0, (JCheckBox)$this$row.checkBox("Pin").getComponent());
                        DfaProfilePanel.access$setThreadsButton$p(this.this$0, (JButton)$this$row.button("Threads", (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                            final /* synthetic */ DfaProfilePanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                DfaProfilePanel.access$showThreads(this.this$0);
                            }
                        }).getComponent());
                        JCheckBox jCheckBox = DfaProfilePanel.access$getAggregateCheckBox$p(this.this$0);
                        if (jCheckBox == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"aggregateCheckBox");
                            jCheckBox = null;
                        }
                        jCheckBox.setSelected(true);
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ DfaProfilePanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.scrollCell((JComponent)DfaProfilePanel.access$getTree$p(this.this$0)).align(Align.FILL);
                    }
                }), (int)1, null).resizableRow();
            }
        }));
        return panel2;
    }

    @Override
    @NotNull
    public DfaEvaluationObserver getObserver() {
        return new DfaEvaluationObserver(this){
            final /* synthetic */ DfaProfilePanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void start(@NotNull DfaEvaluationEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                JCheckBox jCheckBox = DfaProfilePanel.access$getPinCheckBox$p(this.this$0);
                if (jCheckBox == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"pinCheckBox");
                    jCheckBox = null;
                }
                if (!jCheckBox.isSelected()) {
                    DfaProfilePanel.access$getRootNode$p(this.this$0).removeAllChildren();
                    DfaProfilePanel.access$getTreeModel$p(this.this$0).nodeStructureChanged(DfaProfilePanel.access$getRootNode$p(this.this$0));
                }
            }

            public void finish(@NotNull DfaEvaluationStatus status, @Nullable IProfileNode profilerTree) {
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status == DfaEvaluationStatus.SUCCESS) {
                    DfaProfilePanel.access$setProfileRoot$p(this.this$0, profilerTree);
                    JCheckBox jCheckBox = DfaProfilePanel.access$getPinCheckBox$p(this.this$0);
                    if (jCheckBox == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pinCheckBox");
                        jCheckBox = null;
                    }
                    if (!jCheckBox.isSelected()) {
                        SwingUtilities.invokeLater(() -> getObserver.1.finish$lambda$0(this.this$0));
                    }
                }
            }

            private static final void finish$lambda$0(DfaProfilePanel this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.update();
            }
        };
    }

    public final void update() {
        IProfileNode profileNode = this.profileRoot;
        if (profileNode != null) {
            JCheckBox jCheckBox = this.aggregateCheckBox;
            if (jCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"aggregateCheckBox");
                jCheckBox = null;
            }
            if (jCheckBox.isSelected()) {
                profileNode = ProfilerTreeOpKt.joinNodesWithMeta(profileNode, ProfilerNodeMetadata.FUNCTION_SET);
            }
            this.rootNode.removeAllChildren();
            this.rootNode.add(this.makeTree(profileNode));
            this.treeModel.nodeStructureChanged(this.rootNode);
        }
    }

    private final DefaultMutableTreeNode makeTree(IProfileNode profileNode) {
        DefaultMutableTreeNode newRoot2 = (DefaultMutableTreeNode)ProfilerTreeOpKt.transform(profileNode, (Function4)new Function4<ProfileData, ProfileData, ProfileData, List<? extends DefaultMutableTreeNode>, DefaultMutableTreeNode>(profileNode, this){
            final /* synthetic */ IProfileNode $profileNode;
            final /* synthetic */ DfaProfilePanel this$0;
            {
                this.$profileNode = $profileNode;
                this.this$0 = $receiver;
                super(4);
            }

            @NotNull
            public final DefaultMutableTreeNode invoke(@NotNull ProfileData data, @Nullable ProfileData parentData, @Nullable ProfileData functionData, @NotNull List<? extends DefaultMutableTreeNode> children) {
                Number number;
                ProfileData profileData;
                Long parentTime;
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter(children, (String)"children");
                Long time = data.getTime();
                if (Intrinsics.areEqual((Object)data, (Object)functionData)) {
                    v0 = data.getTime();
                } else {
                    ProfileData profileData2 = parentData;
                    v0 = parentTime = profileData2 != null ? profileData2.getTime() : null;
                }
                if ((profileData = functionData) == null) {
                    profileData = this.$profileNode.getProfileData();
                }
                Long l = profileData.getTime();
                if (l == null) {
                    throw new IllegalStateException("Root or function node of profile tree must have time");
                }
                long absoluteTime = l;
                Long l2 = time;
                double timePercentAbs = ((Number)(l2 != null ? (Number)Double.valueOf((double)l2.longValue() / (double)absoluteTime * (double)100) : (Number)Integer.valueOf(0))).doubleValue();
                Long l3 = time;
                if (l3 != null) {
                    Long l4 = parentTime;
                    number = (double)l3.longValue() / (double)(l4 != null ? l4.longValue() : time.longValue()) * (double)100;
                } else {
                    number = 0;
                }
                double timePercentRel = ((Number)number).doubleValue();
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(this.this$0.new ProfileNode(data, timePercentAbs, timePercentRel));
                Iterable $this$forEach$iv = children;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv;
                    boolean bl = false;
                    node.add(it);
                }
                return node;
            }
        });
        return newRoot2;
    }

    /*
     * WARNING - void declaration
     */
    private final void showThreads() {
        Iterator iterator;
        void $this$mapTo$iv$iv;
        Object object = DfaRunningInfoModel.Companion.getInstance(this.project);
        if (object == null || (object = ((DfaRunningInfoModel)object).getRunningInfos()) == null) {
            return;
        }
        Object runningInfos = object;
        if (runningInfos.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = (Iterable)runningInfos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            iterator = (RunningInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getThread());
        }
        List threads = CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        int threadsCnt = threads.size();
        int gap = 50;
        int threadHeight = 50;
        int height = threadsCnt * (threadHeight + gap) + gap;
        iterator = ((Iterable)runningInfos).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        RunningInfo it22 = (RunningInfo)iterator.next();
        boolean bl = false;
        long it22 = it22.getStart();
        while (iterator.hasNext()) {
            RunningInfo it = (RunningInfo)iterator.next();
            $i$a$-minOf-DfaProfilePanel$showThreads$minTime$1 = false;
            long l = it.getStart();
            if (it22 <= l) continue;
            it22 = l;
        }
        long minTime = it22;
        Iterator iterator2 = ((Iterable)runningInfos).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        RunningInfo it32 = (RunningInfo)iterator2.next();
        boolean bl2 = false;
        long it32 = it32.getStart();
        while (iterator2.hasNext()) {
            RunningInfo it = (RunningInfo)iterator2.next();
            $i$a$-maxOf-DfaProfilePanel$showThreads$maxTime$1 = false;
            long l = it.getStart();
            if (it32 >= l) continue;
            it32 = l;
        }
        long maxTime = it32;
        double scale = 0.3;
        double width = (double)(maxTime - minTime) * scale;
        StringBuilder svg = new StringBuilder();
        svg.append("<svg width=\"" + width + "pt\" height=\"" + height + "pt\" xmlns=\"http://www.w3.org/2000/svg\">");
        Iterator iterator3 = runningInfos.iterator();
        while (iterator3.hasNext()) {
            RunningInfo info = (RunningInfo)iterator3.next();
            double x1 = (double)(info.getStart() - minTime) * scale + (double)gap;
            int y1 = threads.indexOf(info.getThread()) * (threadHeight + gap) + gap;
            double x2 = (double)(info.getEnd() - minTime) * scale + (double)gap;
            int y2 = y1 + threadHeight;
            svg.append("<polygon points=\"" + x1 + "," + y1 + " " + x1 + "," + y2 + " " + x2 + "," + y2 + " " + x2 + "," + y1 + "\" style=\"fill:lightgray\"/>");
            svg.append("<text x=\"" + (x1 + (double)10) + "\" y=\"" + (y1 + threadHeight / 2) + "\" font-size=\"15pt\">" + info.getFunction() + " (" + FormatHelperKt.formatDuration$default(info.getEnd() - info.getStart(), 0, 2, null) + "; BDD: " + FormatHelperKt.formatNumber$default(info.getOpCnt(), 0, 2, null) + ")</text>");
        }
        svg.append("</svg>");
        LightVirtualFile file = new LightVirtualFile("threads.svg", (CharSequence)svg);
        FileEditorManager.getInstance((Project)this.project).openFile((VirtualFile)file, true);
    }

    private static final void initCheckBoxes$lambda$0(DfaProfilePanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.update();
    }

    public static final /* synthetic */ void access$setEnableCheckBox$p(DfaProfilePanel $this, JCheckBox jCheckBox) {
        $this.enableCheckBox = jCheckBox;
    }

    public static final /* synthetic */ void access$setAggregateCheckBox$p(DfaProfilePanel $this, JCheckBox jCheckBox) {
        $this.aggregateCheckBox = jCheckBox;
    }

    public static final /* synthetic */ void access$setPinCheckBox$p(DfaProfilePanel $this, JCheckBox jCheckBox) {
        $this.pinCheckBox = jCheckBox;
    }

    public static final /* synthetic */ void access$setThreadsButton$p(DfaProfilePanel $this, JButton jButton) {
        $this.threadsButton = jButton;
    }

    public static final /* synthetic */ void access$showThreads(DfaProfilePanel $this) {
        $this.showThreads();
    }

    public static final /* synthetic */ JCheckBox access$getAggregateCheckBox$p(DfaProfilePanel $this) {
        return $this.aggregateCheckBox;
    }

    public static final /* synthetic */ TreeTableView access$getTree$p(DfaProfilePanel $this) {
        return $this.tree;
    }

    public static final /* synthetic */ JCheckBox access$getPinCheckBox$p(DfaProfilePanel $this) {
        return $this.pinCheckBox;
    }

    public static final /* synthetic */ DefaultMutableTreeNode access$getRootNode$p(DfaProfilePanel $this) {
        return $this.rootNode;
    }

    public static final /* synthetic */ treeModel.1 access$getTreeModel$p(DfaProfilePanel $this) {
        return $this.treeModel;
    }

    public static final /* synthetic */ void access$setProfileRoot$p(DfaProfilePanel $this, IProfileNode iProfileNode) {
        $this.profileRoot = iProfileNode;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/rml/dfa/devtools/impl/panels/DfaProfilePanel$Companion;", "", "()V", "getInstance", "Lcom/intellij/rml/dfa/devtools/impl/panels/DfaProfilePanel;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rml.dfa.devtools.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DfaProfilePanel getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (DfaProfilePanel)ShowDfaToolWindowActionKt.getPanel(project, "DFA", Reflection.getOrCreateKotlinClass(DfaProfilePanel.class));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/rml/dfa/devtools/impl/panels/DfaProfilePanel$ProfileNode;", "Lcom/intellij/rml/dfa/devtools/impl/panels/Node;", "data", "Lcom/intellij/rml/dfa/impl/rml/profiler/tree/ProfileData;", "timePercentAbsolute", "", "timePercentRelative", "(Lcom/intellij/rml/dfa/devtools/impl/panels/DfaProfilePanel;Lcom/intellij/rml/dfa/impl/rml/profiler/tree/ProfileData;DD)V", "getData", "()Lcom/intellij/rml/dfa/impl/rml/profiler/tree/ProfileData;", "getTimePercentAbsolute", "()D", "getTimePercentRelative", "intellij.rml.dfa.devtools.impl"})
    private final class ProfileNode
    extends Node {
        @NotNull
        private final ProfileData data;
        private final double timePercentAbsolute;
        private final double timePercentRelative;

        public ProfileNode(ProfileData data, double timePercentAbsolute, double timePercentRelative) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super(data.getDescription(), null, data.getAdditionalData(), null, 8, null);
            this.data = data;
            this.timePercentAbsolute = timePercentAbsolute;
            this.timePercentRelative = timePercentRelative;
        }

        @NotNull
        public final ProfileData getData() {
            return this.data;
        }

        public final double getTimePercentAbsolute() {
            return this.timePercentAbsolute;
        }

        public final double getTimePercentRelative() {
            return this.timePercentRelative;
        }
    }
}

